package cmd

import (
	"fmt"

	"github.com/hoop33/limo/config"
	"github.com/hoop33/limo/service"
	"github.com/spf13/cobra"
)

// LoginCmd lets you log in
var LoginCmd = &cobra.Command{
	Use:     "login",
	Short:   "Log in to a service",
	Long:    "Log in to the service specified by [--service] (default: github).",
	Example: fmt.Sprintf("  %s login", config.ProgramName),
	Run: func(cmd *cobra.Command, args []string) {
		// Get the specified service and log in
		svc, err := getService()
		fatalOnError(err)

		token, err := svc.Login()
		fatalOnError(err)

		// Update configuration with token
		config, err := getConfiguration()
		fatalOnError(err)

		config.GetService(service.Name(svc)).Token = token
		fatalOnError(config.WriteConfig())
	},
}

func init() {
	RootCmd.AddCommand(LoginCmd)
}
