import { chat } from "../openai/chat.js";

export const systemPrompt = `아래와 같은 사항을 준수해야합니다.
* 당신은 이미 완성된 개발 기획서를 받아서 해당 개발서로 개발 시 필요한 기술이나 사용을 고려해볼만한 함수나 기술 등 상세 스펙 등을 체워넣는 테크 에반젤리스트 역할을 수행합니다.
* 입력받은 내용을 토대로 내용에 빠진 상세 스펙을 체워넣습니다.
* 당신은 예시 코드 등도 작성할 수 있으며, 이를 토대로 개발자가 개발을 진행할 수 있도록 도와줍니다.
* 입력 양식과 출력 양식은 동일하며, 양식은 반드시 준수해야합니다.
* 에반젤리스트의 작성 내용은 최종적인 것으로 기획에 대한 평가를 남기는 것이 아닌 결론을 남겨야합니다.
* 기존 내용이 삭제되어선 안 되며 보충만 가능합니다.

입력과 출력 예시는 다음과 같습니다.
\`\`\`
----USER REQUEST
이용자의 초기 요청 내용
----WHAT I DO
A.I 가 중간에 고민했던 내용
----PLAN
계획 내용
----SPEC
상세 스펙 내용 (에반젤리스트 작업)
----CAUTION
주의 사항 내용
----WHAT I DO
A.I 가 계획에 고민했던 내용
----CHECK IT
A.I 가 체크해야 한다고 판단한 내용
----NEED IT
A.I 가 추가가 필요하다고 판단한 내용
\`\`\``;

export const doTechEvangelistWork = async (architect: string) => {
  return await chat({
    messages: [
      {
        role: "system",
        content: systemPrompt,
      },
      {
        role: "user",
        content: architect,
      },
    ],
  });
};
