/*
 * Decompiled with CFR 0.152.
 */
package jnr.enxio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import jnr.ffi.LastError;
import jnr.ffi.Library;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.annotations.IgnoreError;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;
import jnr.ffi.annotations.Transient;

final class Native {
    Native() {
    }

    static LibC libc() {
        return SingletonHolder.libc;
    }

    static Runtime getRuntime() {
        return SingletonHolder.runtime;
    }

    public static int close(int fd) {
        int rc;
        while ((rc = Native.libc().close(fd)) < 0 && Errno.EINTR.equals((Object)Native.getLastError())) {
        }
        return rc;
    }

    public static int read(int fd, ByteBuffer dst) throws IOException {
        long n;
        if (dst == null) {
            throw new NullPointerException("Destination buffer cannot be null");
        }
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        while ((n = Native.libc().read(fd, dst, dst.remaining())) < 0L && Errno.EINTR.equals((Object)Native.getLastError())) {
        }
        if (n > 0L) {
            dst.position(dst.position() + (int)n);
        }
        return (int)n;
    }

    public static int write(int fd, ByteBuffer src) throws IOException {
        long n;
        if (src == null) {
            throw new NullPointerException("Source buffer cannot be null");
        }
        while ((n = Native.libc().write(fd, src, src.remaining())) < 0L && Errno.EINTR.equals((Object)Native.getLastError())) {
        }
        if (n > 0L) {
            src.position(src.position() + (int)n);
        }
        return (int)n;
    }

    public static void setBlocking(int fd, boolean block) {
        int flags = Native.libc().fcntl(fd, LibC.F_GETFL, 0);
        flags = block ? (flags &= ~LibC.O_NONBLOCK) : (flags |= LibC.O_NONBLOCK);
        Native.libc().fcntl(fd, LibC.F_SETFL, flags);
    }

    public static int shutdown(int fd, int how) {
        return Native.libc().shutdown(fd, how);
    }

    public static String getLastErrorString() {
        return Native.libc().strerror(LastError.getLastError((Runtime)Native.getRuntime()));
    }

    static Errno getLastError() {
        return Errno.valueOf((long)LastError.getLastError((Runtime)Native.getRuntime()));
    }

    public static final class Timespec
    extends Struct {
        public final Struct.SignedLong tv_sec = new Struct.SignedLong((Struct)this);
        public final Struct.SignedLong tv_nsec = new Struct.SignedLong((Struct)this);

        public Timespec() {
            super(Native.getRuntime());
        }

        public Timespec(Runtime runtime) {
            super(runtime);
        }

        public Timespec(long sec, long nsec) {
            super(Native.getRuntime());
            this.tv_sec.set(sec);
            this.tv_nsec.set(nsec);
        }
    }

    private static final class SingletonHolder {
        static final LibC libc = (LibC)Library.loadLibrary((String)"c", LibC.class);
        static final Runtime runtime = Library.getRuntime((Object)libc);

        private SingletonHolder() {
        }
    }

    public static interface LibC {
        public static final int F_GETFL = Fcntl.F_GETFL.intValue();
        public static final int F_SETFL = Fcntl.F_SETFL.intValue();
        public static final int O_NONBLOCK = OpenFlags.O_NONBLOCK.intValue();

        public int close(int var1);

        public long read(int var1, @Out ByteBuffer var2, long var3);

        public long write(int var1, @In ByteBuffer var2, long var3);

        public int fcntl(int var1, int var2, int var3);

        public int poll(@In @Out ByteBuffer var1, int var2, int var3);

        public int kqueue();

        public int kevent(int var1, @In ByteBuffer var2, int var3, @Out ByteBuffer var4, int var5, @In @Transient Timespec var6);

        public int pipe(@Out int[] var1);

        public int shutdown(int var1, int var2);

        @IgnoreError
        public String strerror(int var1);
    }
}

