/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.IOException;
import jnr.constants.platform.Errno;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.enxio.channels.NativeSocketChannel;
import jnr.ffi.LastError;
import jnr.ffi.Runtime;
import jnr.ffi.byref.IntByReference;
import jnr.unixsocket.Native;
import jnr.unixsocket.SockAddrUnix;
import jnr.unixsocket.UnixSocketAddress;

public class UnixSocketChannel
extends NativeSocketChannel {
    private volatile State state;
    private UnixSocketAddress remoteAddress = null;
    private UnixSocketAddress localAddress = null;
    private final Object stateLock = new Object();

    public static final UnixSocketChannel open() throws IOException {
        return new UnixSocketChannel();
    }

    public static final UnixSocketChannel open(UnixSocketAddress unixSocketAddress) throws IOException {
        UnixSocketChannel unixSocketChannel = new UnixSocketChannel();
        unixSocketChannel.connect(unixSocketAddress);
        return unixSocketChannel;
    }

    public static final UnixSocketChannel[] pair() throws IOException {
        int[] nArray = new int[]{-1, -1};
        Native.socketpair(ProtocolFamily.PF_UNIX, Sock.SOCK_STREAM, 0, nArray);
        return new UnixSocketChannel[]{new UnixSocketChannel(nArray[0], 5), new UnixSocketChannel(nArray[1], 5)};
    }

    private UnixSocketChannel() throws IOException {
        super(Native.socket(ProtocolFamily.PF_UNIX, Sock.SOCK_STREAM, 0), 13);
        this.state = State.IDLE;
    }

    UnixSocketChannel(int n, int n2) {
        super(n, n2);
        this.state = State.CONNECTED;
    }

    UnixSocketChannel(int n, UnixSocketAddress unixSocketAddress) {
        super(n, 5);
        this.state = State.CONNECTED;
        this.remoteAddress = unixSocketAddress;
    }

    private final boolean doConnect(SockAddrUnix sockAddrUnix) throws IOException {
        if (Native.connect(this.getFD(), sockAddrUnix, sockAddrUnix.length()) != 0) {
            Errno errno = Errno.valueOf((long)LastError.getLastError((Runtime)Runtime.getSystemRuntime()));
            switch (errno) {
                case EAGAIN: 
                case EWOULDBLOCK: {
                    return false;
                }
            }
            throw new IOException(errno.toString());
        }
        return true;
    }

    public boolean connect(UnixSocketAddress unixSocketAddress) throws IOException {
        this.remoteAddress = unixSocketAddress;
        if (!this.doConnect(this.remoteAddress.getStruct())) {
            this.state = State.CONNECTING;
            return false;
        }
        this.state = State.CONNECTED;
        return true;
    }

    public boolean isConnected() {
        return this.state == State.CONNECTED;
    }

    public boolean isConnectionPending() {
        return this.state == State.CONNECTING;
    }

    public boolean finishConnect() throws IOException {
        switch (this.state) {
            case CONNECTED: {
                return true;
            }
            case CONNECTING: {
                if (!this.doConnect(this.remoteAddress.getStruct())) {
                    return false;
                }
                this.state = State.CONNECTED;
                return true;
            }
        }
        throw new IllegalStateException("socket is not waiting for connect to complete");
    }

    public final UnixSocketAddress getRemoteSocketAddress() {
        if (this.state != State.CONNECTED) {
            return null;
        }
        return this.remoteAddress != null ? this.remoteAddress : (this.remoteAddress = UnixSocketChannel.getpeername(this.getFD()));
    }

    public final UnixSocketAddress getLocalSocketAddress() {
        if (this.state != State.CONNECTED) {
            return null;
        }
        return this.localAddress != null ? this.localAddress : (this.localAddress = UnixSocketChannel.getsockname(this.getFD()));
    }

    static UnixSocketAddress getpeername(int n) {
        UnixSocketAddress unixSocketAddress = new UnixSocketAddress();
        IntByReference intByReference = new IntByReference(unixSocketAddress.getStruct().getMaximumLength());
        if (Native.libc().getpeername(n, unixSocketAddress.getStruct(), intByReference) < 0) {
            throw new Error(Native.getLastErrorString());
        }
        return unixSocketAddress;
    }

    static UnixSocketAddress getsockname(int n) {
        UnixSocketAddress unixSocketAddress = new UnixSocketAddress();
        IntByReference intByReference = new IntByReference(unixSocketAddress.getStruct().getMaximumLength());
        if (Native.libc().getsockname(n, unixSocketAddress.getStruct(), intByReference) < 0) {
            throw new Error(Native.getLastErrorString());
        }
        return unixSocketAddress;
    }

    static enum State {
        UNINITIALIZED,
        CONNECTED,
        IDLE,
        CONNECTING;

    }
}

