#  Copyright (c) 2012-2017, Jungwacht Blauring Schweiz. This file is part of
#  hitobito and licensed under the Affero General Public License version 3
#  or later. See the COPYING file at the top-level directory or at
#  https://github.com/hitobito/hitobito.
# == Schema Information
#
# Table name: payment_reminders
#
#  id         :integer          not null, primary key
#  due_at     :date             not null
#  level      :integer
#  text       :string
#  title      :string
#  created_at :datetime         not null
#  updated_at :datetime         not null
#  invoice_id :integer          not null
#
# Indexes
#
#  index_payment_reminders_on_invoice_id  (invoice_id)
#

require "spec_helper"

describe PaymentReminder do
  let(:draft) { invoices(:invoice) }
  let(:sent) { invoices(:sent) }

  it "creating a payment_reminder updates invoice" do
    due_at = sent.due_at + 2.weeks
    expect do
      Fabricate(:payment_reminder, invoice: sent, due_at: due_at)
    end.to change { [sent.due_at, sent.state] }
    expect(sent.due_at).to eq due_at
    expect(sent.state).to eq "reminded"
  end

  it "validates invoice is in state sent" do
    reminder = Invoice.new.payment_reminders.build
    expect(reminder).to have(1).error_on(:invoice)
  end

  it "validates due_at is set" do
    reminder = sent.payment_reminders.build
    expect(reminder).to have(1).error_on(:due_at)
  end

  it "validates due_at is after invoice.due_date" do
    reminder = sent.payment_reminders.build(due_at: sent.due_at)
    expect(reminder).to have(1).error_on(:due_at)
  end
end
