#  Copyright (c) 2012-2013, Jungwacht Blauring Schweiz. This file is part of
#  hitobito and licensed under the Affero General Public License version 3
#  or later. See the COPYING file at the top-level directory or at
#  https://github.com/hitobito/hitobito.

desc "Add column annotations to active records"
task :annotate do
  sh "RAILS_ENV=test annotate -p before -e tests"
end

namespace :erd do
  task options: :customize
  task :customize do
    require Rails.root.join("lib", "tasks", "rails_erd_patch.rb")
    ENV["attributes"] ||= "content,inheritance,foreign_keys,timestamps"
    ENV["indirect"] ||= "false"
    ENV["orientation"] ||= "vertical"
    ENV["notation"] ||= "uml"
    ENV["filename"] ||= "doc/models"
    ENV["filetype"] ||= "png"
  end
end
