# frozen_string_literal: true

#  Copyright (c) 2022, Schweizer Blasmusikverband. This file is part of
#  hitobito and licensed under the Affero General Public License version 3
#  or later. See the COPYING file at the top-level directory or at
#  https://github.com/hitobito/hitobito.

module Export::Tabular::Event::Participations
  class TableDisplays < Export::Tabular::People::TableDisplays
    self.model_class = ::Event::Participation
    self.row_class = TableDisplayRow

    def public_account_labels(accounts, klass)
      account_labels(people_list.map(&:accounts).flatten.select(&:public?), klass)
    end

    def human_attribute(attr)
      Person.human_attribute_name(attr)
    end

    private

    def people_ids
      @people_ids ||= people_list.pluck("id")
    end

    def people_list
      @people_list ||= @list.map(&:person)
    end
  end
end
