#  Copyright (c) 2012-2013, Jungwacht Blauring Schweiz. This file is part of
#  hitobito and licensed under the Affero General Public License version 3
#  or later. See the COPYING file at the top-level directory or at
#  https://github.com/hitobito/hitobito.

# encoding:  utf-8

require "spec_helper"

describe Event::KindsController, type: :controller do
  class << self
    def it_should_redirect_to_show
      it { is_expected.to redirect_to event_kinds_path(returning: true) }
    end
  end

  let(:test_entry) { event_kinds(:slk) }
  let(:test_entry_attrs) do
    {label: "Automatic Bar Course",
     short_name: "ABC",
     minimum_age: 21}
  end

  before { sign_in(people(:top_leader)) }

  include_examples "crud controller", skip: [%w[show], %w[destroy]]

  # must be after include_examples
  let(:sort_column) { "label" } # rubocop:disable RSpec/LetBeforeExamples

  it "soft deletes" do
    expect { post :destroy, params: {id: test_entry.id} }.to change { Event::Kind.without_deleted.count }.by(-1)
  end

  describe_action :get, :index do
    context ".html", format: :html do
      it "should contain all entries" do
        expect(entries.size).to eq(Event::Kind.count)
      end

      it "should contain all entries in french", perform_request: false do
        I18n.locale = :fr
        perform_request
        expect(entries.size).to eq(Event::Kind.count)
      end
    end
  end
end
