# frozen_string_literal: true

# Copyright (c) 2012-2022, Hitobito AG. This file is part of
# hitobito and licensed under the Affero General Public License version 3
# or later. See the COPYING file at the top-level directory or at
# https://github.com/hitobito/hitobito.

require "spec_helper"

describe MailingLists::BulkMail::BounceMessageForwardJob do
  include Mails::ImapMailsSpecHelper

  let(:raw_bounce_mail) { Mail.read_from_string(Rails.root.join("spec", "fixtures", "email", "list_bounce.eml").read) }

  let(:bulk_mail_bounce) do
    Message::BulkMailBounce.create!(
      state: :pending,
      bounce_parent: messages(:mail),
      raw_source: raw_bounce_mail,
      subject: "Undelivered Mail Returned to Sender"
    )
  end

  let!(:mail_log) do
    MailLog.create!(
      mail_from: "MAILER-DAEMON@example.com",
      message: bulk_mail_bounce,
      mail_hash: "abcd42"
    )
  end

  subject { described_class.new(bulk_mail_bounce) }

  it "forwards bounce message" do
    Settings.email.list_domain = "hitobito.example.com"

    subject.perform

    expect(last_email.to).to eq(["sender@example.com"])
    expect(last_email.from).to eq(["noreply@hitobito.example.com"])
    expect(last_email.smtp_envelope_from).to eq("noreply@hitobito.example.com")
    expect(last_email.sender).to eq("noreply@hitobito.example.com")
    expect(last_email.subject).to eq("Undelivered Mail Returned to Sender")

    expect(mail_log.reload.status).to eq("completed")
    expect(bulk_mail_bounce.reload.raw_source).to be_nil
    expect(bulk_mail_bounce.state).to eq("finished")
  end
end
