#  Copyright (c) 2006-2017, Puzzle ITC GmbH. This file is part of
#  PuzzleTime and licensed under the Affero General Public License version 3
#  or later. See the COPYING file at the top-level directory or at
#  https://github.com/puzzle/puzzletime.


# Puma can serve each request in a thread from an internal thread pool.
# The `threads` method setting takes two numbers: a minimum and maximum.
# Any libraries that use thread pools should be configured to match
# the maximum value specified for Puma. Default is set to 5 threads for minimum
# and maximum; this matches the default thread size of Active Record.
#
threads_count = ENV.fetch("RAILS_MAX_THREADS", 5).to_i
threads threads_count, threads_count

# Specifies the `port` that Puma will listen on to receive requests; default is 3000.
#
port        ENV.fetch("PORT", 3000)

# Specifies the `environment` that Puma will run in.
#
environment ENV.fetch("RAILS_ENV", "development")

# Specifies the number of `workers` to boot in clustered mode.
# Workers are forked webserver processes. If using threads and workers together
# the concurrency of the application would be max `threads` * `workers`.
# Workers do not work on JRuby or Windows (both of which do not support
# processes).
#
worker_count = ENV.fetch("WEB_CONCURRENCY", 1).to_i
workers worker_count if worker_count > 1

# Use the `preload_app!` method when specifying a `workers` number.
# This directive tells Puma to first boot the application and load code
# before forking the application. This takes advantage of Copy On Write
# process behavior so workers use less memory.
#
preload_app! if worker_count > 1

# Allow puma to be restarted by `rails restart` command.
plugin :tmp_restart

if ENV['PROMETHEUS_EXPORTER_HOST']
  after_worker_boot do
    require 'prometheus_exporter/instrumentation'

    PrometheusExporter::Instrumentation::Puma.start
  end

  on_worker_boot do
    require 'prometheus_exporter/instrumentation'
    PrometheusExporter::Instrumentation::Process.start(
      type: 'puma_worker',
      labels: { hostname: `hostname`.strip }
    )
    PrometheusExporter::Instrumentation::ActiveRecord.start(
      custom_labels: { type: 'puma_worker' },
      config_labels: [:database]
    )
  end
end
