# frozen_string_literal: true

#  Copyright (c) 2024, Schweizer Alpen-Club. This file is part of
#  hitobito and licensed under the Affero General Public License version 3
#  or later. See the COPYING file at the top-level directory or at
#  https://github.com/hitobito/hitobito.

module MailingLists
  class SubscribableForConfiguredCleanupJob < BaseJob
    self.parameters = [:mailing_list_id]

    def initialize(mailing_list_id)
      super()
      @mailing_list_id = mailing_list_id
    end

    def perform
      allowed = allowed_people.pluck(:id)
      subscribed = list.subscriptions.people.pluck(:subscriber_id)

      list.subscriptions.people.where(subscriber_id: subscribed - allowed).destroy_all
    end

    private

    def list
      @list ||= MailingList.find(@mailing_list_id)
    end

    def allowed_people
      MailingLists::Subscribers.new(list).people_as_configured(use_people_subscriptions: false)
    end
  end
end
