#  Copyright (c) 2023, Cevi Schweiz. This file is part of
#  hitobito and licensed under the Affero General Public License version 3
#  or later. See the COPYING file at the top-level directory or at
#  https://github.com/hitobito/hitobito.

module TableDisplays::Event::Participations
  class ShowDetailsOrEventLeaderColumn < TableDisplays::PolymorphicPublicColumn
    protected

    def allowed?(object, _attr, original_object, _original_attr)
      index_full_participations?(original_object) || show_details?(object)
    end

    private

    def show_details?(person)
      ability.can?(:show_details, person)
    end

    def index_full_participations?(participation)
      ability.can?(:index_full_participations, participation.event)
    end
  end
end
