#  frozen_string_literal: true

#  Copyright (c) 2012-2021, CVP Schweiz. This file is part of
#  hitobito_cvp and licensed under the Affero General Public License version 3
#  or later. See the COPYING file at the top-level directory or at
#  https://github.com/hitobito/hitobito_cvp.

class MessageAbility < AbilityDsl::Base
  on(Message) do
    permission(:layer_and_below_full)
      .may(:create)
      .in_layer_or_below_if_active

    permission(:layer_and_below_full)
      .may(:show)
      .in_layer_or_below

    permission(:layer_and_below_full)
      .may(:edit, :update, :destroy)
      .in_layer_or_below_if_not_dispatched_nor_bulkmail

    permission(:any)
      .may(:show)
      .if_assignment_assignee_or_creator
  end

  def if_assignment_assignee_or_creator
    subject.assignments.any? { |a| [a.person_id, a.creator_id].include?(user.id) }
  end

  def in_layer_or_below
    permission_in_layers?(subject.group.layer_hierarchy.collect(&:id))
  end

  def in_layer_or_below_if_active
    in_layer_or_below && !subject.group.archived?
  end

  def in_layer_or_below_if_not_dispatched_nor_bulkmail
    not_bulk_mail &&
      in_layer_or_below_if_active &&
      !subject.dispatched?
  end

  def not_bulk_mail
    !subject.is_a?(Message::BulkMail)
  end
end
