# Changelog

This changelog goes through all the changes that have been made in each release
without substantial changes to our git log; to see the highlights of what has
been added to each release, please refer to the [blog](https://blog.gitea.io).

## [1.11.3](https://github.com/go-gitea/gitea/releases/tag/v1.11.3) - 2020-03-10

* BUGFIXES
  * Prevent panic in stopwatch (#10670) (#10673)
  * Fix bug on pull view when required status check no ci result (#10648) (#10651)
  * Build explicitly with Go 1.13 (#10684)

## [1.11.2](https://github.com/go-gitea/gitea/releases/tag/v1.11.2) - 2020-03-06

* BREAKING
  * Various fixes in login sources (#10428) (#10429)
* SECURITY
  * Ensure only own addresses are updated (#10397) (#10399)
  * Logout POST action (#10582) (#10585)
  * Org action fixes and form cleanup (#10512) (#10514)
  * Change action GETs to POST (#10462) (#10464)
  * Fix admin notices (#10480) (#10483)
  * Change admin dashboard to POST (#10465) (#10466)
  * Update markbates/goth (#10444) (#10445)
  * Update crypto vendors (#10385) (#10398)
* BUGFIXES
  * Allow users with write permissions to modify issue descriptions and comments. (#10623) (#10626)
  * Handle deleted base branch in PR (#10618) (#10619)
  * Delete dependencies when deleting a repository (#10608) (#10616)
  * Ensure executable bit is kept on the web editor (#10607) (#10614)
  * Update mergebase in pr checker (#10586) (#10605)
  * Fix release attachments being deleted while upgrading (#10572) (#10573)
  * Fix redirection path if Slack webhook channel is invalid (#10566)
  * Fix head.tmpl og:image picture location (#10531) (#10556)
  * Fix 404 after activating secondary email (#10547) (#10553)
  * Show Signer in commit lists and add basic trust (#10425 & #10511) (#10524)
  * Fix potential bugs (#10513) (#10518)
  * Use \[:space:\] instead of \\s (#10508) (#10509)
  * Avoid mailing users that have explicitly unwatched an issue (#10475) (#10500)
  * Handle push rejection message in Merge & Web Editor (#10373) (#10497)
  * Fix SQLite concurrency problems by using BEGIN IMMEDIATE (#10368) (#10493)
  * Fix double PR notification from API (#10482) (#10486)
  * Show the username as a fallback on feeds if full name is blank (#10461)
  * Trigger webhooks on issue label-change via API too (#10421) (#10439)
  * Fix git reference type in webhooks (#10427) (#10432)
  * Prevent panic on merge to PR (#10403) (#10408)
  * Fix wrong num closed issues on repository when close issue via commit… (#10364) (#10380)
  * Reading pull attachments should depend on read UnitTypePullRequests (#10346) (#10354)
  * Set max-width on review-box comment box (#10348) (#10353)
  * Prevent nil pointer in GetPullRequestCommitStatusState (#10342) (#10344)
  * Fix protected branch status check settings (#10341) (#10343)
  * Truncate long commit message header (#10301) (#10319)
  * Set the initial commit status to Success otherwise it will always be Pending (#10317) (#10318)
  * Don't manually replace whitespace during render (#10291) (#10315)
* ENHANCEMENT
  * Admin page for managing user e-mail activation (#10557) (#10579)

## [1.11.1](https://github.com/go-gitea/gitea/releases/tag/v1.11.1) - 2020-02-15

* BUGFIXES
  * Repo name added to automatically generated commit message when merging (#9997) (#10285)
  * Fix Workerpool deadlock (#10283) (#10284)
  * Divide GetIssueStats query in smaller chunks (#10176) (#10282)
  * Fix reply on code review (#10257)
  * Stop hanging issue indexer initialisation from preventing shutdown (#10243) (#10249)
  * Fix filter label emoji width (#10241) (#10244)
  * Fix issue sidebar menus having an infinite height (#10239) (#10240)
  * Fix commit between two commits calculation if there is only last commit (#10225) (#10226)
  * Only check for conflicts/merging if the PR has not been merged in the interim (#10132) (#10206)
  * Blacklist manifest.json & milestones user (#10292) (#10293)

## [1.11.0](https://github.com/go-gitea/gitea/releases/tag/v1.11.0) - 2020-02-10
* BREAKING
  * Fix followers and following tabs in profile (#10202) (#10203)
  * Make CertFile and KeyFile relative to CustomPath (#9868) (#9874)
  * Remove unused endpoints (#9538)
  * Prefix all user-generated IDs in markup (#9477)
  * Enforce Gitea environment for pushes (#8982)
  * Hide some user information via API if user have not enough permissions (#8655)
  * Move startpage/homepage translation to crowdin (#8596)
* SECURITY
  * Never allow an empty password to validate (#9682) (#9683)
  * Prevent redirect to Host (#9678) (#9679)
  * Swagger hide search field (#9554)
  * Add "search" to reserved usernames (#9063)
  * Switch to fomantic-ui (#9374)
  * Only serve attachments when linked to issue/release and if accessible by user (#9340)
* FEATURES
  * Webhooks should only show sender if it makes sense (#9601)
  * Provide Default messages for merges (#9393)
  * Add description to labels on create issue (#9392)
  * Graceful Queues: Issue Indexing and Tasks (#9363)
  * Default NO_REPLY_ADDRESS to DOMAIN (#9325)
  * Allow FCGI over unix sockets (#9298)
  * Graceful: Xorm, RepoIndexer, Cron and Others (#9282)
  * Add API for Reactions (#9220)
  * Graceful: Cancel Process on monitor pages & HammerTime (#9213)
  * Graceful: Allow graceful restart for unix sockets (#9113)
  * Graceful: Allow graceful restart for fcgi (#9112)
  * Sign protected branches (#8993)
  * Add Graceful shutdown for Windows and hooks for shutdown of goroutines (#8964)
  * Add Gitea icon to Emojis (#8950)
  * Expand/Collapse Files and Blob Excerpt while Reviewing/Comparing code (#8924)
  * Allow Custom Reactions (#8886)
  * Close/reopen issues by keywords in titles and comments (#8866)
  * Allow incompletely specified Time Formats (#8816)
  * Prevent upload (overwrite) of lfs locked file (#8769)
  * Template Repositories (#8768)
  * Add /milestones endpoint (#8733)
  * Make repository management section handle lfs locks (#8726)
  * Respect LFS File Lock on UI (#8719)
  * Add team option to grant rights for all organization repositories (#8688)
  * Enabling and disabling the commit button to prevent empty commits (web editor) (#8590)
  * Add setting to disable BASIC authentication (#8586)
  * Expose db.SetMaxOpenConns and allow non MySQL dbs to set conn pool params (#8528)
  * Allow Protected Branches to Whitelist Deploy Keys (#8483)
  * Push to create repo (#8419)
  * Sign merges, CRUD, Wiki and Repository initialisation with gpg key (#7631)
  * Add basic repository lfs management (#7199)
* BUGFIXES
  * Fix code-expansion arc-green theme bug (#10180) (#10185)
  * Prevent double wait-group decrement (#10170) (#10175)
  * Allow emoji on review head comments (#10159) (#10174)
  * Fix issue/pull link (#10158) (#10173)
  * Fix push-create SSH bugs (#10145) (#10151)
  * Prevent DeleteUser API abuse (#10125) (#10128)
  * Fix issues/pulls dashboard paging error (#10114) (#10115)
  * Add button to revert SimpleMDE to plain textarea (#10099) (#10102)
  * Fix branch page pull request title and link error (#10092) (#10097)
  * Fix PR API: Only try to get HeadBranch if HeadRepo exist (#10029) (#10088)
  * Update topics repo count when deleting repository (#10051) (#10081)
  * Show pull icon on pull requests (#10061) (#10062)
  * Fix milestone API state parameter unhandled (#10049) (#10052)
  * Move to using a temporary repo for pushing new PRs (#10009) (#10042)
  * Fix wiki raw view on sub path (#10002) (#10040)
  * Ensure that feeds are appropriately restricted (#10018) (#10019)
  * Sanitize credentials in mirror form (#9975) (#9991)
  * Close related pull requests when deleting head repository or head branch (#9927) (#9974)
  * Switch to use -f instead of -F for sendmail (#9961) (#9970)
  * Fix file rename/copy not supported by indexer (#9965) (#9967)
  * Fix repo indexer not updating upon push (#9957) (#9963)
  * Don't convert ellipsis in markdown (#9905) (#9937)
  * Fixed repo link in generated comment for cross repository dependency (#9863) (#9935)
  * Check if diff actually contains sections when rendering (#9926) (#9933)
  * Fix wrong hint when status checking is running on pull request view (#9886) (#9928)
  * Fix RocketChat (#9908) (#9921)
  * Do not try to recreate ldap user if they are already created (#9900) (#9919)
  * Create terminated channel in queue_redis (#9910) (#9911)
  * Prevent empty LDAP search result from deactivating all users (#9879) (#9896)
  * Fix wrong permissions check when issues/prs shared operations (#9885) (#9889)
  * Check user != nil before checking values (#9881) (#9883)
  * Allow hyphen in language name (#9873) (#9880)
  * Ensure that 2fa is checked on reset-password (#9857) (#9876)
  * Fix issues/pulls dependencies problems (#9842) (#9864)
  * Fix markdown anchor links (#9673) (#9840)
  * Allow assignee on Pull Creation when Issue Unit is deactivated (#9836) (#9837)
  * Fix download file wrong content-type (#9825) (#9834)
  * Fix wrong poster identity on a migrated pull request when submit review (#9827) (#9830)
  * Fix database dump when log directory is missing (#9818) (#9819)
  * Fix compare (#9808) (#9814)
  * Fix push-to-create (#9772) (#9797)
  * Fix missing msteam webhook on organization (#9781) (#9794)
  * Fix missing unlock in uniquequeue (#9790) (#9791)
  * Fix add team on collaborator page when same name as organization (#9778)
  * DeleteRepoFile incorrectly handles Delete to new branch (#9769) (#9775)
  * Fix milestones page (#9771)
  * Fix SimpleMDE quote reply (#9757) (#9768)
  * Fix missing updated time on migrated issues and comments (#9744) (#9764)
  * Move Errored PRs out of StatusChecking (#9675) (#9726)
  * Make hook status printing configurable with delay (#9641) (#9725)
  * ​Fix /repos​/issues​/search (#9698) (#9724)
  * Silence fomantic error regarding tabs (#9713) (#9718)
  * Remove unused lock (#9709) (#9710)
  * Remove q.lock.Unlock() in setInternal to prevent panic (#9705) (#9706)
  * Load milestone in API PR list (#9671) (#9700)
  * Don't attempt to close issue if already closed (#9696) (#9699)
  * Remove google font call (#9668) (#9681)
  * Eliminate horizontal scroll caused by footer (#9674)
  * Fix nil reference in repo generation (#9660) (#9666)
  * Add HTML URL to API Issues (#9654) (#9661)
  * Add PR review webhook to Telegram (#9653) (#9655)
  * Use filepath.IsAbs instead of path.IsAbs (#9651) (#9652)
  * Disable remove button on repository teams when have access to all (#9640)
  * Clean up old references on branch delete (#9614)
  * Hide public repos owned by private orgs (#9609)
  * Fix access issues on milestone and issue overview pages. (#9603)
  * Fix error logged when repos qs is empty (#9591)
  * Dont trigger notification twice on issue assignee change (#9582)
  * Fix mirror pushed commit actions (#9572)
  * Allow only specific columns to be updated on issue via API (#9189) (#9539)
  * Fix default avatar for ghost user (#9536)
  * Fix download of release attachments with same name (#9529)
  * Resolve deprecated INI conversion (#9525)
  * Ignore empty avatars during database migration (#9520)
  * Fix deleted branch isn't removed when push the branch again (#9516)
  * Fix repository issues pagination bug when there are more than one label filter (#9512)
  * Fix SetExpr failed (#9506)
  * Remove obsolete file private/push_update.go (#9503)
  * When recreating hooks, delete them first so they are recreated with the umask (#9502)
  * Properly enforce gitea environment for pushes (#9501)
  * Fix datarace on repo indexer queue (#9490)
  * Add call to load repo prior to redirect in add/remove dependency code (#9484)
  * Wrap the code indexer (#9476)
  * Use Req.URL.RequestURI() to cope with FCGI urls (#9473)
  * Set default ssh.minimum_key_sizes (#9466)
  * Fixed issue with paging in /repos/{owner}/{repo}/git/trees/{sha} api (#9459)
  * Fix wrong notification on merge (#9450)
  * Issue with Migration rule v111 (#9449)
  * Trigger webhook when deleting a branch after merging a PR (#9424)
  * Add migration to sanitize repository original_url (#9423)
  * Use OriginalURL instead of CloneAddr in migration logging (#9418)
  * Push update after branch is restored (#9416)
  * Fix wrong migration (#9381)
  * Fix show repositories filter (#9234) (#9379)
  * Fix Slack webhook payload title generation to work with Mattermost (#9378)
  * Fix double webhook for new PR (#9375)
  * AuthorizedKeysCommand should not query db directly (#9371)
  * Fix missed change to GetManager() (#9361)
  * Fix cache problem on dashboard (#9358)
  * RepoIndexer: DefaultBranch needs to be prefixed by BranchPrefix (#9356)
  * Fix protected branch using IssueID (#9348)
  * Fix nondeterministic behavior (#9341)
  * Fix PR/issue redirects when having external tracker (#9339)
  * Remove release attachments which repository has been deleted (#9334)
  * Fix issue indexer not triggered when migrating a repository (#9332)
  * Add SyncTags to uploader interface (#9326)
  * Fix bug that release attachment files not deleted when deleting repository (#9322)
  * Only sync tags after all migration release batches are completed (#9319)
  * File Edit: Author/Committer interchanged (#9297)
  * prebuild CSS/JS before xgo release binaries (#9293)
  * Log: Ensure FLAGS=none shows no flags (#9287)
  * Make Diff Detail on Pull Request Changed File UI always on Top (#9280)
  * Switch CSS minifier to cssnano (#9260)
  * Fix latest docker image haven't include static files. (#9252)
  * Don't link wiki revision to commit (#9244)
  * Change review content column to type text in db (#9229)
  * Fixed topic regex pattern and added search by topic links after save (#9219)
  * Add language to user API responce (#9215)
  * Correct tooltip message blocked by dependencies (#9211)
  * Add SimpleMDE and Fix Image Paste for Issue/Comment Editor (#9197)
  * Fix panic when diff (#9187)
  * Fix #9151 - smtp logger configuration sendTos should be an array (#9154)
  * Fix max length check and limit in multiple repo forms (#9148)
  * Always Show Password Field on Link Account Sign-in Page (#9147)
  * Properly fix displaying virtual session provider in admin panel (#9137)
  * Fix race condition on indexer (#9136)
  * Fix team links in HTML rendering (#9127)
  * Fix race condition in ReplaceSanitizer (#9123)
  * Fix what information is shown about user in API (#9115)
  * Fix nil context user for template repositories (#9099)
  * Hide given credentials for migrated repos. (#9097)
  * Fix reCAPTCHA API URL (#9083)
  * Fix password checks on admin create/edit user (#9076)
  * Update golang.org/x/crypto vendor to use acme v2 (#9056)
  * Ensure Written is set in GZIP ProxyResponseWriter (#9018)
  * Fix wrong system notice when repository is empty (#9010)
  * Fix broken link to branch from issue list (#9003)
  * Fix bug when pack js (#8992)
  * New review approvals shouldn't require a message (#8991)
  * Shadow password correctly for session config (#8984)
  * Don't send notification on pending reviews (#8943)
  * Fix Notify Create Ref Error on tag creation (#8936)
  * Convert EOL to UNIX-style to render MD properly (#8925)
  * Migrate temp_repo.go to use git.NewCommand  (#8918)
  * Fix issue with user.fullname (#8902)
  * Add Close() method to gogitRepository (#8901)
  * Enable punctuations ending mentions (#8889)
  * Fix password complexity check on registration (#8887)
  * Fix require external registration password (#8885)
  * Fix edit content button on migrated issue content (#8877)
  * Fix permission checks for close/reopen from commit (#8875)
  * Fix API Bug (fail on empty assignees) (#8873)
  * Stop using git count-objects and use raw directory size for repository (#8848)
  * Fix count for commit graph last page (#8843)
  * Fix to close opened io resources as soon as not needed (#8839)
  * Improve notification (#8835)
  * Fix new user form for non-local users (#8826)
  * Fix: remove duplicated signed commit icons (#8820)
  * Fix (open/closed) issue count when label excluded (#8815)
  * Fix SSH2 conditional in key parsing code (#8806)
  * Fix 500 when edit hook (#8782)
  * On windows set core.longpaths true (#8776)
  * Fix commit expand button to not go to commit link (#8745)
  * Avoid re-issuing redundant cross-references. (#8734)
  * Fix milestone close timestamp function (#8728)
  * Move webhook codes from service to webhook notification (#8712)
  * Show zero lines on the line counter if the file empty (#8700)
  * Fix deadline on update issue or PR via API (#8696)
  * make call createMilestoneComment on newIssue func (#8678)
  * Send tag create and push webhook when release created on UI (#8671)
  * Prevent chrome download page as html with alt + click (#8669)
  * Fix 500 when getting user as unauthenticated user (#8653)
  * Graceful fixes (#8645)
  * Add SubURL to redirect path (#8632) (#8634)
  * Fix extra columns from `label` table (#8633)
  * Add SubURL to redirect path for transferred/renamed repos (#8632)
  * Fix bug when migrate from API (#8631)
  * Allow to merge if file path contains " or \ (#8629)
  * Prevent removal of non-empty emoji panel following selection of duplicate (#8609)
  * Ensure default gpg settings not nil and found commits have reference to repo (#8604)
  * Set webhook Content-Type for application/x-www-form-urlencoded (#8599)
  * Fix #8582 by handling empty repos (#8587)
  * Fix of the diff statistics view on pull request's (#8581)
  * Fix bug on pull requests when transfer head repository (#8564)
  * Fix template error on account page (#8562)
  * Allow externalID to be UUID (#8551)
  * Fix ignored error on editorconfig api (#8550)
  * Fix user avatar name (#8547)
  * Ensure that GitRepo is set on Empty repositories (#8539)
  * Add missed close in ServeBlobLFS (#8527)
  * Fix migrate mirror 500 bug (#8526)
  * Fix password complexity regex for special characters (on master) (#8525)
* ENHANCEMENTS
  * Explicitly refer to PR in squash-merge commit message in case of external tracker (#9844) (#9855)
  * Add a /user/login landing page option (#9622)
  * Some more e-mail notification fixes (#9596)
  * Add branch protection option to block merge on requested changes. (#9592)
  * Add footer extra links template (#9576)
  * Fix for a wrong URL in activity page of repository.  (#9571)
  * Update default issue template (#9568)
  * Change markdown rendering from blackfriday to goldmark  (#9533)
  * Extend file create api with dates (#9464)
  * Add ActionCommentPull action (#9456)
  * Response for context on retry database connection (#9444)
  * Refactor webhooks to reduce code duplication (#9422)
  * update couchbase deps for new license (#9419)
  * Add .ignore file for search tools (#9417)
  * Remove unsued struct (#9405)
  * Hide not allowed Reactions (#9387)
  * Remove text from action-only webhooks (#9377)
  * Move PushToBaseRepo from models to services/pull (#9352)
  * Site admin could view org's members (#9346)
  * Sleep longer if request speed is over github limitation (#9335)
  * Refactor comment (#9330)
  * Refactor code indexer (#9313)
  * Remove SavePatch and generate patches on the fly (#9302)
  * Move some pull request functions from models to services (#9266)
  * Update JS dependencies (#9255)
  * Show label list on label set (#9251)
  * Redirect issue if repo has configured external tracker. (#9247)
  * Allow kbd tags (#9245)
  * Remove unused comment actions (#9222)
  * Fixed errors logging in dump.go (#9218)
  * Expose release counter to repo API response (#9214)
  * Make consistent links to repository in the Slack/Mattermost notificiations (#9205)
  * Expose pull request counter to repo API response (#9202)
  * Extend TrackedTimes API (#9200)
  * Extend StopWatch API (#9196)
  * Move code indexer related code to a new package (#9191)
  * Docker: ask s6 to stop all service when gitea stop (#9171)
  * Variable expansion in repository templates (#9163)
  * Add avatar and issue labels to template repositories (#9149)
  * Show single review comments in the PR conversation tab (#9143)
  * Extract createComment (#9125)
  * Move PushUpdateOptions from models to repofiles (#9124)
  * Alternate syntax for cross references (#9116)
  * Add USE_SERVICE_WORKER setting (#9110)
  * Only show part of members on orgnization dashboard and add paging for orgnization members page (#9092)
  * Explore page: Add topic param to pagination (#9077) (#9078)
  * Markdown: Sanitizier Configuration (#9075)
  * Add password requirement info on error (#9074)
  * Allow authors to use act keywords in PR content (#9059)
  * Move modules/gzip to gitea.com/macaron/gzip (#9058)
  * Branch protection: Possibility to not use whitelist but allow anyone with write access (#9055)
  * Context menus for comments, add quote reply (#9043)
  * Update branch API endpoint to show effective branch protection. (#9031)
  * Move git graph from models to modules/graph (#9027)
  * Move merge actions to notification (#9024)
  * Move mirror sync actions to notification (#9022)
  * Add retry for migration http/https requests (#9019)
  * Rewrite delivery of issue and comment mails (#9009)
  * Add review comments to mail notifications (#8996)
  * Refactor pull request review (#8954)
  * Githook highlighter (#8932)
  * Add git hooks and webhooks to template repositories; move to services (#8926)
  * Only view branch or tag if it match refType requested. (#8899)
  * Drop Admin attribute based on LDAP when login (continue #1743) (#8849)
  * Add additional periods to activity page (#8829)
  * Update go-org to optimize code (#8824)
  * Move some actions to notification/action (#8779)
  * Webhook support custom proxy (#8760)
  * Fix API deadline removal (#8759)
  * Mark review comment as invalidated when file is deleted (#8751)
  * Move pull list code to a separate file (#8748)
  * Move webhook to a standalone package under modules (#8747)
  * Multi repo select on issue page (#8741)
  * apply exclude label on milestone issue list (#8739)
  * Move issue notifications and assignee man (#8713)
  * Move issue change content from models to service (#8711)
  * Move issue change status from models to service (#8691)
  * Move more issue assignee code from models to issue service (#8690)
  * Create PR on Current Repository by Default (#8670)
  * Improve Open Graph Protocol (#8637)
  * Batch hook pre- and post-receive calls (#8602)
  * Improve webhooks (#8583)
  * Move transfer repository and rename repository on a service package and start action notification (#8573)
  * Implement/Fix PR review webhooks (#8570)
  * Rewrite markdown rendering to blackfriday v2 and rewrite orgmode rendering to go-org (#8560)
  * Move some repositories' operations to a standalone service package (#8557)
  * Allow more than 255 characters for tokens in external_login_user table (#8554)
  * Move issue label operations to issue service package (#8553)
  * Adjust error reporting from merge failures and use LC_ALL=C for git (#8548)
  * Mail assignee when issue/pull request is assigned (#8546)
  * Allow committing / adding empty files using the web ui (#8420) (#8532)
  * Move sync mirror actions to mirror service package (#8518)
  * Remove arrows on numeric inputs (#8516)
  * Support inline rendering of CUSTOM_URL_SCHEMES (#8496)
  * Recalculate repository access only for specific user (#8481)
  * Add download button for rull request diff- and patch-file (#8470)
  * Add single sign-on support via SSPI on Windows (#8463)
  * Move change issue title from models to issue service package (#8456)
  * Add included tag on  branch view (#8449)
  * Make static resouces web browser cache time customized on app.ini (#8442)
  * Enable Uploading/Removing Attachments When Editing an Issue/Comment (#8426)
  * Add pagination to commit graph page (#8360)
  * Use templates for issue e-mail subject and body (#8329)
  * Move clearlabels from models to issue service (#8326)
  * Move AddTestPullRequestTask to pull service package from models (#8324)
  * Team permission to create repository in organization (#8312)
  * Allows external rendering of other filetypes (#8300)
  * Add 'Alt + click' feature to exclude labels (#8199)
  * Configurable close and reopen keywords for PRs (#8120)
  * Configurable URL for static resources (#7911)
  * Unifies commit list in repository commit table and wiki revision page (#7907)
  * Allow cross-repository dependencies on issues (#7901)
  * Auto-subscribe user to repository when they commit/tag to it (#7657)
  * Restore Graceful Restarting & Socket Activation (#7274)
  * wiki - add 'write' 'preview' buttons to wiki edit like in issues (#7241)
  * Change target branch for pull request (#6488)
  * Display PR commits and diffs using base repo rather than forked (#3648)
* TESTING
  * Add debug option to serv to help debug problems (#9492)
  * Fix the intermittent TestGPGGit failures (#9360)
  * Testing: Update postgres sequences (#9304)
  * Missed defer prepareTestEnv (#9285)
  * Fix "data race" in testlogger (#9159)
  * Yet another attempt to fix the intermittent failure of gpg git test (#9146)
  * integrations: Fix Dropped Test Errors (#9040)
  * services/mirror: fix dropped test errors (#9007)
  * Fix intermittent GPG Git test failure (#8968)
  * Update Github Migration Tests (#8893) (#8938)
  * Update heatmap fixtures to restore tests (#8615)
* TRANSLATION
  * Fix Korean locales (#9761) (#9780)
  * Fix placeholders in the error message (#9060)
  * Fix spelling of admin.users.max_repo_creation (#8934)
  * Improve german translation of homepage (#8549)
* BUILD
  * Fix webpack polyfills (#9735) (#9738)
  * Update gitea.com/macaron to 1.4.0 (#9608)
  * Upgrade lato fonts to v16. (#9498)
  * Update alpine to 3.11 (#9440)
  * Upgrade blevesearch (#9177)
  * Remove built js/css files from git (#9114)
  * Move semantic.dropdown.custom.js to webpack (#9064)
  * Check compiled files during build (#9042)
  * Enable lazy-loading of gitgraph.js (#9036)
  * Pack web_src/js/draw.js to public/js/index.js (#8975)
  * Modernize js and use babel (#8973)
  * Move index.js to web_src and use webpack to pack them (#8598)
  * Restrict modules/graceful to non-windows build and shim IsChild (#8537)
  * Upgrade gopkg.in/editorconfig/editorconfig-core-go.v1 (#8501)
* DOCS
  * Swagger info corrections (#9441) (#9558)
  * Add ALLOW_ONLY_EXTERNAL_REGISTRATION to config cheat sheet (#8986)
  * Rephrase comment about RuntimeDirectory option in systemd config (#8912)
  * Explicitly indicate the socket unit to use the service unit "gitea.service" (#8804)
  * Adjust the must-change-password help (#8755)
  * Add notice to docs for migrating from more recent versions of Gogs (#8724)
  * Add explicit info about customization of homepage (#8694)
  * Change external asciidoctor tool to embedded mode (#8677)
  * Add Docker fail2ban configuration (#8642)
  * Correct some outdated statements in the contributing guidelines (#8612)
  * Basic Design guidelines (describing different parts of the code) (#8601)
  * Display Gitea logo in Readme (#8592)
  * Fix building from source docs to ref AppWorkPath (#8567)
  * Update the provided gitea.service to mention socket activation (#8531)
  * Doc added how to setup email (#8520)
* MISC
  * Backport Locales [2020-01-14] (#9773)
  * Add translatable Powered by Gitea text in footer (#9600)
  * Add contrib/environment-to-ini (#9519)
  * Remove unnecessary loading of settings in update hook (#9496)
  * Update gitignore list (#9437)
  * Update license list (#9436)
  * Fix background reactions in the arc-green theme (#9421)
  * Update and fix chardet import (#9351)
  * Ensure LF on checkouts and in editors (#9259)
  * Fixed topics margin (#9248)
  * Add comment to exported function WindowsServiceName (make revive) (#9241)
  * Remove empty lines on issues/pulls page (#9232)
  * Fix Add Comment Button's "+" Position (#9140)
  * Add first issue comment hashtag (#9052)
  * Change some label colors (#9051)
  * Fix double scroll in branch dropdown (#9048)
  * Add comment highlight when target from url (#9047)
  * Update display of reactions to issues and comments (#9038)
  * Button tooltip formatting under Branches (#9034)
  * Allow setting default branch via API (#9030)
  * Update dashboard context for PR reviews (#8995)
  * Show repository size in repo home page and settings (#8940)
  * Allow to add and remove all repositories to/from team. (#8867)
  * Show due date in dashboard issues list (#8860)
  * Theme arc-green: reverse heatmap colors (#8840)
  * Project files table style update (#8757)
  * gitignore debugging file from vscode (#8740)
  * Add API for Issue set Subscription (#8729)
  * Make 100% width search bar (#8710)
  * Update color theme for heatmap (#8709)
  * Add margin to title_wip_desc (#8705)
  * Improve visibility of "Pending" indicator (#8685)
  * Improve accessibility of dropdown menus (#8638)
  * Make /users/{username}/repos list private repos the current user has access to (#8621)
  * Prevent .code-view from overriding font on icon fonts (#8614)
  * Add id references on all issue events to allow internal linking (#8608)
  * Upgrade xorm to v0.8.0 (#8536)
  * Upgrade gopkg.in/ini.v1 (#8500)
  * Update CodeMirror to version 5.49.0 (#8381)
  * Wiki editor: enable side-by-side button (#7242)

## [1.10.5](https://github.com/go-gitea/gitea/releases/tag/v1.10.5) - 2020-03-06

* BUGFIXES
  * Fix release attachments being deleted while upgrading (#10572) (#10574)

## [1.10.4](https://github.com/go-gitea/gitea/releases/tag/v1.10.4) - 2020-02-16

* FEATURE
  * Prevent empty LDAP search from deactivating all users (#9879) (#9890)
* BUGFIXES
  * Fix reply on code review (#10261) (#10227)
  * Fix branch page pull request title and link error (#10092) (#10098)
  * Fix milestone API state parameter unhandled (#10049) (#10053)
  * Fix wiki raw view on sub path (#10002) (#10041)
  * Fix RocketChat Webhook (#9908) (#9921) (#9925)
  * Fix bug about wrong dependencies permissions check and other wrong permissions check (#9884) (Partial backport #9842)
  * Ensure that 2fa is checked on reset-password (#9857) (#9877)

## [1.10.3](https://github.com/go-gitea/gitea/releases/tag/v1.10.3) - 2020-01-17
* SECURITY
  * Hide credentials when submitting migration (#9102) (#9704)
  * Never allow an empty password to validate (#9682) (#9684)
  * Prevent redirect to Host (#9678) (#9680)
  * Hide public repos owned by private orgs (#9609) (#9616)
* BUGFIXES
  * Allow assignee on Pull Creation when Issue Unit is deactivated (#9836) (#9838)
  * Fix download file wrong content-type (#9825) (#9835)
  * Fix wrong identify poster on a migrated pull request when submit review (#9827) (#9831)
  * Fix dump non-exist log directory (#9818) (#9820)
  * Fix compare (#9808) (#9815)
  * Fix missing msteam webhook on organization (#9781) (#9795)
  * Fix add team on collaborator page when same name as organization (#9783)
  * Fix cache problem on dashboard (#9358) (#9703)
  * Send tag create and push webhook when release created on UI (#8671) (#9702)
  * Branches not at ref commit ID should not be listed as Merged (#9614) (#9639)

## [1.10.2](https://github.com/go-gitea/gitea/releases/tag/v1.10.2) - 2020-01-02
* BUGFIXES
  * Allow only specific Columns to be updated on Issue via API (#9539) (#9580)
  * Add ErrReactionAlreadyExist error (#9550) (#9564)
  * Fix bug when migrate from API (#8631) (#9563)
  * Use default avatar for ghost user (#9536) (#9537)
  * Fix repository issues pagination bug when there are more than one label filter (#9512) (#9528)
  * Fix deleted branch not removed when push the branch again (#9516) (#9524)
  * Fix missing repository status when migrating repository via API (#9511)
  * Trigger webhook when deleting a branch after merging a PR (#9510)
  * Fix paging on /repos/{owner}/{repo}/git/trees/{sha} API endpoint (#9482)
  * Fix NewCommitStatus (#9434) (#9435)
  * Use OriginalURL instead of CloneAddr in migration logging (#9418) (#9420)
  * Fix Slack webhook payload title generation to work with Mattermost (#9404)
  * DefaultBranch needs to be prefixed by BranchPrefix (#9356) (#9359)
  * Fix issue indexer not triggered when migrating a repository (#9333)
  * Fix bug that release attachment files not deleted when deleting repository (#9322) (#9329)
  * Fix migration releases (#9319) (#9326) (#9328)
  * Fix File Edit: Author/Committer interchanged (#9297) (#9300)

## [1.10.1](https://github.com/go-gitea/gitea/releases/tag/v1.10.1) - 2019-12-05
* BUGFIXES
  * Fix max length check and limit in multiple repo forms (#9148) (#9204)
  * Properly fix displaying virtual session provider in admin panel (#9137) (#9203)
  * Upgrade levelqueue to 0.1.0 (#9192) (#9199)
  * Fix panic when diff (#9187) (#9193)
  * Smtp logger configuration sendTos should be an array (#9154) (#9157)
  * Always Show Password Field on Link Account Sign-in Page (#9150)
  * Create PR on Current Repository by Default (#8670) (#9141)
  * Fix race on indexer (#9136) (#9139)
  * Fix reCAPTCHA URL (#9119)
  * Hide migrated credentials (#9098)
  * Update golang.org/x/crypto vendor to use acme v2 (#9056) (#9085)
  * Fix password checks on admin create/edit user (#9076) (#9081)
  * Fix add search as a reserved username (#9063) (#9065)
  * Fix permission checks for close/reopen from commit (#8875) (#9033)
  * Ensure Written is set in GZIP ProxyResponseWriter (#9018) (#9025)
  * Fix broken link to branch from issue list (#9003) (#9021)
  * Fix wrong system notice when repository is empty (#9020)
  * Shadow password correctly for session config (#8984) (#9002)

## [1.10.0](https://github.com/go-gitea/gitea/releases/tag/v1.10.0) - 2019-11-13
* BREAKING
  * Fix deadline on update issue or PR via API (#8698)
  * Hide some user information via API if user doesn't have enough permission (#8655) (#8657)
  * Remove legacy handling of drone token (#8191)
  * Change repo search to use exact match for topic search. (#7941)
  * Add pagination for admin api get orgs and fix only list public orgs bug (#7742)
  * Implement the ability to change the ssh port to match what is in the gitea config (#7286)
* SECURITY
  * Fix issue with user.fullname (#8903)
  * Ignore mentions for users with no access (#8395)
  * Be more strict with git arguments (#7715)
  * Extract the username and password from the mirror url (#7651)
  * reserve .well-known username (#7637)
* FEATURES
  * Org/Members: display 2FA members states + optimize sql requests (#7621)
  * SetDefaultBranch on pushing to empty repository (#7610)
  * Adds side-by-side diff for images (#6784)
  * API method to list all commits of a repository (#6408)
  * Password Complexity Checks  (#6230)
  * Add option to initialize repository with labels (#6061)
  * Add additional password hash algorithms (#6023)
* BUGFIXES
  * Allow to merge if file path contains " or \ (#8629) (#8771)
  * On windows set core.longpaths true (#8776) (#8786)
  * Fix 500 when edit hook (#8782) (#8789)
  * Fix Checkbox at RepoSettings Protected Branch (#8799) (#8801)
  * Fix SSH2 conditional in key parsing code (#8806) (#8810)
  * Fix commit expand button to not go to commit link (#8745) (#8825)
  * Fix new user form for non-local users (#8826) (#8828)
  * Fix to close opened io resources as soon as not needed (#8839) (#8846)
  * Fix edit content button on migrated issue content (#8877) (#8884)
  * Fix require external registration password (#8885) (#8890)
  * Fix password complexity check on registration (#8887) (#8888)
  * Update Github Migration Tests (#8896) (#8938) (#8945)
  * Enable punctuations ending mentions (#8889) (#8894)
  * Add Close() method to gogitRepository (#8901) (#8956)
  * Hotfix for review actions and notifications (#8965)
  * Expose db.SetMaxOpenConns and allow non MySQL dbs to set conn pool params (#8528) (#8618)
  * Fix milestone close timestamp (#8728) (#8730)
  * Fix 500 when getting user as unauthenticated user (#8653) (#8663)
  * Fix 'New Issue Missing Milestone Comment' (#8678) (#8681)
  * Use AppSubUrl for more redirections (#8647) (#8651)
  * Add SubURL to redirect path (#8632) (#8634)
  * Fix template error on account page (#8562) (#8622)
  * Allow externalID to be UUID (#8551) (#8624)
  * Prevent removal of non-empty emoji panel following selection of duplicate (#8609) (#8623)
  * Update heatmap fixtures to restore tests (#8615) (#8616)
  * Ensure that diff stats can scroll independently of the diff (#8581) (#8621)
  * Webhook: set Content-Type for application/x-www-form-urlencoded (#8600)
  * Fix #8582 by handling empty repos (#8587) (#8594)
  * Fix bug on pull requests when transfer head repository (#8564) (#8569)
  * Add missed close in ServeBlobLFS (#8527) (#8542)
  * Ensure that GitRepo is set on Empty repositories (#8539) (#8541)
  * Fix migrate mirror 500 bug (#8526) (#8530)
  * Fix password complexity regex for special characters (#8524)
  * Prevent .code-view from overriding font on icon fonts (#8614) (#8627)
  * Allow more than 255 characters for tokens in external_login_user table (#8554)
  * Fix errors in create org UI regarding team access permission (#8506)
  * Fix bug on FindExternalUsersByProvider (#8504)
  * Create .ssh dir as necessary (#8486)
  * IsBranchExist: return false if provided name is empty (#8485)
  * Making openssh listen on SSH_LISTEN_PORT not SSH_PORT (#8477)
  * Add check for empty set when dropping indexes during migration (#8471)
  * LFS files are relative to LFS content path, ensure that when deleting they are made relative to this (#8455)
  * Ensure Request Body Readers are closed in LFS server (#8454)
  * Fix template bug on mirror repository setting page (#8438)
  * Fix migration v96 to keep issue attachments (#8435)
  * Update strk.kbt.io/projects/go/libravatar to latest (#8429)
  * Singular form for files that has only one line (#8416)
  * Check for either escaped or unescaped wiki filenames (#8408)
  * Allow users with explicit read access to give approvals (#8382)
  * Fix editor commit to new branch if PR disabled (#8375)
  * readd .markdown class to all markup renderers (#8357)
  * Upgrade xorm to v0.7.9 to fix some bugs (#8354)
  * Fix column name ambiguity in GetUserIssueStats() (#8347)
  * Change general form binding to gogs form (#8334)
  * Fix pull request commit status in user dashboard list (#8321)
  * Fix repo_admin_change_team_access always checked in org settings (#8319)
  * Update to github.com/lafriks/xormstore@v1.3.0 (#8317)
  * Show correct commit status in PR list (#8316)
  * Bugfix for image compare and minor improvements to image compare (#8289)
  * Update xorm (#8286)
  * Fix API for edit and delete release attachment (#8285)
  * Fix nil object access in some conditions when parsing cross references (#8281)
  * Fix label count (#8267)
  * Only show teams access for organization repositories on collaboration setting page (#8265)
  * Test more reserved usernames (#8263)
  * Rewrite reference processing code in preparation for opening/closing from comment references (#8261)
  * Fix assets key on release webhook (#8253)
  * Allow registration when button is hidden (#8237)
  * Fix release API URL generation (#8234)
  * Fix milestone num_issues (#8221)
  * MS Teams webhook misses commit messages (#8209)
  * Fix data race (#8204)
  * Fix team user api (#8172)
  * Fix pull merge 500 error caused by git-fetch breaking behaviors (#8161)
  * Make show private icon when repo avatar set (#8144)
  * Add reviewers as participants (#8121)
  * Fix Go 1.13 private repository go get issue (#8112)
  * feat: highlight issue references with : (#8101)
  * Make AllowedUsers configurable in sshd_config (#8094)
  * Strict name matching for Repository.GetTagID() (#8074)
  * Avoid ambiguity of branch/directory names for the git-diff-tree command (#8066)
  * Add change title notification for issues (#8061)
  * [ssh] fix the config specification in the authorized_keys template (#8031)
  * Fix reading git notes from nested trees (#8026)
  * Fixes synchronize tags to releases for repository - makes sure we are only getting tag refs (#7990)
  * Fix adding default Telegram webhook (#7972)
  * Run CORS handler first for /api routes (#7967)
  * Abort synchronization from LDAP source if there is some error. (#7960)
  * Fix wrong sender when send slack webhook (#7918)
  * Fix bug when migrating a private repository (#7917)
  * Evaluate emojis in commit messages in list view (#7906)
  * Fix upload file type check (#7890)
  * lfs/lock: round locked_at timestamp to second (#7872)
  * fix non existent milestone with 500 error instead of 404 (#7867)
  * gpg/bugfix: Use .ExpiredUnix.IsZero to display green color of forever valid gpg key (#7846)
  * Fix duplicate call of webhook (#7821)
  * Enable switching to a different source branch when PR already exists (#7819)
  * Convert files to utf-8 for indexing (#7814)
  * Do not fetch all refs in pull-request compare (#7797)
  * Fix multiple bugs with statuses endpoints at API (#7785)
  * Restore functionality for early gits (#7775)
  * Fix Slack webhook fork message (#7774)
  * Rewrite existing repo units if setting is not included in api body (#7763)
  * Fix rename failed when rewrite public keys (#7761)
  * Fix approvals counting (#7757)
  * Add migration step to remove old repo_indexer_status orphaned records (#7746)
  * Fix repo_index_status lingering when deleting a repository (#7734)
  * Remove camel case tokenization from repo indexer (#7733)
  * Fix milestone completness calculation when migrating (#7725)
  * Regression: Include "executable" files in the index, as they are not necessarily … (#7718)
  * Fixes indexed repos keeping outdated indexes when files grow too large (#7712)
  * Skip non-regular files (e.g. submodules) on repo indexing (#7711)
  * Fix dropTableColumns sqlite implementation (#7710)
  * Update gopkg.in/src-d/go-git.v4 to v4.13.1 (#7705)
  * improve branches list performance and fix protected branch icon when no-login (#7695)
  * Correct wrong datetime format for git (#7689)
  * Move add to hook queue for created repo to outside xorm session. (#7675)
  * sugestion to use range .Branches (#7674)
  * Fix bug on migrating milestone from github (#7665)
  * hide delete/restore button on archived repos (#7658)
  * css: use flex to fix floating paginate (#7656)
  * Fix syntax highlight initialization (#7617)
  * Fix panic on push at - Merging pull request causes 500 error (#7615)
  * Make PKCS8, PEM and SSH2 keys work (#7600)
  * Fix mistake in arc-green.less split-diff css code. (#7587)
  * Handle ErrUserProhibitLogin in http git (#7586)
  * Fix bug create/edit wiki pages when code master branch protected (#7580)
  * Fixes Malformed URLs in API git/commits response (#7565)
  * Fix file header overflow in file and blame views (#7562)
  * Improve SSH key parser to handle newlines in keys (#7522)
  * Fix empty commits now showing in repo overview (#7521)
  * Fix repository's pull request count error (#7518)
  * Fix markdown invoke sequence (#7513)
  * Remove duplicated webhook trigger (#7511)
  * Update User.NumRepos atomically in createRepository (#7493)
  * Fix settings page of repo you aren't admin print error - Settings pages giving UnitType error message (#7482)
  * Fix redirection after file edit - Handles all redirects for Web UI File CRUD (#7478)
  * cmd/serv: actually exit after fatal errors (#7458)
  * Fix an issue with some pages throwing 'not defined' js exceptions (#7450)
  * fix Dropzone.js integration (#7445)
  * Fix regex for issues in commit messages (#7444)
  * Diff: Fix indentation on unhighlighted code (#7435)
  * Only show "New Pull Request" button if repo allows pulls (#7426)
  * Upgrade macaron/captcha to fix random error problem (#7407)
  * create class for inline positioned lists (#7393)
  * Fetch refs for successful testing for tag (#7388)
  * add missing template variable on organisation settings (#7385)
  * fix post parameter - on issue list - unset assignee (#7380)
  * fix/define autochecked checkboxes on issue list in firefox (#7320)
  * only return head: null if source branch was deleted (#6705)
* ENHANCEMENTS
  * Add nofollow to sign in links (#8509)
  * vendor: update mvdan.cc/xurls/v2 to v2.1.0 (#8495)
  * Update milestone issues numbers when save milestone and other code improvements (#8411)
  * Add extra user information when migrating release (#8331)
  * Require overall success if no context is given for status check (#8318)
  * Transaction-aware retry create issue to cope with duplicate keys (#8307)
  * Change link on issue milestone (#8246)
  * Alwaywas return local url for users avatar (#8245)
  * Move some milestone functions to a standalone package (#8213)
  * Move create issue comment to comments package (#8212)
  * Disable max height property of comment textarea (#8203)
  * Add 'Mentioning you' group to /issues page (#8201)
  * oauth2 with remote Gitea (#8149)
  * Reference issues from pull requests and other issues (#8137)
  * Fix webhooks to use proxy from environment (#8116)
  * Add merged commit id on pull view when it's merged (#8062)
  * Add teams to repo on collaboration page. (#8045)
  * Update swagger to 0.20.1  (#8010)
  * Make link last commit massages in repository home page and commit tables (#8006)
  * Add API endpoint for accessing repo topics (#7963)
  * Include description in repository search (#7942)
  * Use gitea forked macaron (#7933)
  * Fix pull creation with empty changes (#7920)
  * Allow token as authorization for accessing attachments (#7909)
  * Retry create issue to cope with duplicate keys (#7898)
  * Move git diff codes from models to services/gitdiff (#7889)
  * migrate gplus to google oauth2 provider (#7885)
  * Remove unique filter from repo indexer analyzer. (#7878)
  * Detect delimiter in CSV rendering (#7869)
  * Import topics during migration (#7851)
  * Move CreateReview to modules/pull (#7841)
  * vendor: update pdf.js to v2.1.266 (#7834)
  * Support SSH_LISTEN_PORT env var in docker app.ini template (#7829)
  * Add Ability for User to Customize Email Notification Frequency (#7813)
  * Move database settings from models to setting (#7806)
  * Display ui time with customize time location (#7792)
  * Implement webhook branch filter (#7791)
  * Restrict repository indexing by glob match (#7767)
  * Api: advanced settings for repository (external wiki, issue tracker etc.) (#7756)
  * Update migrated repositories' issues/comments/prs poster id if user has a github external user saved (#7751)
  * deps: Upgrade gopkg.in/editorconfig/editorconfig-core-go.v1 (#7749)
  * Apply emoji on commit graph page (#7743)
  * Add a lot of extension to language mappings for syntax highlights (#7741)
  * Add SQL execution on log and indexes on table repository and comment (#7740)
  * Set DB connection error level to error (#7724)
  * Check commit message hashes before making links (#7713)
  * remove unnecessary fmt on generate bindata (#7706)
  * Fix specific highlighting (CMakeLists.txt ...) (#7686)
  * Add file status on API (#7671)
  * Add support for DEFAULT_ORG_MEMBER_VISIBLE (#7669)
  * Provide links in commit summaries in commits table/view list (#7659)
  * Change length of some repository's columns (#7652)
  * Move commit repo action from models to repofiles package (#7645)
  * fix wrong email when use gitea as OAuth2 provider (#7640)
  * [Branch View] add download button (#7604)
  * Update to xorm@v0.7.4 (#7596)
  * use 403 instead of 401 for ErrUserProhibitLogin (#7591)
  * Removed unnecessary conversions (#7557)
  * Un-lambda base.FileSize (#7556)
  * Added missing error checks in tests (#7554)
  * Move create release from models to a standalone package (#7539)
  * Make default branch name link to default branch (#7519)
  * Added total count of contributions to heatmap (#7517)
  * Move mirror to a standalone package from models (#7486)
  * Move models.PushUpdate to repofiles.PushUpdate (#7485)
  * Include thread related headers in issue/coment mail (#7484)
  * Refuse merge until all required status checks success (#7481)
  * convert all js var to let/const (#7464)
  * Only create branches for opened pull requestes when migrating from github (#7463)
  * jQuery 3 (#7425)
  * Add notification placeholder (#7409)
  * Search Commits via Commit Hash (#7400)
  * Move status table to cron package (#7370)
  * wiki - page revisions list  (#7369)
  * Display original author and URL information when showing migrated issues/comments (#7352)
  * Refactor filetype is not allowed errors (#7309)
  * switch to use gliderlabs/ssh for builtin server (#7250)
  * Remove settting dependency on modules/session (#7237)
  * Move all mail related codes from models to services/mailer (#7200)
  * Support git.PATH entry in app.ini (#6772)
  * Support setting cookie domain (#6288)
  * Move migrating repository from frontend to backend (#6200)
  * Delete releases attachments if release is deleted (#6068)
* TRANSLATION
  * Latvian translation for home page (#8468)
  * Add home template italian translation (#8352)
  * fix misprint (#7452)
* BUILD
  * use go 1.13 (#8088)
* MISC
  * add file line count info on UI (#8396)
  * Make issues page left menu 100% width and add reponame as title attribute (#8359)
  * [arc-green] white on hover for active menu items (#8344)
  * Move ref (branch or tag) location on issue list page (#8157)
  * apply emoji on dashboard issue list labels (#8156)
  * 1148: Take up the full width when viewing the diff in split view. (#8114)
  * Display description of 'make this repo private' as help text, not as tooltip (#8097)
  * Fixes deformed emoji in pull request reviews (#8047)
  * Add strike to old header on comment (#8046)
  * Add tooltip for the visibility checkbox in /repo/create (#8025)
  * Update github.com/lafriks/xormstore and tidy up mod.go (#8020)
  * keep blame view buttons sequence consistent with normal view when view a file (#8007)
  * Use "Pull Request" instead of "Merge Request" (#8003)
  * Move line number to :before attr to hide from search on browser (#8002)
  * Changed black color to white for (read) number label on issue list page (#8000)
  * [Branch View] show "New Pull Request" Button only if posible (#7977)
  * Fix hook problem by only setting the git environment variables if we are passed them (#7854)
  * Prevent Commit Status and Message From Overflowing On Branch Page (#7800)
  * Fix global search result CSS, misc CSS tweaks (#7789)
  * Tweak label border CSS (#7739)
  * Fix create menu item widths (#7708)
  * [Branch View] Delete duplicate protection symbol (#7624)
  * [Branch View] Delete Table Header (#7622)
  * [Branch View] icons to buttons (#7602)
  * update js dependencies (#7462)
  * Add Extra Info to Branches Page (#7461)
  * Bump lodash from 4.17.11 to 4.17.14 (#7459)
  * wiki history improvements (#7391)
  * ui fixes - compare view and archieved repo issues (#7345)
  * dark theme scrollbars (#7269)
  * wiki - editor - add buttons 'inline code', 'empty checkbox', 'checked checkbox' (#7243)
  * Fix Statuses API only shows first 10 statuses: Add paging and extend API GetCommitStatuses (#7141)

## [1.9.6](https://github.com/go-gitea/gitea/releases/tag/v1.9.6) - 2019-11-13
* BUGFIXES
  * Allow to merge if file path contains " or \ (#8629) (#8772)
  * Fix 500 when edit hook (#8782) (#8790)
  * Fix issue with user.fullname (#8904)
  * Update Github Migration Test (#8897) (#8946)
  * Add Close() method to gogitRepository (#8901) (#8958)

## [1.9.5](https://github.com/go-gitea/gitea/releases/tag/v1.9.5) - 2019-10-30
* BREAKING
  * Hide some user information via API if user doesn't have enough permission (#8655) (#8658)
* BUGFIXES
  * Fix milestone close timestamp (#8728) (#8731)
  * Fix deadline on update issue or PR via API (#8699)
  * Fix 'New Issue Missing Milestone Comment' (#8678) (#8682)
  * Fix 500 when getting user as unauthenticated user (#8653) (#8662)
  * Use AppSubUrl for more redirections (#8647) (#8652)
  * Add SubURL to redirect path (#8632) (#8634) (#8640)
  * Fix #8582 by handling empty repos (#8587) (#8593)
  * Fix bug on pull requests when transfer head repository (#8571)
  * Add missed close in ServeBlobLFS (#8527) (#8543)
  * Return false if provided branch name is empty for IsBranchExist (#8485) (#8492)
  * Create .ssh dir as necessary (#8369) (#8486) (#8489)
  * Restore functionality for early gits (#7775) (#8476)
  * Add check for empty set when dropping indexes during migration (#8475)
  * Ensure Request Body Readers are closed in LFS server (#8454) (#8459)
  * Ensure that LFS files are relative to the LFS content path (#8455) (#8458)
* SECURITY
  * Ignore mentions for users with no access (#8395) (#8484)
* TESTING
  * Update heatmap fixtures to restore tests (#8615) (#8617)

## [1.9.4](https://github.com/go-gitea/gitea/releases/tag/v1.9.4) - 2019-10-08
* BUGFIXES
  * Highlight issue references (#8101) (#8404)
  * Fix bug when migrating a private repository #7917 (#8403)
  * Change general form binding to gogs form (#8334) (#8402)
  * Fix editor commit to new branch if PR disabled (#8375) (#8401)
  * Fix milestone num_issues (#8221) (#8400)
  * Allow users with explicit read access to give approvals (#8398)
  * Fix commit status in PR #8316 and PR #8321 (#8339)
  * Fix API for edit and delete release attachment (#8290)
  * Fix assets on release webhook (#8283)
  * Fix release API URL generation (#8239)
  * Allow registration when button is hidden (#8238)
  * MS Teams webhook misses commit messages (backport v1.9) (#8225)
  * Fix data race (#8206)
  * Fix pull merge 500 error caused by git-fetch breaking behaviors (#8194)
  * Fix the SSH config specification in the authorized_keys template (#8193)
  * Fix reading git notes from nested trees (#8189)
  * Fix team user api (#8172) (#8188)
  * Add reviewers as participants (#8124)
* BUILD
  * Use vendored go-swagger (#8087) (#8165)
  * Fix version-validation for GO 1.13 (go-macaron/cors) (#8389)
* MISC
  * Make show private icon when repo avatar set (#8144) (#8175)

## [1.9.3](https://github.com/go-gitea/gitea/releases/tag/v1.9.3) - 2019-09-06
* BUGFIXES
  * Fix go get from a private repository with Go 1.13 (#8100)
  * Strict name matching for Repository.GetTagID() (#8082)
  * Avoid ambiguity of branch/directory names for the git-diff-tree command (#8070)
  * Add change title notification for issues (#8064)
  * Run CORS handler first for /api routes (#7967) (#8053)
  * Evaluate emojis in commit messages in list view (#8044)
  * Fix failed to synchronize tags to releases for repository (#7990) (#7994)
  * Fix adding default Telegram webhook (#7972) (#7992)
  * Abort synchronization from LDAP source if there is some error (#7965)
  * Fix deformed emoji in commit message (#8071)
* ENHANCEMENTS
  * Keep blame view buttons sequence consistent with normal view when viewing a file (#8007) (#8009)

## [1.9.2](https://github.com/go-gitea/gitea/releases/tag/v1.9.2) - 2019-08-22
* BUGFIXES
  * Fix wrong sender when send slack webhook (#7918) (#7924)
  * Upload support text/plain; charset=utf8 (#7899)
  * Lfs/lock: round locked_at timestamp to second (#7872) (#7875)
  * Fix non existent milestone with 500 error (#7867) (#7873)
* SECURITY
  * Fix No PGP signature on 1.9.1 tag (#7874)
  * Release built with go 1.12.9 to fix security fixes in golang std lib, ref: https://groups.google.com/forum/#!msg/golang-announce/oeMaeUnkvVE/a49yvTLqAAAJ
* ENHANCEMENTS
  * Fix pull creation with empty changes (#7920) (#7926)
* BUILD
  * Drone/docker: prepare multi-arch release + provide arm64 image (#7571) (#7884)

## [1.9.1](https://github.com/go-gitea/gitea/releases/tag/v1.9.1) - 2019-08-14
* BREAKING
  * Add pagination for admin api get orgs and fix only list public orgs bug (#7742) (#7752)
* SECURITY
  * Be more strict with git arguments (#7715) (#7762)
  * Release built with go 1.12.8 to fix security fixes in golang std lib, ref: https://groups.google.com/forum/#!topic/golang-nuts/fCQWxqxP8aA
* BUGFIXES
  * Fix local runs of ssh-requiring integration tests (#7855) (#7857)
  * Fix hook problem (#7856) (#7754)
  * Use .ExpiredUnix.IsZero to display green color of forever valid gpg key (#7850) (#7846)
  * Do not fetch all refs (#7797) (#7837)
  * Fix duplicate call of webhook (#7824) (#7821)
  * Enable switching to a different source branch when PR already exists (#7823)
  * Rewrite existing repo units if setting is not included in api body (#7811)
  * Prevent Commit Status and Message From Overflowing On Branch Page (#7800) (#7808)
  * API: fix multiple bugs with statuses endpoints (Backport #7785) (#7807)
  * Fix Slack webhook fork message (1.9 release backport) (#7783)
  * Fix approvals counting (#7757) (#7777)
  * Fix rename failed when rewrite public keys (#7761) (#7769)
  * Fix dropTableColumns sqlite implementation (#7710) (#7765)
  * Fix repo_index_status lingering when deleting a repository (#7738)
  * Fix milestone completness calculation when migrating (#7725) (#7732)
  * Fixes indexed repos keeping outdated indexes when files grow too large (#7731)
  * Skip non-regular files (e.g. submodules) on repo indexing (#7717)
  * Improve branches list performance and fix protected branch icon when no-login (#7695) (#7704)
  * Correct wrong datetime format for git (#7689) (#7690)

## [1.9.0](https://github.com/go-gitea/gitea/releases/tag/v1.9.0) - 2019-07-30
* BREAKING
  * Better logging (#6038) (#6095)
* SECURITY
  * Shadow the password on cache and session config on admin panel (#7300)
  * Fix markdown invoke sequence (#7513) (#7560)
  * Reserve .well-known username (#7638)
  * Do not leak secrets via timing side channel (#7364)
  * Ensure that decryption of cookie actually suceeds (#7363)
* FEATURES
  * Content API for Creating, Updating, Deleting Files (#6314)
  * Enable tls-alpn-01: Use certmanager provided TLSConfig for LetsEncrypt (#7229)
  * Add command to convert mysql database from utf8 to utf8mb4 (#7144)
  * Fixes #2738 - Adds the /git/tags API endpoint (#7138)
  * Compare branches, commits and tags with each other (#6991)
  * Show Pull Request button or status of latest PR in branch list (#6990)
  * Repository avatars (#6986)
  * Show git-notes (#6984)
  * Add commit statuses reports on pull request view (#6845)
  * Number of commits ahead/behind in branch overview (#6695)
  * Add CLI commands to manage LDAP authentication source (#6681)
  * Add support for MS Teams webhooks (#6632)
  * OAuth2 Grant UI (#6625)
  * Add SUBJECT_PREFIX mailer config option (#6605)
  * Include custom configuration file in dump (#6516)
  * Add API for manipulating Git hooks (#6436)
  * Improve migrations to support migrating milestones/labels/issues/comments/pullrequests (#6290)
  * Add option to blame files (#5721)
  * Implement Default Webhooks (#4299)
  * Telegram webhook (#4227)
* BUGFIXES
  * Send webhook after commit when creating issue with assignees (#7681) (#7684)
  * Upgrade macaron/captcha to fix random error problem (#7407) (#7683)
  * Move add to hook queue for created repo to outside xorm session. (#7682) (#7675)
  * Show protection symbol if needed on default branch (#7660) (#7668)
  * Hide delete/restore button on archived repos (#7660)
  * Fix bug on migrating milestone from github (#7665) (#7666)
  * Use flex to fix floating paginate (#7656) (#7662)
  * Change length of some repository's columns (#7652) (#7655)
  * Fix wrong email when use gitea as OAuth2 provider (#7640) (#7647)
  * Fix syntax highlight initialization (#7617) (#7626)
  * Fix bug create/edit wiki pages when code master branch protected (#7580) (#7623)
  * Fix panic on push at #7611 (#7615) (#7618)
  * Handle ErrUserProhibitLogin in http git (#7586, #7591) (#7590)
  * Fix color of split-diff view in dark theme (#7587) (#7589)
  * Fix file header overflow in file and blame views (#7562) (#7579)
  * Malformed URLs in API git/commits response (#7565) (#7567)
  * Fix empty commits now showing in repo overview (#7521) (#7563)
  * Fix repository's pull request count error (#7518) (#7524)
  * Remove duplicated webhook trigger (#7511) (#7516)
  * Handles all redirects for Web UI File CRUD (#7478) (#7507)
  * Fix regex for issues in commit messages (#7444) (#7466)
  * cmd/serv: actually exit after fatal errors (#7458) (#7460)
  * Fix an issue with some pages throwing 'not defined' js exceptions #7450 (#7453)
  * Fix Dropzone.js integration (#7445) (#7448)
  * Create class for inline positioned lists (#7439) (#7393)
  * Diff: Fix indentation on unhighlighted code (#7435) (#7443)
  * jQuery 3 (#7442) (#7425)
  * Only show "New Pull Request" button if repo allows pulls (#7426) (#7432)
  * Fix vendor references (#7394) (#7396)
  * Only return head: null if source branch was deleted (#6705) (#7376)
  * Add missing template variable on organisation settings (#7386) (#7385)
  * Fix post parameter on issue list which had unset assignee (#7380) (#7383)
  * Fix migration tests due to issue 7 being resolved (#7375) (#7381)
  * Correctly adjust mirror url (#6593)
  * Handle early git version's lack of get-url (#7065)
  * Fix icon position in issue view (#7354)
  * Cut timeline length with last element on issue view (#7355)
  * Fix mirror repository webhooks (#7366)
  * Fix api route for hooks (#7346)
  * Fix bug conflict between SyncReleasesWithTags and InsertReleases (#7337)
  * Fix pull view ui merge section (#7335)
  * Fix 7303 - remove unnessesary buttons on archived repos (#7326)
  * Fix topic bar to allow prefixes (#7325)
  * Fixes #7152 - Allow create/update/delete message to be empty, use default message (#7324)
  * Fixes #7238 - Annotated tag commit ID incorrect (#7321)
  * Dark theme fixes (#7319)
  * Gitea own dark codemirror theme (#7317)
  * Fixes #7292 - API File Contents bug (#7301)
  * Fix API link header (#7298)
  * Fix extra newlines when copying from diff in Firefox (#7288)
  * Make diff line-marker non-selectable (#7279)
  * Fix Submodule dection in subdir (#7275)
  * Fix error log when loading issues caused by a xorm bug (#7271)
  * Add .fa icon margin like .octicon (#7258)
  * Fix hljs unintenionally highlighting commit links (#7244)
  * Only check and config git on web subcommand but not others (#7236)
  * Fix migration panic when Head.User is not exist (#7226)
  * Only warn on errors in deleting LFS orphaned files during repo deletion (#7213)
  * Fix duplicated file on pull request conflicted files (#7211)
  * Allow colon between fixing word and issue (#7207)
  * Fix overflow issues in repo (#7190)
  * API error cleanup (#7186)
  * Add error for fork already existing (#7185)
  * Fixes diff on merged pull requests (#7171)
  * If milestone id is zero don't get it from database (#7169)
  * Fix pusher name via ssh push (#7167)
  * Fix database lock when use random repository fallback image (#7166)
  * Various fixes for issue mail notifications (#7165)
  * Allow archived repos to be (un)starred and (un)watched (#7163)
  * Fix GCArgs load from ini (#7156)
  * Detect noreply email address as user (#7133)
  * Avoid arbitrary format strings upon calling fail() function (#7112)
  * Validate External Tracker URL Format (#7089)
  * Repository avatar fallback configuration (#7087)
  * Fix #732: Add LFS objects to base repository on merging  (#7082)
  * Install page - Handle invalid administrator username better (#7060)
  * Workaround for posting single comments in split diff view (#7052)
  * Fix possbile mysql invalid connnection error (#7051)
  * Fix charset was not saved after installation finished (#7048)
  * Handle insecure and ports in go get (#7041)
  * Avoid bad database state after failed migration (#7040)
  * Fix wrong init dependency on markup extensions (#7038)
  * Fix default for allowing new organization creation for new users (#7017)
  * Fix content download and /verify LFS handler expecting wrong content-type (#7015)
  * Fix missing repo description when migrating (#7000)
  * Fix LFS Locks over SSH (#6999)
  * Do not attempt to return blob on submodule (#6996)
  * Fix U2F for Chrome >= 74 (#6980)
  * Fix index produces problem when issues/pulls deleted (#6973)
  * Allow collaborators to view repo owned by private org (#6965)
  * Stop running hooks on pr merge (#6963)
  * Run hooks on merge/edit and cope with protected branches (#6961)
  * Webhook Logs show proper HTTP Method, and allow change HTTP method in form (#6953)
  * Stop colorizing log files by default (#6949)
  * Rotate serv.log, http.log and hook logs and stop stacktracing in these (#6935)
  * Fix plain text overflow line wrap (#6915)
  * Fix input size for dependency select (#6913)
  * Change drone token name to let users know to use oauth2 (#6912)
  * Fix syntax highlight in blame view #6895 (#6909)
  * Use AppURL for Oauth user link (#6894)
  * Fixes #6881 - API users search fix (#6882)
  * Fix 404 when send pull request some situation  (#6871)
  * Enforce osusergo build tag for releases (#6862)
  * Fix 500 when reviewer is deleted with integration tests (#6856)
  * Fix v85.go (#6851)
  * Make dropTableColumns drop columns on sqlite and constraints on all (#6849)
  * Fix double-generation of scratch token (#6832) (#6833)
  * When mirroring we should set the remote to mirror (#6824)
  * Fix the v78 migration "Drop is_bare" on MSSQL #6707 (#6823)
  * Change verbose flag in dump command to avoid colliding with global version flag (#6822)
  * Fix #6813: Allow git.GetTree to take both commit and tree names (#6816)
  * Remove `seen` map from `getLastCommitForPaths` (#6807)
  * Show scrollbar only when needed (#6802)
  * Restore IsWindows variable assignment (#6722) (#6790)
  * Service worker js is a missing comma (#6788)
  * Fix team edit API panic (#6780)
  * Set user search base field optional in LDAP (simple auth) edit page (#6779)
  * Ignore already existing public keys after ldap sync (#6766)
  * Fix pulls broken when fork repository deleted (#6754)
  * Fix missing return (#6751)
  * Fix new team 500 (#6749)
  * OAuth2 token can be used in basic auth (#6747)
  * Fix org visibility bug when git cloning (#6743)
  * Fix bug when sort repos on org home page login with non-admin (#6741)
  * Stricter domain name pattern in email regex (#6739)
  * Fix admin template error (#6737)
  * Drop is_bare IDX only when it exists for MySQL and MariaDB (#6736)
  * UI: Detect and restore encoding and BOM in content  (#6727)
  * Load issue attributes when editing an issue with API (#6723)
  * Fix team members API (#6714)
  * Unfortunately MemProvider Init does not actually Init properly (#6692)
  * Fix partial reversion of #6657 caused by #6314 (#6685)
  * Prevent creating empty sessions (#6677)
  * Fixes #6659 - Swagger schemes selection default to page's protocol (#6660)
  * Update highlight.js to 9.15.6 (#6658)
  * Properly escape on the redirect from the web editor (#6657)
  * Fix #6655 - Don't EscapePound .Link as it is already escaped (#6656)
  * Use ctx.metas for SHA hash links (#6645)
  * Fix wrong GPG expire date (#6643)
  * upgrade version of lib/pq to v1.1.0 (#6640)
  * Fix forking an empty repository (#6637)
  * Fix issuer of OTP URI should be URI-encoded. (#6634)
  * Return a UserList from /api/v1/admin/users (#6629)
  * Add json tags for oauth2 form (#6627)
  * Remove extra slash from twitter card (#6619)
  * remove bash requirement in makefile (#6617)
  * Fix Open Graph og:image link (#6612)
  * Fix cross-compile builds (#6609)
  * Change commit summary to full message in API (#6591)
  * Fix bug user search API pagesize didn't obey ExplorePagingNum (#6579)
  * Prevent server 500 on compare branches with no common history (#6555)
  * Properly escape release attachment URL (#6512)
  * Delete local branch when repo branch is deleted (#6497)
  * Fix bug when user login and want to resend register confirmation email (#6482)
  * Fix upload attachments (#6481)
  * Avoid multi-clicks in oauth2 login (#6467)
  * Hacky fix for alignment of the create-organization dialog (#6455)
  * Change order that PostProcess Processors are run (#6445)
  * Clean up ref name rules (#6437)
  * Fix Hook & HookList in Swagger (#6432)
  * Fixed unitTypeCode not being used in accessLevelUnit (#6419)
  * Display correct error for invalid mirror interval (#6414)
  * Don't Unescape redirect_to cookie value (#6399)
  * Fix dump table name error and add some test for dump database (#6394)
  * Fix migrations 82 to ignore unsynced tags between database and git data and missing is_archived on repository table (#6387)
  * Make sure units of a team are returned (#6379)
  * Fix bug manifest.json will not request with cookie so that session will created every request (#6372)
  * Disable benchmarking during tag events on DroneIO (#6365)
  * Comments list performance optimization (#5305)
* ENHANCEMENTS
  * Update Drone docker generation to standard format (#7480) (#7496) (#7504)
  * Add API Endpoint for Repo Edit (#7006)
  * Add state param to milestone listing API (#7131)
  * Make captcha and password optional for external accounts (#6606)
  * Detect migrating batch size (#7353)
  * Fix 7255 - wrap long texts on user profile info (#7333)
  * Use commit graph files for listing pages (#7314)
  * Add git command line commitgraph support global default true when git version >= 2.18 (#7313)
  * Add LFS_START_SERVER option to control git-lfs support (#7281)
  * Dark theme markdown fixes (#7260)
  * Update go-git to v4.12.0 (#7249)
  * Show lfs config on admin panel (#7220)
  * Disable same user check for internal SSH (#7215)
  * Add LastLogin to the User API (#7196)
  * Add missing description of label on API (#7159)
  * Use go method to calculate ssh key fingerprint (#7128)
  * Enable Rust highlighting (#7125)
  * Refactor submodule URL parsing (#7100)
  * Change issue mail title. (#7064)
  * Use batch insert on migrating repository to make the process faster (#7050)
  * Improve github downloader on migrations (#7049)
  * When git version >= 2.18, git command could run with git wire protocol version 2 param if enabled (#7047)
  * Fix Erlang and Elixir highlight mappings (#7044)
  * API Org Visibility (#7028)
  * Improve handling of non-square avatars (#7025)
  * Bugfix: Align comment label and actions to the right (#7024)
  * Change UpdateRepoIndex api to include watchers (#7012)
  * Move serv hook functionality & drop GitLogger (#6993)
  * Add support of utf8mb4 for mysql (#6992)
  * Make webhook http connections resuable (#6976)
  * Move xorm logger bridge from log to models so that log module could be a standalone package (#6944)
  * Refactor models.NewRepoContext to extract git related codes to modules/git (#6941)
  * Remove macaron dependent on models (#6940)
  * Add less linter via npx (#6936)
  * Remove macaron dependent on modules/log (#6933)
  * Remove macaron dependent on models/mail.go (#6931)
  * Clean less files (#6921)
  * Fix code overflow (#6914)
  * Style orgs list in user profile (#6911)
  * Improve description of branch protection (fix #6886) (#6906)
  * Move sdk structs to modules/structs (#6905)
  * update sdk to latest (#6903)
  * Escape the commit message on issues update and title in telegram hook (#6901)
  * SearchRepositoryByName improvements and unification (#6897)
  * Change the color of issues/pulls list, merged is purple and closed is red (#6874)
  * Refactor table width to have more info shown in file list (#6867)
  * Monitor all git commands; move blame to git package and replace git as a variable (#6864)
  * Fix config ui error about cache ttl (#6861)
  * Improve localization of git activity stats (#6848)
  * Generate access token in admin cli (#6847)
  * Update github.com/urfave/cli to version 1.2.0 (#6838)
  * Rename LFS_JWT_SECRET cli option to include OAUTH2 as well (#6826)
  * internal/ssh: ignore env command totally (#6825)
  * Allow Recaptcha service url to be configured (#6820)
  * update github.com/mcuadros/go-version to v0.0.0-20190308113854-92cdf37c5b75 (#6815)
  * Use modules/git for git commands (#6775)
  * Add GET requests to webhook (#6771)
  * Move PushUpdate dependency from models to repofiles (#6763)
  * Tweak tab text and icon colors (#6760)
  * Ignore non-standard refs in git push (#6758)
  * Disable web preview for telegram webhook (#6719)
  * Show full name if DEFAULT_SHOW_FULL_NAME setting enabled (#6710)
  * Reorder file actions (#6706)
  * README WordPress the code is overflowing #6679 (#6696)
  * Improve issue reference on commit (#6694)
  * Handle redirects for git clone commands (#6688)
  * Fix one performance/correctness regression in #6478 found on Rails repository. (#6686)
  * API OTP Context (#6674)
  * Remove local clones & make hooks run on merge/edit/upload (#6672)
  * Bump github.com/stretchr/testify from 1.2.2 to 1.3.0 (#6663)
  * Bump gopkg.in/src-d/go-git.v4 from 4.8.0 to 4.10.0 (#6662)
  * Fix dropdown icon padding (#6651)
  * Add more title attributes on shortened names (#6647)
  * Update UI for topics labels on projects (#6639)
  * Trace Logging on Permission Denied & ColorFormat (#6618)
  * Add .gpg url (match github behaviour) (#6610)
  * Support for custom GITEA_CUSTOM env var in docker(#6608)
  * Show "delete branch" button on closed pull requests (#6570) (#6601)
  * Add option to disable refresh token invalidation (#6584)
  * Fix new repo dropdown alignment (#6583)
  * Fix mail notification when close/reopen issue (#6581)
  * Pre-calculate the absolute path of git (#6575)
  * Minor CSS cleanup for the navbar (#6553)
  * Render SHA1 links as code blocks (#6546)
  * Add username flag in create-user command (#6534)
  * Unifies pagination template usage (#6531) (#6533)
  * Fixes pagination width on mobile view (#5711) (#6532)
  * Improve SHA1 link detection (#6526)
  * Fixes #6446 - Sort team members and team's repositories (#6525)
  * Use stricter boundaries for auto-link detection (#6522)
  * Use regular line-height on frontpage entries (#6518)
  * Fixes #6514 - New Pull Request on files and pulls pages the same (#6515)
  * Make distinction between DisplayName and Username in email templates (#6495)
  * Add X-Auto-Response-Suppress header to outgoing messages (#6492)
  * Cleaned permission checks for API -> site admin can now do anything (#6483)
  * Support search operators for commits search (#6479)
  * Improve listing performance by using go-git (#6478)
  * Fix repo sub_menu font color in arc-green (#6477)
  * Show last commit status in pull request lists (#6465)
  * Add signatures to webhooks (#6428)
  * Optimize all images in public/img (#6427)
  * Add golangci (#6418)
  * Make "Ghost" not link to 404 page (#6410)
  * Include more variables on admin/config page (#6378)
  * Markdown: enable some more extensions (#6362)
  * Include repo name in page title tag (#6343)
  * Show locale string on timestamp (#6324)
  * Handle CORS requests (#6289)
  * Improve issue autolinks (#6273)
  * Migration Tweaks (#6260)
  * Add title attributes to all items in the repo list viewer (#6258)
  * Issue indexer queue redis support (#6218)
  * Add bio field for user (#6113)
  * Make the version within makefile overwriteable (#6080)
  * Updates to API 404 responses (#6077)
  * Use Go1.11 module (#5743)
  * UX + Security current user password reset (#5042)
  * Refactor: append, build variable and type switch (#4940)
  * Git statistics in Activity tab (#4724)
  * Drop the bits argument when generating an ed25519 key (#6504)
* TESTING
  * Exclude pull_request from fetch-tags step, fixes #7108 (#7120)
  * Refactor and improve git test (#7086)
  * Fix TestSearchRepo by waiting till indexing is done (#7004)
  * Add mssql migration tests (needs #6823) (#6852)
  * Add tests for Org API (#6731)
  * Context.ServerError and NotFound should log from their caller (#6550)
* TRANSLATION
  * Add french specific rule for translating plural texts (#6846)
* BUILD
  * Update mssql driver to last working version 20180314172330-6a30f4e59a44 (#7306)
  * Alpine 3.10 (#7256)
  * Use vfsgen instead of go-bindata (#7080)
  * remove and disable package-lock (#6969)
  * add make targets for js and css, add js linter (#6952)
  * Added tags pull step to drone config to show correct version hashes i… (#6836)
  * Make CustomPath, CustomConf and AppWorkPath configurable at build (#6631)
  * chore: update drone format to 1.0 (#6602)
  * Fix race in integration testlogger (#6556)
  * Quieter Integration Tests (#6513)
  * Drop the docker Makefile from the image (#6507)
  * Add make version on gitea version (#6485)
  * Fix #6468 - Uses space match and adds newline for all sed flavors (#6473)
  * Move code.gitea.io/git to code.gitea.io/gitea/modules/git (#6364)
  * Update npm dependencies and various tweaks (#7344)
  * Fix updated drone file (#7336)
  * Add 'npm' and 'npm-update' make targets and lockfile (#7246)
* DOCS
  * Add work path CLI option (#6922)
  * Fix logging documentation (#6904)
  * Some logging documentation (#6498)
  * Fix link to Hacking on Gitea on From-Source doc page (#6471)
  * Fix typos in docs command-line examples (#6466)
  * Added docker example for backup (#5846)

## [1.8.3](https://github.com/go-gitea/gitea/releases/tag/v1.8.3) - 2019-06-17
* BUGFIXES
  * Always set userID on LFS authentication (#7224) (Part of #6993)
  * Fix LFS Locks over SSH (#6999) (#7223)
  * Fix duplicated file on pull request conflicted files (#7211) (#7214)
  * Detect noreply email address as user (#7133) (#7195)
  * Don't get milestone from DB if ID is zero (#7169) (#7174)
  * Allow archived repos to be (un)starred and (un)watched (#7163) (#7168)
  * Fix GCArgs load from ini (#7156) (#7157)

## [1.8.2](https://github.com/go-gitea/gitea/releases/tag/v1.8.2) - 2019-05-29
* BUGFIXES
  * Fix possbile mysql invalid connnection error (#7051) (#7071)
  * Handle invalid administrator username on install page (#7060) (#7063)
  * Disable arm7 builds (#7037) (#7042)
  * Fix default for allowing new organization creation for new users (#7017) (#7034)
  * SearchRepositoryByName improvements and unification (#6897) (#7002)
  * Fix u2f registrationlist ToRegistrations() method (#6980) (#6982)
  * Allow collaborators to view repo owned by private org (#6965) (#6968)
  * Use AppURL for Oauth user link (#6894) (#6925)
  * Escape the commit message on issues update (#6901) (#6902)
  * Fix regression for API users search (#6882) (#6885)
  * Handle early git version's lack of get-url (#7065) (#7076)
  * Fix wrong init dependency on markup extensions (#7038) (#7074)

## [1.8.1](https://github.com/go-gitea/gitea/releases/tag/v1.8.1) - 2019-05-08
* BUGFIXES
  * Fix 404 when sending pull requests in some situations (#6871) (#6873)
  * Enforce osusergo build tag for releases (#6862) (#6869)
  * Don't post process commit summary in templates (#6842) (#6868)
  * Fix 500 when reviewer is deleted (#6856) (#6860)
  * Fix v78 migration for MSSQL (#6823) (#6854)
  * Added tags pull step to drone config to show correct version hashes (#6836) (#6839)
  * Fix double-generation of scratch token (#6833) (#6835)
  * When mirroring we should set the remote to mirror (#6824) (#6834)
  * Show scrollbar only when needed (#6802) (#6803)
  * Service worker js is missing a comma (#6788) (#6795)
  * Set user search base field optional in LDAP (simple auth) edit page (#6779) (#6789)
  * Fix team edit API panic (#6780) (#6785)
  * Minor CSS cleanup for the navbar (#6553) (#6781)
  * Stricter domain name pattern in email regex (#6739) (#6768)
  * Detect and restore encoding and BOM in content (#6727) (#6765)
  * Fix org visibility bug when git cloning (#6743) (#6762)
  * OAuth2 token can be used in basic auth (#6747) (#6761)
  * Fix missing return (#6751) (#6756)
  * Fix sorting repos on org home page with non-admin login (#6741) (#6746)
  * Drop is_bare IDX only when it exists for MySQL and MariaDB (#6736) (#6744)
  * Fix team members API (#6714) (#6729)
  * Load issue attributes when editing an issue with API (#6723) (#6725)
  * Fix config ui error about cache ttl (#6861) (#6865)

## [1.8.0](https://github.com/go-gitea/gitea/releases/tag/v1.8.0) - 2019-04-20
* SECURITY
  * Prevent remote code execution vulnerability with mirror repo URL settings (#6593) (#6594)
  * Resolve 2FA bypass on API (#6676) (#6674)
  * Prevent the creation of empty sessions for non-logged in users (#6690) (#6677)
* BREAKING
  * Add "ghost" and "notifications" to list of reserved user names. (#6208)
  * Change sqlite DB path default to data directory (#6198)
  * Adds MustChangePassword to user create/edit API (#6193)
  * Disable redirect for i18n (#5910)
  * Releases API paging (#5831)
  * Allow Macaron to be set to log through to gitea.log (#5667)
  * Don't close issues via commits on non-default branch (#5622)
* FEATURES
  * Add regenerate secret feature for oauth2 (#6291)
  * Expose issue stopwatch toggling via API (#5970)
  * Add other session providers (#5963)
  * Pull request conflict files detection (#5951)
  * Integrate OAuth2 Provider (#5378)
  * Implement "conversation lock" for issue comments (#5073)
  * Feature: Archive repos (#5009)
  * Discord Oauth2 support (#4476)
  * Allow to set organization visibility (public, internal, private) (#1763)
  * Added URL mapping for Release attachments like on github.com (#1707)
* ENHANCEMENTS
  * Add support for client basic auth for exchanging access tokens (#6293)
  * Add ability to sort issues by due date (#6206) (#6244)
  * Style tweaks to issue selection (#6196)
  * Increase Username and Orgname MaxSize 35 -> 40 (#6178)
  * Coverage profile with multiple packages (#6167)
  * Split setting.go to multiple files (#6154)
  * Allow labels to contain emoji (#6063)
  * Disable git fsck for mirrored repos by default (#6018)
  * Add default time out for git operations (#6015)
  * Split setting.go as multiple files (#6014)
  * Make dashboard navbar and footer full-width (#6013)
  * Add lang specific font stacks for CJK (#6007)
  * Fix header menu misalignment (#6002)
  * Enhance closed PR and Issue status in the list (#6000)
  * Make navbar full width (#5998)
  * Add option to close issues via commit on a non master branch (#5992)
  * Support n as a line highlight prefix (#5987)
  * Search for org repos (#3031) (#5986)
  * Minor UI tweaks (#5980)
  * Use native golang SSH library but ssh-keygen when enable built-in SSH server to remove dependent on that command lines (#5976)
  * Dashboard tweaks (#5974)
  * Fixes for repo topic editor (#5971)
  * Display the branch name in the commit view (#5950)
  * handle milestone events for issues and PR (#5947)
  * Add label names as filter in issue search api (#5946)
  * Repo header tweaks (#5945)
  * Better support for long repo names (#5932)
  * Fix wrapping long code lines (#5927)
  * Change GPG Validation colors and remove inline CSS (#5404) (#5896)
  * Fix "pulls.blocked_by_approvals" text (#5879)
  * Rename reject to 'request changes' (#5858)
  * Move input fields to add members to a team and repos to a team (#5853)
  * Config option to disable automatic repo watching (#5852)
  * New Issue ?body= query (#5851)
  * Add API to list tags (#5850)
  * Pagination for git tree API (#5838)
  * Add InternalTokenURI to load InternalToken from an external file (#5812)
  * Allow markdown files to read from the LFS (#5787)
  * Add the ability to use multiple labels as filters (#5786)
  * Adjust log settings when a user is not found. (#5771)
  * Log IP of failed ssh connection (#5766)
  * Moved defaults in defaults.go to setting.go (#5764)
  * Make DB connect more robust (#5738)
  * Add Default Pull Request Title (#5735)
  * Refactor repo.isBare to repo.isEmpty #5629 (#5714)
  * Add flag to skip repository dumping (#5695)
  * Prioritize "readme.md" (#5691)
  * Improve "Fork button" for guests by showing a pop up asking them to log in before forking (#5690)
  * Allow for user specific themes (#5668)
  * Display branch name in delete branch confirmation modal. (#5654)
  * New API routes added (#5594)
  * Refactor notification for indexer (#5111)
  * Refactor mail notification (#5110)
  * Show email if the authenticated user owns the profile page being requested for (#4981)
  * Optimize pulls merging (#4921)
  * Sort Repositories widget by most recently updated (#3963) (#4599)
  * Allow markdown table to scroll (#4401)
  * Automatically clear stopwatch on merging a PR (#4327)
  * Add the Owner Name to differentiate when merging (#3807)
  * Add title attributes to all items in the repo list viewer (#6258) (#6650)
* BUGFIXES
  * Fix dropdown icon padding (#6651) (#6654)
  * Fix wrong GPG expire date (#6643) (#6644)
  * Fix forking an empty repository (#6637) (#6653)
  * Remove call to EscapePound .Link as it is already escaped (#6656) (#6666)
  * Properly escape on the redirect from the web editor (#6657) (#6667)
  * Allow resend of confirmation email when logged in (#6482) (#6486)
  * Fix mail notification when close/reopen issue (#6581) (#6588)
  * Change API commit summary to full message (#6591) (#6592)
  * Add option to disable refresh token invalidation (#6584) (#6587)
  * Fix bug user search API pagesize didn't obey ExplorePagingNum (#6579) (#6586)
  * Fix new repo alignment (#6583) (#6585)
  * Prevent server 500 on compare branches with no common history (#6555) (#6558)
  * Properly escape release attachment URL (#6512) (#6523)
  * Hacky fix for alignment of the create-organization dialog (#6455) (#6462)
  * Disable benchmarking during tag events on DroneIO (#6365) (#6366)
  * Make sure units of a team are returned (#6379) (#6381)
  * Don't Unescape redirect_to cookie value (#6399) (#6401)
  * Fix dump table name error and add some test for dump database (#6394) (#6402)
  * Fix migration v82 to ignore unsynced tags between database and git data; Add missing is_archived column on repository table (#6387) (#6403)
  * Display correct error for invalid mirror interval (#6414) (#6429)
  * Clean up ref name rules (#6437) (#6439)
  * Fix Hook & HookList in Swagger (#6432) (#6440)
  * Change order that PostProcess Processors are run (#6445) (#6447)
  * Clean up various use of escape/unescape functions for URL generation (#6334)
  * Return 409 when creating repo if it already exists. (#6330)
  * Add same changes from issues page to milestone->issues page (#6328)
  * Fix ParsePatch function to work with quoted diff --git strings (#6323)
  * Fix reported issue in repo description (#6306)
  * Use url.PathEscape to escape the branchname (#6304)
  * Add robots.txt as reserved username (#6272)
  * Replace linkRegex with xurls library (#6261)
  * Remove visitLinksForShortLinks features (#6257)
  * Add unit types to repo action URL to correctly show 404 when archived (#6247)
  * Check organization visibility before everything else (#6234) (#6235)
  * Prevent double-close of issues (#6233)
  * Override xorm type mapping for U2F counter (#6232)
  * Add isAdmin to user API response (#6231)
  * Update git vendor to fix wrong release commit id and add migrations (#6224)
  * Fix fork button (#6223)
  * Fix renames over redirects (#6216)
  * Fix display dashboard even if require to change password (#6214)
  * Create a repo redirect when transferring ownership (#6210) (#6211)
  * Fix issue update race condition (#6194)
  * Fix bug when migrate repository 500 when repo is existed (#6188)
  * Fix scrollbar always present on page body (#6177)
  * Fix bug when set indexer as db and add tests (#6173)
  * Modify linkRegex to require http|https (#6171)
  * Fix bug user could change private repository to public when force private enabled. (#6156)
  * Fix admin list user/org API (#6143)
  * Make repo creation for API similar to UI (#6142)
  * Make document body a flexbox (#6139)
  * Refactor issue indexer, add some testing and fix a bug (#6131)
  * Load Issue attributes for API call (#6122)
  * Fix bug when update owner team then visit team's repo return 404 (#6119)
  * Fix heatmap and repository menu display in Internet Explorer 9+ (#6117)
  * Show private organization for admin, fix #6111 (#6112)
  * Fix prohibit login check on authorization (#6106)
  * Move to ldap.v3 to fix #5928 (#6105)
  * Remove use MakeAssigneeList in webhooks to fix deadlock (#6102)
  * Allow display of LFS stored Readme.md on directory page (#6073) (#6099)
  * Make sure labels are actually returned (#6053)
  * Fix panic: template: repo/issue/list:210: unexpected "=" in operand (#6041)
  * After deleting a repo on admin panel, UI should remember the last sort type (#6033)
  * Default create repository on organisation on its dashboard (#6026)
  * Swagger: Remove spaces in MergePullRequestOption enum (#6016)
  * Fix metrics auth token detection (#6006)
  * Fix repo header issues (#5995)
  * Fix bug when deleting a linked account will removed all (#5989)
  * Make organization dropdown scrollable when using mouse wheel (#5988)
  * Fix empty ssh key importing in ldap (#5984)
  * Admin config page mailertype setting option update (#5973)
  * Fix redirect loop during forced password change (#5965)
  * Show user who created the repository instead of the organisation in action feed (#5948)
  * Remove all CommitStatus when a repo is deleted (#5940)
  * Fix ssh deploy and user key constraints (#1357) (#5939)
  * Fix log output (#5938)
  * Set PusherName and PusherID to owner on deploy key to fix pushing with deploy keys (#5935)
  * Fix compare button (#5929)
  * Fix bug when read public repo lfs file (#5912)
  * Only allow local login if password is non-empty (#5906)
  * Recover panic in orgmode.Render if bad orgfile (#4982) (#5903)
  * Provide better panic handling (#5902)
  * Respect value of REQUIRE_SIGNIN_VIEW (#5901)
  * Show a 404 not a 500 if a repo does not exist (#5900)
  * Ensure repo is loaded in mailer (Completely fix #5891) (#5895)
  * Ensure issue.Poster is loaded in mailIssueCommentToParticipants (#5891)
  * Correct footer height if screen-width is to small (fixes #5878) (#5889)
  * In gitea serv switch off console logger to fix #5866 (#5887)
  * Don't allow pull requests to be created on an archived repository (#5883)
  * Support reviews on a deleted file path (#5880)
  * Fix compare button on upstream repo leading to 404 (#5877)
  * Fix null pointer on not logged in attempt to Sudo (#5872)
  * Fix new release creation API to allow empty target (#5870)
  * Fix an error while adding a dependency via UI. (#5862)
  * Fix failing migration v67 (#5849)
  * Fix delete correct temp directory (#5839)
  * Make sure .git/info is created before generating .git/info/sparse-che… (#5825)
  * Fix topics saving internal error and disable for archived repos (#5821)
  * Fix TLS errors when using acme/autocert for local connections (#5820)
  * When creating new repository fsck option should be enabled (#5817)
  * Request for public keys only if LDAP attribute is set  (#5816)
  * Fix serving of raw wiki files other than .md (#5814)
  * Fix migration 78 error mssql (#5791)
  * Disallow empty titles (#5785)
  * Fix the v78 migration script (#5776)
  * Ensure valid git author names passed in signatures (#5774)
  * Fix wrong assumption where a user is always said to have unassigned (her)himself (#5769)
  * Upgrade go-sql-driver/mysql to fix invalid connection error (#5748)
  * Fixing PostgreSQL dump creation (#5747)
  * Add proper CORS preflight origin validation (#5740)
  * Disable auto-migrate in docker container (#5730)
  * In basic auth check for tokens before call UserSignIn (#5725)
  * Pooled and buffered gzip implementation (#5722)
  * Ensure that sessions are passed into queries that could use the database to prevent deadlocks (#5718)
  * Keep file permissions during database migration (#5707)
  * Use correct value for "MSpan Structures Obtained" #4742 (#5706)
  * Refactor editor upload, update and delete to use git plumbing and add LFS support (#5702)
  * Update xorm to fix issue #5659 and #5651 (#5680)
  * Fix public will not be reused as public key after deleting as deploy key (#5671)
  * When redirecting, clean the path (#5669)
  * Don't list an issue on its own dependency list UI. (#5658)
  * Fix commit page showing status for current default branch (#5649) (#5650)
  * Only count users own actions for heatmap contributions (#5647)
  * Fix sqlite deadlock when assigning to a PR (#5640)
  * Refactor issue indexer (#5363)
* TESTING
  * Run benchmark at tag to track performances (#6035)
  * Add test environment for MySQL8 (#5234)
* BUILD
  * Use go 1.12 for tests and deprecate go 1.9 (#6186)
  * Makefile changes for Windows and easier development (#6103)
  * Update bleve dependency to latest master revision (#6100)
  * Switch to more recent build of xgo (#6070)
  * Add autoprefixer to css build (#6029)
  * Update the version of less (#6010)
  * Make log mailer for testing (#5893)
* DOCS
  * Add more tests and docs for issue indexer, add db indexer type for searching from database (#6144)
  * update default value of `--must-change-password` cli flag (#6032)
  * Update and expand information about building Gitea (#6019)
  * Update U2F Section of app.ini.sample (#5994)
  * Update swagger for release API pagination (#5841)
  * Added docs for the tree api (#5834)
* MISC
  * Add single commit API support (#5843)
  * Add missing GET teams endpoints (#5382)
  * Migrate database if app.ini found (#5290)

## [1.7.6](https://github.com/go-gitea/gitea/releases/tag/v1.7.6) - 2019-04-12
* SECURITY
  * Prevent remote code execution vulnerability with mirror repo URL settings (#6593) (#6595)
* BUGFIXES
  * Allow resend of confirmation email when logged in (#6482) (#6487)

## [1.7.5](https://github.com/go-gitea/gitea/releases/tag/v1.7.5) - 2019-03-27
* BUGFIXES
  * Fix unitTypeCode not being used in accessLevelUnit (#6419) (#6423)
  * Fix bug where manifest.json was being requested without cookies and continuously creating new sessions (#6372) (#6383)
  * Fix ParsePatch function to work with quoted diff --git strings (#6323) (#6332)

## [1.7.4](https://github.com/go-gitea/gitea/releases/tag/v1.7.4) - 2019-03-12
* SECURITY
  * Fix potential XSS vulnerability in repository description. (#6306) (#6308)
* BUGFIXES
  * Fix wrong release commit id (#6224) (#6300)
  * Fix panic on empty signed commits (#6292) (#6300)
  * Fix organization dropdown not being scrollable when using mouse wheel (#5988) (#6246)
  * Fix displaying dashboard even if required to change password (#6214) (#6215)

## [1.7.3](https://github.com/go-gitea/gitea/releases/tag/v1.7.3) - 2019-02-27
* BUGFIXES
  * Fix server 500 when trying to migrate to an already existing repository (#6188) (#6197)
  * Load Issue attributes for API /repos/{owner}/{repo}/issues/{index} (#6122) (#6185)
  * Fix bug whereby user could change private repository to public when force private enabled. (#6156) (#6165)
  * Fix bug when update owner team then visit team's repo return 404 (#6119) (#6166)
  * Fix heatmap and repository menu display in Internet Explorer 9+ (#6117) (#6137)
  * Fix prohibit login check on authorization (#6106) (#6115)
  * Fix LDAP protocol error regression by moving to ldap.v3 (#6105) (#6107)
  * Fix deadlock in webhook PullRequest (#6102) (#6104)
  * Fix redirect loop when password change is required and Gitea is installed as a suburl (#5965) (#6101)
  * Fix compare button regression (#5929) (#6098)
  * Recover panic in orgmode.Render if bad orgfile (#4982) (#5903) (#6097)

## [1.7.2](https://github.com/go-gitea/gitea/releases/tag/v1.7.2) - 2019-02-14
* BUGFIXES
  * Remove all CommitStatus when a repo is deleted (#5940) (#5941)
  * Fix notifications on pushing with deploy keys by setting hook environment variables (#5935) (#5944)
  * Silence console logger in gitea serv (#5887) (#5943)
  * Handle milestone webhook events for issues and PR (#5947) (#5955)
  * Show user who created the repository instead of the organization in action feed (#5948) (#5956)
  * Fix ssh deploy and user key constraints (#1357) (#5939) (#5966)
  * Fix bug when deleting a linked account will removed all (#5989) (#5990)
  * Fix empty ssh key importing in ldap (#5984) (#6009)
  * Fix metrics auth token detection (#6006) (#6017)
  * Create repository on organisation by default on its dashboard (#6026) (#6048)
  * Make sure labels are actually returned in API (#6053) (#6059)
  * Switch to more recent build of xgo (#6070) (#6072)
  * In basic auth check for tokens before call UserSignIn (#5725) (#6083)

## [1.7.1](https://github.com/go-gitea/gitea/releases/tag/v1.7.1) - 2019-01-31
* SECURITY
  * Disable redirect for i18n (#5910) (#5916)
  * Only allow local login if password is non-empty (#5906) (#5908)
  * Fix go-get URL generation (#5905) (#5907)
* BUGFIXES
  * Fix TLS errors when using acme/autocert for local connections (#5820) (#5826)
  * Request for public keys only if LDAP attribute is set (#5816) (#5819)
  * Fix delete correct temp directory (#5840) (#5839)
  * Fix an error while adding a dependency via UI (#5862) (#5876)
  * Fix null pointer in attempt to Sudo if not logged in (#5872) (#5884)
  * When creating new repository fsck option should be enabled (#5817) (#5885)
  * Prevent nil dereference in mailIssueCommentToParticipants (#5891) (#5895) (#5894)
  * Fix bug when read public repo lfs file (#5913) (#5912)
  * Respect value of REQUIRE_SIGNIN_VIEW (#5901) (#5915)
  * Fix compare button on upstream repo leading to 404 (#5877) (#5914)
* DOCS
  * Added docs for the tree api (#5835)
* MISC
  * Include Go toolchain to --version (#5832) (#5830)

## [1.7.0](https://github.com/go-gitea/gitea/releases/tag/v1.7.0) - 2019-01-22
* SECURITY
  * Do not display the raw OpenID error in the UI (#5705) (#5712)
  * When redirecting clean the path to avoid redirecting to external site (#5669) (#5679)
  * Prevent DeleteFilePost doing arbitrary deletion (#5631)
* BREAKING
  * Restrict permission check on repositories and fix some problems (#5314)
  * Show only opened milestones on issues page milestone filter (#5051)
* FEATURES
  * Implement git refs API for listing references (branches, tags and other) (#5354)
  * Approvals at Branch Protection (#5350)
  * Add raw blob endpoint to get objects by SHA ID (#5334)
  * Add api for user to create org (#5268)
  * Create AuthorizedKeysCommand (#5236)
  * User action heatmap (#5131)
  * Refactor heatmap to vue component (#5401)
  * Webhook for Pull Request approval/rejection (#5027)
  * Add command for migrating database (#4954)
  * Search keyword by splitting provided values by , (#4939)
  * Create Progressive Web App (#4730)
  * Give user a link to create PR after push (#4716)
  * Add rebase with merge commit merge style (#3844) (#4052)
* BUGFIXES
  * Disallow empty titles (#5785) (#5794)
  * Fix sqlite deadlock when assigning to a PR (#5640) (#5642)
  * Don't close issues via commits on non-default branch. (#5622) (#5643)
  * Fix commit page showing status for current default branch (#5650) (#5653)
  * Only count users own actions for heatmap contributions (#5647) (#5655)
  * Update xorm to fix issue postgresql dumping issues (#5680) (#5692)
  * Use correct value for "MSpan Structures Obtained" (#5706) (#5716)
  * Fix bug on modifying sshd username (#5624)
  * Delete tags in mirror which are removed for original repo. (#5609)
  * Fix wrong text getting saved on editing second comment on an issue. (#5608)
  * Fix nil pointer when adding a due date  (#5587)
  * Fix type mismatch of format string (#5574)
  * Fix bug on upload file name (#5571)
  * Issue is not overdue when it is on the same date #5566 (#5568)
  * Fix indexer reindex bug when gitea restart (#5563)
  * Fix table name typo on SQL (#5562)
  * Synchronize SSH keys on login with LDAP + Fix SQLite deadlock on ldap ssh key deletion (#5557)
  * Fix makefile generate buildstep (#5556)
  * Fix nil pointer base branch bug (#5555)
  * Fix permission check on api create org (#5523)
  * Fix detect force push failure on deletion of protected branches (#5522)
  * Fix approvals limitation (#5521)
  * Fix bug when a read perm user to edit his issue (#5516)
  * Fix adding reaction fail for read permission user (#5515)
  * Fixing MSSQL timestamp type (#5511)
  * Fix forgot deletion of notification when delete repository (#5506)
  * Fix empty wiki (#5504)
  * Fix clone wiki failed via ssh (#5503)
  * Fix code review on mssql (#5502)
  * Fix lfs version check warning log when using ssh protocol (#5501)
  * Fix topic name length on database (#5493)
  * Ensure that the `closed_at` is set for closed issues (#5449)
  * Admin should be able to delete repos via the API even if he is not a member of the organization (#5443)
  * Word-Break the WebHook url to prevent a ui-break (#5432)
  * Fix forgot removed records when deleting user (#5429)
  * Fix repository deletion when there is large number of issues in it (#5426)
  * Fix heatmap colors for Chrome/Safari (#5421)
  * Fix password variable shadowing (#5405)
  * Fix dependent issue searching when gitea is run in subpath (#5392)
  * Don't force a password change for the admin user when creating an account via cli (#5391)
  * API: '/orgs/:org/repos': return private repos with read access (#5383)
  * Don't send assign webhooks when creating issue (#5365)
  * Removing Labels via EditPullRequest API (#5348)
  * Migration fixes for gogs (0.11.66) to gitea (1.6.0) #5318 (#5341)
  * Fix bug when users have serval teams with different units on different repositories (#5307)
  * Fix U2F if gitea is configured in subpath (#5302)
  * Fix file edit change preview functionality (#5300)
  * Update gitignore list (#5258)
  * Fixed heatmap not working in mssql (#5248)
  * Fixed wrong api request url for instances running in subfolders (#5247)
  * Fix compatibility heatmap with mysql 8 (#5232)
  * Fix data race on migrate repository (#5224)
  * Fix sqlite and mssql lock (#5214)
  * Fix sqlite lock (#5210)
  * Fix: Accept web-command cli flags if web-command is commited (#5200)
  * Fix: Add secret to all webhook's payload where it has been missing (#5199)
  * Fix race on updatesize (#5190)
  * Fix create team, update team missing units (#5188)
  * Fix sqlite lock (#5184 & #5176)
  * Fix showing pull request link when delete a branch (#5166)
  * Fix JSON result of empty array in heatmap data array (#5154)
  * Update build tags for sqlite_unlock notify (#5144)
  * This commit will reduce join star, repo_topic, topic tables on repo search, so that fix extra columns problem on mssql (#5136)
  * Fix deadlock when sqlite (#5118)
  * Add comment replies (#5104)
  * Fix home page template regression (#5102)
  * Fix regex to support optional end line of old section in diff hunk (#5096)
  * LDAP via simple auth separate bind user and search base (#5055)
  * Fix markdown image with link (#4675)
  * Fix to 3819 - Filtering issues by tags on main screen issues (#3824)
* ENHANCEMENTS
  * Delete organization endpoint added (#5601)
  * Update Licenses (#5558)
  * Support reverse proxy providing email (#5554)
  * Add git protocol v2 support via SSH on Docker image (#5520)
  * Add tests for api user orgs (#5494)
  * Allow link verification for services like Mastodon (#5481)
  * Improve team members and repositories settings UI (#5457)
  * Remove the required class from optional ssh port in installation page (#5428)
  * Explicitly disable Git credential helper (#5367)
  * Setting Labels via EditPullRequest API (#5347)
  * Implement pasting image from clipboard for browsers that supports that (#5317)
  * Milestone issues and pull requests (#5293)
  * Support envs on external render commands (#5278)
  * Add option to disable automatic mirror syncing. (#5242)
  * Remove unused db init on commands serv, update, hooks (#5225)
  * Serve audio files using HTML5 audio tag (#5221)
  * Pass link prefixes to external markup parsers (#5201)
  * Add AutoHead functionality. (#5186)
  * Fix emojis not showing in commit messages (#5168)
  * Block registration based on email domain (#5157)
  * Update vendor/go-sqlite3 (#5133 & #5162)
  * Update x/net lib (#5169)
  * Show review summary in pull requests (#5132)
  * Use type switch (#5122)
  * Remove duplicated if bodies (#5121)
  * Remove check for negative length (#5120)
  * Make switch more clear (#5119)
  * Use named const instead of a raw string (#5115)
  * Fix issue where ecdsa and other key types are not synced from LDAP (#5092) (#5094)
  * Refactor: err != nil check, just return error instead (#5093)
  * Add notification interface and refactor UI notifications (#5085)
  * Use APP_NAME on home page (#5048)
  * Explicitly decide whether to  use TLS in mailer's configuration (#5024)
  * Generate random password (#5023)
  * UX of link account (Step 1) (#5006)
  * Make sure argsSet verifies string isn't empty too (#4980)
  * Improve performance of dashboard (#4977)
  * Keys API changes (#4960)
  * Add must-change-password flag to cli for creating a user (#4955)
  * Use native go method to get current user rather than environment variable (#4930)
  * Make gitea serv use api/internal (#4886)
  * Add support for search by uid (#4876)
  * Allow to add organization members as collaborators on organization owned repositories (#4748)
* TESTING
  * Kill testing processes if the test takes too long (#5174)
  * Update outdated Go toolchain version for .drone.yml (#5146)
  * Increase the retry limit to 20 times and the interval to 200ms (#5134)
  * Retry test-fixtures loading in case of transaction rollback (#5125)
  * Added test environment for mssql (#4282)
* BUILD
  * Replace lint to revive (#5422)
  * Update golang version in Dockerfile (#5246)
* DOCS
  * Typo in routers/api/v1/org/org.go fixed. (#5598)
  * Update the docs for sqlite_unlock_notify (#5145)
  * CN translation of docs part (#5049)
  * Kubernetes deployment file (#5046)
* MISC
  * Upgrade alpine to 3.8 (#5423)
  * Git-Trees API (#5403)
  * Only chown directories during docker setup if necessary. Fix #4425 (#5064)

## [1.6.4](https://github.com/go-gitea/gitea/releases/tag/v1.6.4) - 2019-01-15
* BUGFIX
  * Fix SSH key now can be reused as public key after deleting as deploy key (#5671) (#5685)
  * When redirecting clean the path to avoid redirecting to external site (#5669) (#5703)
  * Fix to use correct value for "MSpan Structures Obtained" (#5706) (#5715)

## [1.6.3](https://github.com/go-gitea/gitea/releases/tag/v1.6.3) - 2019-01-04
* SECURITY
  * Prevent DeleteFilePost doing arbitrary deletion (#5631)
* BUGFIX
  * Fix wrong text getting saved on editing second comment on an issue (#5608)

## [1.6.2](https://github.com/go-gitea/gitea/releases/tag/v1.6.2) - 2018-12-21
* SECURITY
  * Sanitize uploaded file names (#5571) (#5573)
  * HTMLEncode user added text (#5570) (#5575)
* BUGFIXES
  * Fix indexer reindex bug when gitea restart (#5563) (#5564)
  * Remove a double slash in the HTTPS redirect with Let's Encrypt (#5537) (#5539)
  * Fix bug when a read perm user to edit his issue (#5516) (#5534)
  * Detect force push failure on deletion of protected branches (#5522) (#5531)
  * Let's Encrypt handler listens on correct port for certificate validation (#5525) (#5527)
  * Fix forgot deletion of notification when delete repository (#5506) (#5514)
  * Fix undeleted content when deleting user (#5429) (#5509)
  * Fix empty wiki (#5504) (#5508)

## [1.6.1](https://github.com/go-gitea/gitea/releases/tag/v1.6.1) - 2018-12-08
* BUGFIXES
  * Fix dependent issue searching when gitea is run in subpath (#5392) (#5400)
  * API: '/orgs/:org/repos': return private repos with read access (#5393)
  * Fix repository deletion when there is large number of issues in it (#5426) (#5434)
  * Word-break the WebHook url to prevent a ui-break (#5445)
  * Admin should be able to delete repos via the API even if they are not a member of the organization (#5443) (#5447)
  * Ensure that the `closed_at` is set for closed (#5450)
  * Fix topic name length on database (#5493) (#5495)

## [1.6.0](https://github.com/go-gitea/gitea/releases/tag/v1.6.0) - 2018-11-22
* BREAKING
  * Respect email privacy option in user search via API (#4512)
  * Simply remove tidb and deps (#3993)
  * Swagger.v1.json template (#3572)
* SECURITY
  * Add CSRF checking to reqToken and add reqToken to admin API routes (#5272) (#5250)
  * Improve URL validation for external wiki  and external issues (#4710)
  * Make cookies HttpOnly and obey COOKIE_SECURE flag (#4706)
  * Don't disclose emails of all users when sending out emails (#4664)
  * Check that repositories can only be migrated to own user or organizations (#4366)
* FEATURES
  * Add comment replies (#5147) (#5104)
  * Pull request review/approval and comment on code (#3748)
  * Added dependencies for issues (#2196) (#2531)
  * Add the ability to have built in themes in Gitea and provide dark theme arc-green (#4198)
  * Add sudo functionality to the API (#4809)
  * Add oauth providers via cli (#4591)
  * Disable merging a WIP Pull request (#4529)
  * Force user to change password (#4489)
  * Add letsencrypt to Gitea (#4189)
  * Add push webhook support for mirrored repositories (#4127)
  * Add csv file render support defaultly (#4105)
  * Add Recaptcha functionality to Gitea (#4044)
* ENHANCEMENTS
  * Fix milestones sorted wrongly (#4987)
  * Allow api to create tags for releases if they don't exist (#4890)
  * Fix #4877 to follow the OpenID Connect Audiences spec (#4878)
  * Enforce token on api routes [fixed critical security issue #4357] (#4840)
  * Update legacy branch and tag URLs in dashboard to new format (#4812)
  * Slack webhook channel name cannot be empty or just contain an hashtag (#4786)
  * Add whitespace handling to PR-comparsion (#4683)
  * Make reverse proxy auth optional (#4643)
  * MySQL TLS (#4642)
  * Make sure to set PR split view when creating/previewing a pull request  (#4617)
  * Log user in after a successful sign up (#4615)
  * Fix typo IsPullReuqestBroken -> IsPullRequestBroken (#4578)
  * Allow admin toggle forcing a password change for newly created users (#4563)
  * Update jQuery to v1.12.4 (#4551)
  * Env var GITEA_PUSHER_EMAIL (#4516)
  * Feat(repo): support search repository by topic name (#4505)
  * Small improvements to dependency UI (#4503)
  * Make max commits in graph configurable (#4498)
  * Add valid for lfs oid (#4461)
  * Add shortcut to save wiki page (#4452)
  * Allow administrator to create repository for any organization (#4368)
  * Fix repository last updated time update when delete a user who watched the repo (#4363)
  * Switch plaintext scratch tokens to use hash instead (#4331)
  * Increase default TOTP secret size to 320 bits (#4287)
  * Keep preseeded database password (#4284)
  * Implemented hover text showing user FullName (#4261)
  * Add ability to delete a token (#4235)
  * Fix typos in i18n variable names. (#4080)
  * Api: repos/search: add parameters to control the sort order (#3964)
  * Add missing path in the Docker app.ini template (#2181)
  * Add file name and branch to page title (#4902)
  * Offline use of google fonts (#4872)
  * Add missing History link to directory listings v2 (#4829)
  * Locale for Edit and Remove due date issue (#4802)
  * Disable 'May Import Local Repository' when is disabled by setting (Is… (#4780)
  * API /admin/users/{username} missing parameter (#4775)
  * Display error when adding a user to a team twice (#4746)
  * Remove UsePrivilegeSeparation from the Docker sshd_config, see #2876 (#4722)
  * Focus title input when clicking helper link (#4696)
  * Add vendor to user reserved words and format words list according alphabet (#4685)
  * Add gitea/issues link to 500 page (#4654)
  * Hide home button when landing page is not set to home (#4651)
  * Remove link to GitHub issues in 404 template (#4639)
  * Cmd/serve: pprof cpu and memory profile dumps to disk (#4560)
  * Add flash message after an account has been successfully activated (#4510)
  * Prevent html entity escaping on delete branch (#4471)
  * Locale for button Edit on protected branch (#4442)
  * Update notification icon (#4343)
  * Added front-end topics validation (#4316)
  * Don't display buttons if there are no system notifications (#4280)
  * Issue due date api (#3890)
* BUGFIXES
  * dont' send assign webhooks when creating issue (#5365)
  * Fix create team, update team missing units (#5188)
  * Fix file edit change preview functionality (#5300)
  * *ix bug when users have serval teams with different units on different repositories (#5307)
  * Fix U2F if gitea is configured in subpath (#5302)
  * Fix markdown image with link (#4675)
  * Remove maxlines option for file logger (#5282)
  * Fix wrong api request url for instances running in subfolders (#5261) (#5247)
  * Accept web-command cli flags if web-command is commited (#5245) (#5200)
  * Reduce join star, repo_topic, topic tables on repo search, to resolve extra columns problem on MSSQL (#5136) (#5229)
  * Fix data race on migrate repository (#5224) (#5230)
  * Add secret to all webhook's payload where it has been missing (#5208) (#5199)
  * Fix sqlite and MSSQL lock (#5210) (#5223) (#5214) (#5218) (#5176) (#5179)
  * Fix race on updatesize (#5190) (#5215)
  * Fix filtering issues by tags on main screen issues (#5219) (#3824)
  * Fix SQL quoting (#5137) (#5117)
  * Fix regex to support optional end line of old section in diff hunk (#5097) (#5096)
  * Fix release creation via API (#5076)
  * Remove links from topics in edit mode  (#5026)
  * Fix missing AppSubUrl in few more templates (fixup) (#5021)
  * Fix missing AppSubUrl in some templates (#5020)
  * Hide outdated comments in file view (#5017)
  * Upgrade gopkg.in/testfixtures.v2 (#4999)
  * Disable debug routes unless PPROF is enabled in configuration (#4995)
  * Fix user menu item styling (#4985)
  * Fix layout of the topics editing form (#4971)
  * Fix null pointer dereference in ParseCommitWithSignature (#4962)
  * Fix url in discord webhook (#4953)
  * Detect charset and convert non UTF-8 files for display (#4950)
  * Make sure to catch the right error so it is displayed on the UI (#4945)
  * Fix(topics): don't redirect to explore page. (#4938)
  * Fix bug forget to remove Stopwatch when remove repository (#4928)
  * Fix bug when repo remained bare if multiple branches pushed in single push (#4923)
  * Fix: Crippled diff (#4726) (#4900)
  * Fix trimming of markup section names (#4863)
  * Issues api allow pulls and fix #4832 (#4852)
  * Do not autocreate directory for new users/orgs (#4828) (#4849)
  * Fix redirect with non-ascii branch names (#4764) (#4810)
  * Fix missing release title in webhook (#4783) (#4796)
  * User shouldn't be able to approve or reject his/her own PR (#4729)
  * Make sure to reset commit count in the cache on mirror syncing (#4720)
  * Fixed bug where team with admin privelege type doesn't get any unit  (#4719)
  * Fix incorrect caption of webhook setting (#4701) (#4717)
  * Allow WIP marker to contains < or > (#4709)
  * Hide org/create menu item in Dashboard if user has no rights (#4678) (#4680)
  * Site admin could create repos even MAX_CREATION_LIMIT=0 (#4645)
  * Fix custom templates being ignored (#4638)
  * Fix starring icon after semantic ui update (#4628)
  * Fix Split-View line adjustment (#4622)
  * Fix integer constant overflows in tests (#4616)
  * Push whitelist now doesn't apply to branch deletion (#4601) (#4607)
  * Fix bugs when too many IN variables (#4594)
  * Fix failure on creating pull request with assignees (#4419) (#4583)
  * Fix panic issue on update avatar email (#4580) (#4581)
  * Fix status code label for a successful webhook (#4540)
  * An inactive user shouldn't be able to be added as a collaborator (#4535)
  * Don't fail silently if trying to add a collaborator twice (#4533)
  * Fix incorrect MergeWhitelistTeamIDs check in CanUserMerge function (#4519) (#4525)
  * Fix out-of-transaction query in removeOrgUser (#4521) (#4522)
  * Fix migration from older releases (#4495)
  * Accept 'Data:' in commit graph (#4487)
  * Update xorm to latest version and fix correct `user` table referencing in sql (#4473)
  * Relative URLs for LibreJS page (#4460)
  * Redirect to correct page after using scratch token (#4458)
  * Fix column droping for MSSQL that need new transaction for that (#4440)
  * Replace src with raw to fix image paths (#4377)
  * Add default merge options when creating new repository (#4369)
  * Fix docker build (#4358)
  * Fixes repo membership check in API (#4341)
  * Dep upgrade mysql lib (#4161)
  * Fix some issues with special chars in branch names (#3767)
  * Responsive design fixes (#4508)
* TRANSLATION
  * Fix punctuation in English translation (#4958)
  * Fix translation (#4355)

## [1.5.3](https://github.com/go-gitea/gitea/releases/tag/v1.5.3) - 2018-10-31
* SECURITY
  * Fix remote command execution vulnerability in upstream library (#5177) (#5196)

## [1.5.2](https://github.com/go-gitea/gitea/releases/tag/v1.5.2) - 2018-10-09
* SECURITY
  * Enforce token on api routes (#4840) (#4905)
* BUGFIXES
  * Remove links from topics in edit mode (#5030)
  * Detect charset and convert non UTF-8 files for display (#4950) (#4994)
  * Fix layout of the topics editing form (#4971) (#4993)
  * Fix null pointer dereference in ParseCommitWithSignature (#4964)
  * Fix url in discord webhook (#4951)
  * Fix font-cropping UI bug in diff (#4726) (#4929)
  * Fix bug forget to remove Stopwatch when remove repository (#4933)
  * Fix bug when repo remained bare if multiple branches pushed (#4927)
  * Fix redirect with non-ascii branch names (#4764) (#4887)
  * Fix issues api allow pulls (#4852) (#4862)
  * Fix trimming of markup section names (#4864)

## [1.5.1](https://github.com/go-gitea/gitea/releases/tag/v1.5.1) - 2018-09-03
* SECURITY
  * Don't disclose emails of all users when sending out emails (#4784)
  * Improve URL validation for external wiki and external issues (#4710) (#4740)
  * Make cookies HttpOnly and obey COOKIE_SECURE flag (#4706) (#4707)
* BUGFIXES
  * Fix missing release title in webhook (#4783) (#4800)
  * Make sure to reset commit count in the cache on mirror syncing (#4770)
  * Fixed bug where team with admin privelege type doesn't get any unit (#4759)
  * Fix failure on creating pull request with assignees (#4583) (#4727)
  * Hide org/create menu item in Dashboard if user has no rights (#4678) (#4686)
* TRANSLATION
  * Fix incorrect caption of webhook setting (#4701) (#4718)

## [1.5.0](https://github.com/go-gitea/gitea/releases/tag/v1.5.0) - 2018-08-10
* SECURITY
  * Check that repositories can only be migrated to own user or organizations (#4366) (#4370)
  * Limit uploaded avatar image-size to 4096px x 3072px by default (#4353)
  * Do not allow to reuse TOTP passcode (#3878)
* BUGFIXES
  * Fix column droping for MSSQL that need new transaction for that (#4440) (#4484)
  * Redirect to correct page after using scratch token (#4458) (#4472)
  * Replace src with raw to fix image paths (#4377) (#4386)
  * Fixes repo membership check in API (#4341) (#4379)
  * Add default merge options when adding new repository (#4369) (#4373)
  * Fix repository last updated time update when delete a user who watched the repo (#4363) (#4371)
  * Fix html entity escaping in branch deletion message (#4471) (#4485)
  * Fix out-of-transaction query in removeOrgUser (#4521) (#4524)
  * Fix incorrect MergeWhitelistTeamIDs check in CanUserMerge function (#4519)
  * Fix panic issue on update avatar email (#4580) (#4590)
  * Fix bugs when too many IN variables (#4594) (#4597)
  * Push whitelist now doesn't apply to branch deletion (#4601) (#4640)
  * Site admin could create repos even MAX_CREATION_LIMIT=0 (#4645) (#4650)
* FEATURES
  * Add cli commands to regen hooks & keys (#3979)
  * Add support for FIDO U2F (#3971)
  * Added user language setting (#3875)
  * LDAP Public SSH Keys synchronization (#1844)
  * Add topic support (#3711)
  * Multiple assignees (#3705)
  * Add protected branch whitelists for merging (#3689)
  * Global code search support (#3664)
  * Add label descriptions (#3662)
  * Add issue search via API (#3612)
  * Add repository setting to enable/disable health checks (#3607)
  * Emoji Autocomplete (#3433)
  * Implements generator cli for secrets (#3531)
* ENHANCEMENTS
  * Add more webhooks support and refactor webhook templates directory (#3929)
  * Add new option to allow only OAuth2/OpenID user registration (#3910)
  * Add option to use paged LDAP search when synchronizing users (#3895)
  * Symlink icons (#1416)
  * Improve release page UI (#3693)
  * Add admin dashboard option to run health checks (#3606)
  * Add branch link in branch list (#3576)
  * Reduce sql query times in retrieveFeeds (#3547)
  * Option to enable or disable swagger endpoints (#3502)
  * Add missing licenses (#3497)
  * Reduce repo indexer disk usage (#3452)
  * Enable caching on assets and avatars (#3376)
  * Add repository search ordered by stars/forks. Forks column in admin repo list (#3969)
  * Add Environment Variables to Docker template (#4012)
  * LFS: make HTTP auth period configurable (#4035)
  * Add config path as an optionial flag when changing pass via CLI (#4184)
  * Refactor User Settings sections (#3900)
  * Allow square brackets in external issue patterns (#3408)
  * Add Attachment API (#3478)
  * Add EnableTimetracking option to app settings (#3719)
  * Add config option to enable or disable log executed SQL (#3726)
  * Shows total tracked time in issue and milestone list (#3341)
* TRANSLATION
  * Improve English grammar and consistency (#3614)
* DEPLOYMENT
  * Allow Gitea to run as different USER in Docker (#3961)
  * Provide compressed release binaries (#3991)
  * Sign release binaries (#4188)

## [1.4.3](https://github.com/go-gitea/gitea/releases/tag/v1.4.3) - 2018-06-26
* SECURITY
  * HTML-escape plain-text READMEs (#4192) (#4214)
  * Fix open redirect vulnerability on login screen (#4312) (#4312)
* BUGFIXES
  * Fix broken monitoring page when running processes are shown (#4203) (#4208)
  * Fix delete comment bug (#4216) (#4228)
  * Delete reactions added to issues and comments when deleting repository (#4232) (#4237)
  * Fix wiki URL encoding bug (#4091) (#4254)
  * Fix code tab link when viewing tags (#3908) (#4263)
  * Fix webhook type conflation (#4285) (#4285)

## [1.4.2](https://github.com/go-gitea/gitea/releases/tag/v1.4.2) - 2018-06-04
* BUGFIXES
  * Adjust z-index for floating labels (#3939) (#3950)
  * Add missing token validation on application settings page (#3976) #3978
  * Webhook and hook_task clean up (#4006)
  * Fix webhook bug of response info is not displayed in UI (#4023)
  * Fix writer cannot read bare repo guide (#4033) (#4039)
  * Don't force due date to current time (#3830) (#4057)
  * Fix wiki redirects (#3919) (#4065)
  * Fix attachment ENABLED (#4064) (#4066)
  * Added deletion of an empty line at the end of file (#4054) (#4074)
  * Use ResolveReference instead of path.Join (#4073)
  * Fix #4081 Check for leading / in base before removing it (#4083)
  * Respository's home page not updated after first push (#4075)

## [1.4.1](https://github.com/go-gitea/gitea/releases/tag/v1.4.1) - 2018-05-03
* BREAKING
  * Add "error" as reserved username (#3882) (#3886)
* SECURITY
  * Do not allow inactive users to access repositories using private key (#3887) (#3889)
  * Fix path cleanup in file editor, when initilizing new repository and LFS oids  (#3871) (#3873)
  * Remove unnecessary allowed safe HTML (#3778) (#3779)
  * Correctly check http git access rights for reverse proxy authorized users (#3721) (#3743)
* BUGFIXES
  * Fix to use only needed columns from tables to get repository git paths (#3870) (#3883)
  * Fix GPG expire time display when time is zero (#3584) (#3884)
  * Fix to update only issue last update time when adding a comment (#3855) (#3860)
  * Fix repository star count after deleting user (#3781) (#3783)
  * Use the active branch for the code tab (#3720) (#3776)
  * Set default branch name on first push (#3715) (#3723)
  * Show clipboard button if disable HTTP of git protocol (#3773) (#3774)

## [1.4.0](https://github.com/go-gitea/gitea/releases/tag/v1.4.0) - 2018-03-25
* BREAKING
  * Drop deprecated GOGS\_WORK\_DIR use (#2946)
  * Fix API status code for hook creation (#2814)
* SECURITY
  * Escape branch name in dropdown menu (#3691) (#3692)
  * Refactor and simplify to correctly validate redirect to URL (#3674) (#3676)
  * Fix escaping changed title in comments (#3530) (#3534)
  * Escape search query (#3486) (#3488)
  * Sanitize logs for mirror sync (#3057)
* FEATURES
  * Serve .patch and .diff for pull requests (#3305, #3293)
  * Add repo-sync-releases admin command (#3254)
  * Support default private when creating or migrating repository (#3239)
  * Writable deploy keys (closes #671) (#3225)
  * Add Pull Request merge options - Ignore white-space for conflict checking, Rebase, Squash merge (#3188)
  * Added progressbar for issues with checkboxes (#1146). (#3171)
  * Mention completion for issue editor. (#3136)
  * Add 'mark all read' option to notifications (#3097)
  * Git LFS lock api (#2938)
  * Add reactions to issues/PR and comments (#2856)
  * Add dingtalk webhook  (#2777)
  * Responsive view (#2750)
* BUGFIXES
  * Fix wiki inter-links with spaces (#3560) (#3632)
  * Fix query protected branch bug (#3563) (#3571)
  * Fix remove team member issue (#3566) (#3570)
  * Fix the protected branch panic issue (#3567) (#3569)
  * If Mirrors repository no content is fetched, updated time should not be changed (#3551) (#3565)
  * Bug fix for mirrored repository releases sorted (#3522) (#3555)
  * Add issue closed time column to fix activity closed issues list (#3537) (#3540)
  * Update markbates/goth library to support OAuth2 with new dropbox API (#3533) (#3539)
  * Fixes missing avatars in offline mode (#3471) (#3477)
  * Fix synchronization bug in repo indexer (#3455) (#3461)
  * Fix rendering of wiki page list if wiki repo contains other files (#3454) (#3463)
  * Fix webhook X-GitHub-* headers casing for better compatibility (#3429)
  * Add content type and doctype to requests made with go-get (#3426, #3423)
  * Fix SQL type error for webhooks (#3424)
  * Fix PR merge error (#3421)
  * Recognize more characters in crossreferenced repo name (#3413)
  * Fix MSSQL bug on org (#3405)
  * HTML escape all lines of the search result (#3402)
  * Change local copy origin url after repository rename (#3399)
  * Force-push to base repo's ref/pull/#/head (#3393)
  * Fix bug when a user delete but assigned on issue (#3318)
  * Use issue number/index instead of id for API URL. Fix #3297 (#3298)
  * Fix repo-transfer-and-team-repo-count bug (#3241)
  * Fix always-on SSL Mode checkbox in admin page (#3208)
  * Fix source download link when no code unit allowed (#3166)
  * Fix org owner cannot be removed if he is not in owner team (#3164)
  * Fix run web with -p push failed (#3154)
  * Fix gpg tmpl (#3153)
  * Fix SSH auth lfs locks (#3152)
  * Improvements for supporting UI Location (#3146)
  * Fix new pull request link (#3133)
  * Fix missing branch in release bug (#3108)
  * Allow adding collaborators with (fullname) (#3103)
  * Fix repo links (#3093)
  * fix lfs url refs + keep path upper/lowercase in db. (#3092)
  * Fix redis session failed (#3086)
  * Fix bugs in issue dashboard stats (#3073)
  * Fix avatar URLs (#3069)
  * Fix ref parsing in commit messages (#3067)
  * Fix issue list branch link broken (#3061)
  * sendmail: correct option to set envelope-sender (#3044)
  * Fix missing password length check when change password (#3039)
  * Fix git lfs path (#3016)
  * Fix API-Endpoint release (#3005) (#3012)
  * Set OpenID support on by default when installing new instance (#3010)
  * Various wiki bug fixes (#2996)
  * Fix go-get, src and raw urls to new scheme (#2978)
  * Fix error when add user has full name to team (#2973)
  * Fix memcache support when value is returned as string always (#2924)
* ENHANCEMENTS
  * Use GiteaServer as the user agent for http requests (#3404)
  * Delete indexer DB entries when (re)creating index (#3385)
  * Change how merged PR commit info are prepared (#3368)
  * Asynchronously populate the repo indexer (#3366)
  * Make the default action for the gitea executable that of running the webserver (#3331)
  * Templates for extra links in top navbar and repo tool tabs. (#3308)
  * Fixed asterisk based tasklist items #3295 (#3296)
  * Add more additional template snippets (#3286)
  * Open external tracker in blank window, consistently with wiki (#3227)
  * Fix repo links on user profile (#3197)
  * Enable emoji for wiki view (#3158)
  * Small improve on deleting attachements (#3145)
  * Reduce overhead of upgrades for users with custom stylesheets/JS (#3051)
  * Default log level to Info without hardcoding it in installer (#3041)
  * Memory usage improvements (#3013)
  * Add fingerprint to ssh key endpoints. (#3009)
  * Improve memory usage when reaching diff limits (#2990)
  * Expandable commit bodies (#2980)
  * Update gitgraph.js to fix blurry commit graph on HiDPI screens (#2957)
  * Fix language names (#2955)
  * Remove render issue link (#2954)
  * Page parameter for repo search API (#2915)
  * Apply LANDING\_PAGE config options for logged in users (#2894)
  * Enable admin to search by email (#2888)
  * Hide add key button if SSH is disabled (#2873)
  * Fix comment API paths (#2813)
  * Add an option to allow redirect of http port 80 to https. (#1928)
* MISC
  * Fix organization profile on mobile devices (#3332)
  * Fix guide link for webhooks in repository settings (#3291) (#3292)
  * Enable Libravatar by default in new installations (#3287)
  * Improve suppressed diff boxes (#3193)
  * fix button heights on commits page (#3091)
  * Minor copy changes (#3074)
  * Sort repos in issues dashboard sidebar (#3072)
  * Remove box-shadow from UI, fix dashboard issue (#3065)
  * Adjust branch button size (#3063)
  * Fix misalignment issue in repo header (#3062)
  * Delete a user's public key via admin api (closes #3014) (#3059)
  * Dashboard: Fix line height problem in issue titles (#3054)
  * Remove duplicate "Max Diff Lines" from config view (#2987)
  * Drop unmaintained gogs migration script (#2947)
  * App restarts to quickly if it fails to start. (#2945)
  * Add owner to delete repo message (#2886)

## [1.3.1](https://github.com/go-gitea/gitea/releases/tag/v1.3.1) - 2017-12-08
* BUGFIXES
  * Sanitize logs for mirror sync (#3057, #3082) (#3078)
  * Fix missing branch in release bug (#3108) (#3117)
  * Fix repo indexer and submodule bug (#3107) (#3110)
  * Fix legacy URL redirects (#3100) (#3106)
  * Fix redis session failed (#3086) (#3089)
  * Fix issue list branch link broken (#3061) (#3070)
  * Fix missing password length check when change password (#3039) (#3071)

## [1.3.0](https://github.com/go-gitea/gitea/releases/tag/v1.3.0) - 2017-11-29
* BREAKING
  * Make URL scheme unambiguous (#2408)
* FEATURES
  * Add branch overiew page (#2108)
  * Code/repo search (#2582)
  * Add Activity page to repository (#2674)
  * Issue Timetracking (#2211)
  * Add orgmode document type on file view and readme (#2525)
  * Add external markup render support (#2570)
  * Implementation of discord webhook (#2402)
  * Webhooks for repo creation/deletion (#1663)
  * Complete push webhooks (#2530)
  * Add possibility to record branch information in an issue (#780)
  * Create new branch from branch selection dropdown (#2130)
  * Implementation of all repositories of a user from user->settings (#1740)
  * Add LFS object verification step after upload (#2868)
  * Configurable SSH cipher suite (#913)
  * Disable custom Git Hooks globally via configuration file (#2450)
  * Sync releases table with tags on push and for mirrors (#2459)
* BUGFIXES
  * Fix label comments for French locale (#3017)
  * Remove duplicate "Max Diff Lines" from config view (#3001)
  * Fix over-escaped characters (#2992)
  * Fix go-get, src and raw urls to new scheme (#2986)
  * Fix error when add user has full name to team (#2975)
  * Fix files/commits of merged PRs (#2970)
  * Update golang x/crypto dependencies - Fix SSH transport fail (#2951)
  * Fix memcache support when value is returned as string always (#2950)
  * Fix issue link rendering in commit messages (#2897)
  * Fix adding a new authentication source after selecting OAuth (#2889)
  * Fix new branch creation to new url scheme (#2884)
  * Allow spaces in username for LDAP users (#2880)
  * Fix LFS not returning correct content length when requesting a range … (#2864)
  * Fix fork repository cycle to self (#2860)
  * Fix click create pull request button 404 (#2859)
  * Fix API raw file content access for default branch (#2849)
  * Clean repository ROOT directory name with filepath.Clean (#2846)
  * Fix API raw requests for commits and tags (#2841)
  * Fix order of comments (#2835)
  * Issue content should not be updated when closing with comment (#2833)
  * Fix ordering in app.ini and fix run mode option (#2829)
  * Fix redirect url of legacy commits route (#2825)
  * Fix commits page url (#2823)
  * Fix wrong translations (#2818)
  * Fix dropdown menu position when explore repos (#2808)
  * Fix Git LFS object/repo link storage in database and small refactoring (#2803)
  * Use relative URLs for avatars on the dashboard (#2800)
  * Add checks for commits with missing author and time (#2771)
  * Fix emojify image URL (#2769)
  * Hide unactive on explore users and some refactors (#2741)
  * Fix IE unsupported javascript construction in branch dropdown (#2736)
  * Only update mirror last update after successful sync (#2730)
  * Fix semantic-ui style conflict with v-cloak (#2722)
  * Fixing wrong translation on sort type oldest/latest (#2720)
  * Fix PR, milestone and label functionality if issue unit is disabled (#2710)
  * Fix plain readme didn't render correctly on repo home page (#2705)
  * Fix organization removal from watch table migration (#2703)
  * Fix repository search function (#2689)
  * fix panic on gogs webhook creation (#2675)
  * Fix orgnization user watch repository (#2670)
  * GPG key email verification no longer case sensitive (#2661) (#2663)
  * Fix index column deletion (#2651)
  * table `pull_request` wasn't updated correctly (#2649)
  * Fix go get response if only app URL is custom in configuration (#2634)
  * Fix doubled issue tab introduced in migration v16 (#2611)
  * Rewrite migrations to not depend on future code changes (#2604)
  * Fix implementation of repo Home func (#2601)
  * Fix translation upload to crowdin (#2599)
  * Reduce usage of allcols on update (#2596)
  * fix go get subpackage bug (#2584)
  * Fix broken migration to add can_push field back to table (#2574)
  * fix readme view bug (#2566)
  * Fix sending mail with a non-latin display name. #2102 (#2559)
  * Restricting access to fork functioanlity to users with Code access (#2534)
  * fix updated update on public key (#2514)
  * Added bucket name to s3 drone plugin (#2505)
  * fixes 500 error on dashboard when using MSSQL (#2504)
  * fix wrong rendering of commit detail page (#2503)
  * Hotfix: Add time manually adds time in nanoseconds (#2499)
  * Remove repository mirrors from "collaborative" list (#2497)
  * fix release failed since the wrong token name (#2496)
  * Fix slice out of bounds error in mailer (#2479)
  * Fix #2470 (#2477)
  * fix orgnization webhooks (#2422)
  * fix webhook test (#2415)
  * fix missing orgnization discord webhook (#2414)
  * Fix route handler order (#2409)
  * Prevent sending emails and notifications to inactive users (#2384)
  * Move themes to plugin directory. Fixes #2372 (#2375)
  * fix duplicated feed (#2370)
  * Fix missing collabrative repos (#2367)
  * Only check at least one email gpg key (#2266)
  * don't check minimum key size when disabled (#1754)
  * Fix run command race (#1470)
  * fix .netrc authentication (#2700)
  * Fix so that user can still fork his own repository to his organizations (#2699)
  * Fix can_push value to false in protected_branch (#2560)
  * Fix copy in email templates (#2801)
  * Fix inconsistencies in user settings UI (#2901)
  * Fix attachments icon size on zoom in/out (#2853)
  * Fix ignored errors in API route (#2850)
  * Fix activity css conflit with semantic ui (#2758)
  * Fix notifications tabs according to semantic-ui docs (#2733)
  * Fix typos in app.ini (#2732)
  * Fix duplicated rel attribute (#2549)
  * Fix tests code to prevent some runtime errors (#2381)
* ENHANCEMENTS
  * Memory usage improvements and lower minimal git requirement to 1.7.2 (#3013) (#3028)
  * Set OpenID support on by default when installing new instance (#3010) (#3027)
  * Use api.TrackedTime in API (#2807)
  * Configurable SSH key exchange algorithm and MAC suite (#2806)
  * Add Safari pinned tab icon (#2799)
  * Improve force push detect when push (#2798)
  * Add wrapping to long diff lines (#2789)
  * Link members and repositories count to each page on org home. (#2787)
  * Show Sendmail settings on admin config page (#2782)
  * Add commit count caching (#2774)
  * Use identicon image for default gravatar. (#2767)
  * Add default ssh ciphers (#2761)
  * Remove manual of unsupported option (#2757)
  * Add search mode option to /api/repo/search (#2756)
  * Move swagger-ui under /api/v1 (#2746)
  * Add support for extra sendmail arguments (#2731)
  * Use buffersize to reduce database connection when iterate (#2724)
  * Render plain text README.txt monospaced (#2721)
  * Integration test for activity page (#2704)
  * Merge password and 2fa page on user settings (#2695)
  * Allow custom SSH user in UI for built-in SSH server (#2617) (#2678)
  * Refactor duplicated code in repo handlers (#2657)
  * Replace deprecated Id method with ID (#2655)
  * Remove redudant functions and code (#2652)
  * hide navbar when only 1 sign-in method is available (#2444) (#2648)
  * Change default sort order (#2647)
  * Change pull description text (#2075) (#2646)
  * Remove direct user adding to organization members (#2641)
  * Use session when creating user (#2638)
  * Use Semantic UI's Search component for user and repo search (#2636)
  * Use AfterLoad instead of AfterSet on Structs (#2628)
  * Remove redudant CheckUnit calls in router (#2627)
  * Remove repo unit index (#2621)
  * Remove redudant issue LoadAttributes() calls (#2614)
  * Make indexer code more reusable (#2590)
  * Use custom type and constants to hold available order by options (#2572)
  * Use named ActionType constants in template helper (#2545)
  * Make basic functionality work without JavaScript (#2541)
  * Ctrl + Enter to submit forms (#2540)
  * Automatically regenerate indexer for incompatible versions (#2524)
  * Set default lfs content path to data/lfs (#2521)
  * Convert spaces to tabs in footer.tmpl (#2520)
  * Sort repository tree entries in natural way (#2506)
  * Open external wiki in new window (#2489)
  * Use created & updated instead BeforeInsert & BeforeUpdate (#2482)
  * Hide branch on pull request view or create UI (#2454)
  * improve protected branch to add whitelist support (#2451)
  * some refactors for issue and comments (#2419)
  * Restructure markup & markdown to prepare for multiple markup language… (#2411)
  * Improve issue search (#2387)
  * Add UseCompatSSHURI setting (#2356)
  * Use custom search for each filter type in dashboard (#2343)
  * Failed authentication are now properly logged (#2334)
  * Add environment variable support for Docker image (#2201)
  * Set session and indexers' data files rel to AppDataPath (#2192)
  * Display commit status on landing page of repo (#1784)
* TESTING
  * Add integration test for logging out (#2892)
  * Integration test for user deleting account (#2891)
  * Use different directories for session files in integration tests (#2834)
  * Add deleted_branch table fixture (#2832)
  * Include HTTP method in test error message (#2815)
  * Add repository search unit and integration tests (#2575)
  * Expand fixtures (#2571)
  * Fix /api/repo/search integration tests (#2550)
  * Make integration tests more user-friendly (#2536)
  * Fix unit test race condition (#2516)
  * Add missing fixture to clean gpg_key table (#2494)
  * Hotfix for integration testing (#2473)
  * Make repo private to not interfere with other tests (#2467)
  * Error message for integration test (#2410)
  * Fix "index out of range" runtime error in repo_list tests (#2376)
  * Add git clone test on integration test (#1682)
* TRANSLATION
  * Fix localization texts that contain semicolon (#2900)
  * Fix activity locale (#2709)
  * Update translation from crowdin (#2368)
* BUILD
  * change the email and name to GitBot account. (#2848)
  * Fix removing backslash before quotes in translations (#2831)
  * add gitea remote in drone. (#2817)
  * add remote name for git push. (#2816)
  * Launch Gitea with custom UID/GID for 'git' user (fixes #2286) (#2791)
  * Download and pushing translations (#2727)
  * Automatic update of translations (#2585)
  * Add pre-build step for nodejs stuff (#2581)
  * Compress css with nodejs (#2580)
  * Remove go version check for make fmt (#2558)
  * Fix lint errors (#2547)
  * Always run fmt check in CI (#2546)
  * Fix fmt errors (#2544)
  * add codecov.io service. (#2493)
  * Fix some tests : make coverage -> test (#2492)
  * Fix fmt error in mailer (#2490)
  * Allow changing integration test database connection using env variables (#2484)
  * Add changelog config file for generate changelog (#2461)
  * Changes for latest DroneCI (#2362)
  * Use standard lessc and minify CSS using Node.js (#2337)
* DOCS
  * Update screenshots on README (#2910)
  * Gogs -> Gitea (#2909)
  * Update swagger documentation (#2899)
  * Fix typo (#2810)
  * Fix Polish language name spelling (#2766)
  * Fix Various Grammar Issues and Adjust Unnatural Wording (#2737)
  * Add maintainer label for docker file (#2658)
  * Link to gitea-specific Vagrant example (#2624)
  * add release notes of v1.1.4 (#2463)
  * Wrap most paragraphs to 80 columns (#2396)
  * Update CONTRIBUTING following #2329  discussion (#2394)
  * Update hard-coded version to 1.3.0+dev (#2390)
  * Clarify Translation Process. Also fix branch names (#2378)
  * Admin grammar fixes and improvements (#2056)
* MISC
  * Sync MaxGitDiffLineCharacters with conf/app.ini (#2779)
  * Dockerfile: Updated alpine image to 3.6. (#2486)
  * Basic VSCode configuration for building and debugging (#2483)
  * Added vendor dir for js/css libs; Documented sources (#1484) (#2241)

## [1.2.3](https://github.com/go-gitea/gitea/releases/tag/v1.2.3) - 2017-11-03
* BUGFIXES
  * Only require one email when validating GPG key (#2266, #2467, #2663) (#2788)
  * Fix order of comments (#2835) (#2839)

## [1.2.2](https://github.com/go-gitea/gitea/releases/tag/v1.2.2) - 2017-10-26
* BUGFIXES
  * Add checks for commits with missing author and time (#2771) (#2785)
  * Fix sending mail with a non-latin display name (#2559) (#2783)
  * Sync MaxGitDiffLineCharacters with conf/app.ini (#2779) (#2780)
  * Update vendor git (#2765) (#2772)
  * Fix emojify image URL (#2769) (#2773)

## [1.2.1](https://github.com/go-gitea/gitea/releases/tag/v1.2.1) - 2017-10-16
* BUGFIXES
  * Fix PR, milestone and label functionality if issue unit is disabled (#2710) (#2714)
  * Fix plain readme didn't render correctly on repo home page (#2705) (#2712)
  * Fix so that user can still fork his own repository to his organizations (#2699) (#2707)
  * Fix .netrc authentication (#2700) (#2708)
  * Fix slice out of bounds error in mailer (#2479) (#2696)

## [1.2.0](https://github.com/go-gitea/gitea/releases/tag/v1.2.0) - 2017-10-10
* SECURITY
  * Sanitation fix from Gogs (#1461)
* BREAKING
  * Rename /forget_password url to /forgot_password (#1219)
* FEATURES
  * Logo: Add task to generate images from SVG and change to new logo (#2194)
  * Status-API (#1332)
  * Show commit status icon in commits table (#1688)
  * Additional OAuth2 providers (#1010)
  * GPG commit validation (#1150)
  * Rework SSH key management UI to add GPG (#1293)
  * Implement GPG api (#710)
  * Login via OpenID-2.0 (#618)
  * Add units to team (#947)
  * Batch updates for issues (#926)
  * Add Gitea Webhook (#1755)
  * API: support '/orgs/:org/repos' (#2047)
  * Display all organization from user settings (#1739)
  * LDAP user synchronization (#1478)
  * Adding #issuecomment to the URL in E-Mail notifications (#1674)
  * Add download count field and unit testing for attachment. (#1512)
  * Add repo mirror sync API endpoint (#1508)
  * Add markup package to prepare for org markup format (#1493)
  * Support for custom html meta  (#1423)
  * Per issue/PR watch/unwatch (#1410)
  * Allow ENABLE_OPENID_SIGNUP to depend on DISABLE_REGISTRATION (#1369)
  * Repo size in admin panel (#1482)
  * Show user OpenID URIs in their profile (#1314)
  * Add change-password admin command (#1304)
  * Only use issue and wiki on repo. (#1297)
  * Allow push to init a wiki repo (#1279)
* ENHANCEMENTS
  * Make time diff translatable (#2057)
  * Smaller watch, star, and fork buttons (#2052)
  * Display config file path on admin panel (#2030)
  * Only show SSH clone URL if signed in (#2169) (#2170)
  * Only show "No Description" to repo admins (#2167)
  * Always return valid go-get meta, even if unauthorized (#2010)
  * Enable assignee e-mail notification (#2003)
  * Let not-logged-in users view releases (#1999)
  * No highlighting for .txt files (#1922)
  * Make side nav on dashboard stackable (#1778)
  * Setting to disable authorized_keys backup (#1856)
  * Hide the create organization button (in dashboard/organization section) (#1705)
  * LFS: Return 404 for unimplemented endpoints (#1330)
  * Show a link to password reset from user settings requiring a password (#862)
  * Reserve the "explore" user/org name (#1222)
  * Send notifications to partecipants in issue comments (#1217)
  * Improve style of user OpenID setting page (#1324)
  * Use font-awesome OpenID icon more (#1320)
  * Use readonly input form to show the validated OpenID URI (#1308)
  * Add captcha support to OpenID based signup (#1307)
  * Minor improvements on commit graph UI (#1380)
  * Mirror sync interval specified as duration string (#1407)
  * Make issue in commit graph "clickable" (#1392)
  * Use whole button (commit graph) as link (#1390)
  * Autofocus on 2fa passcode fields (#1460)
  * Sort on repo size in admin panel (#1654)
  * Improve dashboard repo search (#1652)
  * Use a better default MAX_GIT_DIFF_LINE_CHARACTERS (#1845)
  * Adds Parent property to the repo API (#1687)
  * Add configuration option for default permission to create Organizations (#1686)
  * Remove sha1 hash display in repository table (#1678)
  * Download files to their original filename (#1676)
  * Exposes in API the Repo entity's Size and IsBare property (#1668)
  * Change two factor code entry box from text to number (#1733)
  * Directly show error if user hit repository limit  (#1767)
  * Generate small and large logos at 4x resolution (#2233)
  * Tags listed in releases tab (#2389) (#2424)
* BUGFIXES
  * Fix adding branch as protected to not allow pushing to it (#2556)
  * Orgs: fix org page title when full name is not defined (#1495)
  * Fix double borders on edit page (#1152) (#1153)
  * Search bar fixes for #1187 and #1205 (#1207)
  * Fix upgrade failed after ever rollback (#1194)
  * Fix FCGI (over TCP) support (#1368)
  * Backport of migration fixes (#2604) (#2677)
  * fix panic on gogs webhook creation (#2675) (#2676)
  * Backport: Fixes 500 error on dashboard when using MSSQL (#2504) (#2662)
  * Fix go get response if only app URL is custom in configuration (#2634) (#2640)
  * Fix deletion of unprotected branches (#2630)
  * Backport of 2611 / Fix doubled issue tab introduced in migration v16 (#2622)
  * v38 migration used an outdated version of RepoUnit model (#2602)
  * fix go get subpackage bug (#2584) (#2589)
  * Backport: Sync releases table with tags on push and for mirrors (#2459) (#2554)
  * Backport: Restricting access to fork functioanlity to users with Code access (#2542)
  * Fix migration from pre-v15 to 1.2.0 (#2460) (#2465)
  * Fix migration from pre-v15 to 1.2.0 (#2460)
  * fix duplicated feed (#2370) (#2413)
  * Fix releases to be counted from database not tags (#2389)
  * Fix missing collabrative repos (#2367) (#2382)
  * Add more test for login links and fix a bug on action retrieve (#2361)
  * Fix SQL condition bug in GetFeeds(..) (#2360)
  * fix bug on create repo link on dashboard (#2359)
  * Fix order of elements in dashboard html (#2344)
  * Fix repo-search template errors for go1.7 (#2336)
  * Add missing forks key for dashboard repository component (#2325)
  * fix template error on explore repos (#2319)
  * Trigger sync webhooks on UI commit (#2302)
  * fix 500 error when view an issue which's milestone deleted (#2297)
  * Only update needed columns when update user (#2296)
  * Fix rendering of external links (#2292)
  * Fix and improve dashboard repo UI (#2285)
  * Make short link pattern greedy (#2259)
  * Temporarily patch go-ini/ini with fork (#2255)
  * Convert xorm literal queries to method calls (#2253)
  * update code.gitea.io/git in vendor to fix delete branch fails (#2250)
  * Replace calls to xorm UseBool with Where (#2237)
  * rhel7 has a git version with four digits (1.8.3.1) (#2236)
  * Fix internal requests when gitea listens to unix socket or only external IP (#2234)
  * Check for access in /repositories/:id (#2227)
  * Fixed robots.txt 404 error (#2226)
  * Fix counts on issues dashboard (#2215)
  * Fix unclosed session bug (#2214)
  * Add collaborative repositories to the dashboard (#2205)
  * Fix issue updated_unix bug (#2204)
  * Fix Commits nil pointer dereference (#2203)
  * Fix bare-repo bugs (#2199)
  * Fix PR nil-dereference bug (#2195)
  * Allow only single fork per user/organization (#2193)
  * Fix key usage time update if the key is used in parallel for multiple operations (#2185)
  * Only allow token authentication with 2FA enabled (#2184)
  * Fix profile update for non-local users (#2178)
  * Fix compiling without sqlite and gcc (#2177)
  * Make compare button URL aware if current repo is a fork (#2162) (#2163)
  * Remove unit types commits and settings (#2161)
  * Fix OpenID registration route (#2160)
  * Fix repository settings collobration list display (#2151)
  * Ignore invalid issue numbers in commit messages. Fixes  #2022 (#2150)
  * Fix SHA1 hash linking (#2143)
  * Fix repo API bug (#2133)
  * Use POSIX complaint ! operator in find (#2132)
  * Fix GET /users/:username/repos endpoint (#2125)
  * Fix username rendering bug (#2122)
  * Fix wiki preview links (#2119)
  * vendor: update sqlite to fix "database is locked" errors (#2116)
  * Fix unchecked error bug (#2110)
  * Fix missing-return bug (#2109)
  * Fix API for branches with slashes (#2096)
  * Fix git hooks update to receive required arguments (#2095)
  * upgrade git source code. (#2094)
  * Fix SQL bug in models.PullRequests (#2092)
  * Don't ignore gravatar error (#2083)
  * Fix release display and correct paging (#2080)
  * remove unnecessary blank lines and wrong error log (#2079)
  * Check for valid renamed usernames (#2077)
  * Update git module (#2074)
  * Fix org hooks UI (#2072)
  * Fix #1271: Call location.reload after XHR finishes (#2071)
  * Fix default ghost assignee bug (#2069)
  * Fix bug in issue labels API (#2048)
  * Load label ID in NewLabels (#2045)
  * Fix: `http: multiple response.WriteHeader calls` (#2038)
  * Pagination on releases page (#2035)
  * repo/editor: fix breadcrumb path cuts parent dirs (#3859) (#2032)
  * Fix displaying commits and files of PR created from now deleted fork (#2023)
  * Fix #2001 and fix issue comments hidden (#2016)
  * Update code.gitea.io/git (#2014)
  * Keep sort when switching page (#2013)
  * Important: wrong PR merge commit ID saved (#2007)
  * Don't show non-comments in comments API (#2001)
  * Fix "Dashboard shows deleted comments" (#1995)
  * Make branch deletion URL more like GitHub's, fixes #1397 (#1994)
  * Fix fast-forward PR bug (#1989)
  * Fix GPG email checking to be case insensitive (#1988)
  * fix bug for normal user visit public repo (#1984)
  * fix collborators lack of units on orgnization repositories (#1968)
  * Fix diff of renamed and modified file (#1967)
  * Fix uppercase default branch bug (#1965)
  * Fix bug in Action.loadRepo() (#1959)
  * Fix deleted milestone bug (#1942)
  * Fix engine bug in getIssueByID (#1934)
  * Switch to keybase go-crypto (for some elliptic curve key) + test (#1925)
  * Fix setting.AppPath for integration tests (#1923)
  * Fix search by issue type (#1914)
  * Fix ghost user bug (#1913)
  * Require token before checking membership/ownership (#1905)
  * Bug fixes for org member API (#1904)
  * A missing / to provide a correct endpoint (#1903)
  * Fix 500 in public activity page (#1901)
  * Center-aligned login topbar (#1880)
  * Migration to fix existing owner team units (#1873)
  * Fix paginater length (#1866)
  * Fix bug in removeOrgRepo (#1858)
  * Display draft releases (#1854)
  * Fix 404 for external tracking issues (#1852)
  * Update code.gitea.io/git (#1849)
  * Fix user profile activity feed (#1848)
  * Don't ignore error in getMergeCommit (#1843)
  * Fix locking bug in removeOrgRepo (#1842)
  * Fix status table race condition (#1835)
  * Fix PR template error (#1834)
  * Fix pull request compare link (#1832)
  * Use ghost users in issues/PRs (#1831)
  * Commitless repos should be bare (#1829)
  * Update code.gitea.io/git (#1824)
  * Fix invalid reference in feeds template (#1820)
  * fix bug to deny to add orgnization as a member of an orgnization or team (#1815)
  * xxx_active_code_live setting in printed in hours and minutes instead … (#1814)
  * Fix deadlock in updateRepository (#1813)
  * Give all units to owner team (#1812)
  * Fix 500 for GET /teams/:id endpoints (#1811)
  * fix bug not to trim space of login username (#1796)
  * Fix renaming bug (#1786)
  * Fix activity feed (#1779)
  * Make navbar scroll on overflow (#1777)
  * Delete repo redirects on repo deletion (#1776)
  * Fix unloaded owner bug (#1770)
  * Admin should always be allowed to create repositories even if hit limit (#1765)
  * Update HighlightJS and fix YAML files highlighting (#1764)
  * fix: #1757 fix set MAX_CREATION_LIMIT as zero. (#1762)
  * fix admin lost permission caused by #947 (#1753)
  * More fixes for dashboard search (#1750)
  * fixes wrong after field in webhook payload (#1746)
  * fix avatar update bug (#1729)
  * Fix FOUC on Firefox (#1728)
  * Fix changes introduce by update of go-swagger. (#1727)
  * Fix #1719 (#1722)
  * Correct flash after sending password reset email (#1718)
  * Fix and test for delete user (#1713)
  * Fix rendering of issue checkboxes (#1709)
  * Enforce netgo build tag while cross-compilation (#1690)
  * fix bug when push a branch name with / & fix an integration test bug (#1689)
  * fix potential sqlite lock (#1680)
  * Fix commit sha1 URL rendering in markdown (#1677)
  * Fix static files permission under public/ (#1675)
  * fix: tag contain character ) will http 500 on release page (#1670)
  * Fix CSS for code in wiki markdown (#1660)
  * fix multiple readme file rendering and fix #1657 (#1658)
  * Add primary key and index to external login user table (#1656)
  * fix #1643 and improve integration test (#1645)
  * Fix version in Makefile (#1636)
  * Handle display of GPG key without end date (#1628)
  * fix bug on issue view when not login (#1624)
  * bug fixed for API to get user's repos (#1622)
  * fix lost text color on button on set as primary email (#1621)
  * Add create_at and updated_at in PR json (#1616)
  * update git and fix #1133 (#1614)
  * fix bug on status API (#1533)
  * Do not show empty collaborators segment (#1531)
  * Fix markdown rendering (#1530)
  * fix go get sub package and add domain on installation to let go get work defaultly (#1518)
  * fix #1501 ssh hangs caused by #1461 (#1513)
  * Fix empty file download (#1506)
  * Fix broken v27 migration - change mirror interval from int to bigint (#1504)
  * Do not allow commiting to protected branch from online editor (#1502)
  * Add internal routes for ssh hook comands (#1471)
  * Fix races within code.gitea.io/git.(*Command).RunInDirTimeoutPipeline (#1465)
  * Simple quick fix for #1418 (#1456)
  * fix gpg API panic when no verification (#1451)
  * fix migrate failed and org dashboard failed on MSSQL database (#1448)
  * Optimize and fix autolink function (#1442) (#1444)
  * Fix and simplify repo branches (settings) UI (#1435)
  * Fix disabled fields in repo settings UI (#1431)
  * fixes pull request hanging when it contains normal and LFS files (#1425)
  * Fix races in the log module by using syncmap (#1421)
  * Add length check for the return string (#1420)
  * Fix "Error: No issue number specified"  when pushing (#1393)
  * Corrected Mirror.NextUpdate not set (#1388)
  * fix: remove `str2html` from org full name (#1360)
  * Correct broken unaligned load/store in armv5 (#1355)
  * Remove href on first/last link when on first/last page (#1345)
  * Fix broken table layout (#1344)
  * LFS: Fix SSH authentication for trailing arguments (#1328)
  * Remove empty file (#1326)
  * Fix delete user failed on sqlite (#1321)
  * Fix inconsistency in layout (#1316)
  * Fix gpg wrong column types (#1303)
  * Fix wiki bugs (#1294)
  * Fix missing less sources for oauth (#1288)
  * Make sure both scripts/ can live side by side (#1264)
  * Fix nil-dereference bug (#1258)
  * rewrite pre-commit, post-commit and options hooks (fixes #1250) (#1257)
  * Commit search appearence fixes (#1254)
  * Fix forget migration for wiki hooks (#1227)
  * Fix repo settings external tracker failed and check external urls (#1215)
  * Fix 500 caused by branches settings introduced by #1198 (#1214)
  * fix #1189, commit messages containing a pipe (#1203)
  * Bug fixed for delete repo failed (#1193)
  * Fix migration failed when authorized_keys is not exist (#1180)
  * Fix ini format incomiptable with crowdin (#1177)
* TESTING
  * Integration tests for issues API (#2059)
  * Add integration tests for signin (#2363)
  * Add INTERNAL_TOKEN to integration .ini file (#2346)
  * Add public links check (#2323)
  * Fix hooks for integration repo (#2216)
  * More integration tests for comment API (#2156)
  * Cache session cookies in tests (#2128)
  * Less verbose integration tests (#2123)
  * Fix improper setup for integration tests (#2050)
  * Improve integration test helper functions (#2049)
  * Add integration test for issue creating (#2002)
  * Use testing/benchmark interface (#1993)
  * Add integration test for repository migration (#1983)
  * Consolidate boilerplate in integration tests (#1979)
  * Set console to debug for integration tests (#1976)
  * Add pull-create integration test (#1972)
  * Coverage reports for integration tests (#1960)
  * Add integration test for pull-request merge (#1912)
  * Add integration test for file editing (#1907)
  * Add integration test for repository forking (#1896)
  * Run unused test (#1875)
  * Don't recreate database in integration tests (#1697)
  * remove sqlite tag when integration test with mysql/postgres and recreate database when init integration test (#1693)
  * MySQL, Postgres integration tests in drone (#1638)
  * improve integration test to resue models/fixtures and store git repos with tests (#1627)
  * Improve govendor testing (#1623)
  * Integration test framework (#1290)
  * Unit tests for issue_list (#1209)
  * Add integration test for signup (#1135)
* TRANSLATION
  * update translation from crowdin (#2368) (#2380)
  * Small fixes (#2144)
  * Missing signed commit display translations (#2134)
  * Sync latest translations from crowdin (#2104)
  * Add make command update-translations for update translations from crodwin (#2097)
  * Fix some mistakes (#1833)
  * Improve clarity between is_activated and prohibit_login (#1788)
  * Improve grammar (#1775)
  * Fix bad grammar and wordiness (#1741)
  * Make strings translatable (#1188) (#1198)
* BUILD
  * Dockerfile for aarch64 (#1128) (#1130)
  * backport from v1.2 branch: add secrets for github release (#2588) (#2598)
  * Add secrets for github release to fix drone failed (#2588)
  * Backport changes for latest drone (#2586)
  * Removing .drone.yml.sig (#2579)
  * Fix drone for tags (#2573) (#2576)
  * Backport: Remove go version check for make fmt (#2558) (#2561)
  * Backport: Fix lint, fmt and integration testing errors (#2553)
  * update latest xorm version to vendor (#2353)
  * Remove integration test executables on `make clean` (#2340)
  * refactor(Makefile): allow overriding default go program (#2310)
  * Revert to upstream ini dependency (#2304)
  * Use /dev/urandom to create random password (#2298)
  * update drone sig file. (#2262)
  * go get github.com/wadey/gocovmerge when needed (#2235)
  * fix typo (#2145)
  * Revert "Reduce number of layer" (#2086)
  * Reduce number of layer (#2078)
  * Skip sqlite integration in CI (#2058)
  * fix golint error and rename func for suggestion. (#1997)
  * fix misspell (#1996)
  * update drone sig file (#1981)
  * send notification if status changed (#1973)
  * switch gitter to discord for drone. (#1971)
  * Fix missing backslash in Dockerfile.rpi (#1952)
  * Don't run 'make release' on PRs (#1908)
  * Update code.gitea.io/git (#1892)
  * Use production version of vuejs (#1869)
  * Add a variable for docker tag (#1825)
  * resign drone and fix #1816 (#1819)
  * Separate generate swagger + fix sed os specific (#1791)
  * Only run coverage on merges/pushes to master (#1783)
  * Remove stale rule from Makefile (#1782)
  * feat: upgrade drone docker image to support multi-stage build. (#1732)
  * Realy don't cache apk index (#1694)
  * Limit clone depth when drone-building (#1644)
  * Refactor Dockerfile (#1632)
  * Check if missing/modified/unused deps in vendor and fix errors (#1468)
  * Add GOFLAGS and EXTRA_GOFLAGS (#1438)
  * Include formatting check to the `make test` (and thus also `check`) rule (#1366)
* DOCS
  * fix wrong changelog title (#2395)
  * fix webhook link (#2289)
  * Improve swagger doc (#2274)
  * Add link to forum in issue template (#2070)
  * add missing lfs config on example file (#2039)
  * Add discourse link (#2027)
  * Fix wording (#2024)
  * Fix typo (#1974)
  * Swagger docs for list/create forks (#1941)
  * Update links to Discord server (#1940)
  * [ci skip] update discord badge. (#1930)
  * Change join chat from gitter to discord (#1929)
  * Update changelog with v1.1.1 (#1926)
  * Correct grammar in APIEmpty documentation (#1748)
  * Add swagger comment for MirrorSync (#1747)
  * Add "Table of Contents" in CONTRIBUTING.md (#1634)
  * Fix service description in Debian init file (#1538)
  * Use MAINTAINERS file in repository in CONTRIBUTING (#1489)
  * Generate swagger json (#1402)
  * Changed text when password reset disabled. (#1364)
  * Removed email copyright year (#1348)
  * Specify that time interval units are seconds (#1311)
  * Gitea OpenID-2.0 login has been tested with livejournal.com too (#1306)
  * Make wording of commit search more clear (#1291)
  * Add notice that LFS mirroring is not supported (#1251)
  * Fix typos in models/ and modules/ (#1248)
  * Refactor and fix incorrect comment (#1247)
  * Fix migration comment (#1241)
  * Update locale_en-US.ini (#1235)
  * Add LibreJS support (#1201)
  * rename OSX to macOS (#1176)
  * add mssql to app.ini db config comment (#1172)
  * Add MSSQL to issues template (#1171)
* MISC
  * Add badge and link to the Matrix room (#2348)
  * ignore coverage steps. (#2257)
  * Use sqlite3 database as default for Docker image (#2182)
  * update drone discord plugin to 0.0.4 version (#1992)
  * fix typo (#1990)
  * Move 3rd party js/css into `public/vendor` and document sources (#2383)
  * Prevent conflicting TOTP accounts by adding AppURL to issuer parameter (#2335)
  * Fix variable name typo (#2327)
  * Make use of Vue more universal (#2318)
  * Remove (almost) server side data rendering from repo-search component (#2317)
  * Add OpenID configuration in install page (#2276)
  * More tweaks to repo top panel (#2267)
  * File path tweaks in UI (#2264)
  * Make SHOW_USER_EMAIL also apply to profiles (#2258)
  * EnableUnit() -> UnitEnabled() (#2242)
  * Prevent selection of diff line numbers (#2240)
  * Remove unused variable on makefile (#2225)
  * No error log entries for repo 404 (#2200)
  * Refactor vue delimeters to use es6 template delimeters (#2171)
  * Replace tmp with TMPDIR. (#2152)
  * Remove unused files (#2124)
  * Improve org error handling (#2117)
  * Absolute path for setting.CustomConf (#2085)
  * remove deprecated code for Gogs compitable (#2041)
  * Refactor session close as xorm already does everything needed internally  (#2020)
  * SQLite has a query timeout. Hopefully fixes most 'database locked' errors (#1961)
  * Use monospace font in githook editor (#1958)
  * Fix import order (#1951)
  * Gracefully handle bare repositories on API operations. (#1932)
  * Fix errors caused by force push (#1927)
  * Display URLs in integration test logs (#1924)
  * Set TMPDIR enviroment variable for dump command (#1915)
  * Cache ctx.User in retrieveFeeds (#1902)
  * Make `LocalCopyPath` a setting instead of a hard-coded path (#1881)
  * Add check misspelling (#1877)
  * Fix misspelled variables (#1874)
  * Gofmt (#1868, #1710, #1662)
  * Rename misnamed migration (#1867)
  * Support CRLF when splitting code lines for display (#1862)
  * Add convert less css file step. (#1861)
  * Prevent accidential selection of line numbers in code view (#1860)
  * Delete Public SSH Key tmp file after calculating fingerprint (#1855)
  * Remove annoying difference in button heights. (#1853)
  * Only run test coverage on master branch. (#1838)
  * Error from mktemp command in MacOS. (#1837)
  * Use writeTmpKeyFile in calcFingerprint (#1828)
  * ROOT_URL setting use the default as shown in conf/app.ini (#1823)
  * Rename RepoCreationNum -> MaxCreationLimit (#1766)
  * Add button to admin ui (#1738)
  * Correct spelling mistakes (#1703)
  * Make openid support default false for compitable with v1.1 (#1650)
  * Send mails as HTML as default. Setting for send as plain text. (#1648)
  * fix potential lock when sqlite (#1647)
  * Optimize png images via Google zopflipng [ci skip] (#1639)
  * Upgrade alpine to v3.5 in Dockerfile (#1633)
  * remove unused vendor packages (#1620)
  * markup: microoptimise for many short filenames in directory (#1534)
  * support health check via / and fix #969 (#1520)
  * Remove env user salt since no need to use (#1515)
  * Drop db operations from hook commands (#1514)
  * Better URL validation (#1507)
  * Migrate WatchInfo struct to api (#1492)
  * refactor: show command help message. (#1486)
  * refactor update ssh key use time (#1466)
  * Set VERSION from git once, in a variable (#1447)
  * Remove unused mutex field (#1440)
  * Simplify settings pages with item list (#1389)
  * Clean-up PostgreSQL Tests (#1361)
  * refactor: remove workaround after the golang 1.7 release. (#1349)
  * Delete the useless code (#1335)
  * Run "make fmt" with go-1.6 (#1333)
  * Refactor admin/auth/new.tmpl (#1277)
  * Refactor repo/issue/view_content.tmpl (#1276)
  * Cleaner ui for admin, repo settings, and user settings page (#1269) (#1270)
  * Cleaner UI for explore page (#1253) (#1255)
  * Synced licenses with github repo (#1246)
  * Synced gitignores with github repo (#1245)
  * Simplify RepositoryList.loadAttributes() (#1211)
  * Move user_follow to separate file (#1210)
  * Reduce conditionals in signin/signup inner forms (#1138)

## [1.1.4](https://github.com/go-gitea/gitea/releases/tag/v1.1.4) - 2017-09-04

* BUGFIXES
  * Fix rendering of external links (#2292) (#2315)
  * Fix deleted milestone bug (#1942) (#2300)
  * fix 500 error when view an issue which's milestone deleted (#2297) (#2299)
  * Fix SHA1 hash linking (#2143) (#2293)
  * back port from #1709 (#2291)

## [1.1.3](https://github.com/go-gitea/gitea/releases/tag/v1.1.3) - 2017-08-03

* BUGFIXES
  * Fix PR template error (#2008)
  * Fix markdown rendering (fix #1530) (#2043)
  * Fix missing less sources for oauth (backport #1288) (#2135)
  * Don't ignore gravatar error (#2138)
  * Fix diff of renamed and modified file (#2136)
  * Fix fast-forward PR bug (#2137)
  * Fix some security bugs

## [1.1.2](https://github.com/go-gitea/gitea/releases/tag/v1.1.2) - 2017-06-13

* BUGFIXES
  * Enforce netgo build tag while cross-compilation (Backport of #1690) (#1731)
  * fix update avatar
  * fix delete user failed on sqlite (#1321)
  * fix bug not to trim space of login username (#1806)
  * Backport bugfixes #1220 and #1393 to v1.1 (#1758)

## [1.1.1](https://github.com/go-gitea/gitea/releases/tag/v1.1.1) - 2017-05-04

* BUGFIXES
  * Markdown Sanitation Fix [#1646](https://github.com/go-gitea/gitea/pull/1646)
  * Fix broken hooks [#1376](https://github.com/go-gitea/gitea/pull/1376)
  * Fix migration issue [#1375](https://github.com/go-gitea/gitea/pull/1375)
  * Fix Wiki Issues [#1338](https://github.com/go-gitea/gitea/pull/1338)
  * Forgotten migration for wiki githooks [#1237](https://github.com/go-gitea/gitea/pull/1237)
  * Commit messages can contain pipes [#1218](https://github.com/go-gitea/gitea/pull/1218)
  * Verify external tracker URLs [#1236](https://github.com/go-gitea/gitea/pull/1236)
  * Allow upgrade after downgrade [#1197](https://github.com/go-gitea/gitea/pull/1197)
  * 500 on delete repo with issue [#1195](https://github.com/go-gitea/gitea/pull/1195)
  * INI compat with CrowdIn [#1192](https://github.com/go-gitea/gitea/pull/1192)

## [1.1.0](https://github.com/go-gitea/gitea/releases/tag/v1.1.0) - 2017-03-09

* BREAKING
  * The SSH keys can potentially break, make sure to regenerate the authorized keys
* FEATURES
  * Git LFSv2 support [#122](https://github.com/go-gitea/gitea/pull/122)
  * API endpoints for repo watching [#191](https://github.com/go-gitea/gitea/pull/191)
  * Search within private repos [#222](https://github.com/go-gitea/gitea/pull/222)
  * Hide user email address on explore page [#336](https://github.com/go-gitea/gitea/pull/336)
  * Protected branch system [#339](https://github.com/go-gitea/gitea/pull/339)
  * Sendmail for mail delivery [#355](https://github.com/go-gitea/gitea/pull/355)
  * API endpoints for org webhooks [#372](https://github.com/go-gitea/gitea/pull/372)
  * Enabled MSSQL support [#383](https://github.com/go-gitea/gitea/pull/383)
  * API endpoints for org teams [#370](https://github.com/go-gitea/gitea/pull/370)
  * API endpoints for collaborators [#375](https://github.com/go-gitea/gitea/pull/375)
  * Graceful server restart [#416](https://github.com/go-gitea/gitea/pull/416)
  * Commitgraph / timeline on commits page [#428](https://github.com/go-gitea/gitea/pull/428)
  * API endpoints for repo forks [#509](https://github.com/go-gitea/gitea/pull/509)
  * API endpoints for releases [#510](https://github.com/go-gitea/gitea/pull/510)
  * Folder jumping [#511](https://github.com/go-gitea/gitea/pull/511)
  * Stars tab on profile page [#519](https://github.com/go-gitea/gitea/pull/519)
  * Notification system [#523](https://github.com/go-gitea/gitea/pull/523)
  * Push and pull through reverse proxy basic auth [#524](https://github.com/go-gitea/gitea/pull/524)
  * Search for issues and pull requests [#530](https://github.com/go-gitea/gitea/pull/530)
  * API endpoint for stargazers [#597](https://github.com/go-gitea/gitea/pull/597)
  * API endpoints for subscribers [#598](https://github.com/go-gitea/gitea/pull/598)
  * PID file support [#610](https://github.com/go-gitea/gitea/pull/610)
  * Two factor authentication (2FA) [#630](https://github.com/go-gitea/gitea/pull/630)
  * API endpoints for org users [#645](https://github.com/go-gitea/gitea/pull/645)
  * Release attachments [#673](https://github.com/go-gitea/gitea/pull/673)
  * OAuth2 consumer [#679](https://github.com/go-gitea/gitea/pull/679)
  * Add ability to fork your own repos [#761](https://github.com/go-gitea/gitea/pull/761)
  * Search repository on dashboard [#773](https://github.com/go-gitea/gitea/pull/773)
  * Search bar on user profile [#787](https://github.com/go-gitea/gitea/pull/787)
  * Track label changes on issue view [#788](https://github.com/go-gitea/gitea/pull/788)
  * Allow using custom time format [#798](https://github.com/go-gitea/gitea/pull/798)
  * Redirects for renamed repos [#807](https://github.com/go-gitea/gitea/pull/807)
  * Track assignee changes on issue view [#808](https://github.com/go-gitea/gitea/pull/808)
  * Track title changes on issue view [#841](https://github.com/go-gitea/gitea/pull/841)
  * Archive cleanup action [#885](https://github.com/go-gitea/gitea/pull/885)
  * Basic Open Graph support [#901](https://github.com/go-gitea/gitea/pull/901)
  * Take back control of Git hooks [#1006](https://github.com/go-gitea/gitea/pull/1006)
  * API endpoints for user repos [#1059](https://github.com/go-gitea/gitea/pull/1059)
* BUGFIXES
  * Fixed counting issues for issue filters [#413](https://github.com/go-gitea/gitea/pull/413)
  * Added back default settings for SSH [#500](https://github.com/go-gitea/gitea/pull/500)
  * Fixed repo permissions [#513](https://github.com/go-gitea/gitea/pull/513)
  * Issues cannot be created with labels [#622](https://github.com/go-gitea/gitea/pull/622)
  * Add a reserved wiki paths check to the wiki [#720](https://github.com/go-gitea/gitea/pull/720)
  * Update website binding MaxSize to 255 [#722](https://github.com/go-gitea/gitea/pull/722)
  * User can see the private activity on public history [#818](https://github.com/go-gitea/gitea/pull/818)
  * Wrong pages number which includes private repositories [#844](https://github.com/go-gitea/gitea/pull/844)
  * Trim whitespaces for search keyword [#893](https://github.com/go-gitea/gitea/pull/893)
  * Don't rewrite non-gitea public keys [#906](https://github.com/go-gitea/gitea/pull/906)
  * Use fingerprint to check instead content for public key [#911](https://github.com/go-gitea/gitea/pull/911)
  * Fix random avatars [#1147](https://github.com/go-gitea/gitea/pull/1147)
* ENHANCEMENTS
  * Refactored process manager [#75](https://github.com/go-gitea/gitea/pull/75)
  * Restrict rights to create new orgs [#193](https://github.com/go-gitea/gitea/pull/193)
  * Added label and milestone sorting [#199](https://github.com/go-gitea/gitea/pull/199)
  * Make minimum password length configurable [#223](https://github.com/go-gitea/gitea/pull/223)
  * Speedup conflict checking on pull requests [#276](https://github.com/go-gitea/gitea/pull/276)
  * Added button to delete merged pull request branches [#441](https://github.com/go-gitea/gitea/pull/441)
  * Improved issue references within markdown [#471](https://github.com/go-gitea/gitea/pull/471)
  * Dutch translation for the landingpage [#487](https://github.com/go-gitea/gitea/pull/487)
  * Added Gogs migration script [#532](https://github.com/go-gitea/gitea/pull/532)
  * Support a .gitea folder for issue templates [#582](https://github.com/go-gitea/gitea/pull/582)
  * Enhanced diff-view coloring [#584](https://github.com/go-gitea/gitea/pull/584)
  * Added ETag header to avatars [#721](https://github.com/go-gitea/gitea/pull/721)
  * Added option to config to disable local path imports [#724](https://github.com/go-gitea/gitea/pull/724)
  * Allow custom public files [#782](https://github.com/go-gitea/gitea/pull/782)
  * Added pprof endpoint for debugging [#801](https://github.com/go-gitea/gitea/pull/801)
  * Added `X-GitHub-*` headers [#809](https://github.com/go-gitea/gitea/pull/809)
  * Fill SSH key title automatically [#863](https://github.com/go-gitea/gitea/pull/863)
  * Display Git version on admin panel [#921](https://github.com/go-gitea/gitea/pull/921)
  * Expose URL field on issue API [#982](https://github.com/go-gitea/gitea/pull/982)
  * Statically compile the binaries [#985](https://github.com/go-gitea/gitea/pull/985)
  * Embed build tags into version string [#1051](https://github.com/go-gitea/gitea/pull/1051)
  * Gitignore support for FSharp and Clojure [#1072](https://github.com/go-gitea/gitea/pull/1072)
  * Custom templates for static builds [#1087](https://github.com/go-gitea/gitea/pull/1087)
  * Add ProxyFromEnvironment if none set [#1096](https://github.com/go-gitea/gitea/pull/1096)
* MISC
  * Replaced remaining Gogs references
  * Added more tests on various packages
  * Use Crowdin for translations again
  * Resolved some XSS attack vectors
  * Optimized and reduced number of database queries

## [1.0.2](https://github.com/go-gitea/gitea/releases/tag/v1.0.2) - 2017-02-21

* BUGFIXES
  * Fixed issue counter [#882](https://github.com/go-gitea/gitea/pull/882)
  * Fixed XSS vulnerability on wiki page [#955](https://github.com/go-gitea/gitea/pull/955)
  * Add data dir without session to dump [#587](https://github.com/go-gitea/gitea/pull/587)
  * Fixed wiki page renaming [#958](https://github.com/go-gitea/gitea/pull/958)
  * Drop default console logger if not required [#960](https://github.com/go-gitea/gitea/pull/960)
  * Fixed docker docs link on install page [#972](https://github.com/go-gitea/gitea/pull/972)
  * Handle SetModel errors [#957](https://github.com/go-gitea/gitea/pull/957)
  * Fixed XSS vulnerability on milestones [#977](https://github.com/go-gitea/gitea/pull/977)
  * Fixed XSS vulnerability on alerts [#981](https://github.com/go-gitea/gitea/pull/981)

## [1.0.1](https://github.com/go-gitea/gitea/releases/tag/v1.0.1) - 2017-01-05

* BUGFIXES
  * Fixed localized `MIN_PASSWORD_LENGTH` [#501](https://github.com/go-gitea/gitea/pull/501)
  * Fixed 500 error on organization delete [#507](https://github.com/go-gitea/gitea/pull/507)
  * Ignore empty wiki repo on migrate [#544](https://github.com/go-gitea/gitea/pull/544)
  * Proper check access for forking [#563](https://github.com/go-gitea/gitea/pull/563)
  * Fix SSH domain on installer [#506](https://github.com/go-gitea/gitea/pull/506)
  * Fix missing data rows on admin UI [#580](https://github.com/go-gitea/gitea/pull/580)
  * Do not delete tags with releases by default [#579](https://github.com/go-gitea/gitea/pull/579)
  * Fix missing session config data on admin UI [#578](https://github.com/go-gitea/gitea/pull/578)
  * Properly show the version within footer on the UI [#593](https://github.com/go-gitea/gitea/pull/593)

## [1.0.0](https://github.com/go-gitea/gitea/releases/tag/v1.0.0) - 2016-12-23

* BREAKING
  * We have various changes on the API, scripting against API must be updated
* FEATURES
  * Show last login for admins [#121](https://github.com/go-gitea/gitea/pull/121)
* BUGFIXES
  * Fixed sender of notifications [#2](https://github.com/go-gitea/gitea/pull/2)
  * Fixed keyword hijacking vulnerability [#20](https://github.com/go-gitea/gitea/pull/20)
  * Fixed non-markdown readme rendering [#95](https://github.com/go-gitea/gitea/pull/95)
  * Allow updating draft releases [#169](https://github.com/go-gitea/gitea/pull/169)
  * GitHub API compliance [#227](https://github.com/go-gitea/gitea/pull/227)
  * Added commit SHA to tag webhook [#286](https://github.com/go-gitea/gitea/issues/286)
  * Secured links via noopener [#315](https://github.com/go-gitea/gitea/issues/315)
  * Replace tabs with spaces on wiki title [#371](https://github.com/go-gitea/gitea/pull/371)
  * Fixed vulnerability on labels and releases [#409](https://github.com/go-gitea/gitea/pull/409)
  * Fixed issue comment API [#449](https://github.com/go-gitea/gitea/pull/449)
* ENHANCEMENTS
  * Use proper import path for libravatar [#3](https://github.com/go-gitea/gitea/pull/3)
  * Integrated DroneCI for tests and builds [#24](https://github.com/go-gitea/gitea/issues/24)
  * Integrated dependency manager [#29](https://github.com/go-gitea/gitea/issues/29)
  * Embedded bindata optionally [#30](https://github.com/go-gitea/gitea/issues/30)
  * Integrated pagination for releases [#73](https://github.com/go-gitea/gitea/pull/73)
  * Autogenerate version on every build [#91](https://github.com/go-gitea/gitea/issues/91)
  * Refactored Docker container [#104](https://github.com/go-gitea/gitea/issues/104)
  * Added short-hash support for downloads [#211](https://github.com/go-gitea/gitea/issues/211)
  * Display tooltip for downloads [#221](https://github.com/go-gitea/gitea/issues/221)
  * Improved HTTP headers for issue attachments [#270](https://github.com/go-gitea/gitea/pull/270)
  * Integrate public as bindata optionally [#293](https://github.com/go-gitea/gitea/pull/293)
  * Integrate templates as bindata optionally [#314](https://github.com/go-gitea/gitea/pull/314)
  * Inject more ENV variables into custom hooks [#316](https://github.com/go-gitea/gitea/issues/316)
  * Correct LDAP login validation [#342](https://github.com/go-gitea/gitea/pull/342)
  * Integrate conf as bindata optionally [#354](https://github.com/go-gitea/gitea/pull/354)
  * Serve video files in browser [#418](https://github.com/go-gitea/gitea/pull/418)
  * Configurable SSH host binding [#431](https://github.com/go-gitea/gitea/issues/431)
* MISC
  * Forked from Gogs and renamed to Gitea
  * Catching more errors with logs
  * Fixed all linting errors
  * Made the go linter entirely happy
  * Really integrated vendoring
