# Omnipay: Paxum

**Paxum driver for PHP merchant library**

[![Latest Stable Version](https://poser.pugx.org/hiqdev/omnipay-paxum/v/stable)](https://packagist.org/packages/hiqdev/omnipay-paxum)
[![Total Downloads](https://poser.pugx.org/hiqdev/omnipay-paxum/downloads)](https://packagist.org/packages/hiqdev/omnipay-paxum)
[![Build Status](https://img.shields.io/travis/hiqdev/omnipay-paxum.svg)](https://travis-ci.org/hiqdev/omnipay-paxum)
[![Scrutinizer Code Coverage](https://img.shields.io/scrutinizer/coverage/g/hiqdev/omnipay-paxum.svg)](https://scrutinizer-ci.com/g/hiqdev/omnipay-paxum/)
[![Scrutinizer Code Quality](https://img.shields.io/scrutinizer/g/hiqdev/omnipay-paxum.svg)](https://scrutinizer-ci.com/g/hiqdev/omnipay-paxum/)
[![Dependency Status](https://www.versioneye.com/php/hiqdev:omnipay-paxum/dev-master/badge.svg)](https://www.versioneye.com/php/hiqdev:omnipay-paxum/dev-master)

[Omnipay](https://github.com/omnipay/omnipay) is a framework agnostic, multi-gateway payment
processing library for PHP 5.3+.

This package implements [Paxum](https://paupal.com/) support for Omnipay.

## Installation

The preferred way to install this library is through [composer](http://getcomposer.org/download/).

Either run

```sh
php composer.phar require "hiqdev/omnipay-paxum"
```

or add

```json
"hiqdev/omnipay-paxum": "*"
```

to the require section of your composer.json.

## Basic Usage

The following gateway is provided by this package:

* [Paxum](http://paxum.com/)

For general usage instructions, please see the main [Omnipay](https://github.com/omnipay/omnipay) repository.

## Support

If you are having general issues with Omnipay, we suggest posting on
[Stack Overflow](http://stackoverflow.com/). Be sure to add the
[omnipay tag](http://stackoverflow.com/questions/tagged/omnipay) so it can be easily found.

If you want to keep up to date with release anouncements, discuss ideas for the project,
or ask more detailed questions, there is also a [mailing list](https://groups.google.com/forum/#!forum/omnipay) which
you can subscribe to.

If you believe you have found a bug, please report it using the [GitHub issue tracker](https://github.com/hiqdev/omnipay-paxum/issues),
or better yet, fork the library and submit a pull request.

## License

This project is released under the terms of the MIT [license](LICENSE).
Read more [here](http://choosealicense.com/licenses/mit).

Copyright © 2015-2017, HiQDev (http://hiqdev.com/)
