// @generated by Peggy 4.0.3.
//
// https://peggyjs.org/



import * as ast from "./ast.js";

function peg$subclass(child, parent) {
  function C() { this.constructor = child; }
  C.prototype = parent.prototype;
  child.prototype = new C();
}

function peg$SyntaxError(message, expected, found, location) {
  var self = Error.call(this, message);
  // istanbul ignore next Check is a necessary evil to support older environments
  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(self, peg$SyntaxError.prototype);
  }
  self.expected = expected;
  self.found = found;
  self.location = location;
  self.name = "SyntaxError";
  return self;
}

peg$subclass(peg$SyntaxError, Error);

function peg$padEnd(str, targetLength, padString) {
  padString = padString || " ";
  if (str.length > targetLength) { return str; }
  targetLength -= str.length;
  padString += padString.repeat(targetLength);
  return str + padString.slice(0, targetLength);
}

peg$SyntaxError.prototype.format = function(sources) {
  var str = "Error: " + this.message;
  if (this.location) {
    var src = null;
    var k;
    for (k = 0; k < sources.length; k++) {
      if (sources[k].source === this.location.source) {
        src = sources[k].text.split(/\r\n|\n|\r/g);
        break;
      }
    }
    var s = this.location.start;
    var offset_s = (this.location.source && (typeof this.location.source.offset === "function"))
      ? this.location.source.offset(s)
      : s;
    var loc = this.location.source + ":" + offset_s.line + ":" + offset_s.column;
    if (src) {
      var e = this.location.end;
      var filler = peg$padEnd("", offset_s.line.toString().length, ' ');
      var line = src[s.line - 1];
      var last = s.line === e.line ? e.column : line.length + 1;
      var hatLen = (last - s.column) || 1;
      str += "\n --> " + loc + "\n"
          + filler + " |\n"
          + offset_s.line + " | " + line + "\n"
          + filler + " | " + peg$padEnd("", s.column - 1, ' ')
          + peg$padEnd("", hatLen, "^");
    } else {
      str += "\n at " + loc;
    }
  }
  return str;
};

peg$SyntaxError.buildMessage = function(expected, found) {
  var DESCRIBE_EXPECTATION_FNS = {
    literal: function(expectation) {
      return "\"" + literalEscape(expectation.text) + "\"";
    },

    class: function(expectation) {
      var escapedParts = expectation.parts.map(function(part) {
        return Array.isArray(part)
          ? classEscape(part[0]) + "-" + classEscape(part[1])
          : classEscape(part);
      });

      return "[" + (expectation.inverted ? "^" : "") + escapedParts.join("") + "]";
    },

    any: function() {
      return "any character";
    },

    end: function() {
      return "end of input";
    },

    other: function(expectation) {
      return expectation.description;
    }
  };

  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }

  function literalEscape(s) {
    return s
      .replace(/\\/g, "\\\\")
      .replace(/"/g,  "\\\"")
      .replace(/\0/g, "\\0")
      .replace(/\t/g, "\\t")
      .replace(/\n/g, "\\n")
      .replace(/\r/g, "\\r")
      .replace(/[\x00-\x0F]/g,          function(ch) { return "\\x0" + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return "\\x"  + hex(ch); });
  }

  function classEscape(s) {
    return s
      .replace(/\\/g, "\\\\")
      .replace(/\]/g, "\\]")
      .replace(/\^/g, "\\^")
      .replace(/-/g,  "\\-")
      .replace(/\0/g, "\\0")
      .replace(/\t/g, "\\t")
      .replace(/\n/g, "\\n")
      .replace(/\r/g, "\\r")
      .replace(/[\x00-\x0F]/g,          function(ch) { return "\\x0" + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return "\\x"  + hex(ch); });
  }

  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }

  function describeExpected(expected) {
    var descriptions = expected.map(describeExpectation);
    var i, j;

    descriptions.sort();

    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }

    switch (descriptions.length) {
      case 1:
        return descriptions[0];

      case 2:
        return descriptions[0] + " or " + descriptions[1];

      default:
        return descriptions.slice(0, -1).join(", ")
          + ", or "
          + descriptions[descriptions.length - 1];
    }
  }

  function describeFound(found) {
    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
  }

  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
};

function peg$parse(input, options) {
  options = options !== undefined ? options : {};

  var peg$FAILED = {};
  var peg$source = options.grammarSource;

  var peg$startRuleFunctions = { rulelist: peg$parserulelist };
  var peg$startRuleFunction = peg$parserulelist;

  var peg$c0 = "=/";
  var peg$c1 = ":";
  var peg$c2 = "=";
  var peg$c3 = ";";
  var peg$c4 = "/";
  var peg$c5 = "*";
  var peg$c6 = "(";
  var peg$c7 = ")";
  var peg$c8 = "[";
  var peg$c9 = "]";
  var peg$c10 = "%i";
  var peg$c11 = "%s";
  var peg$c12 = "%";
  var peg$c13 = "<";
  var peg$c14 = ">";
  var peg$c15 = "\"";
  var peg$c16 = "b";
  var peg$c17 = ".";
  var peg$c18 = "-";
  var peg$c19 = "d";
  var peg$c20 = "x";
  var peg$c21 = " ";
  var peg$c22 = "\t";
  var peg$c23 = "\r";
  var peg$c24 = "\n";

  var peg$r0 = /^[\-0-9A-Za-z]/;
  var peg$r1 = /^[\t -~]/;
  var peg$r2 = /^[ -!#-~]/;
  var peg$r3 = /^[ -=?-~]/;
  var peg$r4 = /^[0-1]/;
  var peg$r5 = /^[A-F]/i;
  var peg$r6 = /^[A-Za-z]/;
  var peg$r7 = /^[0-9]/;
  var peg$r8 = /^[\t ]/;
  var peg$r9 = /^[!-~]/;
  var peg$r10 = /^[\n\r]/;

  var peg$e0 = peg$classExpectation(["-", ["0", "9"], ["A", "Z"], ["a", "z"]], false, false);
  var peg$e1 = peg$literalExpectation("=/", false);
  var peg$e2 = peg$literalExpectation(":", false);
  var peg$e3 = peg$literalExpectation("=", false);
  var peg$e4 = peg$literalExpectation(";", false);
  var peg$e5 = peg$classExpectation(["\t", [" ", "~"]], false, false);
  var peg$e6 = peg$literalExpectation("/", false);
  var peg$e7 = peg$literalExpectation("*", false);
  var peg$e8 = peg$literalExpectation("(", false);
  var peg$e9 = peg$literalExpectation(")", false);
  var peg$e10 = peg$literalExpectation("[", false);
  var peg$e11 = peg$literalExpectation("]", false);
  var peg$e12 = peg$literalExpectation("%i", true);
  var peg$e13 = peg$classExpectation([[" ", "!"], ["#", "~"]], false, false);
  var peg$e14 = peg$literalExpectation("%s", true);
  var peg$e15 = peg$literalExpectation("%", false);
  var peg$e16 = peg$literalExpectation("<", false);
  var peg$e17 = peg$classExpectation([[" ", "="], ["?", "~"]], false, false);
  var peg$e18 = peg$literalExpectation(">", false);
  var peg$e19 = peg$literalExpectation("\"", false);
  var peg$e20 = peg$literalExpectation("b", true);
  var peg$e21 = peg$literalExpectation(".", false);
  var peg$e22 = peg$literalExpectation("-", false);
  var peg$e23 = peg$literalExpectation("d", true);
  var peg$e24 = peg$literalExpectation("x", true);
  var peg$e25 = peg$anyExpectation();
  var peg$e26 = peg$classExpectation([["0", "1"]], false, false);
  var peg$e27 = peg$classExpectation([["A", "F"]], false, true);
  var peg$e28 = peg$classExpectation([["A", "Z"], ["a", "z"]], false, false);
  var peg$e29 = peg$classExpectation([["0", "9"]], false, false);
  var peg$e30 = peg$classExpectation(["\t", " "], false, false);
  var peg$e31 = peg$literalExpectation(" ", false);
  var peg$e32 = peg$literalExpectation("\t", false);
  var peg$e33 = peg$classExpectation([["!", "~"]], false, false);
  var peg$e34 = peg$classExpectation(["\n", "\r"], false, false);
  var peg$e35 = peg$literalExpectation("\r", false);
  var peg$e36 = peg$literalExpectation("\n", false);

  var peg$f0 = function() {
  rules.loc = location();
  return rules;
};
  var peg$f1 = function(name, operator, children) {
  if (operator === "=/") {
    rules.addAlternate(name, children, location())
  } else {
    rules.addRule(name, children, location())
  }
};
  var peg$f2 = function(head, tail) {
  if (tail.length > 0) {
    return new ast.Alternation([head, ...tail], location());
  }
  return head;
};
  var peg$f3 = function(head, tail) {
  if (tail.length > 0) {
    return new ast.Concatenation([head, ...tail], location());
  }
  return head;
};
  var peg$f4 = function(repeat, e) {
  if (repeat) {
    return new ast.Repetition(repeat, e, location());
  }
  return e;
};
  var peg$f5 = function(min, max) {
    min |= 0;
    if (max === 0) {
      error("max must not be zero");
      return;
    }
    if ((typeof max === "number") && (max < min)) {
      error(`max must be greater than or equal to min, but ${max} < ${min}`)
      return;
    }
    return new ast.Repeat(min, max, location());
  };
  var peg$f6 = function(n) { return new ast.Repeat(n, n, location()); };
  var peg$f7 = function(name) { return rules.addRef(name, location()) };
  var peg$f8 = function(alt) {
  return new ast.Group(alt, location());
};
  var peg$f9 = function(alt) {
  const loc = location();
  return new ast.Repetition(new ast.Repeat(0, 1, loc), alt, loc);
};
  var peg$f10 = function(txt) {
    return new ast.CaseInsensitiveString(txt, location());
  };
  var peg$f11 = function(txt) {
    return new ast.CaseSensitiveString(txt, 0, location());
  };
  var peg$f12 = function(prose) {
  return new ast.Prose(prose, location());
};
  var peg$f13 = function(nums) {
    return new ast.CaseSensitiveString(
      nums.map(b => String.fromCodePoint(b)).join(""),
      2,
      location()
    );
  };
  var peg$f14 = function(min, max) {
    return ast.Range.create(2, min, max, location(), options.utf16);
  };
  var peg$f15 = function(n) {
    return new ast.CaseSensitiveString(String.fromCodePoint(n), 2, location())
  };
  var peg$f16 = function(nums) {
    return new ast.CaseSensitiveString(
      nums.map(d => String.fromCodePoint(d)).join(""),
      10,
      location()
    );
  };
  var peg$f17 = function(min, max) {
    return ast.Range.create(10, min, max, location(), options.utf16);
  };
  var peg$f18 = function(n) {
    return new ast.CaseSensitiveString(String.fromCodePoint(n), 10, location())
  };
  var peg$f19 = function(nums) {
    return new ast.CaseSensitiveString(
      nums.map(x => String.fromCodePoint(x)).join(""),
      16,
      location()
    );
  };
  var peg$f20 = function(min, max) {
    return ast.Range.create(16, min, max, location(), options.utf16);
  };
  var peg$f21 = function(n) {
    return new ast.CaseSensitiveString(String.fromCodePoint(n), 10, location())
  };
  var peg$f22 = function(b) { return parseInt(b, 2) };
  var peg$f23 = function(d) { return parseInt(d, 10) };
  var peg$f24 = function(h) { return parseInt(h, 16) };
  var peg$currPos = options.peg$currPos | 0;
  var peg$savedPos = peg$currPos;
  var peg$posDetailsCache = [{ line: 1, column: 1 }];
  var peg$maxFailPos = peg$currPos;
  var peg$maxFailExpected = options.peg$maxFailExpected || [];
  var peg$silentFails = options.peg$silentFails | 0;

  var peg$result;

  if (options.startRule) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function offset() {
    return peg$savedPos;
  }

  function range() {
    return {
      source: peg$source,
      start: peg$savedPos,
      end: peg$currPos
    };
  }

  function location() {
    return peg$computeLocation(peg$savedPos, peg$currPos);
  }

  function expected(description, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildStructuredError(
      [peg$otherExpectation(description)],
      input.substring(peg$savedPos, peg$currPos),
      location
    );
  }

  function error(message, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildSimpleError(message, location);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: "literal", text: text, ignoreCase: ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase) {
    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
  }

  function peg$anyExpectation() {
    return { type: "any" };
  }

  function peg$endExpectation() {
    return { type: "end" };
  }

  function peg$otherExpectation(description) {
    return { type: "other", description: description };
  }

  function peg$computePosDetails(pos) {
    var details = peg$posDetailsCache[pos];
    var p;

    if (details) {
      return details;
    } else {
      if (pos >= peg$posDetailsCache.length) {
        p = peg$posDetailsCache.length - 1;
      } else {
        p = pos;
        while (!peg$posDetailsCache[--p]) {}
      }

      details = peg$posDetailsCache[p];
      details = {
        line: details.line,
        column: details.column
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;

      return details;
    }
  }

  function peg$computeLocation(startPos, endPos, offset) {
    var startPosDetails = peg$computePosDetails(startPos);
    var endPosDetails = peg$computePosDetails(endPos);

    var res = {
      source: peg$source,
      start: {
        offset: startPos,
        line: startPosDetails.line,
        column: startPosDetails.column
      },
      end: {
        offset: endPos,
        line: endPosDetails.line,
        column: endPosDetails.column
      }
    };
    if (offset && peg$source && (typeof peg$source.offset === "function")) {
      res.start = peg$source.offset(res.start);
      res.end = peg$source.offset(res.end);
    }
    return res;
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) { return; }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildSimpleError(message, location) {
    return new peg$SyntaxError(message, null, null, location);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(
      peg$SyntaxError.buildMessage(expected, found),
      expected,
      found,
      location
    );
  }

  function peg$parserulelist() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parserule();
    if (s2 === peg$FAILED) {
      s2 = peg$parseempty();
    }
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parserule();
        if (s2 === peg$FAILED) {
          s2 = peg$parseempty();
        }
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f0();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseempty() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseWSP();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parseWSP();
    }
    s2 = peg$parsecomment();
    if (s2 !== peg$FAILED) {
      s1 = [s1, s2];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWSP();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWSP();
      }
      s2 = peg$parseCRLF();
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parserule() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseWSP();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parseWSP();
    }
    s2 = peg$parserulename();
    if (s2 !== peg$FAILED) {
      s3 = peg$parsedefined_as();
      if (s3 !== peg$FAILED) {
        s4 = peg$parseelements();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsec_nl();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f1(s2, s3, s4);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parserulename() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseALPHA();
    if (s2 !== peg$FAILED) {
      s3 = [];
      s4 = input.charAt(peg$currPos);
      if (peg$r0.test(s4)) {
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e0); }
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = input.charAt(peg$currPos);
        if (peg$r0.test(s4)) {
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e0); }
        }
      }
      s2 = [s2, s3];
      s1 = s2;
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parsedefined_as() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsec_wsp();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsec_wsp();
    }
    if (input.substr(peg$currPos, 2) === peg$c0) {
      s2 = peg$c0;
      peg$currPos += 2;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e1); }
    }
    if (s2 === peg$FAILED) {
      s2 = peg$currPos;
      s3 = [];
      if (input.charCodeAt(peg$currPos) === 58) {
        s4 = peg$c1;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e2); }
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        if (s3.length >= 2) {
          s4 = peg$FAILED;
        } else {
          if (input.charCodeAt(peg$currPos) === 58) {
            s4 = peg$c1;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e2); }
          }
        }
      }
      if (input.charCodeAt(peg$currPos) === 61) {
        s4 = peg$c2;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e3); }
      }
      if (s4 !== peg$FAILED) {
        s3 = [s3, s4];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    }
    if (s2 !== peg$FAILED) {
      s3 = [];
      s4 = peg$parsec_wsp();
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$parsec_wsp();
      }
      s0 = s2;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseelements() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsealternation();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsec_wsp();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsec_wsp();
      }
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecomment() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 59) {
      s1 = peg$c3;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e4); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = [];
      s4 = input.charAt(peg$currPos);
      if (peg$r1.test(s4)) {
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e5); }
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = input.charAt(peg$currPos);
        if (peg$r1.test(s4)) {
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e5); }
        }
      }
      s2 = input.substring(s2, peg$currPos);
      s3 = peg$parseEOL();
      if (s3 !== peg$FAILED) {
        s1 = [s1, s2, s3];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealternation() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseconcatenation();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = [];
      s5 = peg$parsec_wsp();
      while (s5 !== peg$FAILED) {
        s4.push(s5);
        s5 = peg$parsec_wsp();
      }
      if (input.charCodeAt(peg$currPos) === 47) {
        s5 = peg$c4;
        peg$currPos++;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e6); }
      }
      if (s5 !== peg$FAILED) {
        s6 = [];
        s7 = peg$parsec_wsp();
        while (s7 !== peg$FAILED) {
          s6.push(s7);
          s7 = peg$parsec_wsp();
        }
        s7 = peg$parseconcatenation();
        if (s7 !== peg$FAILED) {
          s3 = s7;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = [];
        s5 = peg$parsec_wsp();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parsec_wsp();
        }
        if (input.charCodeAt(peg$currPos) === 47) {
          s5 = peg$c4;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e6); }
        }
        if (s5 !== peg$FAILED) {
          s6 = [];
          s7 = peg$parsec_wsp();
          while (s7 !== peg$FAILED) {
            s6.push(s7);
            s7 = peg$parsec_wsp();
          }
          s7 = peg$parseconcatenation();
          if (s7 !== peg$FAILED) {
            s3 = s7;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f2(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseconcatenation() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parserepetition();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = [];
      s5 = peg$parsec_wsp();
      if (s5 !== peg$FAILED) {
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parsec_wsp();
        }
      } else {
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parserepetition();
        if (s5 !== peg$FAILED) {
          s3 = s5;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = [];
        s5 = peg$parsec_wsp();
        if (s5 !== peg$FAILED) {
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parsec_wsp();
          }
        } else {
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parserepetition();
          if (s5 !== peg$FAILED) {
            s3 = s5;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f3(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parserepetition() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parserepeat();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parseelement();
    if (s2 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f4(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parserepeat() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsedecnum();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (input.charCodeAt(peg$currPos) === 42) {
      s2 = peg$c5;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e7); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parsedecnum();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f5(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsedecnum();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f6(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseelement() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parserulename();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f7(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parsegroup();
      if (s0 === peg$FAILED) {
        s0 = peg$parseoption();
        if (s0 === peg$FAILED) {
          s0 = peg$parsechar_val();
          if (s0 === peg$FAILED) {
            s0 = peg$parsenum_val();
            if (s0 === peg$FAILED) {
              s0 = peg$parseprose_val();
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsegroup() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 40) {
      s1 = peg$c6;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e8); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsec_wsp();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsec_wsp();
      }
      s3 = peg$parsealternation();
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$parsec_wsp();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parsec_wsp();
        }
        if (input.charCodeAt(peg$currPos) === 41) {
          s5 = peg$c7;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e9); }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f8(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseoption() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 91) {
      s1 = peg$c8;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e10); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsec_wsp();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsec_wsp();
      }
      s3 = peg$parsealternation();
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$parsec_wsp();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parsec_wsp();
        }
        if (input.charCodeAt(peg$currPos) === 93) {
          s5 = peg$c9;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e11); }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f9(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsechar_val() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = input.substr(peg$currPos, 2);
    if (s1.toLowerCase() === peg$c10) {
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e12); }
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parseDQUOTE();
    if (s2 !== peg$FAILED) {
      s3 = peg$currPos;
      s4 = [];
      s5 = input.charAt(peg$currPos);
      if (peg$r2.test(s5)) {
        peg$currPos++;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e13); }
      }
      while (s5 !== peg$FAILED) {
        s4.push(s5);
        s5 = input.charAt(peg$currPos);
        if (peg$r2.test(s5)) {
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e13); }
        }
      }
      s3 = input.substring(s3, peg$currPos);
      s4 = peg$parseDQUOTE();
      if (s4 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f10(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = input.substr(peg$currPos, 2);
      if (s1.toLowerCase() === peg$c11) {
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e14); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseDQUOTE();
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          s4 = [];
          s5 = input.charAt(peg$currPos);
          if (peg$r2.test(s5)) {
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e13); }
          }
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = input.charAt(peg$currPos);
            if (peg$r2.test(s5)) {
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e13); }
            }
          }
          s3 = input.substring(s3, peg$currPos);
          s4 = peg$parseDQUOTE();
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f11(s3);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsenum_val() {
    var s0, s1, s2;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 37) {
      s1 = peg$c12;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e15); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsebin_val();
      if (s2 === peg$FAILED) {
        s2 = peg$parsedec_val();
        if (s2 === peg$FAILED) {
          s2 = peg$parsehex_val();
        }
      }
      if (s2 !== peg$FAILED) {
        s0 = s2;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseprose_val() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 60) {
      s1 = peg$c13;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e16); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = [];
      s4 = input.charAt(peg$currPos);
      if (peg$r3.test(s4)) {
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e17); }
      }
      if (s4 === peg$FAILED) {
        s4 = peg$parseCRLF();
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = input.charAt(peg$currPos);
        if (peg$r3.test(s4)) {
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e17); }
        }
        if (s4 === peg$FAILED) {
          s4 = peg$parseCRLF();
        }
      }
      s2 = input.substring(s2, peg$currPos);
      if (input.charCodeAt(peg$currPos) === 62) {
        s3 = peg$c14;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e18); }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f12(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseDQUOTE() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 34) {
      s0 = peg$c15;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e19); }
    }

    return s0;
  }

  function peg$parsebin_val() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = input.charAt(peg$currPos);
    if (s1.toLowerCase() === peg$c16) {
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e20); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = [];
      s4 = peg$parsebinnum();
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 46) {
          s5 = peg$c17;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e21); }
        }
        if (s5 !== peg$FAILED) {
          s5 = peg$parsebinnum();
          if (s5 === peg$FAILED) {
            peg$currPos = s4;
            s4 = peg$FAILED;
          } else {
            s4 = s5;
          }
        } else {
          s4 = s5;
        }
      }
      if (s3.length < 2) {
        peg$currPos = s2;
        s2 = peg$FAILED;
      } else {
        s2 = s3;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f13(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = input.charAt(peg$currPos);
      if (s1.toLowerCase() === peg$c16) {
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e20); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsebinnum();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 45) {
            s3 = peg$c18;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e22); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsebinnum();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f14(s2, s4);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = input.charAt(peg$currPos);
        if (s1.toLowerCase() === peg$c16) {
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e20); }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parsebinnum();
          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f15(s2);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsedec_val() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = input.charAt(peg$currPos);
    if (s1.toLowerCase() === peg$c19) {
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e23); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = [];
      s4 = peg$parsedecnum();
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 46) {
          s5 = peg$c17;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e21); }
        }
        if (s5 !== peg$FAILED) {
          s5 = peg$parsedecnum();
          if (s5 === peg$FAILED) {
            peg$currPos = s4;
            s4 = peg$FAILED;
          } else {
            s4 = s5;
          }
        } else {
          s4 = s5;
        }
      }
      if (s3.length < 2) {
        peg$currPos = s2;
        s2 = peg$FAILED;
      } else {
        s2 = s3;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f16(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = input.charAt(peg$currPos);
      if (s1.toLowerCase() === peg$c19) {
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e23); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsedecnum();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 45) {
            s3 = peg$c18;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e22); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsedecnum();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f17(s2, s4);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = input.charAt(peg$currPos);
        if (s1.toLowerCase() === peg$c19) {
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e23); }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parsedecnum();
          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f18(s2);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsehex_val() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = input.charAt(peg$currPos);
    if (s1.toLowerCase() === peg$c20) {
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e24); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = [];
      s4 = peg$parsehexnum();
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 46) {
          s5 = peg$c17;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e21); }
        }
        if (s5 !== peg$FAILED) {
          s5 = peg$parsehexnum();
          if (s5 === peg$FAILED) {
            peg$currPos = s4;
            s4 = peg$FAILED;
          } else {
            s4 = s5;
          }
        } else {
          s4 = s5;
        }
      }
      if (s3.length < 2) {
        peg$currPos = s2;
        s2 = peg$FAILED;
      } else {
        s2 = s3;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f19(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = input.charAt(peg$currPos);
      if (s1.toLowerCase() === peg$c20) {
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e24); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsehexnum();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 45) {
            s3 = peg$c18;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e22); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsehexnum();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f20(s2, s4);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = input.charAt(peg$currPos);
        if (s1.toLowerCase() === peg$c20) {
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e24); }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parsehexnum();
          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f21(s2);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsebinnum() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = [];
    s3 = peg$parseBIT();
    if (s3 !== peg$FAILED) {
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseBIT();
      }
    } else {
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s1 = input.substring(s1, peg$currPos);
    } else {
      s1 = s2;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f22(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsedecnum() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = [];
    s3 = peg$parseDIGIT();
    if (s3 !== peg$FAILED) {
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseDIGIT();
      }
    } else {
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s1 = input.substring(s1, peg$currPos);
    } else {
      s1 = s2;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f23(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsehexnum() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = [];
    s3 = peg$parseHEXDIG();
    if (s3 !== peg$FAILED) {
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseHEXDIG();
      }
    } else {
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s1 = input.substring(s1, peg$currPos);
    } else {
      s1 = s2;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f24(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsec_wsp() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parsec_nl();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseWSP();
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseWSP();
    }

    return s0;
  }

  function peg$parsec_nl() {
    var s0;

    s0 = peg$parseEOL();
    if (s0 === peg$FAILED) {
      s0 = peg$parsecomment();
    }

    return s0;
  }

  function peg$parseEOL() {
    var s0;

    s0 = peg$parseCRLF();
    if (s0 === peg$FAILED) {
      s0 = peg$parseEOF();
    }

    return s0;
  }

  function peg$parseEOF() {
    var s0, s1;

    s0 = peg$currPos;
    peg$silentFails++;
    if (input.length > peg$currPos) {
      s1 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e25); }
    }
    peg$silentFails--;
    if (s1 === peg$FAILED) {
      s0 = undefined;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseBIT() {
    var s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r4.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e26); }
    }

    return s0;
  }

  function peg$parseHEXDIG() {
    var s0;

    s0 = peg$parseDIGIT();
    if (s0 === peg$FAILED) {
      s0 = input.charAt(peg$currPos);
      if (peg$r5.test(s0)) {
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e27); }
      }
    }

    return s0;
  }

  function peg$parseALPHA() {
    var s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r6.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e28); }
    }

    return s0;
  }

  function peg$parseDIGIT() {
    var s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r7.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e29); }
    }

    return s0;
  }

  function peg$parseWSP() {
    var s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r8.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e30); }
    }

    return s0;
  }

  function peg$parseSP() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 32) {
      s0 = peg$c21;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e31); }
    }

    return s0;
  }

  function peg$parseHTAB() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 9) {
      s0 = peg$c22;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e32); }
    }

    return s0;
  }

  function peg$parseVCHAR() {
    var s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r9.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e33); }
    }

    return s0;
  }

  function peg$parseCRLF() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parseCR();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseLF();
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = input.charAt(peg$currPos);
      if (peg$r10.test(s0)) {
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e34); }
      }
    }

    return s0;
  }

  function peg$parseCR() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 13) {
      s0 = peg$c23;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e35); }
    }

    return s0;
  }

  function peg$parseLF() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 10) {
      s0 = peg$c24;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e36); }
    }

    return s0;
  }


const rules = new ast.Rules();

  peg$result = peg$startRuleFunction();

  if (options.peg$library) {
    return /** @type {any} */ ({
      peg$result,
      peg$currPos,
      peg$FAILED,
      peg$maxFailExpected,
      peg$maxFailPos
    });
  }
  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(
      peg$maxFailExpected,
      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
      peg$maxFailPos < input.length
        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
    );
  }
}

const peg$allowedStartRules = [
  "rulelist"
];

export {
  peg$allowedStartRules as StartRules,
  peg$SyntaxError as SyntaxError,
  peg$parse as parse
};
