/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.util.BufferUtil;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public final class StringIO {
    private final Charset charset;

    public static StringIO getStringIO() {
        return StaticDataHolder.INSTANCE;
    }

    public static StringIO getStringIO(Charset charset) {
        return new StringIO(charset);
    }

    private StringIO(Charset charset) {
        this.charset = charset;
    }

    private static CharsetEncoder getEncoder(Charset charset) {
        CharsetEncoder encoder;
        SoftReference<CharsetEncoder> ref = StaticDataHolder.ENCODER.get();
        if (ref != null && (encoder = ref.get()) != null && encoder.charset() == charset) {
            return encoder;
        }
        return StringIO.initEncoder(charset);
    }

    private static CharsetDecoder getDecoder(Charset charset) {
        CharsetDecoder decoder;
        SoftReference<CharsetDecoder> ref = StaticDataHolder.DECODER.get();
        if (ref != null && (decoder = ref.get()) != null && decoder.charset() == charset) {
            return decoder;
        }
        return StringIO.initDecoder(charset);
    }

    private static CharsetEncoder initEncoder(Charset charset) {
        CharsetEncoder encoder = charset.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        StaticDataHolder.ENCODER.set(new SoftReference<CharsetEncoder>(encoder));
        return encoder;
    }

    private static CharsetDecoder initDecoder(Charset charset) {
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        StaticDataHolder.DECODER.set(new SoftReference<CharsetDecoder>(decoder));
        return decoder;
    }

    public final ByteBuffer toNative(CharSequence value, int minSize, boolean copyIn) {
        return StringIO.toNative(StringIO.getEncoder(this.charset), value, minSize, copyIn);
    }

    public final ByteBuffer toNative(CharSequence value, ByteBuffer buf) {
        return StringIO.toNative(StringIO.getEncoder(this.charset), value, buf);
    }

    private static ByteBuffer toNative(CharsetEncoder encoder, CharSequence value, int minSize, boolean copyIn) {
        int len = (int)(((float)Math.max(minSize, value.length()) + 1.0f) * encoder.maxBytesPerChar());
        ByteBuffer buf = ByteBuffer.allocate(len);
        if (copyIn) {
            StringIO.toNative(encoder, value, buf);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer toNative(CharsetEncoder encoder, CharSequence value, ByteBuffer buf) {
        buf.mark();
        try {
            encoder.reset();
            encoder.encode(CharBuffer.wrap(value), buf, true);
            encoder.flush(buf);
            StringIO.nulTerminate(encoder, buf);
        }
        finally {
            buf.reset();
        }
        return buf;
    }

    public final CharSequence fromNative(ByteBuffer buf, int maxSize) {
        int end = BufferUtil.positionOf(buf, (byte)0);
        if (end < 0 || end > maxSize) {
            end = maxSize;
        }
        int limit = buf.limit();
        buf.limit(end);
        try {
            CharBuffer charBuffer = StringIO.getDecoder(this.charset).reset().decode(buf);
            return charBuffer;
        }
        catch (CharacterCodingException ex) {
            throw new Error("Illegal character data in native string", ex);
        }
        finally {
            buf.limit(limit);
        }
    }

    public final CharSequence fromNative(ByteBuffer buf) {
        try {
            return StringIO.getDecoder(this.charset).reset().decode(buf);
        }
        catch (CharacterCodingException ex) {
            throw new Error("Illegal character data in native string", ex);
        }
    }

    public final void nulTerminate(ByteBuffer buf) {
        StringIO.nulTerminate(StringIO.getEncoder(this.charset), buf);
    }

    private static void nulTerminate(CharsetEncoder encoder, ByteBuffer buf) {
        int nulSize;
        for (nulSize = Math.round(encoder.maxBytesPerChar()); nulSize >= 4; nulSize -= 4) {
            buf.putInt(0);
        }
        if (nulSize >= 2) {
            buf.putShort((short)0);
            nulSize -= 2;
        }
        if (nulSize >= 1) {
            buf.put((byte)0);
        }
    }

    private static final class StaticDataHolder {
        static final StringIO INSTANCE = new StringIO(Charset.defaultCharset());
        static final ThreadLocal<SoftReference<CharsetEncoder>> ENCODER = new ThreadLocal();
        static final ThreadLocal<SoftReference<CharsetDecoder>> DECODER = new ThreadLocal();

        private StaticDataHolder() {
        }
    }
}

