# CDN

Recommended: [unpkg](//unpkg.com), which will reflect the latest version as soon as it is published to npm. You can also browse the source of the npm package at [unpkg.com/docsify/](//unpkg.com/docsify/).

## Latest version

```html
<!-- load css -->
<link rel="stylesheet" href="//unpkg.com/docsify/themes/vue.css">

<!-- load script -->
<script src="//unpkg.com/docsify/lib/docsify.js"></script>
```

Alternatively, use [compressed files](#compressed-files).

## Specific version

```html
<!-- load css -->
<link rel="stylesheet" href="//unpkg.com/docsify@2.0.0/themes/vue.css">

<!-- load script -->
<script src="//unpkg.com/docsify@2.0.0/lib/docsify.js"></script>
```

## Compressed file

```html
<!-- load css -->
<link rel="stylesheet" href="//unpkg.com/docsify/lib/themes/vue.css">

<!-- load script -->
<script src="//unpkg.com/docsify/lib/docsify.min.js"></script>
```

```html
<!-- load css -->
<link rel="stylesheet" href="//unpkg.com/docsify@2.0.0/lib/themes/vue.css">

<!-- load script -->
<script src="//unpkg.com/docsify@2.0.0/lib/docsify.min.js"></script>
```

## Other CDN

- http://www.bootcdn.cn/docsify
- https://cdn.jsdelivr.net/npm/docsify/
- https://cdnjs.com/libraries/docsify

