/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.jar;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.BufferedInputStream;
import sandbox.java.io.ByteArrayInputStream;
import sandbox.java.io.ByteArrayOutputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.util.jar.JarEntry;
import sandbox.java.util.jar.JarVerifier;
import sandbox.java.util.jar.Manifest;
import sandbox.java.util.zip.ZipEntry;
import sandbox.java.util.zip.ZipInputStream;
import sandbox.sun.security.util.ManifestEntryVerifier;

public class JarInputStream
extends ZipInputStream {
    private Manifest man;
    private JarEntry first;
    private JarVerifier jv;
    private ManifestEntryVerifier mev;
    private final boolean doVerify;
    private boolean tryManifest;

    public JarInputStream(InputStream inputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarInputStream.<init>:(Ljava/io/InputStream;Z)V");
        this(inputStream, true);
    }

    public JarInputStream(InputStream inputStream, boolean bl) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.<init>:(Ljava/io/InputStream;)V");
        super(inputStream);
        this.doVerify = bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.getNextEntry:()Ljava/util/zip/ZipEntry;");
        JarEntry jarEntry = (JarEntry)super.getNextEntry();
        RuntimeCostAccounter.recordJump();
        if (jarEntry != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.getName:()Ljava/lang/String;");
            String string = jarEntry.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equalsIgnoreCase:(Ljava/lang/String;)Z");
            boolean bl2 = string.equalsIgnoreCase("META-INF/");
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.getNextEntry:()Ljava/util/zip/ZipEntry;");
                jarEntry = (JarEntry)super.getNextEntry();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarInputStream.checkManifest:(Ljava/util/jar/JarEntry;)Ljava/util/jar/JarEntry;");
        this.first = this.checkManifest(jarEntry);
    }

    private JarEntry checkManifest(JarEntry jarEntry) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (jarEntry != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.getName:()Ljava/lang/String;");
            String string = jarEntry.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equalsIgnoreCase:(Ljava/lang/String;)Z");
            boolean bl = "META-INF/MANIFEST.MF".equalsIgnoreCase(string);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/jar/Manifest");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.<init>:()V");
                this.man = new Manifest();
                RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedInputStream");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.<init>:(Ljava/io/InputStream;)V");
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarInputStream.getBytes:(Ljava/io/InputStream;)[B");
                byte[] byArray = this.getBytes(bufferedInputStream);
                RuntimeCostAccounter.recordAllocation((String)"java/io/ByteArrayInputStream");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayInputStream.<init>:([B)V");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.read:(Ljava/io/InputStream;)V");
                this.man.read(byteArrayInputStream);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarInputStream.closeEntry:()V");
                this.closeEntry();
                RuntimeCostAccounter.recordJump();
                if (this.doVerify) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarVerifier");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.<init>:([B)V");
                    this.jv = new JarVerifier(byArray);
                    RuntimeCostAccounter.recordAllocation((String)"sun/security/util/ManifestEntryVerifier");
                    RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.<init>:(Ljava/util/jar/Manifest;)V");
                    this.mev = new ManifestEntryVerifier(this.man);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.getNextEntry:()Ljava/util/zip/ZipEntry;");
                return (JarEntry)super.getNextEntry();
            }
        }
        return jarEntry;
    }

    private byte[] getBytes(InputStream inputStream) throws IOException {
        RuntimeCostAccounter.recordArrayAllocation((int)8192, (int)1);
        byte[] byArray = new byte[8192];
        RuntimeCostAccounter.recordAllocation((String)"java/io/ByteArrayOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.<init>:(I)V");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while (true) {
            int n = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
            int n2 = inputStream.read(byArray, 0, n);
            RuntimeCostAccounter.recordJump();
            if (n2 == -1) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.write:([BII)V");
            byteArrayOutputStream.write(byArray, 0, n2);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.toByteArray:()[B");
        return byteArrayOutputStream.toByteArray();
    }

    public Manifest getManifest() {
        return this.man;
    }

    @Override
    public ZipEntry getNextEntry() throws IOException {
        JarEntry jarEntry;
        RuntimeCostAccounter.recordJump();
        if (this.first == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.getNextEntry:()Ljava/util/zip/ZipEntry;");
            jarEntry = (JarEntry)super.getNextEntry();
            RuntimeCostAccounter.recordJump();
            if (this.tryManifest) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarInputStream.checkManifest:(Ljava/util/jar/JarEntry;)Ljava/util/jar/JarEntry;");
                jarEntry = this.checkManifest(jarEntry);
                this.tryManifest = false;
                RuntimeCostAccounter.recordJump();
            }
        } else {
            jarEntry = this.first;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.getName:()Ljava/lang/String;");
            String string = this.first.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equalsIgnoreCase:(Ljava/lang/String;)Z");
            boolean bl = string.equalsIgnoreCase("META-INF/INDEX.LIST");
            RuntimeCostAccounter.recordJump();
            if (bl) {
                this.tryManifest = true;
            }
            this.first = null;
        }
        RuntimeCostAccounter.recordJump();
        if (this.jv != null) {
            RuntimeCostAccounter.recordJump();
            if (jarEntry != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.nothingToVerify:()Z");
                boolean bl = this.jv.nothingToVerify();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    this.jv = null;
                    this.mev = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.beginEntry:(Ljava/util/jar/JarEntry;Lsun/security/util/ManifestEntryVerifier;)V");
                    this.jv.beginEntry(jarEntry, this.mev);
                }
            }
        }
        return jarEntry;
    }

    public JarEntry getNextJarEntry() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarInputStream.getNextEntry:()Ljava/util/zip/ZipEntry;");
        return (JarEntry)this.getNextEntry();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        RuntimeCostAccounter.recordJump();
        if (this.first == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipInputStream.read:([BII)I");
            n3 = super.read(byArray, n, n2);
            RuntimeCostAccounter.recordJump();
        } else {
            n3 = -1;
        }
        RuntimeCostAccounter.recordJump();
        if (this.jv != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.update:(I[BIILsun/security/util/ManifestEntryVerifier;)V");
            this.jv.update(n3, byArray, n, n2, this.mev);
        }
        return n3;
    }

    @Override
    protected ZipEntry createZipEntry(String string) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarEntry");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.<init>:(Ljava/lang/String;)V");
        JarEntry jarEntry = new JarEntry(string);
        RuntimeCostAccounter.recordJump();
        if (this.man != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.getAttributes:(Ljava/lang/String;)Ljava/util/jar/Attributes;");
            jarEntry.attr = this.man.getAttributes(string);
        }
        return jarEntry;
    }
}

