/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.concurrent.util;

import co.paralleluniverse.concurrent.util.OwnedSynchronizer;
import co.paralleluniverse.concurrent.util.OwnedSynchronizer2;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class SingleConsumerNonblockingProducerQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    final Queue<E> q;
    final OwnedSynchronizer sync = new OwnedSynchronizer2();

    public SingleConsumerNonblockingProducerQueue(Queue<E> q) {
        this.q = q;
    }

    @Override
    public boolean offer(E e) {
        boolean res = this.q.offer(e);
        if (this.sync.shouldSignal() && this.q.peek() == e) {
            this.sync.signal();
        }
        return res;
    }

    @Override
    public E take() throws InterruptedException {
        E e = this.q.poll();
        if (e == null) {
            this.sync.register();
            try {
                e = this.q.poll();
                while (e == null) {
                    this.sync.await();
                    e = this.q.poll();
                }
            }
            finally {
                this.sync.unregister();
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E e = this.q.poll();
        if (e == null) {
            long left = unit.toNanos(timeout);
            this.sync.register();
            try {
                e = this.q.poll();
                while (e == null) {
                    if ((left = this.sync.awaitNanos(left)) < 0L) {
                        E e2 = null;
                        return e2;
                    }
                    e = this.q.poll();
                }
            }
            finally {
                this.sync.unregister();
            }
        }
        return e;
    }

    @Override
    public void put(E e) {
        this.add(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    @Override
    public E poll() {
        return this.q.poll();
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        int count = 0;
        E e = this.q.poll();
        while (e != null) {
            c.add(e);
            ++count;
            e = this.q.poll();
        }
        return count;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int count = 0;
        Object e = null;
        if (count < maxElements) {
            e = this.q.poll();
        }
        while (e != null && count < maxElements) {
            c.add(e);
            if (++count >= maxElements) continue;
            e = this.q.poll();
        }
        return count;
    }

    @Override
    public E peek() {
        return this.q.peek();
    }

    @Override
    public String toString() {
        return this.q.toString();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.q.toArray(a);
    }

    @Override
    public Iterator<E> iterator() {
        return this.q.iterator();
    }

    @Override
    public int size() {
        return this.q.size();
    }

    @Override
    public Object[] toArray() {
        return this.q.toArray();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.q.retainAll(c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.q.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.q.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.q.removeAll(c);
    }

    @Override
    public boolean remove(Object o) {
        return this.q.remove(o);
    }

    @Override
    public boolean isEmpty() {
        return this.q.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.q.contains(o);
    }

    @Override
    public void clear() {
        this.q.clear();
    }
}

