/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.zone;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Duration;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDateTime;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.zone.Ser;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collections;
import sandbox.java.util.List;
import sandbox.java.util.Objects;

public final class ZoneOffsetTransition
implements Comparable<ZoneOffsetTransition>,
Serializable {
    private static final long serialVersionUID = -6946044323557704546L;
    private final LocalDateTime transition;
    private final ZoneOffset offsetBefore;
    private final ZoneOffset offsetAfter;

    public static ZoneOffsetTransition of(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneOffset zoneOffset2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(localDateTime, "transition");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneOffset, "offsetBefore");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneOffset2, "offsetAfter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl = zoneOffset.equals(zoneOffset2);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Offsets must not be equal");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getNano:()I");
        int n = localDateTime.getNano();
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Nano-of-second must be zero");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransition");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneOffset;)V");
        return new ZoneOffsetTransition(localDateTime, zoneOffset, zoneOffset2);
    }

    ZoneOffsetTransition(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneOffset zoneOffset2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.transition = localDateTime;
        this.offsetBefore = zoneOffset;
        this.offsetAfter = zoneOffset2;
    }

    ZoneOffsetTransition(long l, ZoneOffset zoneOffset, ZoneOffset zoneOffset2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.ofEpochSecond:(JILjava/time/ZoneOffset;)Ljava/time/LocalDateTime;");
        this.transition = LocalDateTime.ofEpochSecond(l, 0, zoneOffset);
        this.offsetBefore = zoneOffset;
        this.offsetAfter = zoneOffset2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(2, this);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.toEpochSecond:()J");
        long l = this.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.writeEpochSec:(JLjava/io/DataOutput;)V");
        Ser.writeEpochSec(l, dataOutput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.writeOffset:(Ljava/time/ZoneOffset;Ljava/io/DataOutput;)V");
        Ser.writeOffset(this.offsetBefore, dataOutput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.writeOffset:(Ljava/time/ZoneOffset;Ljava/io/DataOutput;)V");
        Ser.writeOffset(this.offsetAfter, dataOutput);
    }

    static ZoneOffsetTransition readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.readEpochSec:(Ljava/io/DataInput;)J");
        long l = Ser.readEpochSec(dataInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.readOffset:(Ljava/io/DataInput;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = Ser.readOffset(dataInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.readOffset:(Ljava/io/DataInput;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset2 = Ser.readOffset(dataInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl = zoneOffset.equals(zoneOffset2);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Offsets must not be equal");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransition");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.<init>:(JLjava/time/ZoneOffset;Ljava/time/ZoneOffset;)V");
        return new ZoneOffsetTransition(l, zoneOffset, zoneOffset2);
    }

    public Instant getInstant() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toInstant:(Ljava/time/ZoneOffset;)Ljava/time/Instant;");
        return this.transition.toInstant(this.offsetBefore);
    }

    public long toEpochSecond() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toEpochSecond:(Ljava/time/ZoneOffset;)J");
        return this.transition.toEpochSecond(this.offsetBefore);
    }

    public LocalDateTime getDateTimeBefore() {
        return this.transition;
    }

    public LocalDateTime getDateTimeAfter() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDurationSeconds:()I");
        long l = this.getDurationSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusSeconds:(J)Ljava/time/LocalDateTime;");
        return this.transition.plusSeconds(l);
    }

    public ZoneOffset getOffsetBefore() {
        return this.offsetBefore;
    }

    public ZoneOffset getOffsetAfter() {
        return this.offsetAfter;
    }

    public Duration getDuration() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDurationSeconds:()I");
        long l = this.getDurationSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.ofSeconds:(J)Ljava/time/Duration;");
        return Duration.ofSeconds(l);
    }

    private int getDurationSeconds() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetAfter:()Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = this.getOffsetAfter();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        int n = zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetBefore:()Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset2 = this.getOffsetBefore();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        return n - zoneOffset2.getTotalSeconds();
    }

    public boolean isGap() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetAfter:()Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = this.getOffsetAfter();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        int n = zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetBefore:()Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset2 = this.getOffsetBefore();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        int n2 = zoneOffset2.getTotalSeconds();
        RuntimeCostAccounter.recordJump();
        if (n > n2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isOverlap() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetAfter:()Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = this.getOffsetAfter();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        int n = zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetBefore:()Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset2 = this.getOffsetBefore();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        int n2 = zoneOffset2.getTotalSeconds();
        RuntimeCostAccounter.recordJump();
        if (n < n2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidOffset(ZoneOffset zoneOffset) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.isGap:()Z");
        boolean bl2 = this.isGap();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            bl = false;
            RuntimeCostAccounter.recordJump();
            return bl;
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetBefore:()Ljava/time/ZoneOffset;");
            ZoneOffset zoneOffset2 = this.getOffsetBefore();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
            boolean bl3 = zoneOffset2.equals(zoneOffset);
            RuntimeCostAccounter.recordJump();
            if (!bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetAfter:()Ljava/time/ZoneOffset;");
                ZoneOffset zoneOffset3 = this.getOffsetAfter();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
                boolean bl4 = zoneOffset3.equals(zoneOffset);
                RuntimeCostAccounter.recordJump();
                if (!bl4) return false;
            }
            bl = true;
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    List<ZoneOffset> getValidOffsets() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.isGap:()Z");
        boolean bl = this.isGap();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptyList:()Ljava/util/List;");
            return Collections.emptyList();
        }
        RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
        ZoneOffset[] zoneOffsetArray = new ZoneOffset[2];
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetBefore:()Ljava/time/ZoneOffset;");
        zoneOffsetArray[0] = this.getOffsetBefore();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetAfter:()Ljava/time/ZoneOffset;");
        zoneOffsetArray[1] = this.getOffsetAfter();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
        return Arrays.asList(zoneOffsetArray);
    }

    @Override
    public int compareTo(ZoneOffsetTransition zoneOffsetTransition) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getInstant:()Ljava/time/Instant;");
        Instant instant = this.getInstant();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getInstant:()Ljava/time/Instant;");
        Instant instant2 = zoneOffsetTransition.getInstant();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.compareTo:(Ljava/time/Instant;)I");
        return instant.compareTo(instant2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == this) {
            return true;
        }
        boolean bl = object instanceof ZoneOffsetTransition;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        ZoneOffsetTransition zoneOffsetTransition = (ZoneOffsetTransition)object;
        LocalDateTime localDateTime = zoneOffsetTransition.transition;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = this.transition.equals(localDateTime);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        ZoneOffset zoneOffset = zoneOffsetTransition.offsetBefore;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl3 = this.offsetBefore.equals(zoneOffset);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        ZoneOffset zoneOffset2 = zoneOffsetTransition.offsetAfter;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl4 = this.offsetAfter.equals(zoneOffset2);
        RuntimeCostAccounter.recordJump();
        if (!bl4) return false;
        boolean bl5 = true;
        RuntimeCostAccounter.recordJump();
        return bl5;
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.hashCode:()I");
        int n = this.transition.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.hashCode:()I");
        int n2 = n ^ this.offsetBefore.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.hashCode:()I");
        int n3 = this.offsetAfter.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.rotateLeft:(II)I");
        return n2 ^ Integer.rotateLeft(n3, 16);
    }

    public String toString() {
        String string;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Transition[");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.isGap:()Z");
        boolean bl = this.isGap();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            string = "Gap";
            RuntimeCostAccounter.recordJump();
        } else {
            string = "Overlap";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(" at ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(this.transition);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(this.offsetBefore);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append(" to ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(this.offsetAfter);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        stringBuilder8.append(']');
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }
}

