/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.text;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.math.BigInteger;
import sandbox.java.math.RoundingMode;
import sandbox.java.text.DontCareFieldPosition;
import sandbox.java.text.FieldPosition;
import sandbox.java.text.Format;
import sandbox.java.text.ParseException;
import sandbox.java.text.ParsePosition;
import sandbox.java.text.spi.NumberFormatProvider;
import sandbox.java.util.Currency;
import sandbox.java.util.HashMap;
import sandbox.java.util.Locale;
import sandbox.java.util.Map;
import sandbox.java.util.concurrent.atomic.AtomicInteger;
import sandbox.java.util.concurrent.atomic.AtomicLong;
import sandbox.sun.util.locale.provider.LocaleProviderAdapter;
import sandbox.sun.util.locale.provider.LocaleServiceProviderPool;

public abstract class NumberFormat
extends Format {
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    private static final int NUMBERSTYLE = 0;
    private static final int CURRENCYSTYLE = 1;
    private static final int PERCENTSTYLE = 2;
    private static final int SCIENTIFICSTYLE = 3;
    private static final int INTEGERSTYLE = 4;
    private boolean groupingUsed;
    private byte maxIntegerDigits;
    private byte minIntegerDigits;
    private byte maxFractionDigits;
    private byte minFractionDigits;
    private boolean parseIntegerOnly;
    private int maximumIntegerDigits;
    private int minimumIntegerDigits;
    private int maximumFractionDigits;
    private int minimumFractionDigits;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream;
    static final long serialVersionUID = -2308460125733713944L;

    protected NumberFormat() {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/Format.<init>:()V");
        this.groupingUsed = true;
        this.maxIntegerDigits = (byte)40;
        this.minIntegerDigits = 1;
        this.maxFractionDigits = (byte)3;
        this.minFractionDigits = 0;
        this.parseIntegerOnly = false;
        this.maximumIntegerDigits = 40;
        this.minimumIntegerDigits = 1;
        this.maximumFractionDigits = 3;
        this.minimumFractionDigits = 0;
        this.serialVersionOnStream = 1;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        block5: {
            block4: {
                boolean bl = object instanceof Long;
                RuntimeCostAccounter.recordJump();
                if (bl) break block4;
                boolean bl2 = object instanceof Integer;
                RuntimeCostAccounter.recordJump();
                if (bl2) break block4;
                boolean bl3 = object instanceof Short;
                RuntimeCostAccounter.recordJump();
                if (bl3) break block4;
                boolean bl4 = object instanceof Byte;
                RuntimeCostAccounter.recordJump();
                if (bl4) break block4;
                boolean bl5 = object instanceof AtomicInteger;
                RuntimeCostAccounter.recordJump();
                if (bl5) break block4;
                boolean bl6 = object instanceof AtomicLong;
                RuntimeCostAccounter.recordJump();
                if (bl6) break block4;
                boolean bl7 = object instanceof BigInteger;
                RuntimeCostAccounter.recordJump();
                if (!bl7) break block5;
                BigInteger bigInteger = (BigInteger)object;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
                int n = bigInteger.bitLength();
                RuntimeCostAccounter.recordJump();
                if (n >= 64) break block5;
            }
            Number number = (Number)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.longValue:()J");
            long l = number.longValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.format:(JLjava/lang/StringBuffer;Ljava/text/FieldPosition;)Ljava/lang/StringBuffer;");
            return this.format(l, stringBuffer, fieldPosition);
        }
        boolean bl = object instanceof Number;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            Number number = (Number)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.doubleValue:()D");
            double d = number.doubleValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.format:(DLjava/lang/StringBuffer;Ljava/text/FieldPosition;)Ljava/lang/StringBuffer;");
            return this.format(d, stringBuffer, fieldPosition);
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot format given Object as a Number");
        RuntimeCostAccounter.recordThrow();
        throw illegalArgumentException;
    }

    @Override
    public final Object parseObject(String string, ParsePosition parsePosition) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.parse:(Ljava/lang/String;Ljava/text/ParsePosition;)Ljava/lang/Number;");
        return this.parse(string, parsePosition);
    }

    public final String format(double d) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.fastFormat:(D)Ljava/lang/String;");
        String string = this.fastFormat(d);
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            return string;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:()V");
        StringBuffer stringBuffer = new StringBuffer();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.format:(DLjava/lang/StringBuffer;Ljava/text/FieldPosition;)Ljava/lang/StringBuffer;");
        StringBuffer stringBuffer2 = this.format(d, stringBuffer, DontCareFieldPosition.INSTANCE);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
        return stringBuffer2.toString();
    }

    String fastFormat(double d) {
        return null;
    }

    public final String format(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:()V");
        StringBuffer stringBuffer = new StringBuffer();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.format:(JLjava/lang/StringBuffer;Ljava/text/FieldPosition;)Ljava/lang/StringBuffer;");
        StringBuffer stringBuffer2 = this.format(l, stringBuffer, DontCareFieldPosition.INSTANCE);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
        return stringBuffer2.toString();
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public abstract Number parse(String var1, ParsePosition var2);

    public Number parse(String string) throws ParseException {
        RuntimeCostAccounter.recordAllocation((String)"java/text/ParsePosition");
        RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.<init>:(I)V");
        ParsePosition parsePosition = new ParsePosition(0);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.parse:(Ljava/lang/String;Ljava/text/ParsePosition;)Ljava/lang/Number;");
        Number number = this.parse(string, parsePosition);
        int n = parsePosition.index;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/text/ParseException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unparseable number: \"");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append("\"");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder4.toString();
            int n2 = parsePosition.errorIndex;
            RuntimeCostAccounter.recordMethodCall((String)"java/text/ParseException.<init>:(Ljava/lang/String;I)V");
            ParseException parseException = new ParseException(string2, n2);
            RuntimeCostAccounter.recordThrow();
            throw parseException;
        }
        return number;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public void setParseIntegerOnly(boolean bl) {
        this.parseIntegerOnly = bl;
    }

    public static final NumberFormat getInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        return NumberFormat.getInstance(locale, 0);
    }

    public static NumberFormat getInstance(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        return NumberFormat.getInstance(locale, 0);
    }

    public static final NumberFormat getNumberInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        return NumberFormat.getInstance(locale, 0);
    }

    public static NumberFormat getNumberInstance(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        return NumberFormat.getInstance(locale, 0);
    }

    public static final NumberFormat getIntegerInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        return NumberFormat.getInstance(locale, 4);
    }

    public static NumberFormat getIntegerInstance(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        return NumberFormat.getInstance(locale, 4);
    }

    public static final NumberFormat getCurrencyInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        return NumberFormat.getInstance(locale, 1);
    }

    public static NumberFormat getCurrencyInstance(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        return NumberFormat.getInstance(locale, 1);
    }

    public static final NumberFormat getPercentInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        return NumberFormat.getInstance(locale, 2);
    }

    public static NumberFormat getPercentInstance(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        return NumberFormat.getInstance(locale, 2);
    }

    static final NumberFormat getScientificInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        return NumberFormat.getInstance(locale, 3);
    }

    static NumberFormat getScientificInstance(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        return NumberFormat.getInstance(locale, 3);
    }

    public static Locale[] getAvailableLocales() {
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleServiceProviderPool.getPool:(Ljava/lang/Class;)Lsun/util/locale/provider/LocaleServiceProviderPool;");
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(NumberFormatProvider.class);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleServiceProviderPool.getAvailableLocales:()[Ljava/util/Locale;");
        return localeServiceProviderPool.getAvailableLocales();
    }

    public int hashCode() {
        return this.maximumIntegerDigits * 37 + this.maxFractionDigits;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            return false;
        }
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz2 = object.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz != clazz2) {
            return false;
        }
        NumberFormat numberFormat = (NumberFormat)object;
        int n = numberFormat.maximumIntegerDigits;
        RuntimeCostAccounter.recordJump();
        if (this.maximumIntegerDigits != n) return false;
        int n2 = numberFormat.minimumIntegerDigits;
        RuntimeCostAccounter.recordJump();
        if (this.minimumIntegerDigits != n2) return false;
        int n3 = numberFormat.maximumFractionDigits;
        RuntimeCostAccounter.recordJump();
        if (this.maximumFractionDigits != n3) return false;
        int n4 = numberFormat.minimumFractionDigits;
        RuntimeCostAccounter.recordJump();
        if (this.minimumFractionDigits != n4) return false;
        boolean bl = numberFormat.groupingUsed;
        RuntimeCostAccounter.recordJump();
        if (this.groupingUsed != bl) return false;
        boolean bl2 = numberFormat.parseIntegerOnly;
        RuntimeCostAccounter.recordJump();
        if (this.parseIntegerOnly != bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    @Override
    public Object clone() {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/Format.clone:()Ljava/lang/Object;");
        NumberFormat numberFormat = (NumberFormat)super.clone();
        return numberFormat;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public void setGroupingUsed(boolean bl) {
        this.groupingUsed = bl;
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    public void setMaximumIntegerDigits(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        this.maximumIntegerDigits = Math.max(0, n);
        RuntimeCostAccounter.recordJump();
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.minimumIntegerDigits = this.maximumIntegerDigits;
        }
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    public void setMinimumIntegerDigits(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        this.minimumIntegerDigits = Math.max(0, n);
        RuntimeCostAccounter.recordJump();
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.maximumIntegerDigits = this.minimumIntegerDigits;
        }
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public void setMaximumFractionDigits(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        this.maximumFractionDigits = Math.max(0, n);
        RuntimeCostAccounter.recordJump();
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.minimumFractionDigits = this.maximumFractionDigits;
        }
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public void setMinimumFractionDigits(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        this.minimumFractionDigits = Math.max(0, n);
        RuntimeCostAccounter.recordJump();
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.maximumFractionDigits = this.minimumFractionDigits;
        }
    }

    public Currency getCurrency() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    public void setCurrency(Currency currency) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    public RoundingMode getRoundingMode() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    private static NumberFormat getInstance(Locale locale, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getAdapter:(Ljava/lang/Class;Ljava/util/Locale;)Lsun/util/locale/provider/LocaleProviderAdapter;");
        LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(NumberFormatProvider.class, (Locale)locale);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Lsun/util/locale/provider/LocaleProviderAdapter;Ljava/util/Locale;I)Ljava/text/NumberFormat;");
        NumberFormat numberFormat = NumberFormat.getInstance(localeProviderAdapter, locale, n);
        RuntimeCostAccounter.recordJump();
        if (numberFormat == null) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.forJRE:()Lsun/util/locale/provider/LocaleProviderAdapter;");
            LocaleProviderAdapter localeProviderAdapter2 = LocaleProviderAdapter.forJRE();
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.getInstance:(Lsun/util/locale/provider/LocaleProviderAdapter;Ljava/util/Locale;I)Ljava/text/NumberFormat;");
            numberFormat = NumberFormat.getInstance(localeProviderAdapter2, locale, n);
        }
        return numberFormat;
    }

    private static NumberFormat getInstance(LocaleProviderAdapter localeProviderAdapter, Locale locale, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getNumberFormatProvider:()Ljava/text/spi/NumberFormatProvider;");
        NumberFormatProvider numberFormatProvider = localeProviderAdapter.getNumberFormatProvider();
        NumberFormat numberFormat = null;
        switch (n) {
            case 0: {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/NumberFormatProvider.getNumberInstance:(Ljava/util/Locale;)Ljava/text/NumberFormat;");
                numberFormat = numberFormatProvider.getNumberInstance(locale);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/NumberFormatProvider.getPercentInstance:(Ljava/util/Locale;)Ljava/text/NumberFormat;");
                numberFormat = numberFormatProvider.getPercentInstance(locale);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 1: {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/NumberFormatProvider.getCurrencyInstance:(Ljava/util/Locale;)Ljava/text/NumberFormat;");
                numberFormat = numberFormatProvider.getCurrencyInstance(locale);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 4: {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/NumberFormatProvider.getIntegerInstance:(Ljava/util/Locale;)Ljava/text/NumberFormat;");
                numberFormat = numberFormatProvider.getIntegerInstance(locale);
            }
        }
        return numberFormat;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block5: {
            block4: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
                objectInputStream.defaultReadObject();
                RuntimeCostAccounter.recordJump();
                if (this.serialVersionOnStream < 1) {
                    this.maximumIntegerDigits = this.maxIntegerDigits;
                    this.minimumIntegerDigits = this.minIntegerDigits;
                    this.maximumFractionDigits = this.maxFractionDigits;
                    this.minimumFractionDigits = this.minFractionDigits;
                }
                RuntimeCostAccounter.recordJump();
                if (this.minimumIntegerDigits > this.maximumIntegerDigits) break block4;
                RuntimeCostAccounter.recordJump();
                if (this.minimumFractionDigits > this.maximumFractionDigits) break block4;
                RuntimeCostAccounter.recordJump();
                if (this.minimumIntegerDigits < 0) break block4;
                RuntimeCostAccounter.recordJump();
                if (this.minimumFractionDigits >= 0) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
            InvalidObjectException invalidObjectException = new InvalidObjectException("Digit count range invalid");
            RuntimeCostAccounter.recordThrow();
            throw invalidObjectException;
        }
        this.serialVersionOnStream = 1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        RuntimeCostAccounter.recordJump();
        if (this.maximumIntegerDigits > 127) {
            by4 = 127;
            RuntimeCostAccounter.recordJump();
        } else {
            by4 = (byte)this.maximumIntegerDigits;
        }
        this.maxIntegerDigits = by4;
        RuntimeCostAccounter.recordJump();
        if (this.minimumIntegerDigits > 127) {
            by3 = 127;
            RuntimeCostAccounter.recordJump();
        } else {
            by3 = (byte)this.minimumIntegerDigits;
        }
        this.minIntegerDigits = by3;
        RuntimeCostAccounter.recordJump();
        if (this.maximumFractionDigits > 127) {
            by2 = 127;
            RuntimeCostAccounter.recordJump();
        } else {
            by2 = (byte)this.maximumFractionDigits;
        }
        this.maxFractionDigits = by2;
        RuntimeCostAccounter.recordJump();
        if (this.minimumFractionDigits > 127) {
            by = 127;
            RuntimeCostAccounter.recordJump();
        } else {
            by = (byte)this.minimumFractionDigits;
        }
        this.minFractionDigits = by;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
        objectOutputStream.defaultWriteObject();
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = 7494728892700160890L;
        private static final Map<String, Field> instanceMap;
        public static final Field INTEGER;
        public static final Field FRACTION;
        public static final Field EXPONENT;
        public static final Field DECIMAL_SEPARATOR;
        public static final Field SIGN;
        public static final Field GROUPING_SEPARATOR;
        public static final Field EXPONENT_SYMBOL;
        public static final Field PERCENT;
        public static final Field PERMILLE;
        public static final Field CURRENCY;
        public static final Field EXPONENT_SIGN;

        protected Field(String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/text/Format$Field.<init>:(Ljava/lang/String;)V");
            super(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = this.getClass();
            RuntimeCostAccounter.recordJump();
            if (clazz == Field.class) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                instanceMap.put(string, this);
            }
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = this.getClass();
            RuntimeCostAccounter.recordJump();
            if (clazz != Field.class) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
                InvalidObjectException invalidObjectException = new InvalidObjectException("subclass didn't correctly implement readResolve");
                RuntimeCostAccounter.recordThrow();
                throw invalidObjectException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat$Field.getName:()Ljava/lang/String;");
            String string = this.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            Field field = instanceMap.get(string);
            RuntimeCostAccounter.recordJump();
            if (field != null) {
                return field;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
            InvalidObjectException invalidObjectException = new InvalidObjectException("unknown attribute name");
            RuntimeCostAccounter.recordThrow();
            throw invalidObjectException;
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:(I)V");
            instanceMap = new HashMap<String, Field>(11);
            RuntimeCostAccounter.recordAllocation((String)"java/text/NumberFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat$Field.<init>:(Ljava/lang/String;)V");
            INTEGER = new Field("integer");
            RuntimeCostAccounter.recordAllocation((String)"java/text/NumberFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat$Field.<init>:(Ljava/lang/String;)V");
            FRACTION = new Field("fraction");
            RuntimeCostAccounter.recordAllocation((String)"java/text/NumberFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat$Field.<init>:(Ljava/lang/String;)V");
            EXPONENT = new Field("exponent");
            RuntimeCostAccounter.recordAllocation((String)"java/text/NumberFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat$Field.<init>:(Ljava/lang/String;)V");
            DECIMAL_SEPARATOR = new Field("decimal separator");
            RuntimeCostAccounter.recordAllocation((String)"java/text/NumberFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat$Field.<init>:(Ljava/lang/String;)V");
            SIGN = new Field("sign");
            RuntimeCostAccounter.recordAllocation((String)"java/text/NumberFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat$Field.<init>:(Ljava/lang/String;)V");
            GROUPING_SEPARATOR = new Field("grouping separator");
            RuntimeCostAccounter.recordAllocation((String)"java/text/NumberFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat$Field.<init>:(Ljava/lang/String;)V");
            EXPONENT_SYMBOL = new Field("exponent symbol");
            RuntimeCostAccounter.recordAllocation((String)"java/text/NumberFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat$Field.<init>:(Ljava/lang/String;)V");
            PERCENT = new Field("percent");
            RuntimeCostAccounter.recordAllocation((String)"java/text/NumberFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat$Field.<init>:(Ljava/lang/String;)V");
            PERMILLE = new Field("per mille");
            RuntimeCostAccounter.recordAllocation((String)"java/text/NumberFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat$Field.<init>:(Ljava/lang/String;)V");
            CURRENCY = new Field("currency");
            RuntimeCostAccounter.recordAllocation((String)"java/text/NumberFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat$Field.<init>:(Ljava/lang/String;)V");
            EXPONENT_SIGN = new Field("exponent sign");
        }
    }
}

