<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns="http://www.w3.org/1999/xhtml" exclude-result-prefixes="xhtml xsl">
<xsl:output method="xml" version="1.0" encoding="UTF-8" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" indent="yes"/>

	<xsl:template match="/report">
		<xsl:variable name="target">
			<xsl:choose>
				<xsl:when test="diagnostics/diagnostic[@key='target.class.name']/@string">
					<xsl:value-of select="diagnostics/diagnostic[@key='target.class.name']/@string"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>Unknown</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
   		<html>
			<head>
				<title><xsl:value-of select="$target"/>: Results Analysis</title>
				<style type="text/css">
					body {font-family: sans-serif}
					h2 {text-align: center; padding: 0; margin: 0.5em}
					h4 {text-align: center; padding: 0; margin: 0.5em}
					table {border: 1px solid; border-spacing: 0; margin: 1em 0 1em 0; width: 100%}
					tr.diagnostic:hover {background-color: #e0e0e0}
					th {background-color: #ccccff; border: 1px solid; margin: 0; padding: 5px}
					th.severity {width:10%}
					th.problems {width: 45%}
					th.solutions {width: 45%}
					td {border: 1px solid; margin: 0; padding: 5px}
					ul.problems {}
					li.problem {}
					td.sev-high {background-color: #ff9999}
					td.sev-medium {background-color: #ffcc99}
					td.sev-low {background-color: #ffff99}
					p.severity {text-align: center}
					p.solutions {margin: 0; padding: 0}
					ul.solutions {margin: 0 0 0 2em; padding: 0}
					li.solution {margin: 0; padding: 0}
					.show {color: blue; text-decoration: underline; cursor: pointer}
					p.class {margin: 0; padding: 0}
					p.method {margin: 0; padding: 0}
					p.package {margin: 0; padding: 0; font-size: smaller}
					p.na {margin:0; padding: 0}
					ul.diag-list {margin: 0 0 0 1em; padding: 0}
					li.diag-list {margin: 0; padding: 0; font-size: smaller}
					ul.trace {list-style: none; margin: 0 0 0 1em; padding: 0}
					li.trace {margin: 0; padding: 0; font-size: smaller}
					th.ft-title {text-align: center}
					th.ft-head {width:10em; text-align: left}
				</style>
				<script type="text/javascript">
					function show(id) {
						document.getElementById(id).style.display='';
						document.getElementById("show-" + id).style.display="none";
					}
				</script>
			</head>
			<body>
				<h2>Results Analysis</h2>
				<h4>Class: <xsl:value-of select="$target"/></h4>
				<h4>Date: <xsl:value-of select="@date"/></h4>
				<xsl:choose>
					<xsl:when test="problems/problem">
						<table>
						  <tr class="header">
						  	<th class="severity">Severity</th>
						  	<th class="problems">Problem</th>
						  	<th class="solutions">Suggested Solutions</th>
						  </tr>
						  <xsl:apply-templates select="problems/problem[position()&lt;=5]"/>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<p>No suggestions!</p>
					</xsl:otherwise>
				</xsl:choose>
				<p id="show-support" class="show" onclick="show('support')">Click here for support information.</p>
				<div id="support" style="display: none">
					<h2>Support Information</h2>
					<table>
					  <tr class="header">
					  	<th class="diag-key">Diagnostic</th>
					  	<th class="diag-class">Class or Method</th>
					  	<th class="diag-value">Value</th>
					  </tr>
					  <xsl:for-each select="diagnostics/diagnostic">
				  		<xsl:sort select="@key"/>
				  		<xsl:sort select="@package"/>
				  		<xsl:sort select="@class"/>
				  		<xsl:sort select="@method"/>
						<tr class="diagnostic">
							<td class="diag-key"><xsl:value-of select="@key"/></td>
							<td class="diag-class"><xsl:choose>
								<xsl:when test="@method">
									<p class="method"><xsl:value-of select="@class"/>.<xsl:value-of select="@method"/></p>
									<p class="package"><xsl:value-of select="@package"/></p>
								</xsl:when>
								<xsl:when test="@class">
									<p class="class"><xsl:value-of select="@class"/></p>
									<p class="package"><xsl:value-of select="@package"/></p>
								</xsl:when>
								<xsl:otherwise>
									<p class="na">N/A</p>
								</xsl:otherwise>
							</xsl:choose></td>
							<td class="diag-value">
								<xsl:apply-templates select='.'/>
							</td>
						</tr>
					  </xsl:for-each>
					</table>
 				    <xsl:apply-templates select="diagnostics/diagnostic" mode="failingtest"/>
				</div>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="problem">
	  <tr>
	  	<td class="severity">
	  		<xsl:choose>
	  			<xsl:when test="@severity > 600">
	  				<xsl:attribute name="class">sev-high</xsl:attribute>
	  				<p class="severity">High</p>
	  			</xsl:when>
	  			<xsl:when test="@severity > 300">
	  				<xsl:attribute name="class">sev-medium</xsl:attribute>
	  				<p class="severity">Medium</p>
	  			</xsl:when>
	  			<xsl:otherwise>
	  				<xsl:attribute name="class">sev-low</xsl:attribute>
	  				<p class="severity">Low</p>
	  			</xsl:otherwise>
	  		</xsl:choose>
	  	</td>
	    <td class="problem">
	    	<xsl:value-of select="text()"/>
	    </td>
	    <xsl:variable name="n" select="@id"/>
	    <td class="solution">
	      <xsl:choose>
	      	<xsl:when test="count(/report/solutions/solution[@problemid=$n])=1">
				<xsl:apply-templates select="/report/solutions/solution[@problemid=$n]"/>
	      	</xsl:when>
	      	<xsl:otherwise>
				<p class="solutions">Choose one:</p>
			    <ul class="solutions"><xsl:for-each select="/report/solutions/solution[@problemid=$n]">
			    	<li class="solution">
			    		<xsl:apply-templates select="."/>
						<xsl:choose>
						  	<xsl:when test="@rating=3">
								<xsl:text> (++)</xsl:text>
						  	</xsl:when>
						  	<xsl:when test="@rating=2">
								<xsl:text> (+)</xsl:text>
						  	</xsl:when>
						</xsl:choose>
					 </li>
			      </xsl:for-each></ul>
			  </xsl:otherwise>
	      </xsl:choose>
	    </td>
	  </tr>
	</xsl:template>
	
	<xsl:template match="solution">
		<xsl:value-of select="text()"/>
	</xsl:template>

	<xsl:template match="diagnostic[@type='test']" mode="failingtest">
		<table>
			<xsl:variable name="method">
				<xsl:choose>
					<xsl:when test="@method">
						<xsl:value-of select="@method"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="../@method"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<tr><th colspan="2" class="ft-title">Failing test for <xsl:value-of select="$method"/></th></tr>
			<tr><th class="ft-head">Created by</th><td>
				<xsl:choose>
					<xsl:when test="@mocklevel=0">Agitator</xsl:when>
					<xsl:when test="@mocklevel=1">Agitator (fallback)</xsl:when>
					<xsl:when test="@mocklevel=2">Agitator (aggressive)</xsl:when>
					<xsl:when test="@mocklevel=3">Agitator (mock solver)</xsl:when>
					<xsl:otherwise>Mockitator</xsl:otherwise>
				</xsl:choose>
			</td></tr>
			<tr><th class="ft-head">Expected outcome</th><td><xsl:value-of select="@outcome"/></td></tr>
			<tr><th class="ft-head">Source code</th><td>
				<xsl:variable name="id"><xsl:value-of select="generate-id(source)"/></xsl:variable>
				<xsl:choose>
					<xsl:when test="string-length(source/text()) > 500">
						<p class="show">
							<xsl:attribute name="id">show-<xsl:value-of select="$id"/></xsl:attribute>
							<xsl:attribute name="onClick">show('<xsl:value-of select="$id"/>')</xsl:attribute>
							Click here for source code.
						</p>
						<div style="display: none">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
							<pre><xsl:value-of select="source/text()"/></pre>
						</div>
					</xsl:when>
					<xsl:otherwise>
						<pre><xsl:value-of select="source/text()"/></pre>
					</xsl:otherwise>
				</xsl:choose>
			</td></tr>
			<tr><th class="ft-head">Failing reason</th><td><xsl:value-of select="@reason"/></td></tr>
			<xsl:if test="diagnostic">
				<tr><th class="ft-head">Cause</th><td><xsl:apply-templates select="diagnostic"/></td></tr>
			</xsl:if>
			<xsl:if test="@operation">
				<tr><th class="ft-head">Failing operation</th><td><xsl:value-of select="@operation"/></td></tr>
			</xsl:if>
			<xsl:if test="@coverage">
				<tr><th class="ft-head">Coverage</th><td><xsl:value-of select="@coverage"/></td></tr>
			</xsl:if>
		</table>
	</xsl:template>

	<xsl:template match="diagnostic[@type='list']" mode="failingtest">
		<xsl:apply-templates mode="failingtest"/>
	</xsl:template>

	<xsl:template match="diagnostic[@type='list']">
		<xsl:choose>
			<xsl:when test="count(diagnostic)>10">
				<xsl:variable name="id">
			  	<xsl:value-of select="@key"/>
			  	<xsl:text>.</xsl:text>
			  	<xsl:value-of select="@package"/>
			  	<xsl:text>.</xsl:text>
			  	<xsl:value-of select="@class"/>
			  	<xsl:text>.</xsl:text>
			  	<xsl:value-of select="@method"/>
				</xsl:variable>
				<p class="show">
					<xsl:attribute name="id">show-<xsl:value-of select="$id"/></xsl:attribute>
					<xsl:attribute name="onClick">show('<xsl:value-of select="$id"/>')</xsl:attribute>
					<xsl:value-of select="count(diagnostic)"/> items. Click here to view.
				</p>
				<ul class="diag-list" style="display: none">
				  <xsl:attribute name="id">
				  	<xsl:value-of select="$id"/>
				  </xsl:attribute>
  	  			  <xsl:for-each select="diagnostic">
					<li class="diag-list"><xsl:apply-templates select='.'/></li>
				  </xsl:for-each>
				</ul>
			</xsl:when>
			<xsl:otherwise>
				<ul class="diag-list">
					<xsl:for-each select="diagnostic">
						<li class="diag-list"><xsl:apply-templates select='.'/></li>
					</xsl:for-each>
				</ul>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="diagnostic[@type='error']">
		<xsl:if test="@log-message">
			<xsl:value-of select="@log-message"/>
			<xsl:text>: </xsl:text>
		</xsl:if>
		<xsl:if test="@exception-class">
			<xsl:value-of select="@exception-class"/>
			<xsl:text>: </xsl:text>
		</xsl:if>
		<xsl:value-of select="@exception-message"/>
		<xsl:if test="trace">
			<ul class="trace">
				<xsl:for-each select="trace[position()&lt;10]">
					<li class="trace">
						<xsl:text>at </xsl:text>
						<xsl:value-of select="@class"/>
						<xsl:text>.</xsl:text>
						<xsl:value-of select="@method"/>
						<xsl:text>()</xsl:text>
						<xsl:if test="@line">
							<xsl:text> line </xsl:text>
							<xsl:value-of select="@line"/>
						</xsl:if>
					</li>
				</xsl:for-each>
			</ul>
		</xsl:if>
		<xsl:if test="diagnostic">
			<xsl:text>caused by </xsl:text>
			<xsl:apply-templates select="diagnostic"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="diagnostic">
		<xsl:value-of select="@string"/>
	</xsl:template>

</xsl:stylesheet>
