/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.translator;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.retroweaver.translator.Mirror;
import net.sourceforge.retroweaver.translator.NameTranslator;
import net.sourceforge.retroweaver.translator.TranslatorException;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureWriter;

public class NameTranslatorClassVisitor
extends ClassAdapter {
    private final NameTranslator translator;
    private Set<String> visitedMethods;
    private String className;

    public NameTranslatorClassVisitor(ClassVisitor classVisitor, NameTranslator translator) {
        super(classVisitor);
        this.translator = translator;
    }

    private String translateSignature(String signature, boolean type) {
        if (signature == null) {
            return null;
        }
        SignatureReader r = new SignatureReader(signature);
        SignatureWriter w = new SignatureWriter(){

            public void visitClassType(String name) {
                String n = NameTranslatorClassVisitor.this.translator.getClassMirrorTranslation(name);
                super.visitClassType(n);
            }
        };
        if (type) {
            r.acceptType(w);
        } else {
            r.accept(w);
        }
        return w.toString();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String newSuperName = this.translator.getClassMirrorTranslation(superName);
        String[] newInterfaces = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            newInterfaces[i] = this.translator.getClassMirrorTranslation(interfaces[i]);
        }
        this.className = name;
        this.visitedMethods = new HashSet<String>();
        super.visit(version, access, name, this.translateSignature(signature, false), newSuperName, newInterfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return super.visitField(access, name, this.translator.getClassMirrorTranslationDescriptor(desc), this.translateSignature(signature, true), value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String newDesc = this.translator.translateMethodDescriptor(desc);
        String fullDesc = name + newDesc;
        if (this.visitedMethods.contains(fullDesc)) {
            throw new TranslatorException("Duplicate method after name translation in class " + this.className + ": " + name + ' ' + newDesc);
        }
        this.visitedMethods.add(fullDesc);
        MethodVisitor mv = super.visitMethod(access, name, newDesc, this.translateSignature(signature, false), exceptions);
        return mv == null ? null : new MethodTranslator(mv);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String newDesc = this.translateAnnotationDescriptor(desc);
        return new AnnotationTranslator(this.cv.visitAnnotation(newDesc, visible));
    }

    private String translateAnnotationDescriptor(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.charAt(0) != 'L' || name.charAt(name.length() - 1) != ';') {
            return name;
        }
        return this.translator.translateDescriptor(name);
    }

    private class AnnotationTranslator
    implements AnnotationVisitor {
        private final AnnotationVisitor av;

        AnnotationTranslator(AnnotationVisitor av) {
            this.av = av;
        }

        public void visit(String name, Object value) {
            String newName = NameTranslatorClassVisitor.this.translateAnnotationDescriptor(name);
            this.av.visit(newName, value);
        }

        public void visitEnum(String name, String desc, String value) {
            String newName = NameTranslatorClassVisitor.this.translateAnnotationDescriptor(name);
            String newDesc = NameTranslatorClassVisitor.this.translateAnnotationDescriptor(desc);
            this.av.visitEnum(newName, newDesc, value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            String newName = NameTranslatorClassVisitor.this.translateAnnotationDescriptor(name);
            return new AnnotationTranslator(this.av.visitAnnotation(newName, desc));
        }

        public AnnotationVisitor visitArray(String name) {
            String newName = NameTranslatorClassVisitor.this.translateAnnotationDescriptor(name);
            return new AnnotationTranslator(this.av.visitArray(newName));
        }

        public void visitEnd() {
            this.av.visitEnd();
        }
    }

    private class MethodTranslator
    extends MethodAdapter {
        MethodTranslator(MethodVisitor methodVisitor) {
            super(methodVisitor);
        }

        public void visitTypeInsn(int opcode, String desc) {
            super.visitTypeInsn(opcode, NameTranslatorClassVisitor.this.translator.getClassMirrorTranslationDescriptor(desc));
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            Mirror mirror;
            String newDesc = NameTranslatorClassVisitor.this.translator.getClassMirrorTranslationDescriptor(desc);
            if (opcode == 178 && (mirror = NameTranslatorClassVisitor.this.translator.getMirror(owner)).hasStaticField(name, newDesc)) {
                super.visitFieldInsn(opcode, NameTranslatorClassVisitor.this.translator.translate(owner), name, newDesc);
                return;
            }
            super.visitFieldInsn(opcode, NameTranslatorClassVisitor.this.translator.getClassMirrorTranslation(owner), name, newDesc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String newOwner = owner;
            int newOpcode = opcode;
            String newDesc = desc;
            String lookupOwner = owner;
            while (lookupOwner.startsWith("[")) {
                lookupOwner = lookupOwner.substring(1);
            }
            Mirror mirror = NameTranslatorClassVisitor.this.translator.getMirror(lookupOwner);
            if (mirror.isClassMirror()) {
                newOwner = NameTranslatorClassVisitor.this.translator.translate(owner);
            } else if ("<init>".equals(name) && opcode == 183) {
                String constructorDesc = desc.substring(0, desc.length() - 1) + 'L' + owner + ';';
                int i = owner.lastIndexOf(47);
                String constructorName = i == -1 ? owner : owner.substring(i + 1);
                if (mirror.hasMethod(owner, constructorName, constructorDesc, 183)) {
                    newOwner = NameTranslatorClassVisitor.this.translator.translate(owner);
                    super.visitMethodInsn(184, newOwner, constructorName, constructorDesc);
                    super.visitInsn(95);
                    super.visitInsn(87);
                    super.visitInsn(95);
                    super.visitInsn(87);
                    return;
                }
            } else if (mirror.hasMethod(owner, name, desc, opcode)) {
                newOwner = NameTranslatorClassVisitor.this.translator.translate(owner);
                newOpcode = 184;
                if (opcode == 182) {
                    Type[] argTypes = Type.getArgumentTypes(desc);
                    Type[] newArgTypes = new Type[argTypes.length + 1];
                    newArgTypes[0] = Type.getType("L" + owner + ";");
                    System.arraycopy(argTypes, 0, newArgTypes, 1, argTypes.length);
                    newDesc = Type.getMethodDescriptor(Type.getReturnType(desc), newArgTypes);
                }
            }
            super.visitMethodInsn(newOpcode, newOwner, name, NameTranslatorClassVisitor.this.translator.translateMethodDescriptor(newDesc));
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            super.visitTryCatchBlock(start, end, handler, NameTranslatorClassVisitor.this.translator.translate(type));
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            super.visitLocalVariable(name, NameTranslatorClassVisitor.this.translator.translateDescriptor(desc), NameTranslatorClassVisitor.this.translateSignature(signature, true), start, end, index);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationTranslator(this.mv.visitAnnotationDefault());
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTranslator(this.mv.visitAnnotation(desc, visible));
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return new AnnotationTranslator(this.mv.visitParameterAnnotation(parameter, desc, visible));
        }
    }
}

