/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.translator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.sourceforge.retroweaver.translator.Mirror;
import org.objectweb.asm.Type;

class MethodsMirror
implements Mirror {
    private final String translatedName;
    private final Class class_;

    public MethodsMirror(Class class_) {
        this.class_ = class_;
        this.translatedName = class_.getName().replace('.', '/');
    }

    public boolean exists() {
        return true;
    }

    public String getTranslatedName() {
        return this.translatedName;
    }

    public boolean isClassMirror() {
        return false;
    }

    public boolean hasMethod(String owner, String methodName, String methodDescriptor, int opcode) {
        Type[] types = Type.getArgumentTypes(methodDescriptor);
        if (opcode == 182) {
            Type[] newTypes = new Type[types.length + 1];
            newTypes[0] = Type.getType("L" + owner + ";");
            System.arraycopy(types, 0, newTypes, 1, types.length);
            types = newTypes;
        }
        Method[] arr$ = this.class_.getDeclaredMethods();
        int len$ = arr$.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            Method m = arr$[i$];
            Type[] methodTypes = Type.getArgumentTypes(m);
            if (!m.getName().equals(methodName) || methodTypes.length != types.length) continue;
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].equals(methodTypes[i])) continue block0;
            }
            return true;
        }
        return false;
    }

    public boolean hasStaticField(String fieldName, String fieldDescriptor) {
        try {
            Field f = this.class_.getDeclaredField(fieldName);
            if ((f.getModifiers() & 8) == 0) {
                return false;
            }
            Type fieldType = Type.getType(f.getType());
            Type argType = Type.getType(fieldDescriptor);
            return argType.equals(fieldType);
        }
        catch (NoSuchFieldException nsfe) {
            return false;
        }
    }
}

