/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import net.sourceforge.retroweaver.ClassWeaver;
import net.sourceforge.retroweaver.DefaultWeaveListener;
import net.sourceforge.retroweaver.LazyException;
import net.sourceforge.retroweaver.RefVerifier;
import net.sourceforge.retroweaver.RetroWeaverAttribute;
import net.sourceforge.retroweaver.SignatureStripper;
import net.sourceforge.retroweaver.Weaver;
import net.sourceforge.retroweaver.event.WeaveListener;
import net.sourceforge.retroweaver.optimizer.ClassConstantsCollector;
import net.sourceforge.retroweaver.optimizer.Constant;
import net.sourceforge.retroweaver.optimizer.ConstantComparator;
import net.sourceforge.retroweaver.optimizer.ConstantPool;
import net.sourceforge.retroweaver.translator.NameSpace;
import net.sourceforge.retroweaver.translator.NameTranslator;
import net.sourceforge.retroweaver.translator.NameTranslatorClassVisitor;
import net.sourceforge.retroweaver.translator.TranslatorException;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetroWeaver {
    private final int target;
    private boolean lazy;
    private boolean stripSignatures;
    private boolean stripAttributes;
    private int weavedClassCount;
    private WeaveListener listener;
    private RefVerifier verifier;
    private static final String newLine = System.getProperty("line.separator");
    protected static final FileFilter classFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.getName().endsWith(".class");
        }
    };
    protected static final FileFilter subdirFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory();
        }
    };
    private static final boolean COMPACT_CONSTANTS = true;
    protected static final Attribute[] CUSTOM_ATTRIBUTES = new Attribute[]{new RetroWeaverAttribute(Weaver.getBuildNumber(), 49)};
    private boolean classpathChecked;

    public RetroWeaver(int target) {
        this.target = target;
    }

    protected static void buildFileSets(ArrayList<File[]> fileSets, File path) {
        File[] subdirs;
        File[] files = path.listFiles(classFilter);
        if (files != null) {
            fileSets.add(files);
        }
        if ((subdirs = path.listFiles(subdirFilter)) != null) {
            for (File subdir : subdirs) {
                RetroWeaver.buildFileSets(fileSets, subdir);
            }
        }
    }

    private void displayStartMessage(int n) {
        if (n > 0) {
            this.listener.weavingStarted(new StringBuffer().append("Processing ").append(n).append(n == 1 ? " class" : " classes").toString());
        }
    }

    private void displayEndMessage() {
        if (this.weavedClassCount > 0) {
            this.listener.weavingCompleted(new StringBuffer().append(Integer.toString(this.weavedClassCount)).append(this.weavedClassCount == 1 ? " class" : " classes").append(" weaved.").toString());
        }
    }

    public void weave(File path) throws IOException {
        ArrayList<File[]> fileSets = new ArrayList<File[]>();
        RetroWeaver.buildFileSets(fileSets, path);
        int n = 0;
        for (File[] set : fileSets) {
            n += set.length;
        }
        this.displayStartMessage(n);
        for (int i = 0; i < fileSets.size(); ++i) {
            for (File file : fileSets.get(i)) {
                String sourcePath = file.getCanonicalPath();
                this.weave(sourcePath, null);
            }
        }
        this.displayEndMessage();
        if (this.verifier != null) {
            this.verifier.verifyFiles();
            this.verifier.displaySummary();
        }
    }

    public void weave(File[] baseDirs, String[][] fileSets, File outputDir) throws IOException {
        int n = 0;
        for (String[] set : fileSets) {
            n += set.length;
        }
        this.displayStartMessage(n);
        HashSet<String> weaved = new HashSet<String>();
        for (int i = 0; i < fileSets.length; ++i) {
            for (String fileName : fileSets[i]) {
                File file = new File(baseDirs[i], fileName);
                String sourcePath = file.getCanonicalPath();
                String outputPath = null;
                if (outputDir != null) {
                    outputPath = new File(outputDir, fileName).getCanonicalPath();
                }
                if (weaved.contains(sourcePath)) continue;
                this.weave(sourcePath, outputPath);
                weaved.add(sourcePath);
            }
        }
        this.displayEndMessage();
        if (this.verifier != null) {
            this.verifier.verifyFiles();
            this.verifier.displaySummary();
        }
    }

    public void weaveJarFile(String sourceJarFileName, String destJarFileName) throws IOException {
        JarFile jarFile = new JarFile(sourceJarFileName);
        ArrayList<JarEntry> entries = Collections.list(jarFile.entries());
        FileOutputStream os = new FileOutputStream(destJarFileName);
        JarOutputStream out = new JarOutputStream(os);
        int n = 0;
        for (JarEntry entry : entries) {
            if (!entry.getName().endsWith(".class")) continue;
            ++n;
        }
        this.displayStartMessage(n);
        for (JarEntry entry : entries) {
            int len;
            ByteArrayOutputStream classStream;
            InputStream is;
            String name = entry.getName();
            InputStream dataStream = null;
            if (name.endsWith(".class") && this.weave(is = jarFile.getInputStream(entry), name, classStream = new ByteArrayOutputStream())) {
                ++this.weavedClassCount;
                dataStream = new ByteArrayInputStream(classStream.toByteArray());
                entry = new JarEntry(name);
                this.recordFileForVerifier(name);
            }
            if (dataStream == null) {
                dataStream = jarFile.getInputStream(entry);
            }
            out.putNextEntry(new JarEntry(name));
            byte[] buf = new byte[1024];
            while ((len = dataStream.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
        }
        out.close();
        this.displayEndMessage();
        if (this.verifier != null) {
            this.verifier.verifyJarFile(destJarFileName);
            this.verifier.displaySummary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void weave(String sourcePath, String outputPath) throws IOException {
        FileInputStream is = new FileInputStream(sourcePath);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (this.weave(is, sourcePath, bos)) {
                String path;
                ++this.weavedClassCount;
                if (outputPath == null) {
                    path = sourcePath;
                } else {
                    path = outputPath;
                    File parentDir = new File(path).getParentFile();
                    if (parentDir != null) {
                        parentDir.mkdirs();
                    }
                }
                FileOutputStream fos = new FileOutputStream(path);
                fos.write(bos.toByteArray());
                fos.close();
                this.recordFileForVerifier(path);
            } else {
                if (outputPath == null) {
                    return;
                }
                File dir = new File(outputPath).getParentFile();
                if (dir != null) {
                    dir.mkdirs();
                }
                File sf = new File(sourcePath);
                File of = new File(outputPath);
                if (!of.isFile() || !of.getCanonicalPath().equals(sf.getCanonicalPath())) {
                    FileInputStream fis = new FileInputStream(sf);
                    byte[] bytes = new byte[(int)sf.length()];
                    fis.read(bytes);
                    fis.close();
                    FileOutputStream fos = new FileOutputStream(of);
                    fos.write(bytes);
                    fos.close();
                    of.setLastModified(sf.lastModified());
                }
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {}
        }
    }

    private void recordFileForVerifier(String fileName) {
        if (this.verifier != null) {
            this.verifier.addClass(fileName);
        }
    }

    private boolean isRuntimeInClassPath() {
        if (!this.classpathChecked) {
            try {
                Class.forName("net.sourceforge.retroweaver.runtime.java.lang.annotation.AIB");
                this.classpathChecked = true;
            }
            catch (ClassNotFoundException e) {
                this.listener.weavingError("Error: the retroweaver runtime must be in the classpath");
                return false;
            }
        }
        return true;
    }

    protected boolean weave(InputStream sourceStream, String fileName, ByteArrayOutputStream bos) throws IOException {
        if (!this.isRuntimeInClassPath()) {
            return false;
        }
        ClassReader cr = new ClassReader(sourceStream);
        ClassWriter cw = new ClassWriter(1);
        try {
            ClassVisitor classVisitor = cw;
            ConstantPool cp = new ConstantPool();
            classVisitor = new ClassConstantsCollector(classVisitor, cp);
            classVisitor = new NameTranslatorClassVisitor(classVisitor, NameTranslator.getGeneralTranslator());
            classVisitor = new ClassWeaver(classVisitor, this.lazy, this.stripAttributes, this.target, this.listener);
            classVisitor = new NameTranslatorClassVisitor(classVisitor, NameTranslator.getStringBuilderTranslator());
            if (this.stripSignatures) {
                classVisitor = new SignatureStripper(classVisitor);
            }
            cr.accept(classVisitor, CUSTOM_ATTRIBUTES, 8);
            TreeSet<Constant> constants = new TreeSet<Constant>(new ConstantComparator());
            constants.addAll(cp.values());
            cr = new ClassReader(cw.toByteArray());
            cw = new ClassWriter(0);
            for (Constant c : constants) {
                c.write(cw);
            }
            cr.accept(cw, 0);
            bos.write(cw.toByteArray());
            return true;
        }
        catch (TranslatorException te) {
            this.listener.weavingError(te.getMessage());
            return false;
        }
        catch (LazyException e) {
            return false;
        }
    }

    public void setListener(WeaveListener listener) {
        this.listener = listener;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setVerifier(RefVerifier verifier) {
        this.verifier = verifier;
    }

    public static String getUsage() {
        return new StringBuffer().append("Usage: RetroWeaver ").append(newLine).append(" <source path>").append(newLine).append(" [<output path>]").toString();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println(RetroWeaver.getUsage());
            return;
        }
        String sourcePath = args[0];
        String outputPath = null;
        if (args.length > 1) {
            outputPath = args[1];
        }
        try {
            RetroWeaver weaver = new RetroWeaver(48);
            weaver.setListener(new DefaultWeaveListener(false));
            weaver.weave(sourcePath, outputPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setStripSignatures(boolean stripSignatures) {
        this.stripSignatures = stripSignatures;
    }

    public void setStripAttributes(boolean stripAttributes) {
        this.stripAttributes = stripAttributes;
    }

    public void addNameSpaces(List<NameSpace> nameSpaces) {
        NameTranslator translator = NameTranslator.getGeneralTranslator();
        for (NameSpace n : nameSpaces) {
            translator.addNameSpace(n);
        }
    }
}

