/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.servlet;

import java.util.StringTokenizer;

class Path
implements Cloneable {
    private static final String THIS_DIR = ".";
    private static final String PARENT_DIR = "..";
    private final String[] elements;
    final boolean absolute;
    private static final char SEP = '/';
    static final Path ROOT = new Path("/");

    private Path(String[] els, boolean abs) {
        this.elements = els;
        this.absolute = abs;
    }

    private Path(String[] els, int offset, int length, boolean abs) {
        this.elements = new String[length];
        System.arraycopy(els, offset, this.elements, 0, length);
        this.absolute = abs;
    }

    Path(String path) {
        this.checkNullPath(path);
        if (path.length() > 0) {
            this.absolute = path.charAt(0) == '/';
            StringTokenizer st = new StringTokenizer(path, String.valueOf('/'));
            int n = st.countTokens();
            String[] els = new String[n];
            int i = 0;
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (PARENT_DIR.equals(tok) && i > 0 && !PARENT_DIR.equals(els[i - 1])) {
                    --i;
                    continue;
                }
                if (tok.length() <= 0 || THIS_DIR.equals(tok)) continue;
                els[i++] = tok;
            }
            if (i < n) {
                this.elements = new String[i];
                System.arraycopy(els, 0, this.elements, 0, i);
            } else {
                this.elements = els;
            }
        } else {
            this.elements = new String[0];
            this.absolute = false;
        }
    }

    private void checkNullPath(Object path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return new Path(this.elements, 0, this.elements.length, this.absolute);
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isRelative() {
        return !this.absolute;
    }

    public Path subPath(int beg, int end) {
        int n = this.elements.length;
        if (beg < 0 || beg >= n || end > n || beg > end) {
            throw new ArrayIndexOutOfBoundsException("Invalid range: [" + beg + ":" + end + "], valid range is [0:" + n + "].");
        }
        return new Path(this.elements, beg, end - beg, beg == 0 ? this.absolute : false);
    }

    public Path getParent() {
        int n = this.elements.length;
        if (n == 0) {
            return null;
        }
        return this.subPath(0, n - 1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.absolute) {
            sb.append('/');
        }
        for (int i = 0; i < this.elements.length; ++i) {
            sb.append(this.elements[i]).append('/');
        }
        int n = sb.length();
        if (n > 1) {
            sb.deleteCharAt(n - 1);
        }
        return sb.toString();
    }

    public int size() {
        return this.elements.length;
    }

    public Path concat(String path) {
        return this.concat(new Path(path));
    }

    public Path concat(Path path) {
        int i;
        this.checkNullPath(path);
        int s1 = this.size();
        int s2 = path.size();
        for (i = 0; i < s2 && PARENT_DIR.equals(path.elements[i]); ++i) {
        }
        String[] els = new String[(s1 -= i) + (s2 -= i)];
        System.arraycopy(this.elements, 0, els, 0, s1);
        System.arraycopy(path.elements, i, els, s1, s2);
        return new Path(els, this.absolute);
    }

    public Path match(String urlPattern) {
        Path pattern = new Path(urlPattern);
        if (this.isRelative() && pattern.isAbsolute()) {
            return null;
        }
        int n = pattern.size();
        int myN = this.size();
        if (n == 0) {
            return new Path(this.elements, 0, this.elements.length, this.absolute);
        }
        if (n <= myN) {
            int i;
            for (i = 0; i < n; ++i) {
                String p = pattern.elements[i];
                String e = this.elements[i];
                if ("*".equals(p) || p.length() > 1 && p.charAt(0) == '*' && e.endsWith(p.substring(1)) || p.equals(e)) continue;
                return null;
            }
            return this.subPath(0, i);
        }
        if (n == myN + 1 && "*".equals(pattern.elements[myN])) {
            return new Path(this.elements, 0, this.elements.length, this.absolute);
        }
        return null;
    }

    public Path subPath(int i) {
        return this.subPath(i, this.elements.length);
    }

    public Path makeRelative() {
        Path copy = new Path(this.elements, 0, this.elements.length, false);
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            Path that = (Path)obj;
            if (that.elements.length == this.elements.length) {
                for (int i = 0; i < this.elements.length; ++i) {
                    if (this.elements[i].equals(that.elements[i])) continue;
                    return false;
                }
                return this.absolute == that.absolute;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

