/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.agitar.mock.servlet.ContentType;
import org.agitar.mock.servlet.HttpDateFormat;
import org.agitar.mock.util.MultiMap;

public class MockHttpServletResponse
implements HttpServletResponse {
    private boolean committed;
    private int statusCode = 200;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private MultiMap headers = new MultiMap();
    private ServletOutputStream sos;
    private PrintWriter pw;
    private String redirectUrl;
    private int bufferSize;
    private ArrayList cookies = new ArrayList();

    public MockHttpServletResponse() {
        this.setHeader("content-type", "text/html; charset=UTF-8");
    }

    public void sendError(int sc) throws IOException {
        this.checkCommit();
        this.statusCode = sc;
        this.commit();
    }

    public void setStatus(int sc) {
        this.statusCode = sc;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.sendError(sc);
        if (msg != null) {
            String charset = this.getCharacterEncoding();
            if (charset == null) {
                this.bos.write(msg.getBytes());
            }
            this.bos.write(msg.getBytes(charset));
        }
    }

    public void setStatus(int sc, String msg) {
        if (sc >= 400) {
            try {
                this.sendError(sc, msg);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } else {
            this.setStatus(sc);
        }
    }

    public void sendRedirect(String url) throws IOException {
        this.checkCommit();
        this.setStatus(302);
        this.redirectUrl = url;
        this.commit();
    }

    private void checkCommit() {
        if (this.committed) {
            throw new IllegalStateException("Response is already sent.");
        }
    }

    public boolean containsHeader(String header) {
        return this.headers.containsKey(header);
    }

    public void addIntHeader(String header, int val) {
        this.headers.add(header, String.valueOf(val));
    }

    public void setIntHeader(String header, int val) {
        this.headers.set(header, String.valueOf(val));
    }

    public void addDateHeader(String header, long datetime) {
        this.headers.add(header, HttpDateFormat.get().format(new Date(datetime)));
    }

    public void setDateHeader(String header, long datetime) {
        this.headers.set(header, HttpDateFormat.get().format(new Date(datetime)));
    }

    public void addCookie(Cookie arg0) {
        this.cookies.add(arg0);
    }

    public String encodeRedirectURL(String url) {
        return this.encodeUrl(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        String charset = this.getCharacterEncoding();
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            return URLEncoder.encode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported encoding: " + charset);
        }
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void addHeader(String arg0, String arg1) {
        this.headers.add(arg0, arg1);
    }

    public void setHeader(String arg0, String arg1) {
        this.headers.set(arg0, arg1);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        if (this.pw != null) {
            this.pw.flush();
        }
        if (this.sos != null) {
            this.sos.flush();
        }
        this.commit();
    }

    public void reset() {
        this.statusCode = 200;
        this.setHeader("content-type", "text/html; charset=UTF-8");
        this.resetBuffer();
    }

    public void resetBuffer() {
        this.checkCommit();
        this.bos.reset();
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void setContentLength(int contentLength) {
        this.setIntHeader("content-length", contentLength);
    }

    public PrintWriter getWriter() throws IOException {
        this.checkCommit();
        if (this.sos != null) {
            throw new IllegalStateException("getOutputStream() is already called on this response.");
        }
        String charset = this.getCharacterEncoding();
        OutputStreamWriter w = charset == null ? new OutputStreamWriter(this.bos) : new OutputStreamWriter((OutputStream)this.bos, charset);
        this.pw = new PrintWriter(w){

            public void flush() {
                super.flush();
                MockHttpServletResponse.this.commit();
            }
        };
        return this.pw;
    }

    public String getCharacterEncoding() {
        String contentType = this.getContentType();
        if (contentType != null) {
            return new ContentType(contentType).getParameter("charset");
        }
        return null;
    }

    public String getContentType() {
        return this.headers.getValue("content-type");
    }

    public void setCharacterEncoding(String charsetStr) {
        try {
            "a".getBytes(charsetStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding: " + charsetStr);
        }
        String contentType = this.getContentType();
        ContentType contentTypeStr = null;
        contentTypeStr = contentType != null ? new ContentType(contentType) : new ContentType("text", "html");
        contentTypeStr.setParameter("charset", charsetStr);
        this.headers.set("content-type", contentTypeStr.toString());
    }

    public void setContentType(String ctype) {
        new ContentType(ctype);
        this.headers.set("content-type", ctype);
    }

    public Locale getLocale() {
        String localeStr = this.headers.getValue("content-language");
        if (localeStr != null) {
            StringTokenizer st = new StringTokenizer(localeStr, "-");
            String[] tuple = new String[]{"", "", ""};
            int i = 0;
            while (st.hasMoreTokens() && i < tuple.length) {
                tuple[i] = st.nextToken();
            }
            return new Locale(tuple[0], tuple[1], tuple[2]);
        }
        return Locale.getDefault();
    }

    public void setLocale(Locale locale) {
        this.headers.set("content-language", locale.toString().replace('_', '-'));
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.checkCommit();
        if (this.pw != null) {
            throw new IllegalStateException("getWriter() is already called on this response.");
        }
        this.sos = new ServletOutputStream(){

            public void write(int b) throws IOException {
                MockHttpServletResponse.this.bos.write(b);
            }

            public void flush() throws IOException {
                super.flush();
                MockHttpServletResponse.this.commit();
            }
        };
        return this.sos;
    }

    public void commit() {
        this.committed = true;
        this.setIntHeader("content-length", this.bos.size());
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public String getRedirectURL() {
        return this.redirectUrl;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean outputContainsText(String subString) {
        String content;
        String contentTypeStr = this.getContentType();
        String encoding = null;
        if (contentTypeStr != null) {
            ContentType contentType = new ContentType(contentTypeStr);
            if (!"text".equals(contentType.getType())) {
                throw new IllegalStateException("Content type is set to a non-text type: " + contentTypeStr);
            }
            encoding = contentType.getParameter("charset");
        }
        try {
            content = encoding != null ? this.bos.toString(encoding) : this.bos.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Cannot read output with unsupported encoding: " + encoding);
        }
        return content.indexOf(subString) >= 0;
    }
}

