/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.agitar.mock.servlet.ContentType;
import org.agitar.mock.servlet.HttpDateFormat;
import org.agitar.mock.servlet.MockHttpSession;
import org.agitar.mock.servlet.MockRequestDispatcher;
import org.agitar.mock.servlet.MockServletContext;
import org.agitar.mock.servlet.Path;
import org.agitar.mock.util.CollectionEnumeration;
import org.agitar.mock.util.MultiMap;

public class MockHttpServletRequest
implements HttpServletRequest {
    static final String CHARSET = "charset";
    static final String CONTENT_LENGTH = "content-length";
    static final String CONTENT_TYPE = "content-type";
    static final String HOST = "host";
    private static final String POST = "POST";
    private static final String GET = "GET";
    private String requestedSessionId;
    private boolean requestedSessionIdFromCookie;
    private boolean requestedSessionIdFromURL;
    private boolean isRequestedSessionIdValid;
    private int localPort;
    private int serverPort;
    private int remotePort;
    private String serverName;
    private String localName;
    private String remoteHost;
    private String localAddress;
    private String remoteAddress;
    private String authType;
    private String remoteUser;
    private HashMap attributes = new HashMap();
    private MultiMap params = new MultiMap();
    private MultiMap headers = new MultiMap();
    private Principal userPrincipal;
    private Cookie[] cookies;
    private HttpSession session;
    private String protocol = "HTTP/1.1";
    private ArrayList locales = new ArrayList();
    private boolean calledGetInputStream;
    private boolean calledGetReader;
    private ServletInputStream inputStream;
    private String method;
    private String pathInfo;
    private String queryString;
    private String requestURI;
    private String servletPath;
    private String scheme;
    private StringBuffer requestURL;
    private MockServletContext context;
    private Map dispatchers;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MockHttpServletRequest(String urlStr) {
        this(urlStr, new MockServletContext());
    }

    protected MockHttpServletRequest(String urlStr, MockServletContext context) {
        URL url;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            this.scheme = "http";
            this.localName = "localhost";
            this.localPort = 80;
            try {
                url = new URL(this.scheme, this.localName, urlStr);
            }
            catch (MalformedURLException e1) {
                throw new IllegalArgumentException("Cannot simulate url: " + e.getMessage());
            }
        }
        this.scheme = url.getProtocol().toLowerCase();
        if (!"http".equals(this.scheme) && !"https".equals(this.scheme)) {
            throw new IllegalArgumentException("URL must be HTTP or HTTPS.");
        }
        this.queryString = url.getQuery();
        this.requestURI = url.getPath();
        this.locales.add(Locale.getDefault());
        this.localName = url.getHost();
        this.localPort = url.getPort();
        if (this.localPort < 0) {
            this.localPort = 80;
        }
        this.serverName = this.localName;
        this.serverPort = this.localPort;
        this.requestURL = new StringBuffer(urlStr.length());
        this.requestURL.append(this.scheme);
        this.requestURL.append("://");
        this.requestURL.append(this.localName);
        this.requestURL.append(':');
        this.requestURL.append(this.localPort);
        this.requestURL.append(this.requestURI);
        this.context = context;
        this.initServletPath();
        this.initParams(this.queryString);
        this.method = GET;
        this.inputStream = new ServletInputStream(){

            public int read() throws IOException {
                return -1;
            }
        };
    }

    private void initParams(String query) {
        if (query != null) {
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreTokens()) {
                int eq;
                String token = st.nextToken();
                try {
                    String encoding = this.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                    token = URLDecoder.decode(token, encoding);
                }
                catch (UnsupportedEncodingException x) {
                    // empty catch block
                }
                if ((eq = token.indexOf(61)) <= -1) continue;
                String key = token.substring(0, eq);
                String val = token.substring(eq + 1);
                this.params.add(key, val);
            }
        }
    }

    private void initServletPath() {
        if (this.requestURI != null) {
            Path p = new Path(this.requestURI);
            String[] patterns = this.context.getURLPatterns();
            for (int i = 0; i < patterns.length; ++i) {
                Path spath = p.match(patterns[i]);
                if (spath == null) continue;
                this.servletPath = spath.toString();
                if (spath.size() >= p.size()) break;
                this.pathInfo = '/' + p.subPath(spath.size()).toString();
                break;
            }
            if (this.servletPath == null) {
                this.servletPath = this.requestURI;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPostData(String contentType, String postData) {
        void var4_4;
        byte[] data;
        this.setHeader(CONTENT_TYPE, contentType);
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            data = postData.getBytes();
        } else {
            try {
                data = postData.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Invalid charset name: " + encoding);
            }
        }
        this.setHeader(CONTENT_LENGTH, String.valueOf(((void)var4_4).length));
        this.inputStream = new ServletInputStream((byte[])var4_4){
            InputStream is;
            private final /* synthetic */ byte[] val$data;
            {
                this.val$data = val$data;
                this.is = new ByteArrayInputStream(this.val$data);
            }

            public int read() throws IOException {
                return this.is.read();
            }
        };
    }

    public void setPostData(String contentType, final byte[] postData) {
        this.setHeader(CONTENT_TYPE, contentType);
        this.setHeader(CONTENT_LENGTH, String.valueOf(postData.length));
        this.method = POST;
        this.inputStream = new ServletInputStream(){
            InputStream is;
            {
                this.is = new ByteArrayInputStream(postData);
            }

            public int read() throws IOException {
                return this.is.read();
            }
        };
    }

    public void setParameter(String paramName, String paramValue) {
        this.params.add(paramName, paramValue);
    }

    public void setHeader(String header, String val) {
        if (CONTENT_TYPE.equals(header = header.toLowerCase())) {
            new ContentType(val);
            this.headers.set(header, val);
        } else {
            this.headers.add(header, val);
        }
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionIdFromCookie;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionIdFromURL;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.isRequestedSessionIdValid;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        Path path = new Path(this.context.getContextBasePath());
        return Path.ROOT.concat(path).toString();
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.getPathInfo();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public int getIntHeader(String arg0) {
        String header = this.headers.getValue(arg0);
        if (header != null) {
            return Integer.parseInt(header);
        }
        return -1;
    }

    public long getDateHeader(String arg0) {
        String header = this.headers.getValue(arg0);
        if (header != null) {
            try {
                Date date = HttpDateFormat.get().parse(header);
                return date.getTime();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Failed to parse date: " + header);
            }
        }
        return -1L;
    }

    public boolean isUserInRole(String arg0) {
        return false;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public Principal setUserPrincipal(Principal user) {
        this.userPrincipal = user;
        return this.userPrincipal;
    }

    public Enumeration getHeaderNames() {
        return this.headers.getKeys();
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.session == null && create) {
            this.session = new MockHttpSession(this.context);
        }
        return this.session;
    }

    public String getHeader(String arg0) {
        return this.headers.getValue(arg0);
    }

    public Enumeration getHeaders(String arg0) {
        return this.headers.getValuesAsEnum(arg0);
    }

    public int getContentLength() {
        return this.getIntHeader(CONTENT_LENGTH);
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getServerPort() {
        String host = this.getHeader(HOST);
        if (host != null) {
            int p = host.lastIndexOf(58);
            int ret = 80;
            if (p >= 0 && p != host.length() - 1) {
                try {
                    ret = Integer.parseInt(host.substring(p + 1));
                }
                catch (NumberFormatException x) {
                    // empty catch block
                }
            }
            return ret;
        }
        return this.serverPort;
    }

    public boolean isSecure() {
        return "https".equals(this.scheme);
    }

    public BufferedReader getReader() throws IOException {
        if (this.calledGetInputStream) {
            throw new IllegalArgumentException("getInputStream() is already called on this request.");
        }
        this.calledGetReader = true;
        String characterEncoding = this.getCharacterEncoding();
        if (characterEncoding == null) {
            characterEncoding = "UTF-8";
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.inputStream, characterEncoding));
    }

    public String getCharacterEncoding() {
        String contentType = this.getContentType();
        if (contentType != null) {
            return new ContentType(contentType).getParameter(CHARSET);
        }
        return null;
    }

    public String getContentType() {
        return this.headers.getValue(CONTENT_TYPE);
    }

    public String getLocalAddr() {
        return this.localAddress;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRemoteAddr() {
        return this.remoteAddress;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        String host = this.getHeader(HOST);
        if (host != null) {
            int p = host.lastIndexOf(58);
            return p < 0 ? host : host.substring(0, p);
        }
        return this.serverName;
    }

    public void removeAttribute(String arg0) {
        this.attributes.remove(arg0);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        "a".getBytes(arg0);
        String contentType = this.getContentType();
        ContentType contentTypeStr = null;
        contentTypeStr = contentType != null ? new ContentType(contentType) : new ContentType("text", "html");
        contentTypeStr.setParameter(CHARSET, arg0);
        this.headers.set(CONTENT_TYPE, contentTypeStr.toString());
    }

    public Enumeration getAttributeNames() {
        return new CollectionEnumeration(this.attributes.keySet());
    }

    public Enumeration getLocales() {
        return new CollectionEnumeration(this.locales);
    }

    public Enumeration getParameterNames() {
        return this.params.getKeys();
    }

    public Locale getLocale() {
        if (this.locales.size() < 1) {
            return Locale.getDefault();
        }
        return (Locale)this.locales.get(0);
    }

    public Map getParameterMap() {
        return this.params.getMap();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.calledGetReader) {
            throw new IllegalStateException("getReader() is already called on this request.");
        }
        this.calledGetInputStream = true;
        return this.inputStream;
    }

    public Object getAttribute(String arg0) {
        return this.attributes.get(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.attributes.put(arg0, arg1);
    }

    public String getParameter(String arg0) {
        return this.params.getValue(arg0);
    }

    public String getRealPath(String arg0) {
        return this.context.getRealPath(arg0);
    }

    public String[] getParameterValues(String arg0) {
        return this.params.getValues(arg0);
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        RequestDispatcher dispatcher = null;
        if (arg0 != null && arg0.length() > 0) {
            Path path = new Path(arg0);
            dispatcher = path.isAbsolute() ? this.context.getRequestDispatcher(path.toString()) : this.context.getRequestDispatcher(new Path(this.getServletPath()).concat(path).toString());
        }
        if (dispatcher != null) {
            if (this.dispatchers == null) {
                this.dispatchers = new HashMap();
            }
            this.dispatchers.put(arg0, dispatcher);
        }
        return dispatcher;
    }

    public void setRequestedSessionId(String requestedSessionId) {
        this.requestedSessionId = requestedSessionId;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdFromCookie) {
        this.requestedSessionIdFromCookie = requestedSessionIdFromCookie;
    }

    public void setRequestedSessionIdFromURL(boolean requestedSessionIdFromURL) {
        this.requestedSessionIdFromURL = requestedSessionIdFromURL;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setProtocol(String protocol) {
        MockHttpServletRequest.matchesPattern(protocol, "HTTP/[0-1]\\.[0-9]");
        this.protocol = protocol;
    }

    private static void matchesPattern(String arg, String pattern) {
        if (!arg.matches(pattern)) {
            throw new IllegalArgumentException("Expected argument to match [" + pattern + "] but found: " + arg);
        }
    }

    private static void checkInetAddress(String arg) {
        StringTokenizer st = new StringTokenizer(arg, ".");
        if (st.countTokens() == 4) {
            while (st.hasMoreTokens()) {
                String bite = st.nextToken();
                try {
                    byte b = Byte.parseByte(bite);
                    if (b >= 0) continue;
                    throw new IllegalArgumentException("Not an inet address: " + arg);
                }
                catch (NumberFormatException x) {
                    throw new IllegalArgumentException("Not an inet address: " + arg);
                }
            }
            return;
        }
        throw new IllegalArgumentException("Not an inet address: " + arg);
    }

    public void setLocalAddr(String localAddress) {
        MockHttpServletRequest.checkInetAddress(localAddress);
        this.localAddress = localAddress;
    }

    public void addLocale(Locale loc) {
        this.locales.add(loc);
    }

    public void setLocales(ArrayList locs) {
        if (!$assertionsDisabled && locs == null) {
            throw new AssertionError();
        }
        this.locales = locs;
    }

    public void setRemoteAddr(String remoteAddress) {
        MockHttpServletRequest.checkInetAddress(remoteAddress);
        this.remoteAddress = remoteAddress;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public String getForwardedToURI(String dispatcherPath) {
        return this.getRequestedDispatcher(dispatcherPath).getForwardedURI();
    }

    private MockRequestDispatcher getRequestedDispatcher(String dispatcherPath) {
        MockRequestDispatcher dispatcher = null;
        if (this.dispatchers != null) {
            dispatcher = (MockRequestDispatcher)this.dispatchers.get(dispatcherPath);
        }
        if (dispatcher == null) {
            throw new IllegalStateException("No dispatcher for [" + dispatcherPath + "] is requested.");
        }
        return dispatcher;
    }

    public String getIncludedURI(String dispatcherPath) {
        return this.getRequestedDispatcher(dispatcherPath).getIncludedURI();
    }

    public String toString() {
        return this.requestURL.toString();
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    static {
        $assertionsDisabled = !MockHttpServletRequest.class.desiredAssertionStatus();
    }
}

