/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.ejb;

import java.security.Identity;
import java.security.Principal;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;
import org.agitar.mock.util.MultiMap;

public class MockSessionContext
implements SessionContext {
    private EJBLocalObject ejbLocalObject;
    private EJBObject ejbObject;
    private MessageContext messageContext;
    private Identity callerId;
    private Principal callerPrincipal;
    private EJBHome ejbHome;
    private EJBLocalHome ejbLocalHome;
    private TimerService timeService;
    private UserTransaction userTransaction;
    private boolean rollbackOnly;
    private Properties environment = new Properties();
    private MultiMap roles = new MultiMap();

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        return this.ejbLocalObject;
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        return this.ejbObject;
    }

    public MessageContext getMessageContext() throws IllegalStateException {
        return this.messageContext;
    }

    public Identity getCallerIdentity() {
        return this.callerId;
    }

    public Principal getCallerPrincipal() {
        return this.callerPrincipal;
    }

    public EJBHome getEJBHome() {
        return this.ejbHome;
    }

    public EJBLocalHome getEJBLocalHome() {
        return this.ejbLocalHome;
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        return this.rollbackOnly;
    }

    public TimerService getTimerService() throws IllegalStateException {
        return this.timeService;
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        return this.userTransaction;
    }

    public boolean isCallerInRole(String arg0) {
        Principal principal = this.getCallerPrincipal();
        if (principal != null) {
            return this.roles.containsValue(principal.getName(), arg0);
        }
        return false;
    }

    public boolean isCallerInRole(Identity arg0) {
        return false;
    }

    public void setRollbackOnly() throws IllegalStateException {
        this.rollbackOnly = true;
    }

    public void setEJBHome(EJBHome ejbHome) {
        this.ejbHome = ejbHome;
    }

    public void setEJBLocalHome(EJBLocalHome ejbLocalHome) {
        this.ejbLocalHome = ejbLocalHome;
    }

    public void setEJBLocalObject(EJBLocalObject ejbLocalObject) {
        this.ejbLocalObject = ejbLocalObject;
    }

    public void setEJBObject(EJBObject ejbObject) {
        this.ejbObject = ejbObject;
    }

    public TimerService getTimeService() {
        return this.timeService;
    }

    public void setTimeService(TimerService timeService) {
        this.timeService = timeService;
    }

    public void putEnvironment(String key, Object value) {
        this.environment.put(key, value);
    }

    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    public void setUserTransaction(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    public void setRole(Principal user, String roleName) {
        this.roles.add(user.getName(), roleName);
    }
}

