/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.ejb;

import java.lang.reflect.Modifier;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityBean;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.agitar.mock.ejb.Messages;
import org.agitar.mock.ejb.MockEntityContext;
import org.agitar.mock.ejb.MockSessionContext;
import org.agitar.mock.util.StubClassLoader;

public abstract class MockEJBBase {
    protected final Class homeInterface;
    protected final Class remoteOrLocalInterface;
    protected final Class beanImpl;
    protected final boolean isImplAbstract;
    private final boolean isSessionBean;
    private final boolean isEntityBean;
    private MockSessionContext sessionContext;
    private MockEntityContext entityContext;

    protected abstract void checkHome() throws IllegalArgumentException;

    protected abstract void checkInterface() throws IllegalArgumentException;

    protected abstract MockSessionContext createSessionContext();

    protected abstract MockEntityContext createEntityContext();

    protected abstract boolean isLocal();

    public abstract void setEJBName(String var1) throws NamingException;

    protected MockEJBBase(Class home, Class remoteOrLocal, Class impl) {
        this.homeInterface = home;
        this.remoteOrLocalInterface = remoteOrLocal;
        this.beanImpl = impl;
        this.checkHome();
        this.checkInterface();
        this.isSessionBean = SessionBean.class.isAssignableFrom(impl);
        this.isEntityBean = EntityBean.class.isAssignableFrom(impl);
        this.isImplAbstract = Modifier.isAbstract(this.beanImpl.getModifiers());
        if (!this.isSessionBean && !this.isEntityBean) {
            throw new IllegalArgumentException(Messages.format("Bean class [{0}] must implement javax.ejb.SessionBean or javax.ejb.EntityBean.", impl.getName()));
        }
        if (this.isSessionBean && this.isImplAbstract) {
            throw new IllegalArgumentException(Messages.format("Session bean {0} cannot be abstract.", impl.getName()));
        }
    }

    public boolean isSessionBean() {
        return this.isSessionBean;
    }

    public boolean isEntityBean() {
        return this.isEntityBean;
    }

    public void registerCustomMockBean(Object customMock) {
    }

    public void registerCustomMockHome(Object customMock) {
    }

    protected EnterpriseBean newImplObj() {
        try {
            Class c = this.beanImpl;
            if (this.isImplAbstract) {
                c = StubClassLoader.createSubClass(this.beanImpl);
            }
            return (EnterpriseBean)c.newInstance();
        }
        catch (Exception e) {
            IllegalStateException ilx = new IllegalStateException(Messages.format("{0} must have a public no-arg constructor. Nested exception: {1}.", new String[]{this.beanImpl.toString(), e.toString()}));
            ilx.initCause(e);
            throw ilx;
        }
    }

    public MockSessionContext getSessionContext() {
        if (this.isEntityBean) {
            throw new IllegalStateException(Messages.format("{0} is not a javax.ejb.SessionBean.", this.beanImpl));
        }
        if (this.sessionContext == null) {
            this.sessionContext = this.createSessionContext();
        }
        return this.sessionContext;
    }

    public MockEntityContext getEntityContext() {
        if (this.isSessionBean) {
            throw new IllegalStateException(Messages.format("{0} is not a javax.ejb.EntityBean.", this.beanImpl));
        }
        if (this.entityContext == null) {
            this.entityContext = this.createEntityContext();
        }
        return this.entityContext;
    }
}

