/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.org.objectweb.asm.tree.analysis;

import com.agitar.org.objectweb.asm.Opcodes;
import com.agitar.org.objectweb.asm.Type;
import com.agitar.org.objectweb.asm.tree.AbstractInsnNode;
import com.agitar.org.objectweb.asm.tree.FieldInsnNode;
import com.agitar.org.objectweb.asm.tree.LdcInsnNode;
import com.agitar.org.objectweb.asm.tree.MethodInsnNode;
import com.agitar.org.objectweb.asm.tree.analysis.Interpreter;
import com.agitar.org.objectweb.asm.tree.analysis.SmallSet;
import com.agitar.org.objectweb.asm.tree.analysis.SourceValue;
import com.agitar.org.objectweb.asm.tree.analysis.Value;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SourceInterpreter
implements Opcodes,
Interpreter {
    public Value newValue(Type type) {
        return new SourceValue(type == null ? 1 : type.getSize());
    }

    public Value newOperation(AbstractInsnNode insn) {
        int size;
        switch (insn.getOpcode()) {
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                size = 2;
                break;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                size = cst instanceof Long || cst instanceof Double ? 2 : 1;
                break;
            }
            case 178: {
                size = Type.getType(((FieldInsnNode)insn).desc).getSize();
                break;
            }
            default: {
                size = 1;
            }
        }
        return new SourceValue(size, insn);
    }

    public Value copyOperation(AbstractInsnNode insn, Value value) {
        return new SourceValue(value.getSize(), insn);
    }

    public Value unaryOperation(AbstractInsnNode insn, Value value) {
        int size;
        switch (insn.getOpcode()) {
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                size = 2;
                break;
            }
            case 180: {
                size = Type.getType(((FieldInsnNode)insn).desc).getSize();
                break;
            }
            default: {
                size = 1;
            }
        }
        return new SourceValue(size, insn);
    }

    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) {
        int size;
        switch (insn.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                size = 2;
                break;
            }
            default: {
                size = 1;
            }
        }
        return new SourceValue(size, insn);
    }

    public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) {
        return new SourceValue(1, insn);
    }

    public Value naryOperation(AbstractInsnNode insn, List values) {
        int size = insn.getOpcode() == 197 ? 1 : Type.getReturnType(((MethodInsnNode)insn).desc).getSize();
        return new SourceValue(size, insn);
    }

    public Value merge(Value v, Value w) {
        SourceValue dv = (SourceValue)v;
        SourceValue dw = (SourceValue)w;
        if (dv.insns instanceof SmallSet && dw.insns instanceof SmallSet) {
            Set s = ((SmallSet)dv.insns).union((SmallSet)dw.insns);
            if (s == dv.insns && dv.size == dw.size) {
                return v;
            }
            return new SourceValue(Math.min(dv.size, dw.size), s);
        }
        if (dv.size != dw.size || !dv.insns.containsAll(dw.insns)) {
            HashSet s = new HashSet();
            s.addAll(dv.insns);
            s.addAll(dw.insns);
            return new SourceValue(Math.min(dv.size, dw.size), s);
        }
        return v;
    }
}

