/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.org.objectweb.asm.tree.analysis;

import com.agitar.org.objectweb.asm.Opcodes;
import com.agitar.org.objectweb.asm.Type;
import com.agitar.org.objectweb.asm.tree.AbstractInsnNode;
import com.agitar.org.objectweb.asm.tree.IincInsnNode;
import com.agitar.org.objectweb.asm.tree.InsnList;
import com.agitar.org.objectweb.asm.tree.JumpInsnNode;
import com.agitar.org.objectweb.asm.tree.LabelNode;
import com.agitar.org.objectweb.asm.tree.LookupSwitchInsnNode;
import com.agitar.org.objectweb.asm.tree.MethodNode;
import com.agitar.org.objectweb.asm.tree.TableSwitchInsnNode;
import com.agitar.org.objectweb.asm.tree.TryCatchBlockNode;
import com.agitar.org.objectweb.asm.tree.VarInsnNode;
import com.agitar.org.objectweb.asm.tree.analysis.AnalyzerException;
import com.agitar.org.objectweb.asm.tree.analysis.Frame;
import com.agitar.org.objectweb.asm.tree.analysis.Interpreter;
import com.agitar.org.objectweb.asm.tree.analysis.Subroutine;
import java.util.ArrayList;
import java.util.List;

public class Analyzer
implements Opcodes {
    private Interpreter interpreter;
    private int n;
    private InsnList insns;
    private List[] handlers;
    private Frame[] frames;
    private Subroutine[] subroutines;
    private boolean[] queued;
    private int[] queue;
    private int top;
    private boolean jsr;

    public Analyzer(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public Frame[] analyze(String owner, MethodNode m) throws AnalyzerException {
        this.n = m.instructions.size();
        this.insns = m.instructions;
        this.handlers = new List[this.n];
        this.frames = new Frame[this.n];
        this.subroutines = new Subroutine[this.n];
        this.queued = new boolean[this.n];
        this.queue = new int[this.n];
        this.top = 0;
        int i = 0;
        while (i < m.tryCatchBlocks.size()) {
            TryCatchBlockNode tcb = (TryCatchBlockNode)m.tryCatchBlocks.get(i);
            int begin = this.insns.indexOf(tcb.start);
            int end = this.insns.indexOf(tcb.end);
            int j = begin;
            while (j < end) {
                ArrayList<TryCatchBlockNode> insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = new ArrayList<TryCatchBlockNode>();
                }
                insnHandlers.add(tcb);
                ++j;
            }
            ++i;
        }
        Frame current = this.newFrame(m.maxLocals, m.maxStack);
        Frame handler = this.newFrame(m.maxLocals, m.maxStack);
        Type[] args = Type.getArgumentTypes(m.desc);
        int local = 0;
        if ((m.access & 8) == 0) {
            Type ctype = Type.getType("L" + owner + ";");
            current.setLocal(local++, this.interpreter.newValue(ctype));
        }
        int i2 = 0;
        while (i2 < args.length) {
            current.setLocal(local++, this.interpreter.newValue(args[i2]));
            if (args[i2].getSize() == 2) {
                current.setLocal(local++, this.interpreter.newValue(null));
            }
            ++i2;
        }
        while (local < m.maxLocals) {
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        this.merge(0, current, null);
        while (this.top > 0) {
            int insn = this.queue[--this.top];
            Frame f = this.frames[insn];
            Subroutine subroutine = this.subroutines[insn];
            this.queued[insn] = false;
            try {
                AbstractInsnNode insnNode = m.instructions.get(insn);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                this.jsr = false;
                if (insnType == 7 || insnType == 14 || insnType == 13) {
                    this.merge(insn + 1, f, subroutine);
                    this.newControlFlowEdge(this.frames[insn], this.frames[insn + 1]);
                } else {
                    LabelNode label;
                    current.init(f).execute(insnNode, this.interpreter);
                    Subroutine subroutine2 = subroutine = subroutine == null ? null : subroutine.copy();
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode j = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            this.merge(insn + 1, current, subroutine);
                            this.newControlFlowEdge(this.frames[insn], this.frames[insn + 1]);
                        }
                        int jump = this.insns.indexOf(j.label);
                        if (insnOpcode == 168) {
                            this.jsr = true;
                            this.merge(jump, current, new Subroutine(j.label, m.maxLocals, j));
                        } else {
                            this.merge(jump, current, subroutine);
                        }
                        this.newControlFlowEdge(this.frames[insn], this.frames[jump]);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lsi = (LookupSwitchInsnNode)insnNode;
                        int jump = this.insns.indexOf(lsi.dflt);
                        this.merge(jump, current, subroutine);
                        this.newControlFlowEdge(this.frames[insn], this.frames[jump]);
                        int j = 0;
                        while (j < lsi.labels.size()) {
                            label = (LabelNode)lsi.labels.get(j);
                            jump = this.insns.indexOf(label);
                            this.merge(jump, current, subroutine);
                            this.newControlFlowEdge(this.frames[insn], this.frames[jump]);
                            ++j;
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tsi = (TableSwitchInsnNode)insnNode;
                        int jump = this.insns.indexOf(tsi.dflt);
                        this.merge(jump, current, subroutine);
                        this.newControlFlowEdge(this.frames[insn], this.frames[jump]);
                        int j = 0;
                        while (j < tsi.labels.size()) {
                            label = (LabelNode)tsi.labels.get(j);
                            jump = this.insns.indexOf(label);
                            this.merge(jump, current, subroutine);
                            this.newControlFlowEdge(this.frames[insn], this.frames[jump]);
                            ++j;
                        }
                    } else if (insnOpcode == 169) {
                        if (subroutine == null) {
                            throw new AnalyzerException("RET instruction outside of a sub routine");
                        }
                        int i3 = 0;
                        while (i3 < subroutine.callers.size()) {
                            Object caller = subroutine.callers.get(i3);
                            int call = this.insns.indexOf((AbstractInsnNode)caller);
                            this.merge(call + 1, this.frames[call], current, this.subroutines[call], subroutine.access);
                            this.newControlFlowEdge(this.frames[insn], this.frames[call + 1]);
                            ++i3;
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        if (subroutine != null) {
                            if (insnNode instanceof VarInsnNode) {
                                int var = ((VarInsnNode)insnNode).var;
                                subroutine.access[var] = true;
                                if (insnOpcode == 22 || insnOpcode == 24 || insnOpcode == 55 || insnOpcode == 57) {
                                    subroutine.access[var + 1] = true;
                                }
                            } else if (insnNode instanceof IincInsnNode) {
                                int var = ((IincInsnNode)insnNode).var;
                                subroutine.access[var] = true;
                            }
                        }
                        this.merge(insn + 1, current, subroutine);
                        this.newControlFlowEdge(this.frames[insn], this.frames[insn + 1]);
                    }
                }
                List insnHandlers = this.handlers[insn];
                if (insnHandlers == null) continue;
                int i4 = 0;
                while (i4 < insnHandlers.size()) {
                    TryCatchBlockNode tcb = (TryCatchBlockNode)insnHandlers.get(i4);
                    Type type = tcb.type == null ? Type.getType("Ljava/lang/Throwable;") : Type.getType("L" + tcb.type + ";");
                    handler.init(f);
                    handler.clearStack();
                    handler.push(this.interpreter.newValue(type));
                    int jump = this.insns.indexOf(tcb.handler);
                    this.merge(jump, handler, subroutine);
                    this.newControlFlowExceptionEdge(this.frames[insn], this.frames[jump]);
                    ++i4;
                }
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException("Error at instruction " + insn + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new AnalyzerException("Error at instruction " + insn + ": " + e.getMessage(), e);
            }
        }
        return this.frames;
    }

    public Frame[] getFrames() {
        return this.frames;
    }

    public List getHandlers(int insn) {
        return this.handlers[insn];
    }

    protected Frame newFrame(int nLocals, int nStack) {
        return new Frame(nLocals, nStack);
    }

    protected Frame newFrame(Frame src) {
        return new Frame(src);
    }

    protected void newControlFlowEdge(Frame frame, Frame successor) {
    }

    protected void newControlFlowExceptionEdge(Frame frame, Frame successor) {
    }

    private void merge(int insn, Frame frame, Subroutine subroutine) throws AnalyzerException {
        if (insn > this.n - 1) {
            throw new AnalyzerException("Execution can fall off end of the code");
        }
        Frame oldFrame = this.frames[insn];
        Subroutine oldSubroutine = this.subroutines[insn];
        boolean changes = false;
        if (oldFrame == null) {
            this.frames[insn] = this.newFrame(frame);
            changes = true;
        } else {
            changes |= oldFrame.merge(frame, this.interpreter);
        }
        if (oldSubroutine == null) {
            if (subroutine != null) {
                this.subroutines[insn] = subroutine.copy();
                changes = true;
            }
        } else if (subroutine != null) {
            changes |= oldSubroutine.merge(subroutine, !this.jsr);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }

    private void merge(int insn, Frame beforeJSR, Frame afterRET, Subroutine subroutineBeforeJSR, boolean[] access) throws AnalyzerException {
        if (insn > this.n - 1) {
            throw new AnalyzerException("Execution can fall off end of the code");
        }
        Frame oldFrame = this.frames[insn];
        Subroutine oldSubroutine = this.subroutines[insn];
        boolean changes = false;
        afterRET.merge(beforeJSR, access);
        if (oldFrame == null) {
            this.frames[insn] = this.newFrame(afterRET);
            changes = true;
        } else {
            changes |= oldFrame.merge(afterRET, access);
        }
        if (oldSubroutine == null) {
            if (subroutineBeforeJSR != null) {
                this.subroutines[insn] = subroutineBeforeJSR.copy();
                changes = true;
            }
        } else if (subroutineBeforeJSR != null) {
            changes |= oldSubroutine.merge(subroutineBeforeJSR, !this.jsr);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }
}

