/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.org.objectweb.asm.tree;

import com.agitar.org.objectweb.asm.MethodVisitor;
import com.agitar.org.objectweb.asm.tree.AbstractInsnNode;
import java.util.Iterator;

public class InsnList {
    public static boolean check;
    private int size;
    private AbstractInsnNode first;
    private AbstractInsnNode last;
    private AbstractInsnNode[] cache;

    public int size() {
        return this.size;
    }

    public AbstractInsnNode getFirst() {
        return this.first;
    }

    public AbstractInsnNode getLast() {
        return this.last;
    }

    public AbstractInsnNode get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (this.cache == null) {
            this.cache = this.toArray();
        }
        return this.cache[index];
    }

    public boolean contains(AbstractInsnNode insn) {
        AbstractInsnNode i = this.first;
        while (i != null && i != insn) {
            i = i.next;
        }
        return i != null;
    }

    public int indexOf(AbstractInsnNode insn) {
        if (check && !this.contains(insn)) {
            throw new IllegalArgumentException();
        }
        if (this.cache == null) {
            this.cache = this.toArray();
        }
        return insn.index;
    }

    public void accept(MethodVisitor mv) {
        AbstractInsnNode insn = this.first;
        while (insn != null) {
            insn.accept(mv);
            insn = insn.next;
        }
    }

    public Iterator iterator() {
        return new Iterator(){
            AbstractInsnNode insn;
            {
                this.insn = InsnList.this.first;
            }

            public boolean hasNext() {
                return this.insn != null;
            }

            public Object next() {
                AbstractInsnNode result = this.insn;
                this.insn = this.insn.next;
                return result;
            }

            public void remove() {
                InsnList.this.remove(this.insn.prev);
            }
        };
    }

    public AbstractInsnNode[] toArray() {
        int i = 0;
        AbstractInsnNode elem = this.first;
        AbstractInsnNode[] insns = new AbstractInsnNode[this.size];
        while (elem != null) {
            insns[i] = elem;
            elem.index = i++;
            elem = elem.next;
        }
        return insns;
    }

    public void set(AbstractInsnNode i, AbstractInsnNode insn) {
        AbstractInsnNode prev;
        AbstractInsnNode next;
        if (check && (!this.contains(i) || insn.index != -1)) {
            throw new IllegalArgumentException();
        }
        insn.next = next = i.next;
        if (next != null) {
            next.prev = insn;
        } else {
            this.last = insn;
        }
        insn.prev = prev = i.prev;
        if (prev != null) {
            prev.next = insn;
        } else {
            this.first = insn;
        }
        if (this.cache != null) {
            int index = i.index;
            this.cache[index] = insn;
            insn.index = index;
        } else {
            insn.index = 0;
        }
        i.index = -1;
        i.prev = null;
        i.next = null;
    }

    public void add(AbstractInsnNode insn) {
        if (check && insn.index != -1) {
            throw new IllegalArgumentException();
        }
        ++this.size;
        if (this.last == null) {
            this.first = insn;
            this.last = insn;
        } else {
            this.last.next = insn;
            insn.prev = this.last;
        }
        this.last = insn;
        this.cache = null;
        insn.index = 0;
    }

    public void add(InsnList insns) {
        if (check && insns == this) {
            throw new IllegalArgumentException();
        }
        if (insns.size == 0) {
            return;
        }
        this.size += insns.size;
        if (this.last == null) {
            this.first = insns.first;
            this.last = insns.last;
        } else {
            AbstractInsnNode elem;
            this.last.next = elem = insns.first;
            elem.prev = this.last;
            this.last = insns.last;
        }
        this.cache = null;
        insns.removeAll(false);
    }

    public void insert(AbstractInsnNode insn) {
        if (check && insn.index != -1) {
            throw new IllegalArgumentException();
        }
        ++this.size;
        if (this.first == null) {
            this.first = insn;
            this.last = insn;
        } else {
            this.first.prev = insn;
            insn.next = this.first;
        }
        this.first = insn;
        this.cache = null;
        insn.index = 0;
    }

    public void insert(InsnList insns) {
        if (check && insns == this) {
            throw new IllegalArgumentException();
        }
        if (insns.size == 0) {
            return;
        }
        this.size += insns.size;
        if (this.first == null) {
            this.first = insns.first;
            this.last = insns.last;
        } else {
            AbstractInsnNode elem;
            this.first.prev = elem = insns.last;
            elem.next = this.first;
            this.first = insns.first;
        }
        this.cache = null;
        insns.removeAll(false);
    }

    public void insert(AbstractInsnNode i, AbstractInsnNode insn) {
        if (check && (!this.contains(i) || insn.index != -1)) {
            throw new IllegalArgumentException();
        }
        ++this.size;
        AbstractInsnNode next = i.next;
        if (next == null) {
            this.last = insn;
        } else {
            next.prev = insn;
        }
        i.next = insn;
        insn.next = next;
        insn.prev = i;
        this.cache = null;
        insn.index = 0;
    }

    public void insert(AbstractInsnNode i, InsnList insns) {
        if (check && (!this.contains(i) || insns == this)) {
            throw new IllegalArgumentException();
        }
        if (insns.size == 0) {
            return;
        }
        this.size += insns.size;
        AbstractInsnNode ifirst = insns.first;
        AbstractInsnNode ilast = insns.last;
        AbstractInsnNode next = i.next;
        if (next == null) {
            this.last = ilast;
        } else {
            next.prev = ilast;
        }
        i.next = ifirst;
        ilast.next = next;
        ifirst.prev = i;
        this.cache = null;
        insns.removeAll(false);
    }

    public void remove(AbstractInsnNode insn) {
        if (check && !this.contains(insn)) {
            throw new IllegalArgumentException();
        }
        --this.size;
        AbstractInsnNode next = insn.next;
        AbstractInsnNode prev = insn.prev;
        if (next == null) {
            if (prev == null) {
                this.first = null;
                this.last = null;
            } else {
                prev.next = null;
                this.last = prev;
            }
        } else if (prev == null) {
            this.first = next;
            next.prev = null;
        } else {
            prev.next = next;
            next.prev = prev;
        }
        this.cache = null;
        insn.index = -1;
        insn.prev = null;
        insn.next = null;
    }

    private void removeAll(boolean mark) {
        if (mark) {
            AbstractInsnNode insn = this.first;
            while (insn != null) {
                AbstractInsnNode next = insn.next;
                insn.index = -1;
                insn.prev = null;
                insn.next = null;
                insn = next;
            }
        }
        this.size = 0;
        this.first = null;
        this.last = null;
        this.cache = null;
    }

    public void clear() {
        this.removeAll(check);
    }
}

