/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.org.objectweb.asm.tree;

import com.agitar.org.objectweb.asm.MethodVisitor;
import com.agitar.org.objectweb.asm.tree.AbstractInsnNode;
import com.agitar.org.objectweb.asm.tree.LabelNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FrameNode
extends AbstractInsnNode {
    public int type;
    public List local;
    public List stack;

    private FrameNode() {
        super(-1);
    }

    public FrameNode(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        super(-1);
        this.type = type;
        switch (type) {
            case -1: 
            case 0: {
                this.local = FrameNode.asList(nLocal, local);
                this.stack = FrameNode.asList(nStack, stack);
                break;
            }
            case 1: {
                this.local = FrameNode.asList(nLocal, local);
                break;
            }
            case 2: {
                this.local = FrameNode.asList(nLocal, new Object[nLocal]);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.stack = FrameNode.asList(1, stack);
            }
        }
    }

    public int getType() {
        return 13;
    }

    public void accept(MethodVisitor mv) {
        switch (this.type) {
            case -1: 
            case 0: {
                mv.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), this.stack.size(), FrameNode.asArray(this.stack));
                break;
            }
            case 1: {
                mv.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), 0, null);
                break;
            }
            case 2: {
                mv.visitFrame(this.type, this.local.size(), null, 0, null);
                break;
            }
            case 3: {
                mv.visitFrame(this.type, 0, null, 0, null);
                break;
            }
            case 4: {
                mv.visitFrame(this.type, 0, null, 1, FrameNode.asArray(this.stack));
            }
        }
    }

    public AbstractInsnNode clone(Map labels) {
        int i;
        FrameNode clone = new FrameNode();
        clone.type = this.type;
        if (this.local != null) {
            clone.local = new ArrayList();
            i = 0;
            while (i < this.local.size()) {
                Object l = this.local.get(i);
                if (l instanceof LabelNode) {
                    l = labels.get(l);
                }
                clone.local.add(l);
                ++i;
            }
        }
        if (this.stack != null) {
            clone.stack = new ArrayList();
            i = 0;
            while (i < this.stack.size()) {
                Object s = this.stack.get(i);
                if (s instanceof LabelNode) {
                    s = labels.get(s);
                }
                clone.stack.add(s);
                ++i;
            }
        }
        return clone;
    }

    private static List asList(int n, Object[] o) {
        ArrayList<Object> l = new ArrayList<Object>(n);
        int i = 0;
        while (i < n) {
            l.add(o[i]);
            ++i;
        }
        return l;
    }

    private static Object[] asArray(List l) {
        Object[] objs = new Object[l.size()];
        int i = 0;
        while (i < objs.length) {
            Object o = l.get(i);
            if (o instanceof LabelNode) {
                o = ((LabelNode)o).getLabel();
            }
            objs[i] = o;
            ++i;
        }
        return objs;
    }
}

