/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.org.objectweb.asm.commons;

import com.agitar.org.objectweb.asm.ClassAdapter;
import com.agitar.org.objectweb.asm.ClassVisitor;
import com.agitar.org.objectweb.asm.FieldVisitor;
import com.agitar.org.objectweb.asm.MethodVisitor;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class SerialVersionUIDAdder
extends ClassAdapter {
    protected boolean computeSVUID;
    protected boolean hasSVUID;
    protected int access;
    protected String name;
    protected String[] interfaces;
    protected Collection svuidFields = new ArrayList();
    protected boolean hasStaticInitializer;
    protected Collection svuidConstructors = new ArrayList();
    protected Collection svuidMethods = new ArrayList();

    public SerialVersionUIDAdder(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean bl = this.computeSVUID = (access & 0x200) == 0;
        if (this.computeSVUID) {
            this.name = name;
            this.access = access;
            this.interfaces = interfaces;
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.computeSVUID) {
            if (name.equals("<clinit>")) {
                this.hasStaticInitializer = true;
            }
            int mods = access & 0xD3F;
            if ((access & 2) == 0) {
                if (name.equals("<init>")) {
                    this.svuidConstructors.add(new Item(name, mods, desc));
                } else if (!name.equals("<clinit>")) {
                    this.svuidMethods.add(new Item(name, mods, desc));
                }
            }
        }
        return this.cv.visitMethod(access, name, desc, signature, exceptions);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.computeSVUID) {
            if (name.equals("serialVersionUID")) {
                this.computeSVUID = false;
                this.hasSVUID = true;
            }
            int mods = access & 0xDF;
            if ((access & 2) == 0 || (access & 0x88) == 0) {
                this.svuidFields.add(new Item(name, mods, desc));
            }
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitEnd() {
        if (this.computeSVUID && !this.hasSVUID) {
            try {
                this.cv.visitField(24, "serialVersionUID", "J", null, new Long(this.computeSVUID()));
            }
            catch (Throwable e) {
                throw new RuntimeException("Error while computing SVUID for " + this.name, e);
            }
        }
        super.visitEnd();
    }

    /*
     * Exception decompiling
     */
    protected long computeSVUID() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 225->228)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected byte[] computeSHAdigest(byte[] value) {
        try {
            return MessageDigest.getInstance("SHA").digest(value);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("" + e);
        }
    }

    private void writeItems(Collection itemCollection, DataOutputStream dos, boolean dotted) throws IOException {
        int size = itemCollection.size();
        Object[] items = itemCollection.toArray(new Item[size]);
        Arrays.sort(items);
        int i = 0;
        while (i < size) {
            dos.writeUTF(((Item)items[i]).name);
            dos.writeInt(((Item)items[i]).access);
            dos.writeUTF(dotted ? ((Item)items[i]).desc.replace('/', '.') : ((Item)items[i]).desc);
            ++i;
        }
    }

    static class Item
    implements Comparable {
        String name;
        int access;
        String desc;

        Item(String name, int access, String desc) {
            this.name = name;
            this.access = access;
            this.desc = desc;
        }

        public int compareTo(Object o) {
            Item other = (Item)o;
            int retVal = this.name.compareTo(other.name);
            if (retVal == 0) {
                retVal = this.desc.compareTo(other.desc);
            }
            return retVal;
        }
    }
}

