/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Type;

public class StubClassLoader
extends ClassLoader {
    private static final WeakHashMap LOADERS = new WeakHashMap();
    private static final String SUB_CLASS_SUFFIX = "$_stub";
    private final HashMap loaded = new HashMap();
    static final MethodImpl[] M_IMPLS = new MethodImpl[]{new SetterImpl(), new GetterImpl(), new BooleanGetterImpl(), new DefaultConstructorImpl(), new EmptyImpl()};
    static /* synthetic */ Class class$org$agitar$mock$util$StubClassLoader;

    private StubClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static Class createSubClass(Class superClass) {
        Class<?> claz;
        String cname = superClass.getName() + SUB_CLASS_SUFFIX;
        ClassLoader parentLoader = superClass.getClassLoader();
        StubClassLoader loader = (StubClassLoader)LOADERS.get(parentLoader);
        if (loader == null) {
            loader = new StubClassLoader(parentLoader);
            LOADERS.put(parentLoader, loader);
        }
        if ((claz = (Class<?>)loader.loaded.get(cname)) != null) {
            return claz;
        }
        try {
            String cfilename = superClass.getName().replace('.', '/') + ".class";
            ClassReader reader = new ClassReader(parentLoader.getResourceAsStream(cfilename));
            SubClassWriter writer = new SubClassWriter(superClass.getName());
            reader.accept((ClassVisitor)writer, true);
            byte[] bytes = writer.getBytes();
            claz = loader.defineClass(cname, bytes, 0, bytes.length);
            loader.loaded.put(cname, claz);
            return claz;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NoClassDefFoundError(cname);
        }
    }

    static class DefaultConstructorImpl
    extends MethodImpl {
        DefaultConstructorImpl() {
        }

        boolean accept(MethodStruct method) {
            return (method.access & 2) == 0 && "<init>".equals(method.name) && "()V".equals(method.descriptor);
        }

        void genCode(ClassVisitor claz, MethodStruct method, Set fields) {
            String desc = method.descriptor;
            String name = method.name;
            CodeVisitor cv = claz.visitMethod(1, name, desc, method.exceptions, method.attributes);
            cv.visitVarInsn(25, 0);
            cv.visitMethodInsn(183, method.ownerSuperClass, name, desc);
            cv.visitInsn(177);
            cv.visitMaxs(0, 0);
        }
    }

    static class GetterImpl
    extends MethodImpl {
        GetterImpl() {
        }

        boolean accept(MethodStruct method) {
            if (this.isAbstract(method.access) && method.name.length() > 3 && method.name.startsWith("get") && method.descriptor.startsWith("()")) {
                return Type.getReturnType((String)method.descriptor).getSort() != 0;
            }
            return false;
        }

        void genCode(ClassVisitor claz, MethodStruct method, Set fields) {
            String name = method.name;
            String desc = method.descriptor;
            String fname = name.substring(3);
            Type returnType = Type.getReturnType((String)desc);
            String ftype = returnType.getDescriptor();
            if (fields.add(fname)) {
                claz.visitField(2, fname, ftype, null, null);
            }
            int acc = method.access & 0xFFFFFBFF | 1;
            CodeVisitor code = claz.visitMethod(acc, name, desc, method.exceptions, method.attributes);
            code.visitVarInsn(25, 0);
            code.visitFieldInsn(180, method.ownerClass, fname, ftype);
            code.visitInsn(returnType.getOpcode(172));
            code.visitMaxs(0, 0);
        }
    }

    static class BooleanGetterImpl
    extends MethodImpl {
        BooleanGetterImpl() {
        }

        boolean accept(MethodStruct method) {
            return this.isAbstract(method.access) && method.name.length() > 2 && method.name.startsWith("is") && method.descriptor.equals("()Z");
        }

        void genCode(ClassVisitor claz, MethodStruct method, Set fields) {
            String desc = method.descriptor;
            String name = method.name;
            String fname = name.substring(2);
            if (fields.add(fname)) {
                claz.visitField(2, fname, "Z", null, null);
            }
            int acc = method.access & 0xFFFFFBFF | 1;
            CodeVisitor code = claz.visitMethod(acc, name, desc, method.exceptions, method.attributes);
            code.visitVarInsn(25, 0);
            code.visitFieldInsn(180, method.ownerClass, fname, "Z");
            code.visitInsn(172);
            code.visitMaxs(0, 0);
        }
    }

    static class SetterImpl
    extends MethodImpl {
        SetterImpl() {
        }

        boolean accept(MethodStruct method) {
            String desc = method.descriptor;
            String name = method.name;
            return this.isAbstract(method.access) && name.length() > 3 && name.startsWith("set") && desc.endsWith("V") && Type.getArgumentTypes((String)desc).length == 1;
        }

        void genCode(ClassVisitor claz, MethodStruct method, Set fields) {
            String name = method.name;
            String desc = method.descriptor;
            String fname = name.substring(3);
            Type argType = Type.getArgumentTypes((String)desc)[0];
            String ftype = argType.getDescriptor();
            if (fields.add(fname)) {
                claz.visitField(2, fname, ftype, null, null);
            }
            int acc = method.access & 0xFFFFFBFF | 1;
            CodeVisitor code = claz.visitMethod(acc, name, desc, method.exceptions, method.attributes);
            code.visitVarInsn(25, 0);
            code.visitVarInsn(argType.getOpcode(21), 1);
            code.visitFieldInsn(181, method.ownerClass, fname, ftype);
            code.visitInsn(177);
            code.visitMaxs(0, 0);
        }
    }

    static class EmptyImpl
    extends MethodImpl {
        static final /* synthetic */ boolean $assertionsDisabled;

        EmptyImpl() {
        }

        boolean accept(MethodStruct method) {
            return this.isAbstract(method.access);
        }

        void genCode(ClassVisitor claz, MethodStruct method, Set field) {
            int acc = method.access & 0xFFFFFBFF | 1;
            CodeVisitor cv = claz.visitMethod(acc, method.name, method.descriptor, method.exceptions, method.attributes);
            Type type = Type.getReturnType((String)method.descriptor);
            EmptyImpl.loadZero(cv, type);
            cv.visitInsn(type.getOpcode(172));
            cv.visitMaxs(0, 0);
        }

        private static void loadZero(CodeVisitor cv, Type type) {
            switch (type.getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    cv.visitInsn(3);
                    break;
                }
                case 7: {
                    cv.visitInsn(9);
                    break;
                }
                case 6: {
                    cv.visitInsn(11);
                    break;
                }
                case 8: {
                    cv.visitInsn(14);
                    break;
                }
                case 9: 
                case 10: {
                    cv.visitInsn(1);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"unknown type");
                    }
                    break;
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$agitar$mock$util$StubClassLoader == null ? (class$org$agitar$mock$util$StubClassLoader = StubClassLoader.class$("org.agitar.mock.util.StubClassLoader")) : class$org$agitar$mock$util$StubClassLoader).desiredAssertionStatus();
        }
    }

    static abstract class MethodImpl {
        MethodImpl() {
        }

        abstract void genCode(ClassVisitor var1, MethodStruct var2, Set var3);

        abstract boolean accept(MethodStruct var1);

        protected final boolean isAbstract(int acc) {
            return (acc & 0x400) != 0;
        }
    }

    static class MethodStruct {
        String ownerSuperClass;
        String ownerClass;
        String name;
        String descriptor;
        String[] exceptions;
        Attribute attributes;
        int access;

        MethodStruct(String ownersSuper, String owner, int acc, String mtd, String desc, String[] excs, Attribute attrs) {
            this.ownerSuperClass = ownersSuper;
            this.ownerClass = owner;
            this.access = acc;
            this.name = mtd;
            this.descriptor = desc;
            this.exceptions = excs;
            this.attributes = attrs;
        }
    }

    static class SubClassWriter
    implements ClassVisitor {
        private ClassWriter writer;
        private byte[] bytes;
        private final String sup;
        private Set fields = new HashSet();

        public byte[] getBytes() {
            return this.bytes;
        }

        public SubClassWriter(String superClassName) {
            this.writer = new ClassWriter(true);
            this.sup = superClassName.replace('.', '/');
        }

        public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
            this.writer.visit(version, 1, name + StubClassLoader.SUB_CLASS_SUFFIX, name, new String[0], null);
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
            this.writer.visitEnd();
            this.bytes = this.writer.toByteArray();
        }

        public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            MethodStruct mstruct = new MethodStruct(this.sup, this.sup + StubClassLoader.SUB_CLASS_SUFFIX, access, name, desc, exceptions, attrs);
            for (int i = 0; i < M_IMPLS.length; ++i) {
                MethodImpl impl = M_IMPLS[i];
                if (!impl.accept(mstruct)) continue;
                impl.genCode((ClassVisitor)this.writer, mstruct, this.fields);
                return null;
            }
            return null;
        }
    }
}

