/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.util;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import org.agitar.mock.util.CollectionEnumeration;

public class MultiMap {
    HashMap map = new HashMap();

    public void set(String name, String values) {
        this.map.put(name, new String[]{values});
    }

    public void add(String name, String value) {
        String[] vals = (String[])this.map.get(name);
        if (vals == null) {
            vals = new String[]{value};
        } else {
            int n = vals.length;
            String[] tmp = new String[n + 1];
            System.arraycopy(vals, 0, tmp, 0, n);
            vals = tmp;
            vals[n] = value;
        }
        this.map.put(name, vals);
    }

    public String getValue(String name) {
        String[] vals = (String[])this.map.get(name);
        if (vals != null && vals.length > 0) {
            return vals[0];
        }
        return null;
    }

    public String[] getValues(String name) {
        return (String[])this.map.get(name);
    }

    public Enumeration getValuesAsEnum(String name) {
        String[] vals = this.getValues(name);
        if (vals != null) {
            return new CollectionEnumeration(Arrays.asList(vals));
        }
        return null;
    }

    public Enumeration getKeys() {
        return new CollectionEnumeration(this.map.keySet());
    }

    public HashMap getMap() {
        return this.map;
    }

    public boolean containsValue(String key, String val) {
        if (!this.containsKey(key)) {
            return false;
        }
        String[] vals = this.getValues(key);
        if (vals != null) {
            for (int i = 0; i < vals.length; ++i) {
                if (!this.equals(val, vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean equals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }
}

