/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.servlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.agitar.mock.servlet.MockHttpServletRequest;
import org.agitar.mock.servlet.MockHttpServletResponse;
import org.agitar.mock.servlet.MockRequestDispatcher;
import org.agitar.mock.servlet.MockServletConfig;
import org.agitar.mock.util.CollectionEnumeration;

public class MockServletContext
implements ServletContext {
    private Properties servletMapping = new Properties();
    private Properties rcContents = new Properties();
    private Properties initParams = new Properties();
    private Properties mimeMap = new Properties();
    private HashMap attributes = new HashMap();
    private File contextBasePath = new File(".");
    private String servletContextName;

    public MockServletContext() {
        this.mimeMap.setProperty("html", "text/html");
        this.mimeMap.setProperty("htm", "text/html");
        this.mimeMap.setProperty("gif", "image/gif");
        this.mimeMap.setProperty("jpeg", "image/jpeg");
        this.mimeMap.setProperty("jpg", "image/jpeg");
        this.mimeMap.setProperty("pdf", "application/pdf");
        this.mimeMap.setProperty("zip", "application/zip");
        this.mimeMap.setProperty("class", "application/x-java-vm");
        this.mimeMap.setProperty("jar", "application/x-java-archive");
        this.mimeMap.setProperty("ser", "application/x-java-serialized-object");
        this.mimeMap.setProperty("exe", "application/octet-stream");
        this.mimeMap.setProperty("txt", "text/plain");
        this.mimeMap.setProperty("java", "text/plain");
        this.mimeMap.setProperty("jnlp", "application/x-java-jnlp-file");
    }

    public String getContextPath() {
        return this.servletContextName == null ? "" : '/' + this.servletContextName;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getServerInfo() {
        return "Agitar Servlet-API Mock Objects/0.1";
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public void log(String arg0) {
    }

    public void removeAttribute(String arg0) {
        this.attributes.remove(arg0);
    }

    public Enumeration getAttributeNames() {
        return new CollectionEnumeration(this.attributes.keySet());
    }

    public Enumeration getInitParameterNames() {
        return new CollectionEnumeration(this.initParams.keySet());
    }

    public Enumeration getServletNames() {
        return CollectionEnumeration.EMPTY;
    }

    public Enumeration getServlets() {
        return CollectionEnumeration.EMPTY;
    }

    public InputStream getResourceAsStream(String arg0) {
        String rc = this.rcContents.getProperty(arg0);
        if (rc != null) {
            return new ByteArrayInputStream(rc.getBytes());
        }
        File realfile = new File(this.getRealPath(arg0));
        if (realfile.exists()) {
            try {
                return new BufferedInputStream(new FileInputStream(realfile));
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }

    public Object getAttribute(String arg0) {
        return this.attributes.get(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.attributes.put(arg0, arg1);
    }

    public void log(Exception arg0, String arg1) {
    }

    public String getInitParameter(String arg0) {
        return this.initParams.getProperty(arg0);
    }

    public String getMimeType(String file) {
        if (file == null || file.length() == 0) {
            return null;
        }
        String type = null;
        for (int i = file.length() - 2; type == null && i >= 0; --i) {
            if (file.charAt(i) != '.') continue;
            String ext = file.substring(i + 1).toLowerCase();
            type = this.mimeMap.getProperty(ext);
        }
        if (type == null) {
            type = this.mimeMap.getProperty("*");
        }
        return type;
    }

    public String getRealPath(String arg0) {
        return this.getCanonicalFile(new File(this.contextBasePath, arg0)).getPath();
    }

    public void log(String arg0, Throwable arg1) {
    }

    public URL getResource(String arg0) throws MalformedURLException {
        return this.getCanonicalFile(new File(this.contextBasePath, arg0)).toURL();
    }

    public Set getResourcePaths(String arg0) {
        String[] ls;
        File dir = this.getCanonicalFile(new File(this.contextBasePath, arg0));
        HashSet<String> ret = new HashSet<String>();
        if (dir.isDirectory() && (ls = dir.list()) != null) {
            if (!arg0.endsWith("/")) {
                arg0 = arg0 + '/';
            }
            for (int i = 0; i < ls.length; ++i) {
                String f = ls[i];
                if (new File(dir, f).isDirectory()) {
                    ret.add(arg0 + f + '/');
                    continue;
                }
                ret.add(arg0 + f);
            }
        }
        return ret.size() == 0 ? null : ret;
    }

    public RequestDispatcher getNamedDispatcher(String arg0) {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return new MockRequestDispatcher(arg0);
    }

    public Servlet getServlet(String arg0) throws ServletException {
        return null;
    }

    public ServletContext getContext(String arg0) {
        return null;
    }

    public String getURLPattern(String servletName) {
        return this.servletMapping.getProperty(servletName);
    }

    public String[] getURLPatterns() {
        Collection<Object> patterns = this.servletMapping.values();
        return patterns.toArray(new String[patterns.size()]);
    }

    public void setServletMapping(String servletName, String urlPattern) {
        this.servletMapping.setProperty(servletName, urlPattern);
    }

    public void setResourceContent(String resourcePath, String textContent) {
        this.rcContents.setProperty(resourcePath, textContent);
    }

    public void setInitParameter(String pname, String pval) {
        this.initParams.setProperty(pname, pval);
    }

    public void setMimeMapping(String ext, String mimeType) {
        this.mimeMap.setProperty(ext, mimeType);
    }

    public void setContextBasePath(String dirname) {
        this.contextBasePath = new File(dirname);
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    private File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException x) {
            return file.getAbsoluteFile();
        }
    }

    public MockServletConfig createServletConfig() {
        return new MockServletConfig(this);
    }

    public MockHttpServletRequest createHttpServletRequest(String url) {
        return new MockHttpServletRequest(url, this);
    }

    public MockHttpServletResponse createHttpServletResponse() {
        return new MockHttpServletResponse();
    }

    protected String getContextBasePath() {
        if (this.contextBasePath == null) {
            this.contextBasePath = new File(".");
        }
        return this.contextBasePath.getPath();
    }
}

