/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.servlet;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

class HttpDateFormat
extends DateFormat {
    private static final TimeZone DEFAULT_FORMATTING_TZ = TimeZone.getTimeZone("GMT");
    private static final SimpleDateFormat[] FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    private static HttpDateFormat instance;

    HttpDateFormat() {
    }

    public static HttpDateFormat get() {
        if (instance == null) {
            instance = new HttpDateFormat();
        }
        return instance;
    }

    public Date parse(String source, ParsePosition pos) {
        for (int i = 0; i < FORMATS.length; ++i) {
            SimpleDateFormat format = FORMATS[i];
            format.setTimeZone(DEFAULT_FORMATTING_TZ);
            Date date = format.parse(source, pos);
            if (date == null) continue;
            return date;
        }
        return null;
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        SimpleDateFormat format = FORMATS[0];
        format.setTimeZone(DEFAULT_FORMATTING_TZ);
        return format.format(date, toAppendTo, fieldPosition);
    }
}

