/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.servlet;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class ContentType {
    private static final char[] NEED_QUOTE = new char[]{'\"', '\'', '\\', ' ', ';', '='};
    private static final int _A = 65;
    private static final int _Z = 90;
    private static final int _a = 97;
    private static final int _z = 122;
    private static final int _0 = 48;
    private static final int _9 = 57;
    private static final String _allowedchars = "-. ";
    private static final int _START = 0;
    private static final int _SUBTYPE = 1;
    private static final int _PNAME = 2;
    private static final int _PVAL = 3;
    private static final int _QUOTED = 4;
    private static final int _UNQUOTED = 5;
    private static final int _QCLOSED = 6;
    private String mtype;
    private String msubtype;
    private LinkedHashMap params = new LinkedHashMap();

    public ContentType(String str) {
        str = this.checkStr(str);
        this.parse(str);
    }

    private String checkStr(String str) {
        if (str != null) {
            str = str.trim();
        }
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("null or empty mimetype string: " + str);
        }
        return str;
    }

    ContentType(String type, String subtype) {
        this.checkStr(type);
        this.mtype = type;
        this.msubtype = subtype;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.mtype);
        if (this.msubtype != null) {
            sb.append('/');
            sb.append(this.msubtype);
        }
        Iterator iter = this.params.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            sb.append("; ");
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(ContentType.quote((String)entry.getValue()));
        }
        return sb.toString();
    }

    public String getParameter(String pname) {
        if (pname == null) {
            return null;
        }
        return (String)this.params.get(pname.toLowerCase());
    }

    public void setParameter(String pname, String pval) {
        if (pname == null) {
            return;
        }
        this.params.put(pname.toLowerCase(), pval);
    }

    private static void _checkValidTypeChar(char c, int pos) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || _allowedchars.indexOf(c) >= 0) {
            return;
        }
        throw new IllegalArgumentException("invalid character for mimetype at column [" + pos + "] : '" + c + '\'');
    }

    private static String _collect(StringBuffer sb) {
        return ContentType._collect(sb, true);
    }

    private static String _collect(StringBuffer sb, boolean trim) {
        String ret = sb.toString();
        sb.delete(0, sb.length());
        if (trim && (ret = ret.trim()).indexOf(32) > 0) {
            throw new IllegalArgumentException("invalid white space in '" + ret + "'");
        }
        return ret;
    }

    private void parse(String s) {
        int state = 0;
        char[] chs = s.toCharArray();
        StringBuffer buf = new StringBuffer(16);
        String pname = "";
        block16: for (int i = 0; i < chs.length; ++i) {
            char c = chs[i];
            switch (state) {
                case 0: {
                    if (c == '/') {
                        state = 1;
                        this.mtype = ContentType._collect(buf);
                        continue block16;
                    }
                    ContentType._checkValidTypeChar(c, i);
                    buf.append(c);
                    continue block16;
                }
                case 1: {
                    if (c == ';') {
                        state = 2;
                        this.msubtype = ContentType._collect(buf);
                        continue block16;
                    }
                    ContentType._checkValidTypeChar(c, i);
                    buf.append(c);
                    continue block16;
                }
                case 2: {
                    if (c == '=') {
                        state = 3;
                        pname = ContentType._collect(buf);
                        continue block16;
                    }
                    ContentType._checkValidTypeChar(c, i);
                    buf.append(c);
                    continue block16;
                }
                case 3: {
                    if (c == '\"') {
                        state = 4;
                        continue block16;
                    }
                    state = 5;
                    buf.append(c);
                    continue block16;
                }
                case 5: {
                    if (c == ';') {
                        state = 2;
                        this.setParameter(pname, ContentType._collect(buf, false));
                        pname = "";
                        continue block16;
                    }
                    buf.append(c);
                    continue block16;
                }
                case 4: {
                    char prev;
                    char c2 = prev = i == 0 ? (char)'\u0000' : chs[i - 1];
                    if (c == '\"' && prev != '\\') {
                        state = 6;
                        this.setParameter(pname, ContentType._collect(buf, false));
                        pname = "";
                        continue block16;
                    }
                    if (c == '\\' && prev != '\\') continue block16;
                    buf.append(c);
                    continue block16;
                }
                case 6: {
                    if (c == ' ') continue block16;
                    if (c == ';') {
                        state = 2;
                        continue block16;
                    }
                    throw new IllegalArgumentException("expecting ';' at column [" + i + "] but found: " + c);
                }
            }
        }
        switch (state) {
            case 0: {
                this.mtype = ContentType._collect(buf);
                break;
            }
            case 1: {
                this.msubtype = ContentType._collect(buf);
                break;
            }
            case 3: 
            case 5: {
                this.setParameter(pname, ContentType._collect(buf));
                break;
            }
            case 2: {
                throw new IllegalArgumentException("param name [" + ContentType._collect(buf) + "] with no value.");
            }
            case 4: {
                throw new IllegalArgumentException("unclosed quote in value for [" + pname + "]: " + ContentType._collect(buf));
            }
        }
    }

    private static String quote(String s) {
        boolean needquote = false;
        for (int i = 0; i < NEED_QUOTE.length; ++i) {
            if (s.indexOf(NEED_QUOTE[i]) < 0) continue;
            needquote = true;
            break;
        }
        if (needquote) {
            char[] chs = s.toCharArray();
            StringBuffer sb = new StringBuffer(s.length() + 8);
            sb.append('\"');
            block4: for (int i = 0; i < chs.length; ++i) {
                char c = chs[i];
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        sb.append('\\');
                        sb.append(c);
                        continue block4;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            sb.append('\"');
            return sb.toString();
        }
        return s;
    }

    public String getType() {
        return this.mtype;
    }

    public String getSubtype() {
        return this.msubtype;
    }
}

