/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.persistence;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Id;
import javax.persistence.IdClass;

public class PersistenceUtil {
    public static Class getPrimaryKeyClass(Class beanClass) throws ClassNotFoundException {
        Object value;
        Annotation ann = PersistenceUtil.getClassAnnotation(IdClass.class, beanClass);
        if (ann != null && (value = PersistenceUtil.getAnnotationValue(ann, "value")) != null) {
            return Class.forName((String)value);
        }
        return null;
    }

    private static Object getAnnotationValue(Annotation ann, String key) {
        String str = ((Object)ann).toString();
        MessageFormat msg = new MessageFormat("@{0}(" + key + "={1} {2})");
        Object value = null;
        try {
            Object[] tokens = msg.parse(str);
            if (tokens != null && tokens.length == 3) {
                assert (ann.annotationType().getName().equals(tokens[0]));
                value = tokens[2];
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        return value;
    }

    private static Annotation getClassAnnotation(Class targetType, Class beanClass) {
        return beanClass.getAnnotation(targetType);
    }

    public static IdField getPrimaryIdField(Class beanClass) throws NoSuchFieldException {
        Class<Id> idClass = Id.class;
        List anns = PersistenceUtil.getFieldsWithAnnotation(idClass, beanClass);
        if (!anns.isEmpty()) {
            Field f = (Field)anns.get(0);
            return new IdField(f, (Member)f);
        }
        anns = PersistenceUtil.getMethodsWithAnnotation(idClass, beanClass);
        if (!anns.isEmpty()) {
            Method getMethod = (Method)anns.get(0);
            Method setMethod = PersistenceUtil.findSetMethod(beanClass, getMethod.getName());
            return new IdField(setMethod, (Member)getMethod);
        }
        return null;
    }

    static List getMethodsWithAnnotation(Class idClass, Class beanClass) {
        ArrayList<Method> res = new ArrayList<Method>();
        Method[] methods = beanClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isAnnotationPresent(idClass)) continue;
            res.add(methods[i]);
        }
        return res;
    }

    static List getFieldsWithAnnotation(Class annType, Class beanClass) {
        ArrayList<Field> res = new ArrayList<Field>();
        Field[] fields = beanClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isAnnotationPresent(annType)) continue;
            res.add(fields[i]);
        }
        return res;
    }

    private static Method findSetMethod(Class beanClass, String getMethodName) {
        String setMethodName = getMethodName.replace("get", "set");
        Method[] methods = beanClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(setMethodName)) continue;
            return methods[i];
        }
        return null;
    }

    public static String findFieldNameByMethodName(Class beanClass, String methodName) {
        StringBuffer fieldName = new StringBuffer(methodName.substring(3, 4).toLowerCase());
        fieldName.append(methodName.substring(4)).toString();
        return fieldName.toString();
    }

    public static class IdField {
        Field field;
        Method setMethod;
        Member annotatedElement;

        public IdField(Field field2, Member field3) {
            this.field = field2;
            this.annotatedElement = field3;
        }

        public IdField(Method setter, Member field3) {
            this.setMethod = setter;
            this.annotatedElement = field3;
        }
    }
}

