/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.persistence;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.GeneratedValue;
import javax.persistence.LockModeType;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.agitar.mock.persistence.MockEntityTransaction;
import org.agitar.mock.persistence.MockQuery;
import org.agitar.mock.persistence.MockSqlQuery;
import org.agitar.mock.persistence.PersistenceUtil;

public class MockEntityManager
implements EntityManager {
    HashMap store = new HashMap();
    private FlushModeType flushmode;
    private HashMap primaryKeys = new HashMap();
    private boolean isOpen = true;
    private static final String CANNOT_INSTANTIATE_OBJ = "Cannot instantiate new {0}: {1}";
    private static final String NO_DEFAULT_CONS = "Class [{0}] needs a 0-argument constructor. {1} Provide an \"Object Factory\" to create the object.";

    public void persist(Object bean) {
        Class<?> beanClass;
        Object id;
        block5: {
            id = new Integer(0);
            beanClass = bean.getClass();
            try {
                Class keyClass = PersistenceUtil.getPrimaryKeyClass(beanClass);
                if (keyClass != null) {
                    try {
                        id = this.createPrimaryKeyFromIdClass(bean, beanClass, keyClass);
                        break block5;
                    }
                    catch (Exception e) {
                        throw new PersistenceException((Throwable)e);
                    }
                }
                id = this.createPrimaryKeyFromId(bean, beanClass, PersistenceUtil.getPrimaryIdField(beanClass));
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        StoreKey key = new StoreKey(id, beanClass);
        this.store.put(key, bean);
    }

    public Object merge(Object arg0) {
        this.persist(arg0);
        return arg0;
    }

    public void remove(Object toRemove) {
        for (Map.Entry element : this.store.entrySet()) {
            if (!element.getValue().equals(toRemove)) continue;
            toRemove = element.getKey();
        }
        this.store.remove(toRemove);
    }

    public Object find(Class entityClass, Object entityId) {
        StoreKey key = new StoreKey(entityId, entityClass);
        Object instance = this.store.get(key);
        if (instance != null) {
            if (!entityClass.isAssignableFrom(instance.getClass())) {
                return null;
            }
            try {
                this.injectEmptyCollections(instance);
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        return instance;
    }

    public Object getReference(Class entityClass, Object entityId) {
        return this.createInstance(entityClass);
    }

    public void flush() {
    }

    public void setFlushMode(FlushModeType arg0) {
        this.flushmode = arg0;
    }

    public FlushModeType getFlushMode() {
        return this.flushmode;
    }

    public void lock(Object arg0, LockModeType arg1) {
    }

    public void refresh(Object arg0) {
    }

    public void clear() {
        this.store.clear();
    }

    public boolean contains(Object arg0) {
        return this.store.values().contains(arg0);
    }

    public Query createQuery(String arg0) {
        return new MockQuery(arg0);
    }

    public Query createNamedQuery(String arg0) {
        return new MockQuery(arg0);
    }

    public Query createNativeQuery(String queryString) {
        return new MockSqlQuery(queryString);
    }

    public Query createNativeQuery(String queryString, Class resultClass) {
        MockSqlQuery q = new MockSqlQuery(queryString);
        q.addEntity("alias1", resultClass.getName());
        return q;
    }

    public Query createNativeQuery(String queryString, String arg1) {
        MockSqlQuery q = new MockSqlQuery(queryString);
        q.addEntity("alias1", arg1);
        return q;
    }

    public void joinTransaction() {
    }

    public Object getDelegate() {
        return null;
    }

    public void close() {
        this.store.clear();
        this.isOpen = false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public EntityTransaction getTransaction() {
        return new MockEntityTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createPrimaryKeyFromId(Object bean, Class beanClass, PersistenceUtil.IdField idfield) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException, InstantiationException, ClassNotFoundException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Field beanfield = idfield.field;
        if (beanfield != null) {
            if (!this.hasGeneratedValue(idfield.annotatedElement)) {
                try {
                    beanfield.setAccessible(true);
                    Object object = beanfield.get(bean);
                    return object;
                }
                finally {
                    beanfield.setAccessible(false);
                }
            }
            Object id = this.generateOrIncrementDatabasePrimaryKey(beanClass, idfield.field.getType());
            try {
                beanfield.setAccessible(true);
                beanfield.set(bean, id);
            }
            finally {
                beanfield.setAccessible(false);
            }
            return id;
        }
        if (!this.hasGeneratedValue(idfield.annotatedElement)) {
            Method getter = beanClass.getDeclaredMethod(idfield.annotatedElement.getName(), null);
            return getter.invoke(bean, (Object[])null);
        }
        Object id = this.generateOrIncrementDatabasePrimaryKey(beanClass, idfield.setMethod.getParameterTypes()[0]);
        Method setter = idfield.setMethod;
        setter.invoke(bean, id);
        return id;
    }

    private boolean hasGeneratedValue(Member member) {
        Annotation[] anns = null;
        if (member instanceof Field) {
            anns = ((Field)member).getAnnotations();
        } else if (member instanceof Method) {
            anns = ((Method)member).getAnnotations();
        }
        if (anns == null) {
            return false;
        }
        for (int i = 0; i < anns.length; ++i) {
            Annotation annotation = anns[i];
            if (!annotation.annotationType().equals(GeneratedValue.class)) continue;
            return true;
        }
        return false;
    }

    private Object generateOrIncrementDatabasePrimaryKey(Class beanClass, Class keyClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object currId = this.primaryKeys.get(beanClass);
        currId = currId == null ? (Number)(keyClass.equals(Integer.TYPE) || keyClass.equals(Integer.class) ? (Number)new Integer(0) : (Number)(keyClass.equals(Long.TYPE) || keyClass.equals(Long.class) ? new Long(0L) : keyClass.newInstance())) : (Number)(currId instanceof Long ? (Number)new Long((Long)currId + 1L) : (Number)(currId instanceof Integer ? new Integer((Integer)currId + 1) : keyClass.newInstance()));
        this.primaryKeys.put(beanClass, currId);
        return currId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createPrimaryKeyFromIdClass(Object bean, Class beanClass, Class keyClass) throws InstantiationException, IllegalAccessException, NoSuchFieldException {
        Object key = keyClass.newInstance();
        Field[] fields = keyClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field keyfield = fields[i];
            Field beanfield = beanClass.getDeclaredField(keyfield.getName());
            try {
                keyfield.setAccessible(true);
                beanfield.setAccessible(true);
                keyfield.set(key, beanfield.get(bean));
                continue;
            }
            finally {
                keyfield.setAccessible(false);
                beanfield.setAccessible(false);
            }
        }
        return key;
    }

    void injectEmptyCollections(Object bean) throws InstantiationException, IllegalAccessException, NoSuchFieldException {
        this.injectEmptyCollections(bean, OneToMany.class);
        this.injectEmptyCollections(bean, ManyToMany.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void injectEmptyCollections(Object bean, Class mappingType) throws InstantiationException, IllegalAccessException, NoSuchFieldException {
        Object coll;
        Class<?> beanClass = bean.getClass();
        List fieldAnns = PersistenceUtil.getFieldsWithAnnotation(mappingType, beanClass);
        List methodAnns = PersistenceUtil.getMethodsWithAnnotation(mappingType, beanClass);
        for (Field field : fieldAnns) {
            coll = this.createCollectionInstance(mappingType, field.getType());
            try {
                field.setAccessible(true);
                field.set(bean, coll);
            }
            finally {
                field.setAccessible(false);
            }
        }
        for (Method method : methodAnns) {
            coll = this.createCollectionInstance(mappingType, method.getReturnType());
            String fieldName = PersistenceUtil.findFieldNameByMethodName(beanClass, method.getName());
            Field field = beanClass.getDeclaredField(fieldName);
            try {
                field.setAccessible(true);
                field.set(bean, coll);
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    private Object createCollectionInstance(Class mappingType, Class propertyType) throws InstantiationException, IllegalAccessException {
        Cloneable coll = null;
        if (propertyType.equals(Collection.class)) {
            coll = new HashSet();
            propertyType.cast(coll);
        } else if (mappingType.isAssignableFrom(ManyToMany.class)) {
            coll = new HashMap();
        }
        return coll;
    }

    private Object createInstance(Class entityClass) {
        Constructor cons = this.getBeanConstructor(entityClass);
        try {
            return cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw this.newIllegalStateExc(this.getMessage(CANNOT_INSTANTIATE_OBJ, entityClass.getName(), e.getMessage()), e);
        }
    }

    private String getMessage(String pattern, String param1, String param2) {
        return MessageFormat.format(pattern, param1, param2);
    }

    protected IllegalStateException newIllegalStateExc(String msg, Throwable cause) {
        IllegalStateException isx = new IllegalStateException(msg);
        isx.initCause(cause);
        return isx;
    }

    private Constructor getBeanConstructor(Class clazz) {
        try {
            Constructor cons;
            try {
                cons = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException x) {
                cons = clazz.getDeclaredConstructor(new Class[0]);
                cons.setAccessible(true);
            }
            return cons;
        }
        catch (SecurityException e) {
            throw this.newIllegalStateExc(this.getMessage(NO_DEFAULT_CONS, clazz.getName(), e.getMessage()), e);
        }
        catch (NoSuchMethodException e) {
            throw this.newIllegalStateExc(this.getMessage(NO_DEFAULT_CONS, clazz.getName(), ""), e);
        }
    }

    class StoreKey {
        Object id;
        Class beanClass;

        public StoreKey(Object id2, Class beanClass2) {
            this.id = id2;
            this.beanClass = beanClass2;
        }

        public int hashCode() {
            return this.id.hashCode() + this.beanClass.hashCode();
        }

        public boolean equals(Object target) {
            if (!(target instanceof StoreKey)) {
                return false;
            }
            StoreKey tKey = (StoreKey)target;
            return tKey.id.equals(this.id) && tKey.beanClass == this.beanClass;
        }
    }
}

