/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.naming;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.agitar.mock.naming.Messages;
import org.agitar.mock.naming.MockInitialContextFactory;

public class MockContext
implements Context {
    private static final String ROOT_CONTEXT_PREFIX = "";
    private static final String SPECIAL_INSTRUCTION = "agitar$clear$context";
    private HashMap map = new HashMap();
    private Hashtable env = new Hashtable();
    private String prefix;

    public MockContext() throws NamingException {
        this(ROOT_CONTEXT_PREFIX);
    }

    public MockContext(String prefix) throws NamingException {
        this(prefix, null);
    }

    public MockContext(String prefix, HashMap initialMappings) throws NamingException {
        this.prefix = prefix;
        if (initialMappings != null) {
            Iterator iter = initialMappings.keySet().iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                Name name = null;
                if (obj instanceof String) {
                    name = new CompositeName((String)obj);
                } else if (obj instanceof Name) {
                    name = (Name)obj;
                } else {
                    throw new IllegalArgumentException(Messages.format("Initial mapping must contain only String or javax.naming.Name keys."));
                }
                int n = name.size();
                Context ctx = this;
                for (int i = 0; i < n; ++i) {
                    String nameComponent = name.get(i);
                    if (i == n - 1) {
                        ctx.bind(nameComponent, initialMappings.get(obj));
                        continue;
                    }
                    try {
                        ctx = ctx.createSubcontext(nameComponent);
                        continue;
                    }
                    catch (NameAlreadyBoundException x) {
                        ctx = (Context)ctx.lookup(nameComponent);
                    }
                }
            }
        }
    }

    public void close() throws NamingException {
    }

    public String toString() {
        return "Context(" + this.prefix + " size=" + this.map.size() + ")";
    }

    public String getNameInNamespace() throws NamingException {
        return this.prefix;
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    public Hashtable getEnvironment() throws NamingException {
        Hashtable ret = new Hashtable();
        ret.putAll(this.env);
        return ret;
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.checkName(name);
        Context leafContext = this.getLeafContext(name);
        leafContext.unbind(name.get(name.size() - 1));
    }

    public void unbind(Name name) throws NamingException {
        this.checkName(name);
        int len = name.size();
        if (len > 1) {
            Context leafContext = this.getLeafContext(name);
            leafContext.unbind(name.get(len - 1));
        } else {
            this.map.remove(name.get(0));
        }
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj, false);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    public Object lookup(Name name) throws NamingException {
        int len = name.size();
        if (len > 1) {
            Context ctx = this.getLeafContext(name);
            return ctx.lookup(name.get(len - 1));
        }
        Object object = this.map.get(name.get(0));
        if (object != null) {
            return object;
        }
        throw new NameNotFoundException(Messages.format("Name [{0}] is not bound", MockContext.getFullContextName(this.prefix) + name));
    }

    private static String getFullContextName(String name) {
        return name == null || ROOT_CONTEXT_PREFIX.equals(name) ? ROOT_CONTEXT_PREFIX : name + '/';
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name, obj, false);
    }

    private void bind(Name name, Object obj, boolean overwrite) throws NamingException {
        this.checkName(name);
        int len = name.size();
        if (len > 1) {
            Context leaveContext = this.getLeafContext(name);
            if (overwrite) {
                leaveContext.rebind(name.get(len - 1), obj);
            } else {
                leaveContext.bind(name.get(len - 1), obj);
            }
        } else {
            String key = name.get(0);
            if (!overwrite && this.map.containsKey(key)) {
                throw new NameAlreadyBoundException(Messages.format("Name [{0}] already bound", MockContext.getFullContextName(this.prefix) + name));
            }
            this.map.put(key, obj);
        }
    }

    private void checkName(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException(Messages.format("Name is empty"));
        }
    }

    private Context getLeafContext(Name name) throws NamingException {
        Context ctx = this;
        int n = name.size() - 1;
        for (int i = 0; i < n; ++i) {
            String key = name.get(i);
            if (key.length() == 0) {
                throw new InvalidNameException(Messages.format("Invalid name: name has empty component"));
            }
            Object obj = ctx.lookup(key);
            if (!(obj instanceof Context)) {
                throw new NotContextException(Messages.format("[{0}] is not bound to a naming Context object", this.getNameStrUpToIndex(name, i)));
            }
            ctx = (Context)obj;
            if (ctx != null) continue;
            throw new NameNotFoundException(Messages.format("Name [{0}] is not bound", this.getNameStrUpToIndex(name, i)));
        }
        return ctx;
    }

    private String getNameStrUpToIndex(Name name, int index) {
        StringBuffer unboundName = new StringBuffer(this.prefix);
        for (int j = 0; j <= index; ++j) {
            unboundName.append(name.get(j));
            if (j >= index) continue;
            unboundName.append('/');
        }
        return unboundName.toString();
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.bind(name, obj, true);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        this.checkName(name);
        Context leaf = this.getLeafContext(name);
        String key = name.get(name.size() - 1);
        MockContext sub = new MockContext(MockContext.getFullContextName(leaf.getNameInNamespace()) + key);
        leaf.bind(key, (Object)sub);
        return sub;
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        Object obj = this.lookup(oldName);
        this.unbind(oldName);
        this.bind(newName, obj);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return new NameParserImpl();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return new NameParserImpl();
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (!name.isEmpty()) {
            Object obj = this.lookup(name);
            if (!(obj instanceof Context)) {
                throw new NotContextException(Messages.format("Cannot list a non-context object"));
            }
            return ((Context)obj).list(new CompositeName());
        }
        Iterator it = this.map.keySet().iterator();
        NameClassPairEnumeration enumeration = new NameClassPairEnumeration();
        while (it.hasNext()) {
            String bName = (String)it.next();
            Object bObj = this.map.get(bName);
            if (bObj == null) continue;
            enumeration.add(new NameClassPair(bName, bObj.getClass().getName()));
        }
        return enumeration;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (!name.isEmpty()) {
            Object obj = this.lookup(name);
            if (!(obj instanceof Context)) {
                throw new NotContextException("Cannot list a non-context object");
            }
            return ((Context)obj).listBindings(new CompositeName());
        }
        Iterator it = this.map.keySet().iterator();
        NameClassPairEnumeration enumeration = new NameClassPairEnumeration();
        while (it.hasNext()) {
            String bName = (String)it.next();
            Object bObj = this.map.get(bName);
            enumeration.add(new Binding(bName, bObj));
        }
        return enumeration;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (SPECIAL_INSTRUCTION.equals(propName)) {
            MockContext.reset();
            return null;
        }
        Object prev = this.env.get(propName);
        this.env.put(propName, propVal);
        this.map.put(propName, propVal);
        return prev;
    }

    public String composeName(String name, String prefx) throws NamingException {
        return prefx + '/' + name;
    }

    public Name composeName(Name name, Name prefx) throws NamingException {
        CompositeName compositeName = new CompositeName(prefx.toString());
        compositeName.addAll(name);
        return compositeName;
    }

    public List getAllNames() throws NamingException {
        ArrayList ret = new ArrayList();
        this.fillNames(this.prefix, this, ret);
        return ret;
    }

    private void fillNames(String name, Object node, List l) throws NamingException {
        if (!(node instanceof Context)) {
            l.add(name);
        } else {
            Context ctx = (Context)node;
            NamingEnumeration<Binding> bindings = ctx.listBindings(ROOT_CONTEXT_PREFIX);
            while (bindings.hasMore()) {
                Binding binding = (Binding)bindings.nextElement();
                String cname = binding.getName();
                cname = ROOT_CONTEXT_PREFIX.equals(name) ? cname : name + '/' + cname;
                this.fillNames(cname, binding.getObject(), l);
            }
        }
    }

    public static void bindAll(String nameString, Object value) throws NamingException {
        int i;
        CompositeName name = new CompositeName(nameString);
        Context copy = new InitialContext();
        for (i = 0; i < name.size() - 1; ++i) {
            String subname = name.get(i);
            try {
                Object obj = copy.lookup(subname);
                if (!(obj instanceof Context)) {
                    throw new NameAlreadyBoundException(Messages.format("Name [{0}] already bound", name.getPrefix(i + 1)));
                }
                copy = (Context)obj;
                continue;
            }
            catch (NameNotFoundException e) {
                copy = copy.createSubcontext(subname);
            }
        }
        String last = name.get(i);
        try {
            copy.bind(last, value);
        }
        catch (NameAlreadyBoundException e) {
            Object obj = copy.lookup(last);
            if (obj instanceof Context) {
                throw new NamingException(Messages.format("Cannot replace context at [{0}] with [{1}].", new String[]{nameString, value.toString()}));
            }
            copy.rebind(last, value);
        }
    }

    public static void reset() {
        MockInitialContextFactory.reset();
    }

    static {
        try {
            NamingManager.setInitialContextFactoryBuilder(new InitialContextFactoryBuilder(){

                public InitialContextFactory createInitialContextFactory(Hashtable arg0) throws NamingException {
                    return new MockInitialContextFactory();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static class NameParserImpl
    implements NameParser {
        NameParserImpl() {
        }

        public Name parse(String name) throws NamingException {
            return new CompositeName(name);
        }
    }

    static class NameClassPairEnumeration
    implements NamingEnumeration {
        private boolean closed = false;
        private ArrayList list = new ArrayList();
        private int index = 0;

        NameClassPairEnumeration() {
        }

        public void close() throws NamingException {
            this.list.clear();
            this.closed = true;
        }

        private void checkClose() throws NamingException {
            if (this.closed) {
                throw new NamingException(Messages.format("Enumeration is closed"));
            }
        }

        void add(NameClassPair pair) {
            this.list.add(pair);
        }

        public boolean hasMore() throws NamingException {
            this.checkClose();
            return this.index < this.list.size();
        }

        public Object next() throws NamingException {
            this.checkClose();
            if (this.index >= this.list.size()) {
                throw new NoSuchElementException(Messages.format("No more elements in enumeration"));
            }
            return this.list.get(this.index++);
        }

        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

