/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.ejb;

import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.naming.NamingException;
import org.agitar.mock.ejb.HomeProxy;
import org.agitar.mock.ejb.Messages;
import org.agitar.mock.ejb.MockEJBBase;
import org.agitar.mock.ejb.MockEntityContext;
import org.agitar.mock.ejb.MockSessionContext;
import org.agitar.mock.naming.MockContext;

public class MockLocalEJB
extends MockEJBBase {
    private EJBLocalHome homeObj;

    public MockLocalEJB(Class home, Class remoteOrLocal, Class impl) {
        super(home, remoteOrLocal, impl);
    }

    public EJBLocalHome getLocalHome() {
        if (this.homeObj == null) {
            this.homeObj = (EJBLocalHome)HomeProxy.createHomeObject(this);
        }
        return this.homeObj;
    }

    protected void checkHome() throws IllegalArgumentException {
        if (!EJBLocalHome.class.isAssignableFrom(this.homeInterface)) {
            throw new IllegalArgumentException(Messages.format("Home interface [{0}] must implement {1}.", new String[]{this.homeInterface.getName(), EJBLocalHome.class.getName()}));
        }
    }

    protected void checkInterface() throws IllegalArgumentException {
        if (!EJBLocalObject.class.isAssignableFrom(this.remoteOrLocalInterface)) {
            throw new IllegalArgumentException(Messages.format("Interface [{0}] must implement {1}.", new String[]{this.remoteOrLocalInterface.getName(), EJBLocalObject.class.getName()}));
        }
    }

    public void setEJBName(String jndiName) throws NamingException {
        MockContext.bindAll(jndiName, this.getLocalHome());
    }

    protected MockEntityContext createEntityContext() {
        MockEntityContext entityContext = new MockEntityContext();
        entityContext.setEJBLocalHome(this.getLocalHome());
        return entityContext;
    }

    protected MockSessionContext createSessionContext() {
        MockSessionContext sessionContext = new MockSessionContext();
        sessionContext.setEJBLocalHome(this.getLocalHome());
        return sessionContext;
    }

    protected boolean isLocal() {
        return true;
    }
}

