/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.ejb;

import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.NamingException;
import org.agitar.mock.ejb.HomeProxy;
import org.agitar.mock.ejb.Messages;
import org.agitar.mock.ejb.MockEJBBase;
import org.agitar.mock.ejb.MockEntityContext;
import org.agitar.mock.ejb.MockSessionContext;
import org.agitar.mock.naming.MockContext;

public class MockEJB
extends MockEJBBase {
    private EJBHome homeObj;

    public MockEJB(Class home, Class remoteOrLocal, Class impl) {
        super(home, remoteOrLocal, impl);
    }

    public EJBHome getHome() {
        if (this.homeObj == null) {
            this.homeObj = (EJBHome)HomeProxy.createHomeObject(this);
        }
        return this.homeObj;
    }

    protected void checkHome() throws IllegalArgumentException {
        if (!EJBHome.class.isAssignableFrom(this.homeInterface)) {
            throw new IllegalArgumentException(Messages.format("Home interface [{0}] must implement {1}.", new String[]{this.homeInterface.getName(), EJBHome.class.getName()}));
        }
    }

    protected void checkInterface() throws IllegalArgumentException {
        if (!EJBObject.class.isAssignableFrom(this.remoteOrLocalInterface)) {
            throw new IllegalArgumentException(Messages.format("Interface [{0}] must implement {1}.", new String[]{this.remoteOrLocalInterface.getName(), EJBObject.class.getName()}));
        }
    }

    public void setEJBName(String jndiName) throws NamingException {
        MockContext.bindAll(jndiName, this.getHome());
    }

    protected MockEntityContext createEntityContext() {
        MockEntityContext entityContext = new MockEntityContext();
        entityContext.setEJBHome(this.getHome());
        return entityContext;
    }

    protected MockSessionContext createSessionContext() {
        MockSessionContext sessionContext = new MockSessionContext();
        sessionContext.setEJBHome(this.getHome());
        return sessionContext;
    }

    protected boolean isLocal() {
        return false;
    }
}

