/*
 * Decompiled with CFR 0.152.
 */
package org.agitar.mock.ejb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.ejb.CreateException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityContext;
import javax.ejb.SessionContext;
import org.agitar.mock.ejb.Messages;
import org.agitar.mock.ejb.MockEJBBase;
import org.agitar.mock.ejb.MockEntityContext;
import org.agitar.mock.ejb.MockSessionContext;

class EJBProxy
implements InvocationHandler {
    private static final Class[] SET_ENTITY_CONTEXT_PARAMS = new Class[]{EntityContext.class};
    private static final Class[] SET_SESSION_CONTEXT_PARAMS = new Class[]{SessionContext.class};
    private final MockEJBBase ejb;
    private final Object underlyingObject;
    private Object ejbObject;

    public EJBProxy(MockEJBBase ejb) {
        this.ejb = ejb;
        this.underlyingObject = ejb.newImplObj();
    }

    public Object getEjbObject() {
        if (this.ejbObject == null) {
            this.ejbObject = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.ejb.remoteOrLocalInterface}, (InvocationHandler)this);
        }
        return this.ejbObject;
    }

    protected void ejbCreate(Class[] paramTypes, Object[] args) throws Throwable {
        boolean strict = paramTypes.length > 0;
        this.callMethod("ejbCreate", paramTypes, args, strict);
    }

    protected void ejbPostCreate(Class[] paramTypes, Object[] args) throws Throwable {
        this.callMethod("ejbPostCreate", paramTypes, args, false);
    }

    protected void setContext() throws Throwable {
        Object bean = this.getEjbObject();
        if (this.ejb.isSessionBean()) {
            MockSessionContext sessionContext = this.ejb.getSessionContext();
            if (this.ejb.isLocal()) {
                sessionContext.setEJBLocalObject((EJBLocalObject)bean);
            } else {
                sessionContext.setEJBObject((EJBObject)bean);
            }
            this.callMethod("setSessionContext", SET_SESSION_CONTEXT_PARAMS, new Object[]{sessionContext}, true);
        } else if (this.ejb.isEntityBean()) {
            MockEntityContext entityContext = this.ejb.getEntityContext();
            if (this.ejb.isLocal()) {
                entityContext.setEJBLocalObject((EJBLocalObject)bean);
            } else {
                entityContext.setEJBObject((EJBObject)bean);
            }
            this.callMethod("setEntityContext", SET_ENTITY_CONTEXT_PARAMS, new Object[]{entityContext}, true);
        }
    }

    private Object callMethod(String methodName, Class[] paramTypes, Object[] args, boolean strict) throws Throwable {
        Method method;
        Class<?> claz = this.underlyingObject.getClass();
        try {
            method = claz.getMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            if (!strict) {
                return null;
            }
            CreateException exc = new CreateException(Messages.format("Cannot find required method [{0}] in {1}", new String[]{this.makeMethodStr(methodName, paramTypes), claz.toString()}));
            exc.initCause((Throwable)e);
            throw exc;
        }
        try {
            return method.invoke(this.underlyingObject, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception x) {
            Object[] msgParams = new String[]{this.makeMethodStr(methodName, paramTypes), this.ejb.beanImpl.getName(), x.toString()};
            CreateException exc = new CreateException(Messages.format("Failed to invoke {0} on {1} : {2}", msgParams));
            exc.initCause((Throwable)x);
            throw exc;
        }
    }

    private String makeMethodStr(String mname, Class[] paramTypes) {
        int lastChar;
        StringBuffer sb = new StringBuffer(mname);
        sb.append('(');
        if (paramTypes != null) {
            for (int i = 0; i < paramTypes.length; ++i) {
                sb.append(paramTypes[i].getName());
                sb.append(',');
            }
        }
        if (sb.charAt(lastChar = sb.length() - 1) == ',') {
            sb.setCharAt(lastChar, ')');
        } else {
            sb.append(')');
        }
        return sb.toString();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.callMethod(method.getName(), method.getParameterTypes(), args, true);
    }
}

