/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.registry.samples;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class SaveOrganizationTest {
    BusinessQueryManager bqm = null;
    BusinessLifeCycleManager lcm = null;

    public static void main(String[] stringArray) {
        SaveOrganizationTest saveOrganizationTest = new SaveOrganizationTest();
        saveOrganizationTest.saveOrganizationTest();
    }

    public SaveOrganizationTest() {
        try {
            InitialContext initialContext = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("javax.xml.registry.ConnectionFactory");
            Properties properties = new Properties();
            properties.put("javax.xml.registry.factoryClass", "com.sun.xml.registry.ConnectionFactory");
            properties.put("javax.xml.registry.queryManagerURL", "http://java.sun.com/uddi/inquiry");
            properties.put("javax.xml.registry.lifeCycleManagerURL", "http://java.sun.com/uddi/publish");
            connectionFactory.setProperties(properties);
            Connection connection = connectionFactory.createConnection();
            Set set = null;
            connection.setCredentials(set);
            RegistryService registryService = connection.getRegistryService();
            this.lcm = registryService.getBusinessLifeCycleManager();
            this.bqm = registryService.getBusinessQueryManager();
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
        catch (JAXRException jAXRException) {
            jAXRException.printStackTrace();
        }
    }

    public void saveOrganizationTest() {
        try {
            Organization organization = (Organization)this.lcm.createObject("Organization");
            organization.setName(this.lcm.createInternationalString("Acme Systems"));
            organization.setDescription(this.lcm.createInternationalString("A high tech gadget manufacturer"));
            PersonName personName = (PersonName)this.lcm.createObject("PersonName");
            personName.setFullName("Waqar Sadiq");
            User user = (User)this.lcm.createObject("User");
            user.setPersonName(personName);
            ArrayList<EmailAddress> arrayList = new ArrayList<EmailAddress>();
            arrayList.add(this.lcm.createEmailAddress("waqar.sadiq@eds.com"));
            user.setEmailAddresses(arrayList);
            TelephoneNumber telephoneNumber = (TelephoneNumber)this.lcm.createObject("TelephoneNumber");
            telephoneNumber.setNumber("972-797-8408");
            telephoneNumber.setType(null);
            ArrayList<TelephoneNumber> arrayList2 = new ArrayList<TelephoneNumber>();
            arrayList2.add(telephoneNumber);
            user.setTelephoneNumbers(arrayList2);
            Slot slot = (Slot)this.lcm.createObject("Slot");
            slot.setName("sortCode");
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(new String("546789"));
            slot.setValues(arrayList3);
            slot.setSlotType(null);
            String string = new String("5400 Legacy Drive");
            String string2 = new String("Plano");
            String string3 = new String("TX");
            String string4 = new String("75024");
            PostalAddress postalAddress = this.lcm.createPostalAddress("5400", "Legacy Drive", "Plano", "TX", "USA", "75024", null);
            postalAddress.addSlot(slot);
            ArrayList<PostalAddress> arrayList4 = new ArrayList<PostalAddress>();
            arrayList4.add(postalAddress);
            user.setPostalAddresses(arrayList4);
            organization.setPrimaryContact(user);
            ExternalIdentifier externalIdentifier = this.lcm.createExternalIdentifier(this.bqm.findClassificationSchemeByName(null, "%D-U-N-S"), "Sun Microsystems", "123456789");
            organization.addExternalIdentifier(externalIdentifier);
            Classification classification = this.lcm.createClassification(this.bqm.findClassificationSchemeByName(null, "%naics"), "NAICS product code", "12345");
            organization.addClassification(classification);
            Service service = (Service)this.lcm.createObject("Service");
            service.setName(this.lcm.createInternationalString("purchasing service"));
            organization.addService(service);
            ServiceBinding serviceBinding = (ServiceBinding)this.lcm.createObject("ServiceBinding");
            serviceBinding.setName(this.lcm.createInternationalString("purchasing service SOAP binding"));
            serviceBinding.setAccessURI("http://www.sun.com/purchasingService");
            service.addServiceBinding(serviceBinding);
            SpecificationLink specificationLink = (SpecificationLink)this.lcm.createObject("SpecificationLink");
            specificationLink.setName(this.lcm.createInternationalString("purchasing service SOAP binding SpecificationLink"));
            specificationLink.setUsageDescription(this.lcm.createInternationalString("Use the WSDL file with a tool like JAXRPC to call this service"));
            serviceBinding.addSpecificationLink(specificationLink);
            Concept concept = (Concept)this.lcm.createObject("Concept");
            concept.setDescription(this.lcm.createInternationalString("purchasing service SOAP binding WSDL file's proxy"));
            specificationLink.setSpecificationObject((RegistryObject)concept);
            ExternalLink externalLink = this.lcm.createExternalLink("http://www.sun.com/purchasing/purchasingSOAPBinding.wsdl", "ExternalLink to WSDL file for SOAP binding for purchasing service");
            concept.addExternalLink(externalLink);
            ArrayList<Organization> arrayList5 = new ArrayList<Organization>();
            arrayList5.add(organization);
            BulkResponse bulkResponse = this.lcm.saveOrganizations(arrayList5);
        }
        catch (JAXRException jAXRException) {
            jAXRException.printStackTrace();
        }
    }
}

