/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.tlv;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.jsp.jstl.tlv.ScriptFreeTLV;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ScriptFreeTLV
extends TagLibraryValidator {
    private boolean allowDeclarations = false;
    private boolean allowScriptlets = false;
    private boolean allowExpressions = false;
    private boolean allowRTExpressions = false;
    private SAXParserFactory factory = SAXParserFactory.newInstance();

    public ScriptFreeTLV() {
        this.factory.setValidating(false);
        this.factory.setNamespaceAware(true);
    }

    public void setInitParameters(Map<String, Object> initParms) {
        super.setInitParameters(initParms);
        String declarationsParm = (String)initParms.get("allowDeclarations");
        String scriptletsParm = (String)initParms.get("allowScriptlets");
        String expressionsParm = (String)initParms.get("allowExpressions");
        String rtExpressionsParm = (String)initParms.get("allowRTExpressions");
        this.allowDeclarations = "true".equalsIgnoreCase(declarationsParm);
        this.allowScriptlets = "true".equalsIgnoreCase(scriptletsParm);
        this.allowExpressions = "true".equalsIgnoreCase(expressionsParm);
        this.allowRTExpressions = "true".equalsIgnoreCase(rtExpressionsParm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ValidationMessage[] validate(String prefix, String uri, PageData page) {
        InputStream in = null;
        MyContentHandler handler = new MyContentHandler(this, null);
        try {
            SAXParser parser;
            SAXParserFactory sAXParserFactory = this.factory;
            synchronized (sAXParserFactory) {
                parser = this.factory.newSAXParser();
            }
            in = page.getInputStream();
            parser.parse(in, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            ValidationMessage[] validationMessageArray = ScriptFreeTLV.vmFromString((String)e.toString());
            return validationMessageArray;
        }
        catch (SAXException e) {
            ValidationMessage[] validationMessageArray = ScriptFreeTLV.vmFromString((String)e.toString());
            return validationMessageArray;
        }
        catch (IOException e2) {
            ValidationMessage[] validationMessageArray = ScriptFreeTLV.vmFromString((String)e2.toString());
            return validationMessageArray;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return handler.reportResults();
    }

    private static ValidationMessage[] vmFromString(String message) {
        return new ValidationMessage[]{new ValidationMessage(null, message)};
    }

    static /* synthetic */ boolean access$100(ScriptFreeTLV x0) {
        return x0.allowDeclarations;
    }

    static /* synthetic */ boolean access$200(ScriptFreeTLV x0) {
        return x0.allowScriptlets;
    }

    static /* synthetic */ boolean access$300(ScriptFreeTLV x0) {
        return x0.allowExpressions;
    }

    static /* synthetic */ boolean access$400(ScriptFreeTLV x0) {
        return x0.allowRTExpressions;
    }

    static /* synthetic */ ValidationMessage[] access$500(String x0) {
        return ScriptFreeTLV.vmFromString((String)x0);
    }
}

