/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.tlv;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.jsp.jstl.tlv.PermittedTaglibsTLV;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PermittedTaglibsTLV
extends TagLibraryValidator {
    private final String PERMITTED_TAGLIBS_PARAM = "permittedTaglibs";
    private final String JSP_ROOT_URI = "http://java.sun.com/JSP/Page";
    private final String JSP_ROOT_NAME = "root";
    private final String JSP_ROOT_QN = "jsp:root";
    private Set permittedTaglibs;
    private boolean failed;
    private String uri;

    public PermittedTaglibsTLV() {
        this.init();
    }

    private void init() {
        this.permittedTaglibs = null;
    }

    public void release() {
        super.release();
        this.init();
    }

    public synchronized ValidationMessage[] validate(String prefix, String uri, PageData page) {
        try {
            this.uri = uri;
            this.permittedTaglibs = this.readConfiguration();
            PermittedTaglibsHandler h = new PermittedTaglibsHandler(this, null);
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setValidating(true);
            SAXParser p = f.newSAXParser();
            p.parse(page.getInputStream(), (DefaultHandler)h);
            if (this.failed) {
                return this.vmFromString("taglib " + prefix + " (" + uri + ") allows only the " + "following taglibs to be imported: " + this.permittedTaglibs);
            }
            return null;
        }
        catch (SAXException ex) {
            return this.vmFromString(ex.toString());
        }
        catch (ParserConfigurationException ex) {
            return this.vmFromString(ex.toString());
        }
        catch (IOException ex) {
            return this.vmFromString(ex.toString());
        }
    }

    private Set readConfiguration() {
        HashSet<String> s = new HashSet<String>();
        String uris = (String)this.getInitParameters().get("permittedTaglibs");
        StringTokenizer st = new StringTokenizer(uris);
        while (st.hasMoreTokens()) {
            s.add(st.nextToken());
        }
        return s;
    }

    private ValidationMessage[] vmFromString(String message) {
        return new ValidationMessage[]{new ValidationMessage(null, message)};
    }

    static /* synthetic */ String access$100(PermittedTaglibsTLV x0) {
        return x0.uri;
    }

    static /* synthetic */ Set access$200(PermittedTaglibsTLV x0) {
        return x0.permittedTaglibs;
    }

    static /* synthetic */ boolean access$302(PermittedTaglibsTLV x0, boolean x1) {
        x0.failed = x1;
        return x0.failed;
    }
}

